/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio.manager;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.util.List;
import live.hms.video.audio.manager.AudioDeviceMapping;
import live.hms.video.audio.manager.AudioManagerUtil;
import org.jetbrains.annotations.Nullable;

public abstract class AudioManagerCompat {
    private static final String TAG = "AudioManagerCompat";
    private static final int AUDIOFOCUS_GAIN = 4;
    protected final AudioManager audioManager;
    protected boolean hasFocus;
    protected final AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = focusChange -> {
        Log.i((String)TAG, (String)("onAudioFocusChangeListener: " + focusChange));
        this.hasFocus = focusChange == 1;
    };

    private AudioManagerCompat(@NonNull Context context) {
        this.audioManager = (AudioManager)context.getSystemService("audio");
    }

    public boolean isBluetoothScoAvailableOffCall() {
        return this.audioManager.isBluetoothScoAvailableOffCall();
    }

    public void startBluetoothSco() {
        this.audioManager.startBluetoothSco();
    }

    public void stopBluetoothSco() {
        this.audioManager.stopBluetoothSco();
    }

    public boolean isBluetoothHeadsetAvailable() {
        if (Build.VERSION.SDK_INT >= 31) {
            return this.audioManager.getAvailableCommunicationDevices().stream().anyMatch(it -> AudioDeviceMapping.fromPlatformType(it.getType()) == AudioManagerUtil.AudioDevice.BLUETOOTH);
        }
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        return mBluetoothAdapter != null && mBluetoothAdapter.isEnabled() && mBluetoothAdapter.getProfileConnectionState(1) == 2 && this.isBluetoothScoAvailableOffCall();
    }

    public boolean isBluetoothConnected() {
        if (Build.VERSION.SDK_INT >= 31) {
            AudioDeviceInfo communicationDevice = this.audioManager.getCommunicationDevice();
            if (communicationDevice == null) {
                return false;
            }
            AudioManagerUtil.AudioDevice audioDevice = AudioDeviceMapping.fromPlatformType(communicationDevice.getType());
            return AudioManagerUtil.AudioDevice.BLUETOOTH == audioDevice;
        }
        return this.isBluetoothScoOn();
    }

    public boolean isBluetoothScoOn() {
        return this.audioManager.isBluetoothScoOn();
    }

    public void setBluetoothScoOn(boolean on) {
        this.audioManager.setBluetoothScoOn(on);
    }

    public int getMode() {
        return this.audioManager.getMode();
    }

    public void setMode(int modeInCommunication) {
        this.audioManager.setMode(modeInCommunication);
    }

    public boolean isSpeakerphoneOn() {
        return this.audioManager.isSpeakerphoneOn();
    }

    public void setSpeakerphoneOn(boolean on) {
        this.audioManager.setSpeakerphoneOn(on);
    }

    public boolean isMicrophoneMute() {
        return this.audioManager.isMicrophoneMute();
    }

    public void setMicrophoneMute(boolean on) {
        this.audioManager.setMicrophoneMute(on);
    }

    public boolean hasEarpiece(@NonNull Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @RequiresApi(value=31)
    @Nullable
    public AudioDeviceInfo getConnectedBluetoothDevice() {
        return this.getAvailableCommunicationDevices().stream().filter(it -> AudioDeviceMapping.fromPlatformType(it.getType()) == AudioManagerUtil.AudioDevice.BLUETOOTH).findAny().orElse(null);
    }

    @RequiresApi(value=31)
    public List<AudioDeviceInfo> getAvailableCommunicationDevices() {
        return this.audioManager.getAvailableCommunicationDevices();
    }

    @RequiresApi(value=31)
    @Nullable
    public AudioDeviceInfo getCommunicationDevice() {
        return this.audioManager.getCommunicationDevice();
    }

    @RequiresApi(value=31)
    public boolean setCommunicationDevice(@NonNull AudioDeviceInfo device) {
        try {
            return this.audioManager.setCommunicationDevice(device);
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)"Invalid device chosen.", (Throwable)e);
            return false;
        }
    }

    @RequiresApi(value=31)
    public void clearCommunicationDevice() {
        this.audioManager.clearCommunicationDevice();
    }

    @RequiresApi(value=23)
    public void registerAudioDeviceCallback(@NonNull AudioDeviceCallback deviceCallback2, Handler handler) {
        this.audioManager.registerAudioDeviceCallback(deviceCallback2, handler);
    }

    @RequiresApi(value=23)
    public void unregisterAudioDeviceCallback(@NonNull AudioDeviceCallback deviceCallback2) {
        this.audioManager.unregisterAudioDeviceCallback(deviceCallback2);
    }

    @SuppressLint(value={"WrongConstant"})
    public boolean isWiredHeadsetOn() {
        AudioDeviceInfo[] devices;
        if (Build.VERSION.SDK_INT < 23) {
            return this.audioManager.isWiredHeadsetOn();
        }
        for (AudioDeviceInfo device : devices = this.audioManager.getDevices(3)) {
            int type = device.getType();
            if (type == 3) {
                return true;
            }
            if (type != 11) continue;
            return true;
        }
        return false;
    }

    public float ringVolumeWithMinimum() {
        int currentVolume = this.audioManager.getStreamVolume(2);
        int maxVolume = this.audioManager.getStreamMaxVolume(2);
        float volume = AudioManagerCompat.logVolume(currentVolume, maxVolume);
        float minVolume = AudioManagerCompat.logVolume(15, 100);
        return Math.max(volume, minVolume);
    }

    private static float logVolume(int volume, int maxVolume) {
        if (maxVolume == 0 || volume > maxVolume) {
            return 0.5f;
        }
        return (float)(1.0 - Math.log(maxVolume + 1 - volume) / Math.log(maxVolume + 1));
    }

    public float getVoiceCallVolume() {
        return this.audioManager.getStreamVolume(0);
    }

    public abstract SoundPool createSoundPool();

    public abstract boolean requestCallAudioFocus();

    public abstract void abandonCallAudioFocus();

    public static AudioManagerCompat create(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            return new Api26AudioManagerCompat(context);
        }
        return new Api21AudioManagerCompat(context);
    }

    @RequiresApi(value=26)
    private static class Api26AudioManagerCompat
    extends AudioManagerCompat {
        private static AudioAttributes AUDIO_ATTRIBUTES = new AudioAttributes.Builder().setContentType(1).setUsage(2).build();
        private AudioFocusRequest audioFocusRequest;

        private Api26AudioManagerCompat(@NonNull Context context) {
            super(context);
        }

        @Override
        public SoundPool createSoundPool() {
            return new SoundPool.Builder().setAudioAttributes(AUDIO_ATTRIBUTES).setMaxStreams(1).build();
        }

        @Override
        public boolean requestCallAudioFocus() {
            if (this.audioFocusRequest != null && this.hasFocus) {
                Log.w((String)AudioManagerCompat.TAG, (String)"Already requested audio focus. Ignoring...");
                return true;
            }
            if (this.audioFocusRequest == null) {
                this.audioFocusRequest = new AudioFocusRequest.Builder(4).setAudioAttributes(AUDIO_ATTRIBUTES).setOnAudioFocusChangeListener(this.onAudioFocusChangeListener).build();
            } else {
                Log.w((String)AudioManagerCompat.TAG, (String)"Trying again to request audio focus");
            }
            try {
                int result2 = this.audioManager.requestAudioFocus(this.audioFocusRequest);
                if (result2 != 1) {
                    Log.w((String)AudioManagerCompat.TAG, (String)("Audio focus not granted. Result code: " + result2));
                    return false;
                }
            }
            catch (SecurityException ex) {
                Log.w((String)AudioManagerCompat.TAG, (String)"Encountered security exception when requesting audio focus.");
                return false;
            }
            return true;
        }

        @Override
        public void abandonCallAudioFocus() {
            if (this.audioFocusRequest == null) {
                Log.w((String)AudioManagerCompat.TAG, (String)"Don't currently have audio focus. Ignoring...");
                return;
            }
            int result2 = this.audioManager.abandonAudioFocusRequest(this.audioFocusRequest);
            if (result2 != 1) {
                Log.w((String)AudioManagerCompat.TAG, (String)("Audio focus abandon failed. Result code: " + result2));
            }
            this.hasFocus = false;
            this.audioFocusRequest = null;
        }
    }

    private static class Api21AudioManagerCompat
    extends Api19AudioManagerCompat {
        private static AudioAttributes AUDIO_ATTRIBUTES = new AudioAttributes.Builder().setContentType(1).setUsage(2).setLegacyStreamType(0).build();

        private Api21AudioManagerCompat(@NonNull Context context) {
            super(context);
        }

        @Override
        public SoundPool createSoundPool() {
            return new SoundPool.Builder().setAudioAttributes(AUDIO_ATTRIBUTES).setMaxStreams(1).build();
        }
    }

    private static class Api19AudioManagerCompat
    extends AudioManagerCompat {
        private Api19AudioManagerCompat(@NonNull Context context) {
            super(context);
        }

        @Override
        public SoundPool createSoundPool() {
            return new SoundPool(1, 5, 0);
        }

        @Override
        public boolean requestCallAudioFocus() {
            int result2 = this.audioManager.requestAudioFocus(this.onAudioFocusChangeListener, 0, 4);
            if (result2 != 1) {
                Log.w((String)AudioManagerCompat.TAG, (String)("Audio focus not granted. Result code: " + result2));
                return false;
            }
            return true;
        }

        @Override
        public void abandonCallAudioFocus() {
            int result2 = this.audioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
            if (result2 != 1) {
                Log.w((String)AudioManagerCompat.TAG, (String)("Audio focus abandon failed. Result code: " + result2));
            }
        }
    }
}

