/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.capturers.camera.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.camera2.CaptureResult;
import android.media.Image;
import java.io.Closeable;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.media.capturers.camera.utils.OrientationTools;
import live.hms.video.media.capturers.camera.utils.YuvToRgbConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J8\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00020\u001b2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0007H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Llive/hms/video/media/capturers/camera/utils/ImageCaptureModel;", "Ljava/io/Closeable;", "image", "Landroid/media/Image;", "metadata", "Landroid/hardware/camera2/CaptureResult;", "orientation", "", "format", "<init>", "(Landroid/media/Image;Landroid/hardware/camera2/CaptureResult;Ljava/lang/Integer;I)V", "getImage", "()Landroid/media/Image;", "getMetadata", "()Landroid/hardware/camera2/CaptureResult;", "getOrientation", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getFormat", "()I", "close", "", "getBitmap", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "correctOrientation", "", "opts", "Landroid/graphics/BitmapFactory$Options;", "component1", "component2", "component3", "component4", "copy", "(Landroid/media/Image;Landroid/hardware/camera2/CaptureResult;Ljava/lang/Integer;I)Llive/hms/video/media/capturers/camera/utils/ImageCaptureModel;", "equals", "other", "", "hashCode", "toString", "", "lib_release"})
@SourceDebugExtension(value={"SMAP\nImageCaptureModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageCaptureModel.kt\nlive/hms/video/media/capturers/camera/utils/ImageCaptureModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class ImageCaptureModel
implements Closeable {
    @NotNull
    private final Image image;
    @NotNull
    private final CaptureResult metadata;
    @Nullable
    private final Integer orientation;
    private final int format;

    public ImageCaptureModel(@NotNull Image image, @NotNull CaptureResult metadata, @Nullable Integer orientation, int format) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.image = image;
        this.metadata = metadata;
        this.orientation = orientation;
        this.format = format;
    }

    @NotNull
    public final Image getImage() {
        return this.image;
    }

    @NotNull
    public final CaptureResult getMetadata() {
        return this.metadata;
    }

    @Nullable
    public final Integer getOrientation() {
        return this.orientation;
    }

    public final int getFormat() {
        return this.format;
    }

    @Override
    public void close() {
        this.image.close();
    }

    @Nullable
    public final Bitmap getBitmap(@NotNull Context context, boolean correctOrientation, @Nullable BitmapFactory.Options opts) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        switch (this.image.getFormat()) {
            case 256: 
            case 1768253795: {
                byte[] byArray;
                ByteBuffer buffer = this.image.getPlanes()[0].getBuffer();
                byte[] $this$getBitmap_u24lambda_u240 = byArray = new byte[buffer.remaining()];
                boolean bl = false;
                buffer.get($this$getBitmap_u24lambda_u240);
                byte[] bytes = byArray;
                bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)opts);
                break;
            }
            case 35: {
                Bitmap bitmap2 = Bitmap.createBitmap((int)this.image.getWidth(), (int)this.image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
                Bitmap bitmap3 = bitmap2;
                new YuvToRgbConverter(context).yuvToRgb(this.image, bitmap3);
                bitmap = bitmap3;
                break;
            }
            default: {
                bitmap = null;
            }
        }
        Bitmap bitmap4 = bitmap;
        return correctOrientation ? new OrientationTools().correctOrientation(bitmap4, this.orientation) : bitmap4;
    }

    public static /* synthetic */ Bitmap getBitmap$default(ImageCaptureModel imageCaptureModel, Context context, boolean bl, BitmapFactory.Options options, int n, Object object) {
        if ((n & 4) != 0) {
            options = null;
        }
        return imageCaptureModel.getBitmap(context, bl, options);
    }

    @NotNull
    public final Image component1() {
        return this.image;
    }

    @NotNull
    public final CaptureResult component2() {
        return this.metadata;
    }

    @Nullable
    public final Integer component3() {
        return this.orientation;
    }

    public final int component4() {
        return this.format;
    }

    @NotNull
    public final ImageCaptureModel copy(@NotNull Image image, @NotNull CaptureResult metadata, @Nullable Integer orientation, int format) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        return new ImageCaptureModel(image, metadata, orientation, format);
    }

    public static /* synthetic */ ImageCaptureModel copy$default(ImageCaptureModel imageCaptureModel, Image image, CaptureResult captureResult, Integer n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            image = imageCaptureModel.image;
        }
        if ((n3 & 2) != 0) {
            captureResult = imageCaptureModel.metadata;
        }
        if ((n3 & 4) != 0) {
            n = imageCaptureModel.orientation;
        }
        if ((n3 & 8) != 0) {
            n2 = imageCaptureModel.format;
        }
        return imageCaptureModel.copy(image, captureResult, n, n2);
    }

    @NotNull
    public String toString() {
        return "ImageCaptureModel(image=" + this.image + ", metadata=" + this.metadata + ", orientation=" + this.orientation + ", format=" + this.format + ')';
    }

    public int hashCode() {
        int result2 = this.image.hashCode();
        result2 = result2 * 31 + this.metadata.hashCode();
        result2 = result2 * 31 + (this.orientation == null ? 0 : ((Object)this.orientation).hashCode());
        result2 = result2 * 31 + Integer.hashCode(this.format);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ImageCaptureModel)) {
            return false;
        }
        ImageCaptureModel imageCaptureModel = (ImageCaptureModel)other;
        if (!Intrinsics.areEqual((Object)this.image, (Object)imageCaptureModel.image)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metadata, (Object)imageCaptureModel.metadata)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.orientation, (Object)imageCaptureModel.orientation)) {
            return false;
        }
        return this.format == imageCaptureModel.format;
    }
}

