/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import androidx.annotation.NonNull;
import hms.webrtc.VideoFrame;
import io.github.crow_misia.libyuv.RowStride;
import io.github.crow_misia.libyuv.Yuv;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Llive/hms/video/utils/VideoFrameToBitmapConverter;", "", "<init>", "()V", "Companion", "lib_release"})
public final class VideoFrameToBitmapConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "VideoFrameToBitmapConverter";

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Llive/hms/video/utils/VideoFrameToBitmapConverter$Companion;", "", "<init>", "()V", "TAG", "", "convertToBitmap", "Landroid/graphics/Bitmap;", "videoFrame", "Lhms/webrtc/VideoFrame;", "applyRotation", "", "convertI420ToArgb", "i420Buffer", "Lhms/webrtc/VideoFrame$I420Buffer;", "rotateBitmap", "bitmap", "degrees", "", "getByteArrayFromByteBuffer", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Bitmap convertToBitmap(@NotNull VideoFrame videoFrame, boolean applyRotation) {
            Bitmap bitmap;
            Intrinsics.checkNotNullParameter((Object)videoFrame, (String)"videoFrame");
            VideoFrame.I420Buffer i420Buffer = videoFrame.getBuffer().toI420();
            if (i420Buffer == null) {
                return null;
            }
            VideoFrame.I420Buffer i420Buffer2 = i420Buffer;
            try {
                int rotationDegrees = applyRotation ? videoFrame.getRotation() : 0;
                Bitmap bitmap2 = this.convertI420ToArgb(i420Buffer2);
                bitmap = applyRotation && rotationDegrees != 0 ? this.rotateBitmap(bitmap2, rotationDegrees) : bitmap2;
            }
            catch (Exception e) {
                HMSLogger.INSTANCE.e(VideoFrameToBitmapConverter.TAG, "Error converting VideoFrame to Bitmap", e);
                bitmap = null;
            }
            finally {
                i420Buffer2.release();
            }
            return bitmap;
        }

        public static /* synthetic */ Bitmap convertToBitmap$default(Companion companion, VideoFrame videoFrame, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.convertToBitmap(videoFrame, bl);
        }

        private final Bitmap convertI420ToArgb(VideoFrame.I420Buffer i420Buffer) {
            int width = i420Buffer.getWidth();
            int height = i420Buffer.getHeight();
            ByteBuffer byteBuffer = i420Buffer.getDataY();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getDataY(...)");
            ByteBuffer srcY = byteBuffer;
            ByteBuffer byteBuffer2 = i420Buffer.getDataU();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"getDataU(...)");
            ByteBuffer srcU = byteBuffer2;
            ByteBuffer byteBuffer3 = i420Buffer.getDataV();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"getDataV(...)");
            ByteBuffer srcV = byteBuffer3;
            int strideY = RowStride.constructor-impl((int)i420Buffer.getStrideY());
            int strideU = RowStride.constructor-impl((int)i420Buffer.getStrideU());
            int strideV = RowStride.constructor-impl((int)i420Buffer.getStrideV());
            int offsetY = 0;
            int offsetU = 0;
            int offsetV = 0;
            ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(width * height * 4);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer4, (String)"allocateDirect(...)");
            ByteBuffer dstARGB = byteBuffer4;
            int dstStride = RowStride.constructor-impl((int)(width * 4));
            int dstOffset = 0;
            Yuv.INSTANCE.convertI420ToARGB(srcY, strideY, offsetY, srcV, strideV, offsetV, srcU, strideU, offsetU, dstARGB, dstStride, dstOffset, width, height);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
            Bitmap bitmap2 = bitmap;
            bitmap2.copyPixelsFromBuffer((Buffer)dstARGB);
            return bitmap2;
        }

        private final Bitmap rotateBitmap(Bitmap bitmap, int degrees) {
            if (degrees == 0) {
                return bitmap;
            }
            Matrix matrix = new Matrix();
            matrix.postRotate((float)degrees);
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
            return bitmap2;
        }

        private final byte[] getByteArrayFromByteBuffer(@NonNull ByteBuffer byteBuffer) {
            byte[] bytesArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytesArray, 0, bytesArray.length);
            return bytesArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

