/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.factories;

import android.content.Context;
import android.content.SharedPreferences;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.preference.PreferenceManager;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import hms.webrtc.AudioProcessingFactory;
import hms.webrtc.EglBase;
import hms.webrtc.Logging;
import hms.webrtc.PeerConnectionFactory;
import hms.webrtc.VideoDecoderFactory;
import hms.webrtc.VideoEncoderFactory;
import hms.webrtc.audio.AudioDeviceModule;
import hms.webrtc.audio.JavaAudioDeviceModule;
import hms.webrtc.audio.WebRtcAudioRecord;
import hms.webrtc.audio.WebRtcAudioTrack;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import live.hms.video.encoder.video.SimulcastVideoEncoderFactoryWrapper;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.factories.HMSPeerConnectionFactory;
import live.hms.video.factories.HMSVideoDecoderFactory;
import live.hms.video.factories.SafeVariable;
import live.hms.video.factories.noisecancellation.NoiseCancellation;
import live.hms.video.factories.noisecancellation.NoiseCancellationFactoryImpl;
import live.hms.video.factories.noisecancellation.NoiseCancellationStatusChecker;
import live.hms.video.media.capturers.HMSWavCapturer;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSTrackSettings;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sdk.models.enums.AudioMixingMode;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HMSUtils;
import live.hms.video.utils.SharedEglContext;
import live.hms.video.utils.WertcAudioUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0004EHKV\b\u0000\u0018\u0000 \u0088\u00012\u00020\u0001:\u0002\u0088\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020NH\u0002J\b\u0010[\u001a\u00020YH\u0003J\u0010\u0010\\\u001a\u00020Y2\u0006\u0010Z\u001a\u00020NH\u0002J\u001e\u0010]\u001a\u00020Y2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020aJ\u0018\u0010e\u001a\u00020Y2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020<H\u0007J\u000e\u0010i\u001a\u00020Y2\u0006\u0010h\u001a\u00020<J\u0010\u0010j\u001a\u00020Y2\u0006\u0010f\u001a\u00020gH\u0003J\b\u0010k\u001a\u00020YH\u0002J\u0006\u0010l\u001a\u00020YJ'\u0010m\u001a\n o*\u0004\u0018\u00010n0n2\b\b\u0002\u0010`\u001a\u00020a2\u0006\u0010^\u001a\u00020_H\u0002\u00a2\u0006\u0002\u0010pJ\b\u0010q\u001a\u00020YH\u0002J \u0010r\u001a\u00020P2\u0006\u0010s\u001a\u00020P2\u0006\u0010t\u001a\u00020B2\u0006\u0010u\u001a\u00020vH\u0002J\n\u0010w\u001a\u0004\u0018\u00010xH\u0002J\u0010\u0010y\u001a\u00020Y2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010z\u001a\u00020Y2\u0006\u0010{\u001a\u00020|H\u0002J\u001a\u0010\u0083\u0001\u001a\u00020Y2\u0007\u0010\u0084\u0001\u001a\u00020B2\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001J\u0011\u0010\u0087\u0001\u001a\u00020Y2\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R+\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR+\u0010 \u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u001f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u001e\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R \u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R+\u0010.\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020-8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b3\u0010\u001e\u001a\u0004\b/\u00100\"\u0004\b1\u00102R+\u00105\u001a\u0002042\u0006\u0010\u0016\u001a\u0002048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b:\u0010\u001e\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u000e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010D\u001a\u00020EX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010FR\u0010\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010IR\u0010\u0010J\u001a\u00020KX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010LR\u000e\u0010M\u001a\u00020NX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020NX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010S\u001a\u0004\u0018\u00010TX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010WR\u000e\u0010c\u001a\u00020dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010}\u001a\u00020~8BX\u0082\u0084\u0002\u00a2\u0006\u000f\n\u0006\b\u0081\u0001\u0010\u0082\u0001\u001a\u0005\b\u007f\u0010\u0080\u0001\u00a8\u0006\u0089\u0001"}, d2={"Llive/hms/video/factories/HMSPeerConnectionFactory;", "", "context", "Landroid/content/Context;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "ncStatusChecker", "Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;", "<init>", "(Landroid/content/Context;Llive/hms/video/events/AnalyticsEventsService;Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;)V", "getContext", "()Landroid/content/Context;", "getAnalyticsEventsService", "()Llive/hms/video/events/AnalyticsEventsService;", "getNcStatusChecker", "()Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;", "noiseCancellation", "Llive/hms/video/factories/noisecancellation/NoiseCancellation;", "getNoiseCancellation", "()Llive/hms/video/factories/noisecancellation/NoiseCancellation;", "setNoiseCancellation", "(Llive/hms/video/factories/noisecancellation/NoiseCancellation;)V", "<set-?>", "Lhms/webrtc/VideoEncoderFactory;", "videoEncoderFactory", "getVideoEncoderFactory", "()Lhms/webrtc/VideoEncoderFactory;", "setVideoEncoderFactory", "(Lhms/webrtc/VideoEncoderFactory;)V", "videoEncoderFactory$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lhms/webrtc/VideoDecoderFactory;", "videoDecoderFactory", "getVideoDecoderFactory", "()Lhms/webrtc/VideoDecoderFactory;", "setVideoDecoderFactory", "(Lhms/webrtc/VideoDecoderFactory;)V", "videoDecoderFactory$delegate", "factory", "Llive/hms/video/factories/SafeVariable;", "Lhms/webrtc/PeerConnectionFactory;", "getFactory", "()Llive/hms/video/factories/SafeVariable;", "setFactory", "(Llive/hms/video/factories/SafeVariable;)V", "Lhms/webrtc/audio/WebRtcAudioRecord;", "webrtcAudioRecord", "getWebrtcAudioRecord", "()Lhms/webrtc/audio/WebRtcAudioRecord;", "setWebrtcAudioRecord", "(Lhms/webrtc/audio/WebRtcAudioRecord;)V", "webrtcAudioRecord$delegate", "Lhms/webrtc/audio/WebRtcAudioTrack;", "webRtcAudioTrack", "getWebRtcAudioTrack", "()Lhms/webrtc/audio/WebRtcAudioTrack;", "setWebRtcAudioTrack", "(Lhms/webrtc/audio/WebRtcAudioTrack;)V", "webRtcAudioTrack$delegate", "_audioMixingMode", "Llive/hms/video/sdk/models/enums/AudioMixingMode;", "nextSchedulerId", "Ljava/util/concurrent/atomic/AtomicInteger;", "audioManager", "Landroid/media/AudioManager;", "inputSampleRate", "", "outputSampleRate", "audioRecordErrorCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioRecordErrorCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioRecordErrorCallback$1;", "audioTrackErrorCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioTrackErrorCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioTrackErrorCallback$1;", "audioRecordStateCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioRecordStateCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioRecordStateCallback$1;", "systemAudioByteBuffer", "Ljava/nio/ByteBuffer;", "systemAudioShortArray", "", "combinedByteBuffer", "capacity", "mAudioRecord", "Landroid/media/AudioRecord;", "audioBufferCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioBufferCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioBufferCallback$1;", "scaleUpMicVolume", "", "micAudioByteBuffer", "captureSystemAudio", "mixAudioBytes", "initialize", "hmsTrackSettings", "Llive/hms/video/media/settings/HMSTrackSettings;", "isSimulcastEnabled", "", "serverSoftwareEchoCancellationEnabled", "isSystemAudioCaptureEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "startAudioMixing", "mMediaProjection", "Landroid/media/projection/MediaProjection;", "audioMixingMode", "setAudioMixingMode", "initAudioRecorder", "initchunk", "stopAudioMixing", "getPeerConnectionFactoryBuilder", "Lhms/webrtc/PeerConnectionFactory$Builder;", "kotlin.jvm.PlatformType", "(ZLlive/hms/video/media/settings/HMSTrackSettings;)Lhms/webrtc/PeerConnectionFactory$Builder;", "initPeerConnectionFactory", "scaleValues", "buff", "len", "scale", "", "newDefaultScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "sendAECAnalytics", "sendMicCaptureFailedEvent", "errorMessage", "", "wavCapturer", "Llive/hms/video/media/capturers/HMSWavCapturer;", "getWavCapturer", "()Llive/hms/video/media/capturers/HMSWavCapturer;", "wavCapturer$delegate", "Lkotlin/Lazy;", "streamAndPlayAudioFromRawFile", "audioResourceId", "hmsActionResultListener", "Llive/hms/video/sdk/HMSActionResultListener;", "stopAudioFromRawFile", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHMSPeerConnectionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSPeerConnectionFactory.kt\nlive/hms/video/factories/HMSPeerConnectionFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,579:1\n1#2:580\n*E\n"})
public final class HMSPeerConnectionFactory {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Context context;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @NotNull
    private final NoiseCancellationStatusChecker ncStatusChecker;
    public NoiseCancellation noiseCancellation;
    @NotNull
    private final ReadWriteProperty videoEncoderFactory$delegate;
    @NotNull
    private final ReadWriteProperty videoDecoderFactory$delegate;
    @NotNull
    private SafeVariable<PeerConnectionFactory> factory;
    @NotNull
    private final ReadWriteProperty webrtcAudioRecord$delegate;
    @NotNull
    private final ReadWriteProperty webRtcAudioTrack$delegate;
    @NotNull
    private AudioMixingMode _audioMixingMode;
    @NotNull
    private AtomicInteger nextSchedulerId;
    @NotNull
    private final AudioManager audioManager;
    private final int inputSampleRate;
    private final int outputSampleRate;
    @NotNull
    private final audioRecordErrorCallback.1 audioRecordErrorCallback;
    @NotNull
    private final audioTrackErrorCallback.1 audioTrackErrorCallback;
    @NotNull
    private final audioRecordStateCallback.1 audioRecordStateCallback;
    private ByteBuffer systemAudioByteBuffer;
    private short[] systemAudioShortArray;
    private ByteBuffer combinedByteBuffer;
    private int capacity;
    @Nullable
    private AudioRecord mAudioRecord;
    @NotNull
    private final audioBufferCallback.1 audioBufferCallback;
    @NotNull
    private final AtomicBoolean isSystemAudioCaptureEnabled;
    @NotNull
    private final Lazy wavCapturer$delegate;
    @NotNull
    private static final String TAG = "HMSPeerConnectionFactory";
    @NotNull
    private static final String PREF_AEC_EVENT_KEY = "aec_event";
    private static final boolean PREF_AEC_EVENT_DEFAULT = false;
    private static final int DEFAULT_AUDIO_FORMAT = 2;
    private static final int DEFAULT_AUDIO_SOURCE = 7;
    private static final int INPUT_BITS_PER_SAMPLE = 16;
    private static final int OUTPUT_BITS_PER_SAMPLE = 16;
    private static final int INPUT_NUM_OF_CHANNELS = 1;
    private static final int OUTPUT_NUM_OF_CHANNELS = 1;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final float MIC_VOLUME_SCALE = 5.0f;
    private static final float FILE_VOLUME_SCALE = 0.1f;

    public HMSPeerConnectionFactory(@NotNull Context context, @NotNull AnalyticsEventsService analyticsEventsService2, @NotNull NoiseCancellationStatusChecker ncStatusChecker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        Intrinsics.checkNotNullParameter((Object)ncStatusChecker, (String)"ncStatusChecker");
        this.context = context;
        this.analyticsEventsService = analyticsEventsService2;
        this.ncStatusChecker = ncStatusChecker;
        this.videoEncoderFactory$delegate = Delegates.INSTANCE.notNull();
        this.videoDecoderFactory$delegate = Delegates.INSTANCE.notNull();
        this.factory = new SafeVariable();
        this.webrtcAudioRecord$delegate = Delegates.INSTANCE.notNull();
        this.webRtcAudioTrack$delegate = Delegates.INSTANCE.notNull();
        this._audioMixingMode = AudioMixingMode.TALK_AND_MUSIC;
        this.nextSchedulerId = new AtomicInteger(0);
        Object object = this.context.getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        this.audioManager = (AudioManager)object;
        this.inputSampleRate = WertcAudioUtils.Companion.getSampleRate(this.audioManager);
        this.outputSampleRate = WertcAudioUtils.Companion.getSampleRate(this.audioManager);
        this.audioRecordErrorCallback = new JavaAudioDeviceModule.AudioRecordErrorCallback(this){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onWebRtcAudioRecordInitError(String errorMessage) {
                String errorMessage2 = "audioRecordErrorCallback:: onWebRtcAudioRecordError:: " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, String errorMessage) {
                String errorMessage2 = "audioRecordErrorCallback:: onWebRtcAudioRecordStartError:: " + errorCode + " ==> " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioRecordError(String errorMessage) {
                String errorMessage2 = "audioRecordErrorCallback:: onWebRtcAudioRecordError:: " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }
        };
        this.audioTrackErrorCallback = new JavaAudioDeviceModule.AudioTrackErrorCallback(this){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onWebRtcAudioTrackInitError(String errorMessage) {
                String errorMessage2 = "audioTrackErrorCallback:: onWebRtcAudioRecordInitError:: " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, String errorMessage) {
                String errorMessage2 = "audioTrackErrorCallback:: onWebRtcAudioRecordStartError:: " + errorCode + " ==> " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioTrackError(String errorMessage) {
                String errorMessage2 = "audioTrackErrorCallback:: onWebRtcAudioRecordError:: " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }
        };
        this.audioRecordStateCallback = new JavaAudioDeviceModule.AudioRecordStateCallback(){

            public void onWebRtcAudioRecordStart() {
                HMSLogger.INSTANCE.v("HMSPeerConnectionFactory", "~~ onWebRtcAudioRecordStart ~~");
            }

            public void onWebRtcAudioRecordStop() {
                HMSLogger.INSTANCE.v("HMSPeerConnectionFactory", "~~ onWebRtcAudioRecordStop ~~");
            }
        };
        this.audioBufferCallback = new WebRtcAudioRecord.AudioBufferCallback(this){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBuffer(ByteBuffer micByteBuffer, int micBytesRead) {
                long startTime = System.currentTimeMillis();
                if (HMSPeerConnectionFactory.access$get_audioMixingMode$p(this.this$0) == AudioMixingMode.TALK_AND_MUSIC || HMSPeerConnectionFactory.access$get_audioMixingMode$p(this.this$0) == AudioMixingMode.MUSIC_ONLY) {
                    HMSLogger.d("AudioMixing", "Mixing system audio and mic data");
                    if (HMSPeerConnectionFactory.access$getWavCapturer(this.this$0).isStarted().get()) {
                        HMSWavCapturer hMSWavCapturer = HMSPeerConnectionFactory.access$getWavCapturer(this.this$0);
                        ByteBuffer byteBuffer = HMSPeerConnectionFactory.access$getSystemAudioByteBuffer$p(this.this$0);
                        if (byteBuffer == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
                            byteBuffer = null;
                        }
                        hMSWavCapturer.readNext10ms(byteBuffer);
                    } else {
                        HMSPeerConnectionFactory.access$getWebrtcAudioRecord(this.this$0).isMixingNeeded(false);
                    }
                    if (HMSPeerConnectionFactory.access$isSystemAudioCaptureEnabled$p(this.this$0).get() && Build.VERSION.SDK_INT >= 29) {
                        HMSPeerConnectionFactory.access$getWebrtcAudioRecord(this.this$0).isMixingNeeded(true);
                        HMSPeerConnectionFactory.access$captureSystemAudio(this.this$0);
                    }
                    ByteBuffer byteBuffer = micByteBuffer;
                    if (byteBuffer != null) {
                        ByteBuffer byteBuffer2 = byteBuffer;
                        HMSPeerConnectionFactory hMSPeerConnectionFactory = this.this$0;
                        ByteBuffer it = byteBuffer2;
                        boolean bl = false;
                        HMSPeerConnectionFactory.access$mixAudioBytes(hMSPeerConnectionFactory, it);
                    }
                } else {
                    HMSLogger.d("AudioMixing", "Not Mixing system audio and mic data :: TALK_MODE");
                    ByteBuffer byteBuffer = micByteBuffer;
                    if (byteBuffer != null) {
                        ByteBuffer it = byteBuffer;
                        boolean bl = false;
                    }
                }
                long endTime = System.currentTimeMillis();
                long timeTaken = endTime - startTime;
                HMSLogger.d("HMSPeerConnectionFactory", " Callback took " + timeTaken + " ms to finish");
            }
        };
        this.isSystemAudioCaptureEnabled = new AtomicBoolean(false);
        this.wavCapturer$delegate = LazyKt.lazy(() -> HMSPeerConnectionFactory.wavCapturer_delegate$lambda$5(this));
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AnalyticsEventsService getAnalyticsEventsService() {
        return this.analyticsEventsService;
    }

    @NotNull
    public final NoiseCancellationStatusChecker getNcStatusChecker() {
        return this.ncStatusChecker;
    }

    @NotNull
    public final NoiseCancellation getNoiseCancellation() {
        NoiseCancellation noiseCancellation = this.noiseCancellation;
        if (noiseCancellation != null) {
            return noiseCancellation;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"noiseCancellation");
        return null;
    }

    public final void setNoiseCancellation(@NotNull NoiseCancellation noiseCancellation) {
        Intrinsics.checkNotNullParameter((Object)noiseCancellation, (String)"<set-?>");
        this.noiseCancellation = noiseCancellation;
    }

    private final VideoEncoderFactory getVideoEncoderFactory() {
        return (VideoEncoderFactory)this.videoEncoderFactory$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
        this.videoEncoderFactory$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)videoEncoderFactory);
    }

    private final VideoDecoderFactory getVideoDecoderFactory() {
        return (VideoDecoderFactory)this.videoDecoderFactory$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
        this.videoDecoderFactory$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)videoDecoderFactory);
    }

    @NotNull
    public final SafeVariable<PeerConnectionFactory> getFactory() {
        return this.factory;
    }

    public final void setFactory(@NotNull SafeVariable<PeerConnectionFactory> safeVariable) {
        Intrinsics.checkNotNullParameter(safeVariable, (String)"<set-?>");
        this.factory = safeVariable;
    }

    private final WebRtcAudioRecord getWebrtcAudioRecord() {
        return (WebRtcAudioRecord)this.webrtcAudioRecord$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final void setWebrtcAudioRecord(WebRtcAudioRecord webRtcAudioRecord) {
        this.webrtcAudioRecord$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)webRtcAudioRecord);
    }

    private final WebRtcAudioTrack getWebRtcAudioTrack() {
        return (WebRtcAudioTrack)this.webRtcAudioTrack$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final void setWebRtcAudioTrack(WebRtcAudioTrack webRtcAudioTrack) {
        this.webRtcAudioTrack$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)webRtcAudioTrack);
    }

    private final void scaleUpMicVolume(ByteBuffer micAudioByteBuffer) {
        ShortBuffer micAudioShortBuffer = micAudioByteBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] micAudioShortArray = new short[micAudioByteBuffer.limit() / 2];
        micAudioShortBuffer.get(micAudioShortArray);
        this.scaleValues(micAudioShortArray, micAudioShortArray.length, 5.0f);
    }

    @RequiresApi(value=29)
    private final void captureSystemAudio() {
        ByteBuffer byteBuffer;
        AudioRecord audioRecord = this.mAudioRecord;
        Intrinsics.checkNotNull((Object)audioRecord);
        ByteBuffer byteBuffer2 = this.systemAudioByteBuffer;
        if (byteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            byteBuffer2 = null;
        }
        if ((byteBuffer = this.systemAudioByteBuffer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            byteBuffer = null;
        }
        int capturedNumOfBytes = audioRecord.read(byteBuffer2, byteBuffer.capacity(), 0);
        HMSLogger.d("AudioMixing", "Read " + capturedNumOfBytes + " bytes of System audio buffer");
    }

    private final void mixAudioBytes(ByteBuffer micAudioByteBuffer) {
        micAudioByteBuffer.position(0);
        ByteBuffer byteBuffer = this.systemAudioByteBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            byteBuffer = null;
        }
        byteBuffer.position(0);
        ShortBuffer micAudioShortBuffer = micAudioByteBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] micAudioShortArray = new short[micAudioByteBuffer.limit() / 2];
        micAudioShortBuffer.get(micAudioShortArray);
        ByteBuffer byteBuffer2 = this.systemAudioByteBuffer;
        if (byteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            byteBuffer2 = null;
        }
        ShortBuffer shortBuffer = byteBuffer2.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] sArray = this.systemAudioShortArray;
        if (this.systemAudioShortArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            sArray = null;
        }
        shortBuffer.get(sArray);
        this.scaleValues(micAudioShortArray, micAudioShortArray.length, 5.0f);
        short[] sArray2 = this.systemAudioShortArray;
        if (this.systemAudioShortArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            sArray2 = null;
        }
        short[] sArray3 = this.systemAudioShortArray;
        if (this.systemAudioShortArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            sArray3 = null;
        }
        this.scaleValues(sArray2, sArray3.length, 0.1f);
        int n = micAudioShortArray.length;
        short[] sArray4 = this.systemAudioShortArray;
        if (this.systemAudioShortArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            sArray4 = null;
        }
        short[] sArray5 = this.systemAudioShortArray;
        if (this.systemAudioShortArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            sArray5 = null;
        }
        byte[] combinedByteArray = HMSUtils.INSTANCE.addAndConvertBuffers(micAudioShortArray, n, sArray4, sArray5.length);
        this.combinedByteBuffer = ByteBuffer.wrap(combinedByteArray);
        micAudioByteBuffer.clear();
        if (this._audioMixingMode == AudioMixingMode.TALK_AND_MUSIC) {
            HMSLogger.d("AudioMixing", "Adding combinedByteBuffer");
            ByteBuffer byteBuffer3 = this.combinedByteBuffer;
            if (byteBuffer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"combinedByteBuffer");
                byteBuffer3 = null;
            }
            micAudioByteBuffer.put(byteBuffer3);
        } else if (this._audioMixingMode == AudioMixingMode.MUSIC_ONLY) {
            HMSLogger.d("AudioMixing", "Adding systemAudioByteBuffer");
            ByteBuffer byteBuffer4 = this.systemAudioByteBuffer;
            if (byteBuffer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
                byteBuffer4 = null;
            }
            micAudioByteBuffer.put(byteBuffer4);
        }
    }

    public final void initialize(@NotNull HMSTrackSettings hmsTrackSettings, boolean isSimulcastEnabled, boolean serverSoftwareEchoCancellationEnabled) {
        Intrinsics.checkNotNullParameter((Object)hmsTrackSettings, (String)"hmsTrackSettings");
        this.factory.initialize((Function0<PeerConnectionFactory>)((Function0)() -> HMSPeerConnectionFactory.initialize$lambda$0(this, hmsTrackSettings, serverSoftwareEchoCancellationEnabled, isSimulcastEnabled)));
    }

    @RequiresApi(value=29)
    public final void startAudioMixing(@NotNull MediaProjection mMediaProjection, @NotNull AudioMixingMode audioMixingMode) {
        Intrinsics.checkNotNullParameter((Object)mMediaProjection, (String)"mMediaProjection");
        Intrinsics.checkNotNullParameter((Object)((Object)audioMixingMode), (String)"audioMixingMode");
        HMSLogger.d("AudioMixing", "starting audio mixing in " + (Object)((Object)audioMixingMode) + " mode");
        this.initAudioRecorder(mMediaProjection);
        this.initchunk();
        this.isSystemAudioCaptureEnabled.set(true);
        this.getWebrtcAudioRecord().setBufferCallback((WebRtcAudioRecord.AudioBufferCallback)this.audioBufferCallback);
        this._audioMixingMode = audioMixingMode;
        this.getWebrtcAudioRecord().isMixingNeeded(true);
    }

    public final void setAudioMixingMode(@NotNull AudioMixingMode audioMixingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioMixingMode), (String)"audioMixingMode");
        HMSLogger.d("AudioMixing", "setting Audio Mixing mode to " + (Object)((Object)audioMixingMode));
        this._audioMixingMode = audioMixingMode;
    }

    @RequiresApi(value=29)
    private final void initAudioRecorder(MediaProjection mMediaProjection) {
        int size = AudioRecord.getMinBufferSize((int)this.inputSampleRate, (int)16, (int)2);
        AudioFormat format = new AudioFormat.Builder().setEncoding(2).setSampleRate(this.inputSampleRate).setChannelMask(4).build();
        AudioPlaybackCaptureConfiguration audioPlaybackCaptureConfiguration = new AudioPlaybackCaptureConfiguration.Builder(mMediaProjection).addMatchingUsage(1).addMatchingUsage(0).addMatchingUsage(14).build();
        Intrinsics.checkNotNullExpressionValue((Object)audioPlaybackCaptureConfiguration, (String)"build(...)");
        AudioPlaybackCaptureConfiguration playbackConfig = audioPlaybackCaptureConfiguration;
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.RECORD_AUDIO") != 0) {
            return;
        }
        AudioRecord audioRecord = this.mAudioRecord = new AudioRecord.Builder().setAudioFormat(format).setAudioPlaybackCaptureConfig(playbackConfig).build();
        Intrinsics.checkNotNull((Object)audioRecord);
        audioRecord.startRecording();
    }

    private final void initchunk() {
        int bytesPerFrame = 2;
        this.capacity = bytesPerFrame * (this.inputSampleRate / 100);
        this.systemAudioByteBuffer = ByteBuffer.allocateDirect(this.capacity).order(ByteOrder.nativeOrder());
        ByteBuffer byteBuffer = this.systemAudioByteBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            byteBuffer = null;
        }
        this.systemAudioShortArray = new short[byteBuffer.capacity() / 2];
    }

    public final void stopAudioMixing() {
        this.isSystemAudioCaptureEnabled.set(false);
        HMSLogger.d("AudioMixing", "stopping Audio mixing");
        this.getWebrtcAudioRecord().isMixingNeeded(false);
    }

    private final PeerConnectionFactory.Builder getPeerConnectionFactoryBuilder(boolean isSimulcastEnabled, HMSTrackSettings hmsTrackSettings) {
        PeerConnectionFactory.Builder builder;
        PeerConnectionFactory.Builder $this$getPeerConnectionFactoryBuilder_u24lambda_u241 = builder = PeerConnectionFactory.builder();
        boolean bl = false;
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        $this$getPeerConnectionFactoryBuilder_u24lambda_u241.setOptions(options);
        HMSVideoTrackSettings hMSVideoTrackSettings = hmsTrackSettings.getVideoSettings();
        this.setVideoEncoderFactory(new SimulcastVideoEncoderFactoryWrapper(SharedEglContext.INSTANCE.getContext(), false, false, hMSVideoTrackSettings != null ? hMSVideoTrackSettings.getForceSoftwareEncoder() : false, 6, null));
        EglBase.Context context = SharedEglContext.INSTANCE.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"<get-context>(...)");
        HMSVideoTrackSettings hMSVideoTrackSettings2 = hmsTrackSettings.getVideoSettings();
        this.setVideoDecoderFactory((VideoDecoderFactory)new HMSVideoDecoderFactory(context, hMSVideoTrackSettings2 != null ? hMSVideoTrackSettings2.getForceSoftwareDecoder() : false));
        $this$getPeerConnectionFactoryBuilder_u24lambda_u241.setVideoEncoderFactory(this.getVideoEncoderFactory());
        $this$getPeerConnectionFactoryBuilder_u24lambda_u241.setVideoDecoderFactory(this.getVideoDecoderFactory());
        this.setNoiseCancellation(new NoiseCancellationFactoryImpl(this.ncStatusChecker).jniLoad(this.context));
        HMSAudioTrackSettings hMSAudioTrackSettings = hmsTrackSettings.getAudioSettings();
        AudioProcessingFactory audioProcessingFactory = this.getNoiseCancellation().getAudioProcessingFactory(hMSAudioTrackSettings != null ? hMSAudioTrackSettings.getEnableNoiseCancellation() : false);
        if (audioProcessingFactory != null) {
            $this$getPeerConnectionFactoryBuilder_u24lambda_u241.setAudioProcessingFactory(audioProcessingFactory);
        }
        return builder;
    }

    static /* synthetic */ PeerConnectionFactory.Builder getPeerConnectionFactoryBuilder$default(HMSPeerConnectionFactory hMSPeerConnectionFactory, boolean bl, HMSTrackSettings hMSTrackSettings, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return hMSPeerConnectionFactory.getPeerConnectionFactoryBuilder(bl, hMSTrackSettings);
    }

    private final void initPeerConnectionFactory() {
        PeerConnectionFactory.InitializationOptions.Builder builder;
        PeerConnectionFactory.InitializationOptions.Builder $this$initPeerConnectionFactory_u24lambda_u243 = builder = PeerConnectionFactory.InitializationOptions.builder((Context)this.context);
        boolean bl = false;
        $this$initPeerConnectionFactory_u24lambda_u243.setFieldTrials("WebRTC-H264HighProfile/Enabled/WebRTC-MediaCodecVideoEncoder-AutomaticResize/Enabled/WebRTC-UseDifferentiatedCellularCosts/Enabled/");
        $this$initPeerConnectionFactory_u24lambda_u243.setInjectableLogger(HMSPeerConnectionFactory::initPeerConnectionFactory$lambda$3$lambda$2, Logging.Severity.LS_VERBOSE);
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)builder.createInitializationOptions());
    }

    private final short[] scaleValues(short[] buff, int len, float scale) {
        for (int i = 0; i < len; ++i) {
            short oldValue = buff[i];
            int newValue = (int)((float)buff[i] * scale);
            if (newValue > Short.MAX_VALUE) {
                newValue = Short.MAX_VALUE;
            } else if (newValue < Short.MIN_VALUE) {
                newValue = Short.MIN_VALUE;
            }
            buff[i] = (short)newValue;
        }
        return buff;
    }

    private final ScheduledExecutorService newDefaultScheduler() {
        AtomicInteger nextThreadId = new AtomicInteger(0);
        return Executors.newScheduledThreadPool(0, arg_0 -> HMSPeerConnectionFactory.newDefaultScheduler$lambda$4(this, nextThreadId, arg_0));
    }

    private final void sendAECAnalytics(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        boolean isAECEventSent = sharedPreferences.getBoolean(PREF_AEC_EVENT_KEY, false);
        if (!isAECEventSent) {
            boolean isHardwareAECSupported = JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported();
            AnalyticsEvent analyticsEvent = AnalyticsEventFactory.INSTANCE.audioEchoCancellation(isHardwareAECSupported);
            this.analyticsEventsService.queue(analyticsEvent);
            sharedPreferences.edit().putBoolean(PREF_AEC_EVENT_KEY, true).apply();
        }
    }

    private final void sendMicCaptureFailedEvent(String errorMessage) {
        HMSException hmsException = ErrorFactory.TracksErrors.MicCaptureFailed$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, errorMessage, null, null, 12, null);
        AnalyticsEvent analyticsEvent = AnalyticsEventFactory.INSTANCE.audioPublishFail(hmsException);
        this.analyticsEventsService.queue(analyticsEvent);
    }

    private final HMSWavCapturer getWavCapturer() {
        Lazy lazy = this.wavCapturer$delegate;
        return (HMSWavCapturer)lazy.getValue();
    }

    public final void streamAndPlayAudioFromRawFile(int audioResourceId, @NotNull HMSActionResultListener hmsActionResultListener) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)hmsActionResultListener, (String)"hmsActionResultListener");
        this.initchunk();
        try {
            boolean bl = false;
            this.getWavCapturer().loadUrl(audioResourceId);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object task2 = object;
        if (Result.isSuccess-impl((Object)task2)) {
            this.getWebrtcAudioRecord().setBufferCallback((WebRtcAudioRecord.AudioBufferCallback)this.audioBufferCallback);
            this.getWebrtcAudioRecord().isMixingNeeded(true);
            hmsActionResultListener.onSuccess();
        } else {
            hmsActionResultListener.onError(ErrorFactory.GenericErrors.Unknown$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.PLUGIN, "Unable to start wav playback", Result.exceptionOrNull-impl((Object)task2), null, 8, null));
        }
    }

    public final void stopAudioFromRawFile(@NotNull HMSActionResultListener hmsActionResultListener) {
        Intrinsics.checkNotNullParameter((Object)hmsActionResultListener, (String)"hmsActionResultListener");
        boolean isPlaying = this.getWavCapturer().isStarted().get();
        this.getWavCapturer().close();
        this.getWebrtcAudioRecord().isMixingNeeded(false);
        if (isPlaying) {
            hmsActionResultListener.onSuccess();
        } else {
            hmsActionResultListener.onError(ErrorFactory.GenericErrors.Unknown$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.PLUGIN, "Unable to stop because no wav file is playing", null, null, 8, null));
        }
    }

    private static final PeerConnectionFactory initialize$lambda$0(HMSPeerConnectionFactory this$0, HMSTrackSettings $hmsTrackSettings, boolean $serverSoftwareEchoCancellationEnabled, boolean $isSimulcastEnabled) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$hmsTrackSettings, (String)"$hmsTrackSettings");
        this$0.initPeerConnectionFactory();
        boolean isBuiltInAcousticEchoCancelerSupported = JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported();
        boolean useHardwareAcousticEchoCanceler = false;
        if (isBuiltInAcousticEchoCancelerSupported) {
            boolean bl;
            HMSAudioTrackSettings hMSAudioTrackSettings = $hmsTrackSettings.getAudioSettings();
            if ((hMSAudioTrackSettings != null ? hMSAudioTrackSettings.getUseHardwareAcousticEchoCanceler() : null) == null) {
                bl = !$serverSoftwareEchoCancellationEnabled;
            } else {
                Boolean bl2 = $hmsTrackSettings.getAudioSettings().getUseHardwareAcousticEchoCanceler();
                bl = bl2 != null ? bl2 : true;
            }
            useHardwareAcousticEchoCanceler = bl;
        }
        boolean useHardwareNoiseSuppressor = JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported();
        this$0.setWebrtcAudioRecord(new WebRtcAudioRecord(this$0.context, this$0.newDefaultScheduler(), this$0.audioManager, 7, 2, (JavaAudioDeviceModule.AudioRecordErrorCallback)this$0.audioRecordErrorCallback, (JavaAudioDeviceModule.AudioRecordStateCallback)this$0.audioRecordStateCallback, null, useHardwareAcousticEchoCanceler, useHardwareNoiseSuppressor));
        this$0.setWebRtcAudioTrack(new WebRtcAudioTrack(this$0.context, this$0.audioManager, null, (JavaAudioDeviceModule.AudioTrackErrorCallback)this$0.audioTrackErrorCallback, null, false, false));
        JavaAudioDeviceModule customAudioDeviceModule = new JavaAudioDeviceModule(this$0.context, this$0.audioManager, this$0.getWebrtcAudioRecord(), this$0.getWebRtcAudioTrack(), this$0.inputSampleRate, this$0.outputSampleRate, false, false);
        PeerConnectionFactory.Builder builder = this$0.getPeerConnectionFactoryBuilder($isSimulcastEnabled, $hmsTrackSettings);
        PeerConnectionFactory peerConnectionFactory = builder.setAudioDeviceModule((AudioDeviceModule)customAudioDeviceModule).createPeerConnectionFactory();
        this$0.sendAECAnalytics(this$0.context);
        Intrinsics.checkNotNull((Object)peerConnectionFactory);
        return peerConnectionFactory;
    }

    private static final void initPeerConnectionFactory$lambda$3$lambda$2(String message, Logging.Severity severity, String tag) {
        Intrinsics.checkNotNull((Object)severity);
        Intrinsics.checkNotNull((Object)tag);
        Intrinsics.checkNotNull((Object)message);
        HMSLogger.INSTANCE.webRTCLog$lib_release(severity, tag, message);
    }

    private static final Thread newDefaultScheduler$lambda$4(HMSPeerConnectionFactory this$0, AtomicInteger $nextThreadId, Runnable r2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nextThreadId, (String)"$nextThreadId");
        Thread thread = Executors.defaultThreadFactory().newThread(r2);
        String string = "WebRtcAudioRecordScheduler-%s-%s";
        Object[] objectArray = new Object[]{this$0.nextSchedulerId.getAndIncrement(), $nextThreadId.getAndIncrement()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        thread.setName(string2);
        return thread;
    }

    private static final HMSWavCapturer wavCapturer_delegate$lambda$5(HMSPeerConnectionFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new HMSWavCapturer(this$0.context, 48000, 0, 0, 12, null);
    }

    public static final /* synthetic */ void access$sendMicCaptureFailedEvent(HMSPeerConnectionFactory $this, String errorMessage) {
        $this.sendMicCaptureFailedEvent(errorMessage);
    }

    public static final /* synthetic */ AudioMixingMode access$get_audioMixingMode$p(HMSPeerConnectionFactory $this) {
        return $this._audioMixingMode;
    }

    public static final /* synthetic */ HMSWavCapturer access$getWavCapturer(HMSPeerConnectionFactory $this) {
        return $this.getWavCapturer();
    }

    public static final /* synthetic */ ByteBuffer access$getSystemAudioByteBuffer$p(HMSPeerConnectionFactory $this) {
        return $this.systemAudioByteBuffer;
    }

    public static final /* synthetic */ WebRtcAudioRecord access$getWebrtcAudioRecord(HMSPeerConnectionFactory $this) {
        return $this.getWebrtcAudioRecord();
    }

    public static final /* synthetic */ AtomicBoolean access$isSystemAudioCaptureEnabled$p(HMSPeerConnectionFactory $this) {
        return $this.isSystemAudioCaptureEnabled;
    }

    public static final /* synthetic */ void access$captureSystemAudio(HMSPeerConnectionFactory $this) {
        $this.captureSystemAudio();
    }

    public static final /* synthetic */ void access$mixAudioBytes(HMSPeerConnectionFactory $this, ByteBuffer micAudioByteBuffer) {
        $this.mixAudioBytes(micAudioByteBuffer);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HMSPeerConnectionFactory.class, "videoEncoderFactory", "getVideoEncoderFactory()Lhms/webrtc/VideoEncoderFactory;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HMSPeerConnectionFactory.class, "videoDecoderFactory", "getVideoDecoderFactory()Lhms/webrtc/VideoDecoderFactory;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HMSPeerConnectionFactory.class, "webrtcAudioRecord", "getWebrtcAudioRecord()Lhms/webrtc/audio/WebRtcAudioRecord;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HMSPeerConnectionFactory.class, "webRtcAudioTrack", "getWebRtcAudioTrack()Lhms/webrtc/audio/WebRtcAudioTrack;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Llive/hms/video/factories/HMSPeerConnectionFactory$Companion;", "", "<init>", "()V", "TAG", "", "PREF_AEC_EVENT_KEY", "PREF_AEC_EVENT_DEFAULT", "", "DEFAULT_AUDIO_FORMAT", "", "DEFAULT_AUDIO_SOURCE", "INPUT_BITS_PER_SAMPLE", "OUTPUT_BITS_PER_SAMPLE", "INPUT_NUM_OF_CHANNELS", "OUTPUT_NUM_OF_CHANNELS", "CALLBACK_BUFFER_SIZE_MS", "BUFFERS_PER_SECOND", "MIC_VOLUME_SCALE", "", "FILE_VOLUME_SCALE", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

