/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.media.AudioManager;
import android.media.audiofx.AudioEffect;
import android.os.Build;
import hms.webrtc.Logging;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Llive/hms/video/utils/WertcAudioUtils;", "", "()V", "Companion", "lib_release"})
public final class WertcAudioUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "WertcAudioUtils";
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    @Nullable
    private static AudioEffect.Descriptor[] cachedEffects;

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0016R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001a"}, d2={"Llive/hms/video/utils/WertcAudioUtils$Companion;", "", "()V", "AOSP_ACOUSTIC_ECHO_CANCELER", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "getAOSP_ACOUSTIC_ECHO_CANCELER", "()Ljava/util/UUID;", "TAG", "", "cachedEffects", "", "Landroid/media/audiofx/AudioEffect$Descriptor;", "[Landroid/media/audiofx/AudioEffect$Descriptor;", "getAvailableEffects", "()[Landroid/media/audiofx/AudioEffect$Descriptor;", "getSampleRate", "", "audioManager", "Landroid/media/AudioManager;", "getSampleRateForApiLevel", "isEffectTypeAvailable", "", "effectType", "blockListedUuid", "runningOnEmulator", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public final UUID getAOSP_ACOUSTIC_ECHO_CANCELER() {
            return AOSP_ACOUSTIC_ECHO_CANCELER;
        }

        private final AudioEffect.Descriptor[] getAvailableEffects() {
            if (cachedEffects != null) {
                return cachedEffects;
            }
            cachedEffects = AudioEffect.queryEffects();
            return cachedEffects;
        }

        public final boolean isEffectTypeAvailable(@NotNull UUID effectType, @NotNull UUID blockListedUuid) {
            Intrinsics.checkNotNullParameter((Object)effectType, (String)"effectType");
            Intrinsics.checkNotNullParameter((Object)blockListedUuid, (String)"blockListedUuid");
            AudioEffect.Descriptor[] descriptorArray = this.getAvailableEffects();
            if (descriptorArray == null) {
                return false;
            }
            for (AudioEffect.Descriptor d : descriptorArray) {
                if (!Intrinsics.areEqual((Object)d.type, (Object)effectType)) continue;
                return !Intrinsics.areEqual((Object)d.uuid, (Object)blockListedUuid);
            }
            return false;
        }

        public final int getSampleRateForApiLevel(@NotNull AudioManager audioManager) {
            String sampleRateString;
            Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
            String string = sampleRateString = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            return string != null ? Integer.parseInt(string) : 16000;
        }

        public final int getSampleRate(@NotNull AudioManager audioManager) {
            Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
            if (this.runningOnEmulator()) {
                Logging.d((String)WertcAudioUtils.TAG, (String)"Running emulator, overriding sample rate to 8 kHz.");
                return 8000;
            }
            int sampleRateHz = this.getSampleRateForApiLevel(audioManager);
            HMSLogger.d(WertcAudioUtils.TAG, "Sample rate is set to " + sampleRateHz + " Hz");
            return sampleRateHz;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean runningOnEmulator() {
            if (!Intrinsics.areEqual((Object)Build.HARDWARE, (Object)"goldfish")) return false;
            String string = Build.BRAND;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
            if (!StringsKt.startsWith$default((String)string, (String)"generic_", (boolean)false, (int)2, null)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

