/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.diagnostics;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import live.hms.video.connection.stats.HMSLocalAudioStats;
import live.hms.video.connection.stats.HMSLocalVideoStats;
import live.hms.video.connection.stats.HMSRTCStatsReport;
import live.hms.video.connection.stats.HMSRemoteAudioStats;
import live.hms.video.connection.stats.HMSRemoteVideoStats;
import live.hms.video.connection.stats.HMSStatsObserver;
import live.hms.video.diagnostics.ConnectivityCheckListener;
import live.hms.video.diagnostics.DiagnosticTokenService;
import live.hms.video.diagnostics.HMSAudioDeviceCheckListener;
import live.hms.video.diagnostics.HMSCameraCheckListener;
import live.hms.video.diagnostics.HMSDiagnostic;
import live.hms.video.diagnostics.ITransportListener;
import live.hms.video.diagnostics.models.ConnectivityCheckResult;
import live.hms.video.diagnostics.models.ConnectivityState;
import live.hms.video.diagnostics.models.DiagnosticTokenResponse;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.media.tracks.HMSLocalVideoTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.sdk.HMSUpdateListener;
import live.hms.video.sdk.SDKDelegate;
import live.hms.video.sdk.models.HMSConfig;
import live.hms.video.sdk.models.HMSMessage;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSRemovedFromRoom;
import live.hms.video.sdk.models.HMSRoleChangeRequest;
import live.hms.video.sdk.models.HMSRoom;
import live.hms.video.sdk.models.enums.HMSPeerUpdate;
import live.hms.video.sdk.models.enums.HMSRoomUpdate;
import live.hms.video.sdk.models.enums.HMSTrackUpdate;
import live.hms.video.sdk.models.trackchangerequest.HMSChangeTrackStateRequest;
import live.hms.video.sdk.transcripts.HmsTranscripts;
import live.hms.video.sessionstore.HmsSessionStore;
import live.hms.video.utils.HMSCoroutineScope;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.CandidatePairChangeEvent;
import org.webrtc.IceCandidate;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\u001c\u0018\u0000 =2\u00020\u0001:\u0001=B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0005H\u0002J\b\u0010)\u001a\u00020%H\u0002J\b\u0010*\u001a\u00020%H\u0002J\u0018\u0010+\u001a\u00020%2\b\b\u0002\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0018\u00100\u001a\u00020%2\b\u00101\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020\bJ\u0016\u00102\u001a\u00020%2\u0006\u00103\u001a\u0002042\u0006\u0010.\u001a\u000205J\u0006\u00106\u001a\u00020%J\u0006\u00107\u001a\u00020%J\u0006\u00108\u001a\u00020%J\u0006\u00109\u001a\u00020%J\u0006\u0010:\u001a\u00020%J\b\u0010;\u001a\u00020%H\u0002J\b\u0010<\u001a\u00020%H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0018\u00010\u0019j\u0004\u0018\u0001`\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006>"}, d2={"Llive/hms/video/diagnostics/HMSDiagnostic;", "", "delegate", "Llive/hms/video/sdk/SDKDelegate;", "customerUserId", "", "(Llive/hms/video/sdk/SDKDelegate;Ljava/lang/String;)V", "connectivityCheckListener", "Llive/hms/video/diagnostics/ConnectivityCheckListener;", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "isPreparing", "", "lastNetworkQualityUpdatedAt", "", "mp", "Landroid/media/MediaPlayer;", "recorder", "Landroid/media/MediaRecorder;", "recordingPath", "result", "Llive/hms/video/diagnostics/models/ConnectivityCheckResult;", "runnable", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "transportListener", "live/hms/video/diagnostics/HMSDiagnostic$transportListener$1", "Llive/hms/video/diagnostics/HMSDiagnostic$transportListener$1;", "videoTrack", "Llive/hms/video/media/tracks/HMSLocalVideoTrack;", "getVideoTrack", "()Llive/hms/video/media/tracks/HMSLocalVideoTrack;", "setVideoTrack", "(Llive/hms/video/media/tracks/HMSLocalVideoTrack;)V", "addPendingCQSTillNow", "", "handleTestCompletion", "joinConnectivityTestRoom", "authToken", "leaveConnectivityTestRoom", "setConnectivityCheckValues", "startCameraCheck", "cameraFacing", "Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "listener", "Llive/hms/video/diagnostics/HMSCameraCheckListener;", "startConnectivityCheck", "region", "startMicCheck", "context", "Landroid/content/Context;", "Llive/hms/video/diagnostics/HMSAudioDeviceCheckListener;", "startSpeakerCheck", "stopCameraCheck", "stopConnectivityCheck", "stopMicCheck", "stopSpeakerCheck", "tearDownDiagnostic", "updateAverageCQSInResult", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHMSDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSDiagnostic.kt\nlive/hms/video/diagnostics/HMSDiagnostic\n+ 2 Runnable.kt\nkotlinx/coroutines/RunnableKt\n*L\n1#1,405:1\n17#2:406\n*S KotlinDebug\n*F\n+ 1 HMSDiagnostic.kt\nlive/hms/video/diagnostics/HMSDiagnostic\n*L\n174#1:406\n*E\n"})
public final class HMSDiagnostic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SDKDelegate delegate;
    @Nullable
    private ConnectivityCheckListener connectivityCheckListener;
    @NotNull
    private ConnectivityCheckResult result;
    @Nullable
    private MediaRecorder recorder;
    @Nullable
    private String recordingPath;
    private long lastNetworkQualityUpdatedAt;
    @NotNull
    private final Handler handler;
    @NotNull
    private final transportListener.1 transportListener;
    @Nullable
    private HMSLocalVideoTrack videoTrack;
    @Nullable
    private Runnable runnable;
    @Nullable
    private MediaPlayer mp;
    private boolean isPreparing;
    @NotNull
    private static final String TAG = "HMSDiagnostic";

    public HMSDiagnostic(@NotNull SDKDelegate delegate, @Nullable String customerUserId) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.result = new ConnectivityCheckResult();
        this.delegate.startAudioManager$lib_release();
        this.handler = new Handler(Looper.getMainLooper());
        this.transportListener = new ITransportListener(this){
            final /* synthetic */ HMSDiagnostic this$0;
            {
                this.this$0 = $receiver;
            }

            public void onInitFetched() {
                block0: {
                    HMSLogger.d("HMSDiagnostic", "onInitFetched");
                    HMSDiagnostic.access$getResult$p(this.this$0).getSignallingReport().setInitConnected$lib_release(true);
                    HMSDiagnostic.access$getResult$p(this.this$0).setConnectivityState$lib_release(ConnectivityState.INIT_FETCHED);
                    ConnectivityCheckListener connectivityCheckListener = HMSDiagnostic.access$getConnectivityCheckListener$p(this.this$0);
                    if (connectivityCheckListener == null) break block0;
                    connectivityCheckListener.onConnectivityStateChanged(ConnectivityState.INIT_FETCHED);
                }
            }

            public void onWebSocketConnected(@NotNull String websocketUrl) {
                Intrinsics.checkNotNullParameter((Object)websocketUrl, (String)"websocketUrl");
                HMSLogger.d("HMSDiagnostic", "onWebSocketConnected");
                ConnectivityCheckListener connectivityCheckListener = HMSDiagnostic.access$getConnectivityCheckListener$p(this.this$0);
                if (connectivityCheckListener != null) {
                    connectivityCheckListener.onConnectivityStateChanged(ConnectivityState.SIGNAL_CONNECTED);
                }
                HMSDiagnostic.access$getResult$p(this.this$0).setConnectivityState$lib_release(ConnectivityState.SIGNAL_CONNECTED);
                HMSDiagnostic.access$getResult$p(this.this$0).getSignallingReport().setConnected$lib_release(true);
                HMSDiagnostic.access$getResult$p(this.this$0).getSignallingReport().setWebsocketUrl$lib_release(websocketUrl);
            }

            public void onICEConnected(boolean isPublish) {
                block3: {
                    block2: {
                        HMSLogger.d("HMSDiagnostic", "onICEConnected , isPublish :: " + isPublish);
                        if (!isPublish) break block2;
                        HMSDiagnostic.access$getResult$p(this.this$0).getMediaServerReport().setPublishICEConnected$lib_release(true);
                        HMSDiagnostic.access$getResult$p(this.this$0).setPublishICEConnected$lib_release(true);
                        if (!HMSDiagnostic.access$getResult$p(this.this$0).isSubscribeICEConnected$lib_release()) break block3;
                        HMSDiagnostic.access$getResult$p(this.this$0).setConnectivityState$lib_release(ConnectivityState.ICE_ESTABLISHED);
                        ConnectivityCheckListener connectivityCheckListener = HMSDiagnostic.access$getConnectivityCheckListener$p(this.this$0);
                        if (connectivityCheckListener != null) {
                            connectivityCheckListener.onConnectivityStateChanged(ConnectivityState.ICE_ESTABLISHED);
                        }
                        break block3;
                    }
                    HMSDiagnostic.access$getResult$p(this.this$0).getMediaServerReport().setSubcribeICEConnected$lib_release(true);
                    HMSDiagnostic.access$getResult$p(this.this$0).setSubscribeICEConnected$lib_release(true);
                    if (!HMSDiagnostic.access$getResult$p(this.this$0).isPublishICEConnected$lib_release()) break block3;
                    HMSDiagnostic.access$getResult$p(this.this$0).setConnectivityState$lib_release(ConnectivityState.ICE_ESTABLISHED);
                    ConnectivityCheckListener connectivityCheckListener = HMSDiagnostic.access$getConnectivityCheckListener$p(this.this$0);
                    if (connectivityCheckListener != null) {
                        connectivityCheckListener.onConnectivityStateChanged(ConnectivityState.ICE_ESTABLISHED);
                    }
                }
            }

            public void onIceCandidate(@NotNull IceCandidate candidate, boolean isPublish) {
                Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
                if (isPublish) {
                    List<IceCandidate> list = HMSDiagnostic.access$getResult$p(this.this$0).getMediaServerReport().getPublishIceCandidatesGathered();
                    Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type java.util.ArrayList<org.webrtc.IceCandidate>");
                    ((ArrayList)list).add(candidate);
                } else {
                    List<IceCandidate> list = HMSDiagnostic.access$getResult$p(this.this$0).getMediaServerReport().getSubscribeIceCandidatesGathered();
                    Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type java.util.ArrayList<org.webrtc.IceCandidate>");
                    ((ArrayList)list).add(candidate);
                }
            }

            public void onMediaCaptured() {
                block0: {
                    HMSDiagnostic.access$getResult$p(this.this$0).setConnectivityState$lib_release(ConnectivityState.MEDIA_CAPTURED);
                    ConnectivityCheckListener connectivityCheckListener = HMSDiagnostic.access$getConnectivityCheckListener$p(this.this$0);
                    if (connectivityCheckListener == null) break block0;
                    connectivityCheckListener.onConnectivityStateChanged(ConnectivityState.MEDIA_CAPTURED);
                }
            }

            public void onMediaPublished() {
                block0: {
                    HMSDiagnostic.access$getResult$p(this.this$0).setConnectivityState$lib_release(ConnectivityState.MEDIA_PUBLISHED);
                    ConnectivityCheckListener connectivityCheckListener = HMSDiagnostic.access$getConnectivityCheckListener$p(this.this$0);
                    if (connectivityCheckListener == null) break block0;
                    connectivityCheckListener.onConnectivityStateChanged(ConnectivityState.MEDIA_PUBLISHED);
                }
            }

            public void onSelectedCandidatePairChanged(@Nullable CandidatePairChangeEvent event, boolean isPublish) {
                if (isPublish) {
                    CandidatePairChangeEvent candidatePairChangeEvent = event;
                    HMSDiagnostic.access$getResult$p(this.this$0).getMediaServerReport().getPublishICECandidatePairSelected().setLocal$lib_release((IceCandidate)(candidatePairChangeEvent != null ? candidatePairChangeEvent.local : null));
                    CandidatePairChangeEvent candidatePairChangeEvent2 = event;
                    HMSDiagnostic.access$getResult$p(this.this$0).getMediaServerReport().getPublishICECandidatePairSelected().setRemote$lib_release((IceCandidate)(candidatePairChangeEvent2 != null ? candidatePairChangeEvent2.remote : null));
                } else {
                    CandidatePairChangeEvent candidatePairChangeEvent = event;
                    HMSDiagnostic.access$getResult$p(this.this$0).getMediaServerReport().getSubscribeICECandidatePairSelected().setLocal$lib_release((IceCandidate)(candidatePairChangeEvent != null ? candidatePairChangeEvent.local : null));
                    CandidatePairChangeEvent candidatePairChangeEvent3 = event;
                    HMSDiagnostic.access$getResult$p(this.this$0).getMediaServerReport().getSubscribeICECandidatePairSelected().setRemote$lib_release((IceCandidate)(candidatePairChangeEvent3 != null ? candidatePairChangeEvent3.remote : null));
                }
            }

            public void onNetworkQuality(int quality) {
                if (quality < 0) {
                    return;
                }
                if (HMSDiagnostic.access$getResult$p(this.this$0).getNetworkQualityValues$lib_release().size() == 0) {
                    HMSDiagnostic.access$getResult$p(this.this$0).getNetworkQualityValues$lib_release().add(Float.valueOf(quality));
                    HMSDiagnostic.access$setLastNetworkQualityUpdatedAt$p(this.this$0, System.currentTimeMillis());
                } else {
                    HMSDiagnostic.access$addPendingCQSTillNow(this.this$0);
                    HMSDiagnostic.access$getResult$p(this.this$0).getNetworkQualityValues$lib_release().add(Float.valueOf(quality));
                }
                HMSDiagnostic.access$updateAverageCQSInResult(this.this$0);
            }

            public void onCompleted() {
            }

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            }
        };
    }

    @NotNull
    public final Handler getHandler() {
        return this.handler;
    }

    private final void updateAverageCQSInResult() {
        if (!this.result.getNetworkQualityValues$lib_release().isEmpty()) {
            this.result.getMediaServerReport().setConnectionQualityScore$lib_release(Float.valueOf((float)CollectionsKt.averageOfFloat((Iterable)this.result.getNetworkQualityValues$lib_release())));
        }
    }

    @Nullable
    public final HMSLocalVideoTrack getVideoTrack() {
        return this.videoTrack;
    }

    public final void setVideoTrack(@Nullable HMSLocalVideoTrack hMSLocalVideoTrack) {
        this.videoTrack = hMSLocalVideoTrack;
    }

    public final void startCameraCheck(@NotNull HMSVideoTrackSettings.CameraFacing cameraFacing, @NotNull HMSCameraCheckListener listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)cameraFacing), (String)"cameraFacing");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, listener, null){
            Object L$0;
            int label;
            final /* synthetic */ HMSDiagnostic this$0;
            final /* synthetic */ HMSCameraCheckListener $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = this.this$0;
                        this.L$0 = var3_3;
                        this.label = 1;
                        v0 = SDKDelegate.getLocalVideoTrack$default(HMSDiagnostic.access$getDelegate$p(this.this$0), null, (Continuation)this, 1, null);
                        ** if (v0 != var4_2) goto lbl13
lbl12:
                        // 1 sources

                        return var4_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        var3_3 = (HMSDiagnostic)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl20:
                            // 2 sources

                            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type live.hms.video.media.tracks.HMSLocalVideoTrack");
                            var3_3.setVideoTrack((HMSLocalVideoTrack)v0);
                            v1 = this.this$0.getVideoTrack();
                            Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type live.hms.video.media.tracks.HMSVideoTrack");
                            this.$listener.onVideoTrack(v1);
                            HMSDiagnostic.access$getResult$p(this.this$0).getDeviceTestReport().getVideoInputReport().setPassed(true);
                        }
                        catch (HMSException exception) {
                            this.$listener.onError(exception);
                            HMSDiagnostic.access$getResult$p(this.this$0).getDeviceTestReport().getVideoInputReport().setPassed(false);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void startCameraCheck$default(HMSDiagnostic hMSDiagnostic, HMSVideoTrackSettings.CameraFacing cameraFacing, HMSCameraCheckListener hMSCameraCheckListener, int n, Object object) {
        if ((n & 1) != 0) {
            cameraFacing = HMSVideoTrackSettings.CameraFacing.FRONT;
        }
        hMSDiagnostic.startCameraCheck(cameraFacing, hMSCameraCheckListener);
    }

    public final void stopCameraCheck() {
        block0: {
            HMSLocalVideoTrack hMSLocalVideoTrack = this.videoTrack;
            if (hMSLocalVideoTrack == null) break block0;
            hMSLocalVideoTrack.stopCapturing$lib_release();
        }
    }

    public final void startMicCheck(@NotNull Context context, @NotNull HMSAudioDeviceCheckListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.recorder = new MediaRecorder();
        boolean $i$f$Runnable = false;
        this.runnable = new Runnable(this, listener){
            final /* synthetic */ HMSDiagnostic this$0;
            final /* synthetic */ HMSAudioDeviceCheckListener $listener$inlined;
            {
                this.this$0 = hMSDiagnostic;
                this.$listener$inlined = hMSAudioDeviceCheckListener;
            }

            public final void run() {
                boolean bl = false;
                try {
                    MediaRecorder mediaRecorder = HMSDiagnostic.access$getRecorder$p(this.this$0);
                    int volume = ((Number)(mediaRecorder != null ? (Number)Float.valueOf(mediaRecorder.getMaxAmplitude()) : (Number)Integer.valueOf(0))).intValue();
                    this.$listener$inlined.onAudioLevelChanged(volume);
                    Runnable runnable = HMSDiagnostic.access$getRunnable$p(this.this$0);
                    if (runnable != null) {
                        Runnable it = runnable;
                        boolean bl2 = false;
                        this.this$0.getHandler().postDelayed(it, 10L);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
        };
        try {
            MediaRecorder mediaRecorder = this.recorder;
            if (mediaRecorder != null) {
                mediaRecorder.setAudioSource(1);
            }
            Runnable runnable = this.runnable;
            if (runnable != null) {
                Runnable it = runnable;
                boolean bl = false;
                this.handler.postDelayed(it, 10L);
            }
            MediaRecorder mediaRecorder2 = this.recorder;
            if (mediaRecorder2 != null) {
                mediaRecorder2.setOutputFormat(0);
            }
            MediaRecorder mediaRecorder3 = this.recorder;
            if (mediaRecorder3 != null) {
                mediaRecorder3.setAudioEncoder(0);
            }
            this.recordingPath = new File(context.getCacheDir(), "MediaUtil#micAvailTestFile").getAbsolutePath();
            MediaRecorder mediaRecorder4 = this.recorder;
            if (mediaRecorder4 != null) {
                mediaRecorder4.setOutputFile(this.recordingPath);
            }
            MediaRecorder mediaRecorder5 = this.recorder;
            if (mediaRecorder5 != null) {
                mediaRecorder5.prepare();
            }
            MediaRecorder mediaRecorder6 = this.recorder;
            if (mediaRecorder6 != null) {
                mediaRecorder6.start();
            }
            listener.onSuccess();
            this.result.getDeviceTestReport().getAudioInputReport().setPassed(true);
        }
        catch (Exception exception) {
            String description;
            CharSequence it = exception.getMessage();
            String string = description = !(it == null || it.length() == 0) ? exception.getMessage() : "Exception in starting mic";
            Intrinsics.checkNotNull((Object)string);
            HMSException error = ErrorFactory.TracksErrors.CantAccessCaptureDevice$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "microphone", string, false, null, null, 48, null);
            listener.onError(error);
            this.result.getDeviceTestReport().getAudioInputReport().setPassed(false);
        }
    }

    public final void stopMicCheck() {
        block1: {
            this.handler.removeCallbacksAndMessages(null);
            MediaRecorder mediaRecorder = this.recorder;
            if (mediaRecorder != null) {
                mediaRecorder.stop();
            }
            MediaRecorder mediaRecorder2 = this.recorder;
            if (mediaRecorder2 == null) break block1;
            mediaRecorder2.release();
        }
    }

    public final void startSpeakerCheck() {
        MediaPlayer mediaPlayer = this.mp;
        boolean bl = mediaPlayer != null ? mediaPlayer.isPlaying() : false;
        if (bl || this.isPreparing) {
            return;
        }
        try {
            this.mp = new MediaPlayer();
            this.isPreparing = true;
            CharSequence charSequence = this.recordingPath;
            if (charSequence == null || charSequence.length() == 0) {
                MediaPlayer mediaPlayer2 = this.mp;
                if (mediaPlayer2 != null) {
                    mediaPlayer2.setDataSource("https://100ms.live/test-audio.wav");
                }
            } else {
                MediaPlayer mediaPlayer3 = this.mp;
                if (mediaPlayer3 != null) {
                    mediaPlayer3.setDataSource(this.recordingPath);
                }
            }
            MediaPlayer mediaPlayer4 = this.mp;
            if (mediaPlayer4 != null) {
                mediaPlayer4.setOnPreparedListener(arg_0 -> HMSDiagnostic.startSpeakerCheck$lambda$3(this, arg_0));
            }
            MediaPlayer mediaPlayer5 = this.mp;
            if (mediaPlayer5 != null) {
                mediaPlayer5.prepareAsync();
            }
            this.result.getDeviceTestReport().getAudioOutputReport().setPassed(true);
        }
        catch (IOException error) {
            HMSLogger.e(TAG, " error while playing :" + error.getMessage());
            this.result.getDeviceTestReport().getAudioOutputReport().setPassed(false);
        }
    }

    public final void stopSpeakerCheck() {
        try {
            MediaPlayer mediaPlayer;
            MediaPlayer mediaPlayer2 = this.mp;
            if (mediaPlayer2 != null) {
                mediaPlayer2.stop();
            }
            MediaPlayer mediaPlayer3 = mediaPlayer = this.mp;
            if (mediaPlayer3 != null) {
                mediaPlayer3.release();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private final void setConnectivityCheckValues() {
        this.result = new ConnectivityCheckResult();
        this.result.setConnectivityState$lib_release(ConnectivityState.STARTING);
        ConnectivityCheckListener connectivityCheckListener = this.connectivityCheckListener;
        if (connectivityCheckListener != null) {
            connectivityCheckListener.onConnectivityStateChanged(ConnectivityState.STARTING);
        }
        this.result.setTestTimestamp$lib_release(System.currentTimeMillis());
    }

    public final void startConnectivityCheck(@Nullable String region, @NotNull ConnectivityCheckListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        HMSLogger.d(TAG, "startConnectivityCheck called");
        this.connectivityCheckListener = listener;
        this.setConnectivityCheckValues();
        BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(region, this, null){
            int label;
            final /* synthetic */ String $region;
            final /* synthetic */ HMSDiagnostic this$0;
            {
                this.$region = $region;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DiagnosticTokenService.INSTANCE.getDiagnosticRoomToken(this.$region, null, (Continuation<? super DiagnosticTokenResponse>)((Continuation)this));
                        ** if (v0 != var7_2) goto lbl11
lbl10:
                        // 1 sources

                        return var7_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            tokenResponse = (DiagnosticTokenResponse)v0;
                            v1 = tokenResponse.getToken();
                            if (v1 != null) {
                                var3_5 = v1;
                                var4_6 = this.this$0;
                                it = var3_5;
                                $i$a$-let-HMSDiagnostic$startConnectivityCheck$1$1 = false;
                                HMSDiagnostic.access$joinConnectivityTestRoom(var4_6, it);
                            }
                        }
                        catch (HMSException exception) {
                            HMSLogger.e("HMSDiagnostic", "Error in getting token from Diagnostic API :: " + exception.getMessage());
                            v2 = HMSDiagnostic.access$getResult$p(this.this$0).getErrors();
                            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type java.util.ArrayList<live.hms.video.error.HMSException>");
                            ((ArrayList)v2).add(exception);
                            HMSDiagnostic.access$handleTestCompletion(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void stopConnectivityCheck() {
        HMSLogger.d(TAG, "stopConnectivityCheck called");
        this.leaveConnectivityTestRoom();
    }

    private final void tearDownDiagnostic() {
        this.handler.removeCallbacksAndMessages(null);
        this.connectivityCheckListener = null;
        this.result = new ConnectivityCheckResult();
        this.lastNetworkQualityUpdatedAt = 0L;
    }

    private final void leaveConnectivityTestRoom() {
        BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ HMSDiagnostic this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = SDKDelegate.leave$default(HMSDiagnostic.access$getDelegate$p(this.this$0), false, (Continuation)this, 1, null);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        HMSLogger.d("HMSDiagnostic", "Left diagnostic room");
                        HMSDiagnostic.access$addPendingCQSTillNow(this.this$0);
                        HMSDiagnostic.access$updateAverageCQSInResult(this.this$0);
                        HMSDiagnostic.access$handleTestCompletion(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void addPendingCQSTillNow() {
        if (this.result.getNetworkQualityValues$lib_release().size() > 0) {
            long timeDiffInSec = (System.currentTimeMillis() - this.lastNetworkQualityUpdatedAt) / (long)1000;
            while (timeDiffInSec > 0L) {
                this.result.getNetworkQualityValues$lib_release().add((Float)CollectionsKt.last(this.result.getNetworkQualityValues$lib_release()));
                long l = timeDiffInSec;
                timeDiffInSec = l + -1L;
            }
            this.lastNetworkQualityUpdatedAt = System.currentTimeMillis();
        }
    }

    private final void handleTestCompletion() {
        this.result.setConnectivityState$lib_release(ConnectivityState.COMPLETED);
        ConnectivityCheckListener connectivityCheckListener = this.connectivityCheckListener;
        if (connectivityCheckListener != null) {
            connectivityCheckListener.onConnectivityStateChanged(ConnectivityState.COMPLETED);
        }
        ConnectivityCheckListener connectivityCheckListener2 = this.connectivityCheckListener;
        if (connectivityCheckListener2 != null) {
            connectivityCheckListener2.onCompleted(this.result);
        }
        this.tearDownDiagnostic();
    }

    private final void joinConnectivityTestRoom(String authToken) {
        this.delegate.addDiagnosticListener(this.transportListener);
        HMSConfig config = new HMSConfig("diagnostic-test", authToken, null, false, null, 28, null);
        BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, config, null){
            int label;
            final /* synthetic */ HMSDiagnostic this$0;
            final /* synthetic */ HMSConfig $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HMSDiagnostic.access$getDelegate$p(this.this$0).join(this.$config, new HMSUpdateListener(this.this$0){
                            final /* synthetic */ HMSDiagnostic this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public void onJoin(@NotNull HMSRoom room) {
                                Intrinsics.checkNotNullParameter((Object)room, (String)"room");
                                HMSLogger.d("HMSDiagnostic", "Joined Diagnostic room");
                                HMSDiagnostic.access$getDelegate$p(this.this$0).addStatsObserver(new HMSStatsObserver(this.this$0){
                                    final /* synthetic */ HMSDiagnostic this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    public void onRTCStats(@NotNull HMSRTCStatsReport rtcStats) {
                                        Intrinsics.checkNotNullParameter((Object)rtcStats, (String)"rtcStats");
                                        HMSLogger.d("HMSDiagnostic", "Cumulative stats: " + rtcStats);
                                        HMSDiagnostic.access$getResult$p(this.this$0).getMediaServerReport().setStats$lib_release(rtcStats);
                                    }

                                    public void onLocalVideoStats(@NotNull List<HMSLocalVideoStats> videoStats, @Nullable HMSTrack hmsTrack, @Nullable HMSPeer hmsPeer) {
                                        HMSStatsObserver.DefaultImpls.onLocalVideoStats(this, videoStats, hmsTrack, hmsPeer);
                                    }

                                    public void onLocalAudioStats(@NotNull HMSLocalAudioStats audioStats, @Nullable HMSTrack hmsTrack, @Nullable HMSPeer hmsPeer) {
                                        HMSStatsObserver.DefaultImpls.onLocalAudioStats(this, audioStats, hmsTrack, hmsPeer);
                                    }

                                    public void onRemoteVideoStats(@NotNull HMSRemoteVideoStats videoStats, @Nullable HMSTrack hmsTrack, @Nullable HMSPeer hmsPeer) {
                                        HMSStatsObserver.DefaultImpls.onRemoteVideoStats(this, videoStats, hmsTrack, hmsPeer);
                                    }

                                    public void onRemoteAudioStats(@NotNull HMSRemoteAudioStats audioStats, @Nullable HMSTrack hmsTrack, @Nullable HMSPeer hmsPeer) {
                                        HMSStatsObserver.DefaultImpls.onRemoteAudioStats(this, audioStats, hmsTrack, hmsPeer);
                                    }
                                });
                                this.this$0.getHandler().postDelayed(() -> joinConnectivityTestRoom.1.onJoin$lambda$0(this.this$0), 20000L);
                            }

                            public void onRoomUpdate(@NotNull HMSRoomUpdate type, @NotNull HMSRoom hmsRoom) {
                                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                                Intrinsics.checkNotNullParameter((Object)hmsRoom, (String)"hmsRoom");
                            }

                            public void onPeerUpdate(@NotNull HMSPeerUpdate type, @NotNull HMSPeer peer) {
                                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                                Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
                            }

                            public void onTrackUpdate(@NotNull HMSTrackUpdate type, @NotNull HMSTrack track, @NotNull HMSPeer peer) {
                                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                                Intrinsics.checkNotNullParameter((Object)track, (String)"track");
                                Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
                                HMSLogger.d("HMSDiagnostic", "onTrackUpdate :: " + (Object)((Object)type));
                            }

                            public void onRoleChangeRequest(@NotNull HMSRoleChangeRequest request) {
                                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                            }

                            public void onMessageReceived(@NotNull HMSMessage message) {
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                            }

                            public void onChangeTrackStateRequest(@NotNull HMSChangeTrackStateRequest details) {
                                Intrinsics.checkNotNullParameter((Object)details, (String)"details");
                            }

                            public void onReconnecting(@NotNull HMSException error) {
                                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                                HMSLogger.e("HMSDiagnostic", "onReconnecting");
                                HMSDiagnostic.access$addPendingCQSTillNow(this.this$0);
                                HMSDiagnostic.access$updateAverageCQSInResult(this.this$0);
                            }

                            public void onError(@NotNull HMSException error) {
                                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                                HMSLogger.e("HMSDiagnostic", "error :: " + error.getMessage());
                                List<HMSException> list = HMSDiagnostic.access$getResult$p(this.this$0).getErrors();
                                Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type java.util.ArrayList<live.hms.video.error.HMSException>");
                                ((ArrayList)list).add(error);
                                if (error.isTerminal()) {
                                    HMSLogger.e("HMSDiagnostic", "Terminal error received. Completing the test");
                                    HMSDiagnostic.access$handleTestCompletion(this.this$0);
                                }
                            }

                            public void onReconnected() {
                                HMSUpdateListener.DefaultImpls.onReconnected(this);
                            }

                            public void onRemovedFromRoom(@NotNull HMSRemovedFromRoom notification) {
                                HMSUpdateListener.DefaultImpls.onRemovedFromRoom(this, notification);
                            }

                            public void peerListUpdated(@Nullable ArrayList<HMSPeer> addedPeers, @Nullable ArrayList<HMSPeer> removedPeers) {
                                HMSUpdateListener.DefaultImpls.peerListUpdated(this, addedPeers, removedPeers);
                            }

                            public void onSessionStoreAvailable(@NotNull HmsSessionStore sessionStore) {
                                HMSUpdateListener.DefaultImpls.onSessionStoreAvailable(this, sessionStore);
                            }

                            public void onTranscripts(@NotNull HmsTranscripts transcripts) {
                                HMSUpdateListener.DefaultImpls.onTranscripts(this, transcripts);
                            }

                            public void onPermissionsRequested(@NotNull List<String> permissions) {
                                HMSUpdateListener.DefaultImpls.onPermissionsRequested(this, permissions);
                            }

                            private static final void onJoin$lambda$0(HMSDiagnostic this$0) {
                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                HMSDiagnostic.access$leaveConnectivityTestRoom(this$0);
                            }
                        }, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void startSpeakerCheck$lambda$3(HMSDiagnostic this$0, MediaPlayer mp) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        mp.start();
        this$0.isPreparing = false;
    }

    public static final /* synthetic */ SDKDelegate access$getDelegate$p(HMSDiagnostic $this) {
        return $this.delegate;
    }

    public static final /* synthetic */ ConnectivityCheckResult access$getResult$p(HMSDiagnostic $this) {
        return $this.result;
    }

    public static final /* synthetic */ void access$handleTestCompletion(HMSDiagnostic $this) {
        $this.handleTestCompletion();
    }

    public static final /* synthetic */ void access$joinConnectivityTestRoom(HMSDiagnostic $this, String authToken) {
        $this.joinConnectivityTestRoom(authToken);
    }

    public static final /* synthetic */ void access$addPendingCQSTillNow(HMSDiagnostic $this) {
        $this.addPendingCQSTillNow();
    }

    public static final /* synthetic */ void access$updateAverageCQSInResult(HMSDiagnostic $this) {
        $this.updateAverageCQSInResult();
    }

    public static final /* synthetic */ void access$leaveConnectivityTestRoom(HMSDiagnostic $this) {
        $this.leaveConnectivityTestRoom();
    }

    public static final /* synthetic */ MediaRecorder access$getRecorder$p(HMSDiagnostic $this) {
        return $this.recorder;
    }

    public static final /* synthetic */ Runnable access$getRunnable$p(HMSDiagnostic $this) {
        return $this.runnable;
    }

    public static final /* synthetic */ ConnectivityCheckListener access$getConnectivityCheckListener$p(HMSDiagnostic $this) {
        return $this.connectivityCheckListener;
    }

    public static final /* synthetic */ void access$setLastNetworkQualityUpdatedAt$p(HMSDiagnostic $this, long l) {
        $this.lastNetworkQualityUpdatedAt = l;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/diagnostics/HMSDiagnostic$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

