/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.plugin.video;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSAction;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.plugin.video.HMSVideoPlugin;
import live.hms.video.plugin.video.HMSVideoPluginAnalytics;
import live.hms.video.plugin.video.HMSVideoPluginType;
import live.hms.video.plugin.video.HMSVideoPluginsManager;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sdk.HMSPluginResultListener;
import live.hms.video.sdk.ProcessTimeVariables;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.VideoFrame;
import org.webrtc.VideoProcessor;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u0014\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\nJ \u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\nH\u0002J\u0016\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001fJ\u0010\u0010/\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u0011H\u0002J\u0006\u00100\u001a\u00020&J\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017J\u0010\u00102\u001a\u00020&2\b\u00103\u001a\u0004\u0018\u000104J\u0012\u00105\u001a\u00020&2\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u000e\u00106\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001cJ\u0010\u00107\u001a\u00020&2\u0006\u0010-\u001a\u00020\u0011H\u0002J\u000e\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020\nJ\b\u0010:\u001a\u00020&H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00190\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001c0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001f0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006<"}, d2={"Llive/hms/video/plugin/video/HMSVideoPluginsManager;", "", "source", "Lorg/webrtc/VideoSource;", "eventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Lorg/webrtc/VideoSource;Llive/hms/video/events/AnalyticsEventsService;)V", "analytics", "Llive/hms/video/plugin/video/HMSVideoPluginAnalytics;", "inputFrameRate", "", "localSink", "Lorg/webrtc/VideoSink;", "pluginAddInProgress", "", "pluginNumFramesSkipped", "Ljava/util/concurrent/ConcurrentHashMap;", "", "pluginNumFramesToSkip", "pluginResultListener", "live/hms/video/plugin/video/HMSVideoPluginsManager$pluginResultListener$1", "Llive/hms/video/plugin/video/HMSVideoPluginsManager$pluginResultListener$1;", "plugins", "Ljava/util/concurrent/CopyOnWriteArrayList;", "pluginsAvgProcessingTime", "", "pluginsFrameRateList", "pluginsMap", "Llive/hms/video/plugin/video/HMSVideoPlugin;", "pluginsObjectList", "pluginsProcessingTimeExceedsSafeLimitCount", "", "setProcessor", "getSource", "()Lorg/webrtc/VideoSource;", "setSource", "(Lorg/webrtc/VideoSource;)V", "addPlugin", "", "plugin", "resultListener", "Llive/hms/video/sdk/HMSActionResultListener;", "pluginFrameRate", "addPluginInternal", "checkIfPluginFpsChangeNeeded", "name", "timeTakenWithML", "checkIfSkipRequired", "clean", "getPlugins", "pluginsProcessing", "frame", "Lorg/webrtc/VideoFrame;", "processFramesThroughPlugins", "removePlugin", "removePluginEntry", "setInputFps", "inputFps", "setVideoProcessor", "Companion", "lib_release"})
public final class HMSVideoPluginsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private VideoSource source;
    private boolean setProcessor;
    @Nullable
    private VideoSink localSink;
    private int inputFrameRate;
    @NotNull
    private CopyOnWriteArrayList<String> plugins;
    @NotNull
    private ConcurrentHashMap<String, HMSVideoPlugin> pluginsMap;
    @NotNull
    private CopyOnWriteArrayList<HMSVideoPlugin> pluginsObjectList;
    @NotNull
    private ConcurrentHashMap<String, Double> pluginsAvgProcessingTime;
    @NotNull
    private ConcurrentHashMap<String, Long> pluginsProcessingTimeExceedsSafeLimitCount;
    @NotNull
    private ConcurrentHashMap<String, Integer> pluginsFrameRateList;
    @NotNull
    private HMSVideoPluginAnalytics analytics;
    private boolean pluginAddInProgress;
    @NotNull
    private ConcurrentHashMap<String, Integer> pluginNumFramesToSkip;
    @NotNull
    private ConcurrentHashMap<String, Integer> pluginNumFramesSkipped;
    @NotNull
    private final pluginResultListener.1 pluginResultListener;
    @NotNull
    public static final String TAG = "HMSVideoPluginsManager";
    public static final int MAX_CONSEQUENT_TIME_VALUE = 30;

    public HMSVideoPluginsManager(@NotNull VideoSource source, @NotNull AnalyticsEventsService eventsService) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)eventsService, (String)"eventsService");
        this.source = source;
        this.plugins = new CopyOnWriteArrayList();
        this.pluginsMap = new ConcurrentHashMap();
        this.pluginsObjectList = new CopyOnWriteArrayList();
        this.pluginsAvgProcessingTime = new ConcurrentHashMap();
        this.pluginsProcessingTimeExceedsSafeLimitCount = new ConcurrentHashMap();
        this.pluginsFrameRateList = new ConcurrentHashMap();
        this.analytics = new HMSVideoPluginAnalytics(eventsService);
        this.pluginNumFramesToSkip = new ConcurrentHashMap();
        this.pluginNumFramesSkipped = new ConcurrentHashMap();
        this.pluginResultListener = new HMSPluginResultListener(this){
            final /* synthetic */ HMSVideoPluginsManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOutputResult(@Nullable VideoFrame output) {
                block1: {
                    VideoFrame videoFrame;
                    VideoSink videoSink = HMSVideoPluginsManager.access$getLocalSink$p(this.this$0);
                    if (videoSink != null) {
                        videoSink.onFrame(output);
                    }
                    if ((videoFrame = output) == null || (videoFrame = videoFrame.getBuffer()) == null) break block1;
                    videoFrame.release();
                }
            }

            public void onTimeTaken(@NotNull ProcessTimeVariables timeObject) {
                Intrinsics.checkNotNullParameter((Object)timeObject, (String)"timeObject");
                if (HMSVideoPluginsManager.access$getPlugins$p(this.this$0).size() > 0) {
                    HMSVideoPluginAnalytics hMSVideoPluginAnalytics = HMSVideoPluginsManager.access$getAnalytics$p(this.this$0);
                    E e = HMSVideoPluginsManager.access$getPlugins$p(this.this$0).get(0);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"plugins[0]");
                    hMSVideoPluginAnalytics.processTime((String)e, timeObject.getTimeTakenWithML(), timeObject.getTimeTakenWithoutML());
                }
            }
        };
    }

    @NotNull
    public final VideoSource getSource() {
        return this.source;
    }

    public final void setSource(@NotNull VideoSource videoSource) {
        Intrinsics.checkNotNullParameter((Object)videoSource, (String)"<set-?>");
        this.source = videoSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPlugin(@NotNull HMSVideoPlugin plugin, @NotNull HMSActionResultListener resultListener, int pluginFrameRate) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)resultListener, (String)"resultListener");
        if (this.pluginAddInProgress) {
            String name = plugin.getName();
            if (((CharSequence)name).length() == 0) {
                HMSLogger.INSTANCE.w(TAG, "no name provided by the plugin");
                return;
            }
            HMSException err = ErrorFactory.MediaPluginErrors.INSTANCE.AddAlreadyInProgress(HMSAction.VIDEO_PLUGINS, "Add Plugin is already in Progress");
            this.analytics.failure(name, err);
            HMSLogger.INSTANCE.w(TAG, "can't add another plugin when previous add is in progress");
        }
        this.pluginAddInProgress = true;
        try {
            this.addPluginInternal(plugin, resultListener, pluginFrameRate);
        }
        catch (HMSException err) {
            throw err;
        }
        finally {
            this.pluginAddInProgress = false;
        }
    }

    private final void setVideoProcessor() {
        this.source.setVideoProcessor(new VideoProcessor(this){
            final /* synthetic */ HMSVideoPluginsManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCapturerStarted(boolean p0) {
            }

            public void onCapturerStopped() {
            }

            public void onFrameCaptured(@Nullable VideoFrame frame) {
                block1: {
                    block0: {
                        if (HMSVideoPluginsManager.access$getPlugins$p(this.this$0).size() <= 0) break block0;
                        this.this$0.pluginsProcessing(frame);
                        break block1;
                    }
                    VideoSink videoSink = HMSVideoPluginsManager.access$getLocalSink$p(this.this$0);
                    if (videoSink == null) break block1;
                    videoSink.onFrame(frame);
                }
            }

            public void setSink(@Nullable VideoSink sink) {
                HMSVideoPluginsManager.access$setLocalSink$p(this.this$0, sink);
                HMSLogger.d("HMSVideoPluginsManager", "set local sink");
            }
        });
    }

    private final void addPluginInternal(HMSVideoPlugin plugin, HMSActionResultListener resultListener, int pluginFrameRate) {
        Integer n;
        String name = plugin.getName();
        if (((CharSequence)name).length() == 0) {
            HMSLogger.INSTANCE.w(TAG, "no name provided by the plugin");
            return;
        }
        if (this.pluginsMap.containsKey(name)) {
            HMSLogger.INSTANCE.w(TAG, "plugin - " + plugin.getName() + " already added.");
            return;
        }
        int numFramesToSkip = 0;
        if (pluginFrameRate > 0) {
            HMSLogger.INSTANCE.i(TAG, "adding plugin " + plugin.getName() + " with framerate " + pluginFrameRate);
            n = pluginFrameRate;
            ((Map)this.pluginsFrameRateList).put(name, n);
            if (pluginFrameRate < this.inputFrameRate) {
                numFramesToSkip = (int)Math.ceil((double)this.inputFrameRate / (double)pluginFrameRate - 1.0);
            }
            this.analytics.added(name, this.inputFrameRate, pluginFrameRate);
        } else {
            ((Map)this.pluginsFrameRateList).put(name, 0);
            HMSLogger.INSTANCE.i(TAG, "adding plugin " + plugin.getName());
            this.analytics.added(name, this.inputFrameRate, null);
        }
        HMSLogger.INSTANCE.i(TAG, "numFrames to skip processing " + numFramesToSkip);
        n = numFramesToSkip;
        ((Map)this.pluginNumFramesToSkip).put(name, n);
        n = numFramesToSkip;
        ((Map)this.pluginNumFramesSkipped).put(name, n);
        ((Map)this.pluginsAvgProcessingTime).put(name, 0.0);
        ((Map)this.pluginsProcessingTimeExceedsSafeLimitCount).put(name, 0L);
        if (!plugin.isSupported()) {
            HMSException err = ErrorFactory.MediaPluginErrors.INSTANCE.PlatformNotSupported(HMSAction.VIDEO_PLUGINS, "platform not supported");
            this.analytics.failure(name, err);
            HMSLogger.INSTANCE.i(TAG, "Platform/Resolution is not supported for plugin - " + plugin.getName());
            throw err;
        }
        try {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, plugin, resultListener, name, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int label;
                final /* synthetic */ HMSVideoPluginsManager this$0;
                final /* synthetic */ HMSVideoPlugin $plugin;
                final /* synthetic */ HMSActionResultListener $resultListener;
                final /* synthetic */ String $name;
                {
                    this.this$0 = $receiver;
                    this.$plugin = $plugin;
                    this.$resultListener = $resultListener;
                    this.$name = $name;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var3_3 = this.$plugin;
                            var4_4 = this.this$0;
                            var5_5 = this.$name;
                            var6_6 = this.$resultListener;
                            $i$a$-runCatching-HMSVideoPluginsManager$addPluginInternal$1$initResult$1 = false;
                            this.L$0 = var3_3;
                            this.L$1 = var4_4;
                            this.L$2 = var5_5;
                            this.L$3 = var6_6;
                            this.label = 1;
                            v0 = var3_3.init((Continuation<? super Unit>)this);
                            ** if (v0 != var9_2) goto lbl21
lbl20:
                            // 1 sources

                            return var9_2;
lbl21:
                            // 1 sources

                            ** GOTO lbl32
                        }
                        case 1: {
                            $i$a$-runCatching-HMSVideoPluginsManager$addPluginInternal$1$initResult$1 = false;
                            var6_6 = (HMSActionResultListener)this.L$3;
                            var5_5 = (String)this.L$2;
                            var4_4 = (HMSVideoPluginsManager)this.L$1;
                            var3_3 = (HMSVideoPlugin)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl32:
                                // 2 sources

                                HMSVideoPluginsManager.access$getPlugins$p(var4_4).add(var5_5);
                                HMSVideoPluginsManager.access$getPluginsObjectList$p(var4_4).add(var3_3);
                                ((Map)HMSVideoPluginsManager.access$getPluginsMap$p(var4_4)).put(var5_5, var3_3);
                                if (!HMSVideoPluginsManager.access$getSetProcessor$p(var4_4)) {
                                    HMSLogger.d("HMSVideoPluginsManager", "setting video processor");
                                    HMSVideoPluginsManager.access$setVideoProcessor(var4_4);
                                    HMSLogger.d("HMSVideoPluginsManager", "source set on processor " + var4_4.getSource());
                                    HMSVideoPluginsManager.access$setSetProcessor$p(var4_4, true);
                                }
                                var6_6.onSuccess();
                                var7_8 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable var8_9) {
                                var7_8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var8_9));
                            }
                            initResult = var7_8;
                            if (Result.isFailure-impl((Object)initResult)) {
                                this.this$0.removePlugin(this.$plugin);
                                this.$resultListener.onError(ErrorFactory.GenericErrors.Unknown$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.PLUGIN, "Plugin error " + Result.exceptionOrNull-impl((Object)initResult), null, null, 12, null));
                                return Unit.INSTANCE;
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        catch (HMSException err) {
            HMSLogger.INSTANCE.e(TAG, "failed to add plugin", err);
            this.removePlugin(plugin);
            throw err;
        }
    }

    public final void pluginsProcessing(@Nullable VideoFrame frame) {
        try {
            this.processFramesThroughPlugins(frame);
        }
        catch (HMSException err) {
            HMSLogger.INSTANCE.e(TAG, "error in plugins loop", err);
            throw err;
        }
    }

    private final void processFramesThroughPlugins(VideoFrame frame) {
        for (String name : this.plugins) {
            HMSVideoPlugin plugin;
            if (this.pluginsMap.get(name) == null) continue;
            try {
                if (plugin.getPluginType() == HMSVideoPluginType.TRANSFORM) {
                    VideoFrame videoFrame = frame;
                    Intrinsics.checkNotNull((Object)videoFrame);
                    plugin.processVideoFrame(videoFrame, this.pluginResultListener, false);
                    continue;
                }
                if (plugin.getPluginType() != HMSVideoPluginType.ANALYZE) continue;
                Function0 processFn2 = (Function0)new Function0<Unit>(plugin, frame){
                    final /* synthetic */ HMSVideoPlugin $plugin;
                    final /* synthetic */ VideoFrame $frame;
                    {
                        this.$plugin = $plugin;
                        this.$frame = $frame;
                        super(0);
                    }

                    public final void invoke() {
                        VideoFrame videoFrame = this.$frame;
                        Intrinsics.checkNotNull((Object)videoFrame);
                        this.$plugin.processVideoFrame(videoFrame, null, false);
                    }
                };
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                this.analytics.processWithTime(name, (Function0<Unit>)processFn2);
                VideoSink videoSink = this.localSink;
                if (videoSink == null) continue;
                videoSink.onFrame(frame);
            }
            catch (HMSException err) {
                HMSLogger.INSTANCE.e(TAG, "error in processing plugin " + name, err);
                HMSException e = ErrorFactory.MediaPluginErrors.INSTANCE.ProcessingFailed(HMSAction.VIDEO_PLUGINS, "Failed during processing of plugin" + err.getMessage());
                HMSLogger.e("HMSVideoPluginAnalytics", err.toString());
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                this.analytics.failure(name, err);
                this.removePlugin(plugin);
                throw err;
            }
        }
    }

    public final void removePlugin(@NotNull HMSVideoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        try {
            boolean bl = false;
            String name = plugin.getName();
            if (!this.pluginsMap.containsKey(name)) {
                HMSLogger.INSTANCE.w(TAG, "plugin - " + name + " not found to remove.");
                return;
            }
            HMSLogger.INSTANCE.i(TAG, "removing plugin " + name);
            this.pluginsObjectList.remove(plugin);
            this.removePluginEntry(name);
            if (this.plugins.size() == 0) {
                HMSLogger.INSTANCE.i(TAG, "No plugins left, stopping processing");
            }
            plugin.stop();
            this.analytics.removed(name);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    @NotNull
    public final CopyOnWriteArrayList<HMSVideoPlugin> getPlugins() {
        return this.pluginsObjectList;
    }

    public final void checkIfPluginFpsChangeNeeded(@NotNull String name, long timeTakenWithML) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (timeTakenWithML > 0L) {
            if (Intrinsics.areEqual((Double)this.pluginsAvgProcessingTime.get(name), (double)0.0)) {
                ((Map)this.pluginsAvgProcessingTime).put(name, Double.valueOf(timeTakenWithML));
            } else if (this.pluginsFrameRateList.containsKey(name)) {
                IntRange intRange = new IntRange(11, 15);
                Integer n = this.pluginsFrameRateList.get(name);
                if (n != null && intRange.contains(n.intValue())) {
                    double d = timeTakenWithML;
                    Double d2 = this.pluginsAvgProcessingTime.get(name);
                    Intrinsics.checkNotNull((Object)d2);
                    double avgTime = (d + ((Number)d2).doubleValue()) / 2.0;
                    Double d3 = avgTime;
                    ((Map)this.pluginsAvgProcessingTime).put(name, d3);
                    if (avgTime > 100.0 && this.pluginsProcessingTimeExceedsSafeLimitCount.containsKey(name)) {
                        Map map = this.pluginsProcessingTimeExceedsSafeLimitCount;
                        Long l = this.pluginsProcessingTimeExceedsSafeLimitCount.get(name);
                        Intrinsics.checkNotNull((Object)l);
                        map.put(name, ((Number)l).longValue() + 1L);
                        Long l2 = this.pluginsProcessingTimeExceedsSafeLimitCount.get(name);
                        Intrinsics.checkNotNull((Object)l2);
                        if (((Number)l2).longValue() > 30L) {
                            HMSLogger.INSTANCE.i(TAG, "Reducing the plugin Frame Rate to 10");
                            ((Map)this.pluginsFrameRateList).put(name, 10);
                            double d4 = this.inputFrameRate;
                            Integer n2 = this.pluginsFrameRateList.get(name);
                            Intrinsics.checkNotNull((Object)n2);
                            int numFramesToSkip = (int)Math.ceil(d4 / ((Number)n2).doubleValue() - 1.0);
                            Integer n3 = numFramesToSkip;
                            ((Map)this.pluginNumFramesToSkip).put(name, n3);
                            n3 = numFramesToSkip;
                            ((Map)this.pluginNumFramesSkipped).put(name, n3);
                        }
                    } else {
                        ((Map)this.pluginsProcessingTimeExceedsSafeLimitCount).put(name, 0L);
                    }
                }
            }
        }
    }

    public final void clean() {
        for (Map.Entry entry : ((Map)this.pluginsMap).entrySet()) {
            String name = (String)entry.getKey();
            HMSVideoPlugin plugin = (HMSVideoPlugin)entry.getValue();
            this.removePlugin(plugin);
            this.analytics.clean(name);
        }
        this.pluginsMap.clear();
        this.pluginNumFramesSkipped.clear();
        this.pluginNumFramesToSkip.clear();
        this.plugins.clear();
        this.pluginsObjectList.clear();
        this.pluginsAvgProcessingTime.clear();
        this.pluginsProcessingTimeExceedsSafeLimitCount.clear();
        this.pluginsFrameRateList.clear();
        this.setProcessor = false;
        this.source.setVideoProcessor(null);
    }

    public final void setInputFps(int inputFps) {
        this.inputFrameRate = inputFps;
    }

    private final void removePluginEntry(String name) {
        this.plugins.remove(name);
        this.pluginsMap.remove(name);
        this.pluginNumFramesToSkip.remove(name);
        this.pluginNumFramesSkipped.remove(name);
        this.pluginsAvgProcessingTime.remove(name);
        this.pluginsProcessingTimeExceedsSafeLimitCount.remove(name);
        this.pluginsFrameRateList.remove(name);
    }

    private final boolean checkIfSkipRequired(String name) {
        boolean skip = false;
        Integer n = this.pluginNumFramesSkipped.get(name);
        Intrinsics.checkNotNull((Object)n);
        int n2 = ((Number)n).intValue();
        Integer n3 = this.pluginNumFramesToSkip.get(name);
        Intrinsics.checkNotNull((Object)n3);
        if (n2 < ((Number)n3).intValue()) {
            Map map = this.pluginNumFramesSkipped;
            Integer n4 = this.pluginNumFramesSkipped.get(name);
            Intrinsics.checkNotNull((Object)n4);
            map.put(name, ((Number)n4).intValue() + 1);
            skip = true;
        } else {
            skip = false;
            ((Map)this.pluginNumFramesSkipped).put(name, 0);
        }
        return skip;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getPlugins$p(HMSVideoPluginsManager $this) {
        return $this.plugins;
    }

    public static final /* synthetic */ VideoSink access$getLocalSink$p(HMSVideoPluginsManager $this) {
        return $this.localSink;
    }

    public static final /* synthetic */ void access$setLocalSink$p(HMSVideoPluginsManager $this, VideoSink videoSink) {
        $this.localSink = videoSink;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getPluginsObjectList$p(HMSVideoPluginsManager $this) {
        return $this.pluginsObjectList;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPluginsMap$p(HMSVideoPluginsManager $this) {
        return $this.pluginsMap;
    }

    public static final /* synthetic */ boolean access$getSetProcessor$p(HMSVideoPluginsManager $this) {
        return $this.setProcessor;
    }

    public static final /* synthetic */ void access$setVideoProcessor(HMSVideoPluginsManager $this) {
        $this.setVideoProcessor();
    }

    public static final /* synthetic */ void access$setSetProcessor$p(HMSVideoPluginsManager $this, boolean bl) {
        $this.setProcessor = bl;
    }

    public static final /* synthetic */ HMSVideoPluginAnalytics access$getAnalytics$p(HMSVideoPluginsManager $this) {
        return $this.analytics;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Llive/hms/video/plugin/video/HMSVideoPluginsManager$Companion;", "", "()V", "MAX_CONSEQUENT_TIME_VALUE", "", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

