/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.streams;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.connection.publish.HMSPublishConnection;
import live.hms.video.media.settings.HMSTrackSettings;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.media.streams.HMSMediaStream;
import live.hms.video.media.tracks.HMSLocalAudioTrack;
import live.hms.video.media.tracks.HMSLocalVideoTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSTrackType;
import live.hms.video.sdk.models.DegradationPreference;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HMSUtils;
import org.jetbrains.annotations.NotNull;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0012"}, d2={"Llive/hms/video/media/streams/HMSLocalStream;", "Llive/hms/video/media/streams/HMSMediaStream;", "nativeStream", "Lorg/webrtc/MediaStream;", "(Lorg/webrtc/MediaStream;)V", "addTransceiver", "Lorg/webrtc/RtpTransceiver;", "connection", "Llive/hms/video/connection/publish/HMSPublishConnection;", "track", "Llive/hms/video/media/tracks/HMSTrack;", "isScreenShare", "", "hmsTrackSettings", "Llive/hms/video/media/settings/HMSTrackSettings;", "removeSender", "", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHMSLocalStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSLocalStream.kt\nlive/hms/video/media/streams/HMSLocalStream\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1855#2,2:91\n*S KotlinDebug\n*F\n+ 1 HMSLocalStream.kt\nlive/hms/video/media/streams/HMSLocalStream\n*L\n75#1:91,2\n*E\n"})
public final class HMSLocalStream
extends HMSMediaStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "HMSLocalStream";

    public HMSLocalStream(@NotNull MediaStream nativeStream) {
        Intrinsics.checkNotNullParameter((Object)nativeStream, (String)"nativeStream");
        super(nativeStream);
    }

    @NotNull
    public final RtpTransceiver addTransceiver(@NotNull HMSPublishConnection connection, @NotNull HMSTrack track, boolean isScreenShare, @NotNull HMSTrackSettings hmsTrackSettings) {
        List list;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Intrinsics.checkNotNullParameter((Object)hmsTrackSettings, (String)"hmsTrackSettings");
        if (track.getType() == HMSTrackType.VIDEO) {
            list = HMSUtils.INSTANCE.getVideoEncodingParameter$lib_release(((HMSLocalVideoTrack)track).getSettings(), isScreenShare);
        } else {
            RtpParameters.Encoding audioEncoding = new RtpParameters.Encoding(null, true, null);
            audioEncoding.bitratePriority = 2.0;
            audioEncoding.maxBitrateBps = ((HMSLocalAudioTrack)track).getSettings().getMaxBitrate() * 1000;
            list = CollectionsKt.listOf((Object)audioEncoding);
        }
        List sendEncodings = list;
        RtpTransceiver.RtpTransceiverInit init = new RtpTransceiver.RtpTransceiverInit(RtpTransceiver.RtpTransceiverDirection.SEND_ONLY, CollectionsKt.listOf((Object)this.getNativeStream().getId()), sendEncodings);
        RtpTransceiver transceiver = connection.addTransceiver(track.getNativeTrack$lib_release(), init);
        HMSVideoTrackSettings hMSVideoTrackSettings = hmsTrackSettings.getVideoSettings();
        if ((hMSVideoTrackSettings != null ? hMSVideoTrackSettings.getDegradationPreference() : null) != DegradationPreference.DEFAULT && track.getType() == HMSTrackType.VIDEO && !isScreenShare) {
            HMSVideoTrackSettings hMSVideoTrackSettings2 = hmsTrackSettings.getVideoSettings();
            transceiver.getSender().getParameters().degradationPreference = HMSUtils.INSTANCE.mapHmsDegradationPreference(hMSVideoTrackSettings2 != null ? hMSVideoTrackSettings2.getDegradationPreference() : null);
        }
        HMSLogger.d(TAG, "[streamId=" + this.getNativeStream().getId() + "] publishTrack trackId=" + track.getTrackId() + " kind=" + (Object)((Object)track.getType()) + " sendEncodings=" + sendEncodings + ", Added transceiver: mid=" + transceiver.getMid());
        return transceiver;
    }

    public final void removeSender(@NotNull HMSPublishConnection connection, @NotNull HMSTrack track) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Iterable $this$forEach$iv = connection.getSenders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpSender sender = (RtpSender)element$iv;
            boolean bl = false;
            sender.getParameters();
            MediaStreamTrack senderTrack = sender.track();
            if (senderTrack == null || !senderTrack.id().equals(track.getNativeTrack$lib_release().id())) continue;
            connection.removeTrack(sender);
            boolean removedLocalReference = this.getTracks().remove(track);
            if (!removedLocalReference) {
                throw new IllegalStateException("Cannot find " + track + " in locally stored tracks");
            }
            return;
        }
        HMSLogger.e(TAG, "Cannot find sender track in streamId=" + this.getId());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/media/streams/HMSLocalStream$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

