/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\t"}, d2={"Llive/hms/video/sdk/SignatureChecker;", "", "applicationContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isReleaseSigned", "", "()Z", "mContext", "lib_release"})
public final class SignatureChecker {
    private final boolean isReleaseSigned;

    public SignatureChecker(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.isReleaseSigned = this.isReleaseSigned(applicationContext);
    }

    public final boolean isReleaseSigned() {
        return this.isReleaseSigned;
    }

    private final boolean isReleaseSigned(Context mContext) {
        String string;
        Principal principal;
        Certificate cert;
        Certificate certificate;
        Signature[] signatureArray;
        Signature[] signatureArray2;
        PackageManager packageManager = mContext.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"mContext.packageManager");
        PackageManager pm = packageManager;
        String string2 = mContext.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mContext.packageName");
        String packageName = string2;
        int flags = Build.VERSION.SDK_INT >= 28 ? 0x8000000 : 64;
        PackageInfo packageInfo = null;
        try {
            PackageInfo packageInfo2 = pm.getPackageInfo(packageName, flags);
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo2, (String)"pm.getPackageInfo(packageName, flags)");
            packageInfo = packageInfo2;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            signatureArray2 = packageInfo.signingInfo.hasMultipleSigners() ? packageInfo.signingInfo.getApkContentsSigners() : packageInfo.signingInfo.getSigningCertificateHistory();
            Intrinsics.checkNotNullExpressionValue((Object)signatureArray2, (String)"{\n            // Following the docs for apkContentsSigners, therefore checking hasMultipleSigners\n            if(packageInfo.signingInfo.hasMultipleSigners())\n                packageInfo.signingInfo.apkContentsSigners\n            else\n                packageInfo.signingInfo.signingCertificateHistory\n        }");
            signatureArray = signatureArray2;
        } else {
            signatureArray2 = packageInfo.signatures;
            Intrinsics.checkNotNullExpressionValue((Object)signatureArray2, (String)"{\n            packageInfo.signatures\n        }");
            signatureArray = signatureArray2;
        }
        Signature[] signatures = signatureArray;
        byte[] byArray = signatures[0].toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"signatures[0].toByteArray()");
        byte[] certBytes = byArray;
        InputStream input = new ByteArrayInputStream(certBytes);
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X509");
            certificate = cf.generateCertificate(input);
            if (certificate == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
        }
        catch (CertificateException e) {
            e.printStackTrace();
            certificate = null;
        }
        Certificate certificate2 = cert = certificate;
        boolean release = Intrinsics.areEqual((Object)(certificate2 == null ? null : ((X509Certificate)certificate2).getSigAlgName()), (Object)"SHA256withRSA") || ((certificate2 = cert) == null ? false : ((principal = ((X509Certificate)certificate2).getIssuerDN()) == null ? false : ((string = principal.getName()) == null ? false : !StringsKt.contains$default((CharSequence)string, (CharSequence)"CN=Android Debug", (boolean)false, (int)2, null))));
        return release;
    }
}

