/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.factories.noisecancellation;

import android.content.Context;
import java.io.InputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.factories.noisecancellation.AvailabilityStatus;
import live.hms.video.sdk.featureflags.FeatureFlags;
import live.hms.video.sdk.featureflags.Features;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\tJ\u000f\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;", "", "context", "Landroid/content/Context;", "getFeatureFlags", "Lkotlin/Function0;", "Llive/hms/video/sdk/featureflags/FeatureFlags;", "(Landroid/content/Context;Lkotlin/jvm/functions/Function0;)V", "libraryPresent", "", "getLibraryPresent", "()Z", "libraryPresent$delegate", "Lkotlin/Lazy;", "modelName", "", "modelPath", "enableWebrtcNoiseSuppression", "enabledFromDashboard", "enabledFromDashboardInternal", "()Ljava/lang/Boolean;", "getModelStream", "Ljava/io/InputStream;", "isNoiseCancellationAvailable", "Llive/hms/video/factories/noisecancellation/AvailabilityStatus;", "lib_release"})
public final class NoiseCancellationStatusChecker {
    @NotNull
    private final Function0<FeatureFlags> getFeatureFlags;
    @NotNull
    private final String modelPath;
    @NotNull
    private final String modelName;
    @NotNull
    private final Lazy libraryPresent$delegate;

    public NoiseCancellationStatusChecker(@NotNull Context context, @NotNull Function0<FeatureFlags> getFeatureFlags) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(getFeatureFlags, (String)"getFeatureFlags");
        this.getFeatureFlags = getFeatureFlags;
        this.modelPath = "hms/";
        this.modelName = "100ms_noise_cancellation_model";
        this.libraryPresent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(context, this){
            final /* synthetic */ Context $context;
            final /* synthetic */ NoiseCancellationStatusChecker this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                super(0);
            }

            public final boolean invoke() {
                Object[] objectArray = this.$context.getResources().getAssets().list(NoiseCancellationStatusChecker.access$getModelPath$p(this.this$0));
                return objectArray == null ? false : ArraysKt.contains((Object[])objectArray, (Object)NoiseCancellationStatusChecker.access$getModelName$p(this.this$0));
            }
        }));
    }

    public final boolean enabledFromDashboard() {
        return Intrinsics.areEqual((Object)this.enabledFromDashboardInternal(), (Object)true);
    }

    private final Boolean enabledFromDashboardInternal() {
        FeatureFlags featureFlags = (FeatureFlags)this.getFeatureFlags.invoke();
        return featureFlags == null ? null : Boolean.valueOf(featureFlags.isFeatureEnabled(Features.NOISE_CANCELLATION.INSTANCE));
    }

    public final boolean getLibraryPresent() {
        Lazy lazy = this.libraryPresent$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final InputStream getModelStream(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = context.getResources().getAssets().open(Intrinsics.stringPlus((String)this.modelPath, (Object)this.modelName));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.resources.assets.open(\"$modelPath$modelName\")");
        return inputStream;
    }

    @NotNull
    public final AvailabilityStatus isNoiseCancellationAvailable() {
        AvailabilityStatus availabilityStatus;
        if (!this.getLibraryPresent()) {
            availabilityStatus = new AvailabilityStatus.NotAvailable("Add the import for live.100ms:hms-noise-cancellation-android:$version to enable noise cancellation.");
        } else {
            Boolean bl = this.enabledFromDashboardInternal();
            if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                availabilityStatus = AvailabilityStatus.Available.INSTANCE;
            } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
                availabilityStatus = new AvailabilityStatus.NotAvailable("Noise Cancellation is disabled in the 100ms dashboard. Enable it there to turn it on.");
            } else if (bl == null) {
                availabilityStatus = new AvailabilityStatus.NotAvailable("Method called too early, please call this either after a preview call returns, onPreview, or after join, onJoin.");
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return availabilityStatus;
    }

    public final boolean enableWebrtcNoiseSuppression() {
        return !Intrinsics.areEqual((Object)this.isNoiseCancellationAvailable(), (Object)AvailabilityStatus.Available.INSTANCE);
    }

    public static final /* synthetic */ String access$getModelPath$p(NoiseCancellationStatusChecker $this) {
        return $this.modelPath;
    }

    public static final /* synthetic */ String access$getModelName$p(NoiseCancellationStatusChecker $this) {
        return $this.modelName;
    }
}

