/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.factories;

import android.content.Context;
import android.content.SharedPreferences;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.media.projection.MediaProjection;
import android.preference.PreferenceManager;
import androidx.annotation.RequiresApi;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import live.hms.video.encoder.video.SimulcastVideoEncoderFactoryWrapper;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.factories.HMSPeerConnectionFactory;
import live.hms.video.factories.HMSVideoDecoderFactory;
import live.hms.video.factories.noisecancellation.NoiseCancellation;
import live.hms.video.factories.noisecancellation.NoiseCancellationFactoryImpl;
import live.hms.video.factories.noisecancellation.NoiseCancellationStatusChecker;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSTrackSettings;
import live.hms.video.sdk.models.enums.AudioMixingMode;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HMSUtils;
import live.hms.video.utils.SharedEglContext;
import live.hms.video.utils.WertcAudioUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.AudioProcessingFactory;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.WebRtcAudioRecord;
import org.webrtc.audio.WebRtcAudioTrack;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0017\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006*\u0004\u000e\u0015\u0018\u001b\b\u0000\u0018\u0000 \u007f2\u00020\u0001:\u0001\u007fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010^\u001a\u00020_H\u0003J\"\u0010`\u001a\n b*\u0004\u0018\u00010a0a2\b\b\u0002\u0010c\u001a\u0002002\u0006\u0010d\u001a\u00020eH\u0002J\u0010\u0010f\u001a\u00020_2\u0006\u0010g\u001a\u00020hH\u0003J\b\u0010i\u001a\u00020_H\u0002J\b\u0010j\u001a\u00020_H\u0002J\u001e\u0010k\u001a\u00020_2\u0006\u0010d\u001a\u00020e2\u0006\u0010c\u001a\u0002002\u0006\u0010l\u001a\u000200J\u0010\u0010m\u001a\u00020_2\u0006\u0010n\u001a\u00020 H\u0002J\b\u0010o\u001a\u0004\u0018\u00010pJ\u0010\u0010q\u001a\u00020_2\u0006\u0010n\u001a\u00020 H\u0002J \u0010r\u001a\u00020A2\u0006\u0010s\u001a\u00020A2\u0006\u0010t\u001a\u00020\u001e2\u0006\u0010u\u001a\u00020vH\u0002J\u0010\u0010w\u001a\u00020_2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010x\u001a\u00020_2\u0006\u0010y\u001a\u00020zH\u0002J\u000e\u0010{\u001a\u00020_2\u0006\u0010|\u001a\u00020\nJ\u0018\u0010}\u001a\u00020_2\u0006\u0010g\u001a\u00020h2\u0006\u0010|\u001a\u00020\nH\u0007J\u0006\u0010~\u001a\u00020_R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R+\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0011\u0010,\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u000208X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010.R\u000e\u0010?\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082.\u00a2\u0006\u0002\n\u0000R+\u0010C\u001a\u00020B2\u0006\u0010#\u001a\u00020B8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bH\u0010+\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR+\u0010J\u001a\u00020I2\u0006\u0010#\u001a\u00020I8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bO\u0010+\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR+\u0010Q\u001a\u00020P2\u0006\u0010#\u001a\u00020P8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bV\u0010+\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR+\u0010X\u001a\u00020W2\u0006\u0010#\u001a\u00020W8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b]\u0010+\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\\u00a8\u0006\u0080\u0001"}, d2={"Llive/hms/video/factories/HMSPeerConnectionFactory;", "", "context", "Landroid/content/Context;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "ncStatusChecker", "Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;", "(Landroid/content/Context;Llive/hms/video/events/AnalyticsEventsService;Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;)V", "_audioMixingMode", "Llive/hms/video/sdk/models/enums/AudioMixingMode;", "getAnalyticsEventsService", "()Llive/hms/video/events/AnalyticsEventsService;", "audioBufferCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioBufferCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioBufferCallback$1;", "audioManager", "Landroid/media/AudioManager;", "getAudioManager", "()Landroid/media/AudioManager;", "audioRecordErrorCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioRecordErrorCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioRecordErrorCallback$1;", "audioRecordStateCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioRecordStateCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioRecordStateCallback$1;", "audioTrackErrorCallback", "live/hms/video/factories/HMSPeerConnectionFactory$audioTrackErrorCallback$1", "Llive/hms/video/factories/HMSPeerConnectionFactory$audioTrackErrorCallback$1;", "capacity", "", "combinedByteBuffer", "Ljava/nio/ByteBuffer;", "getContext", "()Landroid/content/Context;", "<set-?>", "Lorg/webrtc/PeerConnectionFactory;", "factory", "getFactory", "()Lorg/webrtc/PeerConnectionFactory;", "setFactory", "(Lorg/webrtc/PeerConnectionFactory;)V", "factory$delegate", "Lkotlin/properties/ReadWriteProperty;", "inputSampleRate", "getInputSampleRate", "()I", "isAudioMixingNeeded", "", "mAudioRecord", "Landroid/media/AudioRecord;", "getNcStatusChecker", "()Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;", "nextSchedulerId", "Ljava/util/concurrent/atomic/AtomicInteger;", "noiseCancellation", "Llive/hms/video/factories/noisecancellation/NoiseCancellation;", "getNoiseCancellation", "()Llive/hms/video/factories/noisecancellation/NoiseCancellation;", "setNoiseCancellation", "(Llive/hms/video/factories/noisecancellation/NoiseCancellation;)V", "outputSampleRate", "getOutputSampleRate", "systemAudioByteBuffer", "systemAudioShortArray", "", "Lorg/webrtc/VideoDecoderFactory;", "videoDecoderFactory", "getVideoDecoderFactory", "()Lorg/webrtc/VideoDecoderFactory;", "setVideoDecoderFactory", "(Lorg/webrtc/VideoDecoderFactory;)V", "videoDecoderFactory$delegate", "Lorg/webrtc/VideoEncoderFactory;", "videoEncoderFactory", "getVideoEncoderFactory", "()Lorg/webrtc/VideoEncoderFactory;", "setVideoEncoderFactory", "(Lorg/webrtc/VideoEncoderFactory;)V", "videoEncoderFactory$delegate", "Lorg/webrtc/audio/WebRtcAudioTrack;", "webRtcAudioTrack", "getWebRtcAudioTrack", "()Lorg/webrtc/audio/WebRtcAudioTrack;", "setWebRtcAudioTrack", "(Lorg/webrtc/audio/WebRtcAudioTrack;)V", "webRtcAudioTrack$delegate", "Lorg/webrtc/audio/WebRtcAudioRecord;", "webrtcAudioRecord", "getWebrtcAudioRecord", "()Lorg/webrtc/audio/WebRtcAudioRecord;", "setWebrtcAudioRecord", "(Lorg/webrtc/audio/WebRtcAudioRecord;)V", "webrtcAudioRecord$delegate", "captureSystemAudio", "", "getPeerConnectionFactoryBuilder", "Lorg/webrtc/PeerConnectionFactory$Builder;", "kotlin.jvm.PlatformType", "isSimulcastEnabled", "hmsTrackSettings", "Llive/hms/video/media/settings/HMSTrackSettings;", "initAudioRecorder", "mMediaProjection", "Landroid/media/projection/MediaProjection;", "initPeerConnectionFactory", "initchunk", "initialize", "serverSoftwareEchoCancellationEnabled", "mixAudioBytes", "micAudioByteBuffer", "newDefaultScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "scaleUpMicVolume", "scaleValues", "buff", "len", "scale", "", "sendAECAnalytics", "sendMicCaptureFailedEvent", "errorMessage", "", "setAudioMixingMode", "audioMixingMode", "startAudioMixing", "stopAudioMixing", "Companion", "lib_release"})
public final class HMSPeerConnectionFactory {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Context context;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @NotNull
    private final NoiseCancellationStatusChecker ncStatusChecker;
    public NoiseCancellation noiseCancellation;
    @NotNull
    private final ReadWriteProperty videoEncoderFactory$delegate;
    @NotNull
    private final ReadWriteProperty videoDecoderFactory$delegate;
    @NotNull
    private final ReadWriteProperty factory$delegate;
    @NotNull
    private final ReadWriteProperty webrtcAudioRecord$delegate;
    @NotNull
    private final ReadWriteProperty webRtcAudioTrack$delegate;
    private boolean isAudioMixingNeeded;
    @NotNull
    private AudioMixingMode _audioMixingMode;
    @NotNull
    private AtomicInteger nextSchedulerId;
    @NotNull
    private final AudioManager audioManager;
    private final int inputSampleRate;
    private final int outputSampleRate;
    @NotNull
    private final audioRecordErrorCallback.1 audioRecordErrorCallback;
    @NotNull
    private final audioTrackErrorCallback.1 audioTrackErrorCallback;
    @NotNull
    private final audioRecordStateCallback.1 audioRecordStateCallback;
    private ByteBuffer systemAudioByteBuffer;
    private short[] systemAudioShortArray;
    private ByteBuffer combinedByteBuffer;
    private int capacity;
    @Nullable
    private AudioRecord mAudioRecord;
    @RequiresApi(value=29)
    @NotNull
    private final audioBufferCallback.1 audioBufferCallback;
    @NotNull
    private static final String TAG = "HMSPeerConnectionFactory";
    @NotNull
    private static final String PREF_AEC_EVENT_KEY = "aec_event";
    private static final boolean PREF_AEC_EVENT_DEFAULT = false;
    private static final int DEFAULT_AUDIO_FORMAT = 2;
    private static final int DEFAULT_AUDIO_SOURCE = 7;
    private static final int INPUT_BITS_PER_SAMPLE = 16;
    private static final int OUTPUT_BITS_PER_SAMPLE = 16;
    private static final int INPUT_NUM_OF_CHANNELS = 1;
    private static final int OUTPUT_NUM_OF_CHANNELS = 1;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final float MIC_VOLUME_SCALE = 5.0f;
    private static final float FILE_VOLUME_SCALE = 0.1f;

    public HMSPeerConnectionFactory(@NotNull Context context, @NotNull AnalyticsEventsService analyticsEventsService2, @NotNull NoiseCancellationStatusChecker ncStatusChecker2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        Intrinsics.checkNotNullParameter((Object)ncStatusChecker2, (String)"ncStatusChecker");
        this.context = context;
        this.analyticsEventsService = analyticsEventsService2;
        this.ncStatusChecker = ncStatusChecker2;
        this.videoEncoderFactory$delegate = Delegates.INSTANCE.notNull();
        this.videoDecoderFactory$delegate = Delegates.INSTANCE.notNull();
        this.factory$delegate = Delegates.INSTANCE.notNull();
        this.webrtcAudioRecord$delegate = Delegates.INSTANCE.notNull();
        this.webRtcAudioTrack$delegate = Delegates.INSTANCE.notNull();
        this._audioMixingMode = AudioMixingMode.TALK_AND_MUSIC;
        this.nextSchedulerId = new AtomicInteger(0);
        Object object = this.context.getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        this.audioManager = (AudioManager)object;
        this.inputSampleRate = WertcAudioUtils.Companion.getSampleRate(this.audioManager);
        this.outputSampleRate = WertcAudioUtils.Companion.getSampleRate(this.audioManager);
        this.audioRecordErrorCallback = new JavaAudioDeviceModule.AudioRecordErrorCallback(this){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onWebRtcAudioRecordInitError(@Nullable String errorMessage) {
                String errorMessage2 = Intrinsics.stringPlus((String)"audioRecordErrorCallback:: onWebRtcAudioRecordError:: ", (Object)errorMessage);
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioRecordStartError(@Nullable JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, @Nullable String errorMessage) {
                String errorMessage2 = "audioRecordErrorCallback:: onWebRtcAudioRecordStartError:: " + errorCode + " ==> " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioRecordError(@Nullable String errorMessage) {
                String errorMessage2 = Intrinsics.stringPlus((String)"audioRecordErrorCallback:: onWebRtcAudioRecordError:: ", (Object)errorMessage);
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }
        };
        this.audioTrackErrorCallback = new JavaAudioDeviceModule.AudioTrackErrorCallback(this){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onWebRtcAudioTrackInitError(@Nullable String errorMessage) {
                String errorMessage2 = Intrinsics.stringPlus((String)"audioTrackErrorCallback:: onWebRtcAudioRecordInitError:: ", (Object)errorMessage);
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioTrackStartError(@Nullable JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, @Nullable String errorMessage) {
                String errorMessage2 = "audioTrackErrorCallback:: onWebRtcAudioRecordStartError:: " + errorCode + " ==> " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }

            public void onWebRtcAudioTrackError(@Nullable String errorMessage) {
                String errorMessage2 = Intrinsics.stringPlus((String)"audioTrackErrorCallback:: onWebRtcAudioRecordError:: ", (Object)errorMessage);
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(this.this$0, errorMessage2);
            }
        };
        this.audioRecordStateCallback = new JavaAudioDeviceModule.AudioRecordStateCallback(){

            public void onWebRtcAudioRecordStart() {
                HMSLogger.INSTANCE.v("HMSPeerConnectionFactory", "~~ onWebRtcAudioRecordStart ~~");
            }

            public void onWebRtcAudioRecordStop() {
                HMSLogger.INSTANCE.v("HMSPeerConnectionFactory", "~~ onWebRtcAudioRecordStop ~~");
            }
        };
        this.audioBufferCallback = new WebRtcAudioRecord.AudioBufferCallback(this){
            final /* synthetic */ HMSPeerConnectionFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBuffer(@Nullable ByteBuffer micByteBuffer, int micBytesRead) {
                ByteBuffer byteBuffer;
                long startTime = System.currentTimeMillis();
                if (HMSPeerConnectionFactory.access$get_audioMixingMode$p(this.this$0) == AudioMixingMode.TALK_AND_MUSIC || HMSPeerConnectionFactory.access$get_audioMixingMode$p(this.this$0) == AudioMixingMode.MUSIC_ONLY) {
                    HMSLogger.d("AudioMixing", "Mixing system audio and mic data");
                    HMSPeerConnectionFactory.access$captureSystemAudio(this.this$0);
                    byteBuffer = micByteBuffer;
                    if (byteBuffer != null) {
                        ByteBuffer byteBuffer2 = byteBuffer;
                        HMSPeerConnectionFactory hMSPeerConnectionFactory = this.this$0;
                        ByteBuffer it = byteBuffer2;
                        boolean bl = false;
                        HMSPeerConnectionFactory.access$mixAudioBytes(hMSPeerConnectionFactory, it);
                    }
                } else {
                    HMSLogger.d("AudioMixing", "Not Mixing system audio and mic data :: TALK_MODE");
                    byteBuffer = micByteBuffer;
                    if (byteBuffer != null) {
                        ByteBuffer byteBuffer3;
                        ByteBuffer it = byteBuffer3 = byteBuffer;
                        boolean bl = false;
                    }
                }
                long endTime = System.currentTimeMillis();
                long timeTaken = endTime - startTime;
                HMSLogger.d("HMSPeerConnectionFactory", " Callback took " + timeTaken + " ms to finish");
            }
        };
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AnalyticsEventsService getAnalyticsEventsService() {
        return this.analyticsEventsService;
    }

    @NotNull
    public final NoiseCancellationStatusChecker getNcStatusChecker() {
        return this.ncStatusChecker;
    }

    @NotNull
    public final NoiseCancellation getNoiseCancellation() {
        NoiseCancellation noiseCancellation = this.noiseCancellation;
        if (noiseCancellation != null) {
            return noiseCancellation;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"noiseCancellation");
        throw null;
    }

    public final void setNoiseCancellation(@NotNull NoiseCancellation noiseCancellation) {
        Intrinsics.checkNotNullParameter((Object)noiseCancellation, (String)"<set-?>");
        this.noiseCancellation = noiseCancellation;
    }

    @NotNull
    public final VideoEncoderFactory getVideoEncoderFactory() {
        return (VideoEncoderFactory)this.videoEncoderFactory$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
        this.videoEncoderFactory$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)videoEncoderFactory);
    }

    @NotNull
    public final VideoDecoderFactory getVideoDecoderFactory() {
        return (VideoDecoderFactory)this.videoDecoderFactory$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
        this.videoDecoderFactory$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)videoDecoderFactory);
    }

    @NotNull
    public final PeerConnectionFactory getFactory() {
        return (PeerConnectionFactory)this.factory$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final void setFactory(PeerConnectionFactory peerConnectionFactory) {
        this.factory$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)peerConnectionFactory);
    }

    private final WebRtcAudioRecord getWebrtcAudioRecord() {
        return (WebRtcAudioRecord)this.webrtcAudioRecord$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final void setWebrtcAudioRecord(WebRtcAudioRecord webRtcAudioRecord) {
        this.webrtcAudioRecord$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)webRtcAudioRecord);
    }

    private final WebRtcAudioTrack getWebRtcAudioTrack() {
        return (WebRtcAudioTrack)this.webRtcAudioTrack$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    private final void setWebRtcAudioTrack(WebRtcAudioTrack webRtcAudioTrack) {
        this.webRtcAudioTrack$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)webRtcAudioTrack);
    }

    @NotNull
    public final AudioManager getAudioManager() {
        return this.audioManager;
    }

    public final int getInputSampleRate() {
        return this.inputSampleRate;
    }

    public final int getOutputSampleRate() {
        return this.outputSampleRate;
    }

    private final void scaleUpMicVolume(ByteBuffer micAudioByteBuffer) {
        ShortBuffer micAudioShortBuffer = micAudioByteBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] micAudioShortArray = new short[micAudioByteBuffer.limit() / 2];
        micAudioShortBuffer.get(micAudioShortArray);
        this.scaleValues(micAudioShortArray, micAudioShortArray.length, 5.0f);
    }

    @RequiresApi(value=29)
    private final void captureSystemAudio() {
        AudioRecord audioRecord = this.mAudioRecord;
        Intrinsics.checkNotNull((Object)audioRecord);
        ByteBuffer byteBuffer = this.systemAudioByteBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            throw null;
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        byteBuffer = this.systemAudioByteBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            throw null;
        }
        int capturedNumOfBytes = audioRecord.read(byteBuffer2, byteBuffer.capacity(), 0);
        HMSLogger.d("AudioMixing", "Read " + capturedNumOfBytes + " bytes of System audio buffer");
    }

    private final void mixAudioBytes(ByteBuffer micAudioByteBuffer) {
        micAudioByteBuffer.position(0);
        ByteBuffer byteBuffer = this.systemAudioByteBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            throw null;
        }
        byteBuffer.position(0);
        ShortBuffer micAudioShortBuffer = micAudioByteBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] micAudioShortArray = new short[micAudioByteBuffer.limit() / 2];
        micAudioShortBuffer.get(micAudioShortArray);
        Object object = this.systemAudioByteBuffer;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            throw null;
        }
        ShortBuffer shortBuffer = ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        object = this.systemAudioShortArray;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            throw null;
        }
        shortBuffer.get((short[])object);
        this.scaleValues(micAudioShortArray, micAudioShortArray.length, 5.0f);
        object = this.systemAudioShortArray;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            throw null;
        }
        Object object2 = object;
        object = this.systemAudioShortArray;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            throw null;
        }
        this.scaleValues((short[])object2, ((Object)object).length, 0.1f);
        Object object3 = this.systemAudioShortArray;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            throw null;
        }
        short[] sArray = object3;
        object3 = this.systemAudioShortArray;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioShortArray");
            throw null;
        }
        byte[] combinedByteArray = HMSUtils.INSTANCE.addAndConvertBuffers(micAudioShortArray, micAudioShortArray.length, sArray, ((short[])object3).length);
        object3 = ByteBuffer.wrap(combinedByteArray);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"wrap(combinedByteArray)");
        this.combinedByteBuffer = object3;
        micAudioByteBuffer.clear();
        if (this._audioMixingMode == AudioMixingMode.TALK_AND_MUSIC) {
            HMSLogger.d("AudioMixing", "Adding combinedByteBuffer");
            object3 = this.combinedByteBuffer;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"combinedByteBuffer");
                throw null;
            }
            micAudioByteBuffer.put((ByteBuffer)object3);
        } else if (this._audioMixingMode == AudioMixingMode.MUSIC_ONLY) {
            HMSLogger.d("AudioMixing", "Adding systemAudioByteBuffer");
            object3 = this.systemAudioByteBuffer;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
                throw null;
            }
            micAudioByteBuffer.put((ByteBuffer)object3);
        }
    }

    public final void initialize(@NotNull HMSTrackSettings hmsTrackSettings, boolean isSimulcastEnabled, boolean serverSoftwareEchoCancellationEnabled) {
        Intrinsics.checkNotNullParameter((Object)hmsTrackSettings, (String)"hmsTrackSettings");
        this.initPeerConnectionFactory();
        boolean isBuiltInAcousticEchoCancelerSupported = JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported();
        boolean useHardwareAcousticEchoCanceler = false;
        if (isBuiltInAcousticEchoCancelerSupported) {
            Object object = hmsTrackSettings.getAudioSettings();
            useHardwareAcousticEchoCanceler = (object == null ? null : ((HMSAudioTrackSettings)object).getUseHardwareAcousticEchoCanceler()) == null ? !serverSoftwareEchoCancellationEnabled : ((object = hmsTrackSettings.getAudioSettings().getUseHardwareAcousticEchoCanceler()) == null ? true : (Boolean)object);
        }
        boolean useHardwareNoiseSuppressor = JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported();
        this.setWebrtcAudioRecord(new WebRtcAudioRecord(this.context, this.newDefaultScheduler(), this.audioManager, 7, 2, (JavaAudioDeviceModule.AudioRecordErrorCallback)this.audioRecordErrorCallback, (JavaAudioDeviceModule.AudioRecordStateCallback)this.audioRecordStateCallback, null, useHardwareAcousticEchoCanceler, useHardwareNoiseSuppressor));
        this.setWebRtcAudioTrack(new WebRtcAudioTrack(this.context, this.audioManager, null, (JavaAudioDeviceModule.AudioTrackErrorCallback)this.audioTrackErrorCallback, null, false, false));
        JavaAudioDeviceModule customAudioDeviceModule = new JavaAudioDeviceModule(this.context, this.audioManager, this.getWebrtcAudioRecord(), this.getWebRtcAudioTrack(), this.inputSampleRate, this.outputSampleRate, false, false);
        PeerConnectionFactory.Builder builder = this.getPeerConnectionFactoryBuilder(isSimulcastEnabled, hmsTrackSettings);
        PeerConnectionFactory peerConnectionFactory = builder.setAudioDeviceModule((AudioDeviceModule)customAudioDeviceModule).createPeerConnectionFactory();
        Intrinsics.checkNotNullExpressionValue((Object)peerConnectionFactory, (String)"builder\n      .setAudioDeviceModule(customAudioDeviceModule)\n      .createPeerConnectionFactory()");
        this.setFactory(peerConnectionFactory);
        this.sendAECAnalytics(this.context);
    }

    @RequiresApi(value=29)
    public final void startAudioMixing(@NotNull MediaProjection mMediaProjection, @NotNull AudioMixingMode audioMixingMode) {
        Intrinsics.checkNotNullParameter((Object)mMediaProjection, (String)"mMediaProjection");
        Intrinsics.checkNotNullParameter((Object)((Object)audioMixingMode), (String)"audioMixingMode");
        HMSLogger.d("AudioMixing", "starting audio mixing in " + (Object)((Object)audioMixingMode) + " mode");
        this.initAudioRecorder(mMediaProjection);
        this.initchunk();
        this.getWebrtcAudioRecord().setBufferCallback((WebRtcAudioRecord.AudioBufferCallback)this.audioBufferCallback);
        this.isAudioMixingNeeded = true;
        this._audioMixingMode = audioMixingMode;
        this.getWebrtcAudioRecord().isMixingNeeded(true);
    }

    public final void setAudioMixingMode(@NotNull AudioMixingMode audioMixingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioMixingMode), (String)"audioMixingMode");
        HMSLogger.d("AudioMixing", Intrinsics.stringPlus((String)"setting Audio Mixing mode to ", (Object)((Object)audioMixingMode)));
        this._audioMixingMode = audioMixingMode;
    }

    @RequiresApi(value=29)
    private final void initAudioRecorder(MediaProjection mMediaProjection) {
        int size = AudioRecord.getMinBufferSize((int)this.inputSampleRate, (int)16, (int)2);
        AudioFormat format = new AudioFormat.Builder().setEncoding(2).setSampleRate(this.inputSampleRate).setChannelMask(4).build();
        AudioPlaybackCaptureConfiguration audioPlaybackCaptureConfiguration = new AudioPlaybackCaptureConfiguration.Builder(mMediaProjection).addMatchingUsage(1).addMatchingUsage(0).addMatchingUsage(14).build();
        Intrinsics.checkNotNullExpressionValue((Object)audioPlaybackCaptureConfiguration, (String)"Builder(mMediaProjection)\n      .addMatchingUsage(AudioAttributes.USAGE_MEDIA)\n      .addMatchingUsage(AudioAttributes.USAGE_UNKNOWN)\n      .addMatchingUsage(AudioAttributes.USAGE_GAME)\n      .build()");
        AudioPlaybackCaptureConfiguration playbackConfig = audioPlaybackCaptureConfiguration;
        AudioRecord audioRecord = this.mAudioRecord = new AudioRecord.Builder().setAudioFormat(format).setAudioPlaybackCaptureConfig(playbackConfig).build();
        Intrinsics.checkNotNull((Object)audioRecord);
        audioRecord.startRecording();
    }

    private final void initchunk() {
        int bytesPerFrame = 2;
        this.capacity = bytesPerFrame * (this.inputSampleRate / 100);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.capacity).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(capacity).order(ByteOrder.nativeOrder())");
        byteBuffer = this.systemAudioByteBuffer = byteBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"systemAudioByteBuffer");
            throw null;
        }
        this.systemAudioShortArray = new short[byteBuffer.capacity() / 2];
    }

    public final void stopAudioMixing() {
        HMSLogger.d("AudioMixing", "stopping Audio mixing");
        this.isAudioMixingNeeded = false;
        this.getWebrtcAudioRecord().isMixingNeeded(false);
    }

    private final PeerConnectionFactory.Builder getPeerConnectionFactoryBuilder(boolean isSimulcastEnabled, HMSTrackSettings hmsTrackSettings) {
        String string;
        VideoCodecInfo it;
        Collection<String> collection;
        Object[] $this$mapTo$iv$iv;
        Object[] $this$map$iv;
        PeerConnectionFactory.Builder builder;
        PeerConnectionFactory.Builder $this$getPeerConnectionFactoryBuilder_u24lambda_u2d2 = builder = PeerConnectionFactory.builder();
        boolean bl = false;
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        $this$getPeerConnectionFactoryBuilder_u24lambda_u2d2.setOptions(options);
        Object[] objectArray = hmsTrackSettings.getVideoSettings();
        this.setVideoEncoderFactory(new SimulcastVideoEncoderFactoryWrapper(SharedEglContext.INSTANCE.getContext(), false, false, objectArray == null ? false : objectArray.getForceSoftwareEncoder(), 6, null));
        objectArray = SharedEglContext.INSTANCE.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"SharedEglContext.context");
        VideoCodecInfo[] videoCodecInfoArray = objectArray;
        objectArray = hmsTrackSettings.getVideoSettings();
        this.setVideoDecoderFactory((VideoDecoderFactory)new HMSVideoDecoderFactory((EglBase.Context)videoCodecInfoArray, objectArray == null ? false : objectArray.getForceSoftwareDecoder()));
        objectArray = this.getVideoEncoderFactory().getSupportedCodecs();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"videoEncoderFactory.supportedCodecs");
        objectArray = objectArray;
        String string2 = "Encoder supported Codecs: ";
        String string3 = TAG;
        boolean $i$f$map = false;
        void var11_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (VideoCodecInfo item$iv$iv : $this$mapTo$iv$iv) {
            VideoCodecInfo videoCodecInfo = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            string = it.name;
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        HMSLogger.d(string3, Intrinsics.stringPlus((String)string2, (Object)collection));
        $this$map$iv = this.getVideoDecoderFactory().getSupportedCodecs();
        Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"videoDecoderFactory.supportedCodecs");
        $this$map$iv = $this$map$iv;
        string2 = "Decoder supported Codecs: ";
        string3 = TAG;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        for (VideoCodecInfo item$iv$iv : $this$mapTo$iv$iv) {
            it = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            string = it.name;
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        HMSLogger.d(string3, Intrinsics.stringPlus((String)string2, collection));
        $this$getPeerConnectionFactoryBuilder_u24lambda_u2d2.setVideoEncoderFactory(this.getVideoEncoderFactory());
        $this$getPeerConnectionFactoryBuilder_u24lambda_u2d2.setVideoDecoderFactory(this.getVideoDecoderFactory());
        this.setNoiseCancellation(new NoiseCancellationFactoryImpl(this.getNcStatusChecker()).jniLoad(this.getContext()));
        HMSAudioTrackSettings hMSAudioTrackSettings = hmsTrackSettings.getAudioSettings();
        AudioProcessingFactory audioProcessingFactory = this.getNoiseCancellation().getAudioProcessingFactory(hMSAudioTrackSettings == null ? false : hMSAudioTrackSettings.getEnableNoiseCancellation());
        if (audioProcessingFactory != null) {
            $this$getPeerConnectionFactoryBuilder_u24lambda_u2d2.setAudioProcessingFactory(audioProcessingFactory);
        }
        return builder;
    }

    static /* synthetic */ PeerConnectionFactory.Builder getPeerConnectionFactoryBuilder$default(HMSPeerConnectionFactory hMSPeerConnectionFactory, boolean bl, HMSTrackSettings hMSTrackSettings, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return hMSPeerConnectionFactory.getPeerConnectionFactoryBuilder(bl, hMSTrackSettings);
    }

    private final void initPeerConnectionFactory() {
        PeerConnectionFactory.InitializationOptions.Builder builder;
        PeerConnectionFactory.InitializationOptions.Builder $this$initPeerConnectionFactory_u24lambda_u2d4 = builder = PeerConnectionFactory.InitializationOptions.builder((Context)this.context);
        boolean bl = false;
        $this$initPeerConnectionFactory_u24lambda_u2d4.setFieldTrials("WebRTC-H264HighProfile/Enabled/WebRTC-MediaCodecVideoEncoder-AutomaticResize/Enabled/WebRTC-UseDifferentiatedCellularCosts/Enabled/");
        $this$initPeerConnectionFactory_u24lambda_u2d4.setInjectableLogger(HMSPeerConnectionFactory::initPeerConnectionFactory$lambda-4$lambda-3, Logging.Severity.LS_VERBOSE);
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)builder.createInitializationOptions());
    }

    private final short[] scaleValues(short[] buff, int len, float scale) {
        int n = 0;
        if (n < len) {
            do {
                int i = n++;
                short oldValue = buff[i];
                int newValue = (int)((float)buff[i] * scale);
                if (newValue > Short.MAX_VALUE) {
                    newValue = Short.MAX_VALUE;
                } else if (newValue < Short.MIN_VALUE) {
                    newValue = Short.MIN_VALUE;
                }
                buff[i] = (short)newValue;
            } while (n < len);
        }
        return buff;
    }

    @Nullable
    public final ScheduledExecutorService newDefaultScheduler() {
        AtomicInteger nextThreadId = new AtomicInteger(0);
        return Executors.newScheduledThreadPool(0, arg_0 -> HMSPeerConnectionFactory.newDefaultScheduler$lambda-5(this, nextThreadId, arg_0));
    }

    private final void sendAECAnalytics(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        boolean isAECEventSent = sharedPreferences.getBoolean(PREF_AEC_EVENT_KEY, false);
        if (!isAECEventSent) {
            boolean isHardwareAECSupported = JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported();
            AnalyticsEvent analyticsEvent = AnalyticsEventFactory.INSTANCE.audioEchoCancellation(isHardwareAECSupported);
            this.analyticsEventsService.queue(analyticsEvent);
            sharedPreferences.edit().putBoolean(PREF_AEC_EVENT_KEY, true).apply();
        }
    }

    private final void sendMicCaptureFailedEvent(String errorMessage) {
        HMSException hmsException = ErrorFactory.TracksErrors.MicCaptureFailed$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, errorMessage, null, null, 12, null);
        AnalyticsEvent analyticsEvent = AnalyticsEventFactory.INSTANCE.audioPublishFail(hmsException);
        this.analyticsEventsService.queue(analyticsEvent);
    }

    private static final void initPeerConnectionFactory$lambda-4$lambda-3(String message, Logging.Severity severity, String tag) {
        Intrinsics.checkNotNullExpressionValue((Object)severity, (String)"severity");
        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        HMSLogger.INSTANCE.webRTCLog$lib_release(severity, tag, message);
    }

    private static final Thread newDefaultScheduler$lambda-5(HMSPeerConnectionFactory this$0, AtomicInteger $nextThreadId, Runnable r2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nextThreadId, (String)"$nextThreadId");
        Thread thread = Executors.defaultThreadFactory().newThread(r2);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "WebRtcAudioRecordScheduler-%s-%s";
        Object[] objectArray = new Object[]{this$0.nextSchedulerId.getAndIncrement(), $nextThreadId.getAndIncrement()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        thread.setName(string2);
        return thread;
    }

    public static final /* synthetic */ void access$sendMicCaptureFailedEvent(HMSPeerConnectionFactory $this, String errorMessage) {
        $this.sendMicCaptureFailedEvent(errorMessage);
    }

    public static final /* synthetic */ AudioMixingMode access$get_audioMixingMode$p(HMSPeerConnectionFactory $this) {
        return $this._audioMixingMode;
    }

    public static final /* synthetic */ void access$captureSystemAudio(HMSPeerConnectionFactory $this) {
        $this.captureSystemAudio();
    }

    public static final /* synthetic */ void access$mixAudioBytes(HMSPeerConnectionFactory $this, ByteBuffer micAudioByteBuffer) {
        $this.mixAudioBytes(micAudioByteBuffer);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HMSPeerConnectionFactory.class), "videoEncoderFactory", "getVideoEncoderFactory()Lorg/webrtc/VideoEncoderFactory;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HMSPeerConnectionFactory.class), "videoDecoderFactory", "getVideoDecoderFactory()Lorg/webrtc/VideoDecoderFactory;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HMSPeerConnectionFactory.class), "factory", "getFactory()Lorg/webrtc/PeerConnectionFactory;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HMSPeerConnectionFactory.class), "webrtcAudioRecord", "getWebrtcAudioRecord()Lorg/webrtc/audio/WebRtcAudioRecord;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HMSPeerConnectionFactory.class), "webRtcAudioTrack", "getWebRtcAudioTrack()Lorg/webrtc/audio/WebRtcAudioTrack;")))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Llive/hms/video/factories/HMSPeerConnectionFactory$Companion;", "", "()V", "BUFFERS_PER_SECOND", "", "CALLBACK_BUFFER_SIZE_MS", "DEFAULT_AUDIO_FORMAT", "DEFAULT_AUDIO_SOURCE", "FILE_VOLUME_SCALE", "", "INPUT_BITS_PER_SAMPLE", "INPUT_NUM_OF_CHANNELS", "MIC_VOLUME_SCALE", "OUTPUT_BITS_PER_SAMPLE", "OUTPUT_NUM_OF_CHANNELS", "PREF_AEC_EVENT_DEFAULT", "", "PREF_AEC_EVENT_KEY", "", "TAG", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

