/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection.models;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.factories.IceCandidateFactory;
import live.hms.video.signal.init.IceServer;
import live.hms.video.signal.init.InitConfig;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.webrtc.PeerConnection;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Llive/hms/video/connection/models/HMSConfiguration;", "Lorg/webrtc/PeerConnection$RTCConfiguration;", "iceServers", "", "Lorg/webrtc/PeerConnection$IceServer;", "(Ljava/util/List;)V", "toString", "", "Companion", "lib_release"})
public final class HMSConfiguration
extends PeerConnection.RTCConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "HMSConfiguration";

    public HMSConfiguration(@NotNull List<? extends PeerConnection.IceServer> iceServers) {
        Intrinsics.checkNotNullParameter(iceServers, (String)"iceServers");
        super(iceServers);
        this.sdpSemantics = PeerConnection.SdpSemantics.UNIFIED_PLAN;
    }

    @NotNull
    public String toString() {
        return super.toString();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Llive/hms/video/connection/models/HMSConfiguration$Companion;", "", "()V", "TAG", "", "from", "Llive/hms/video/connection/models/HMSConfiguration;", "config", "Llive/hms/video/signal/init/InitConfig;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HMSConfiguration from(@NotNull InitConfig config) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            ArrayList<PeerConnection.IceServer> servers = new ArrayList<PeerConnection.IceServer>();
            for (IceServer server : config.getRtcConfig().getIceServers()) {
                String string = server.getUrls().get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.urls[0]");
                if (StringsKt.startsWith$default((String)string, (String)"stun:", (boolean)false, (int)2, null)) {
                    servers.add(IceCandidateFactory.INSTANCE.makeStunServer((List<String>)server.getUrls()));
                    continue;
                }
                string = server.getUrls().get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.urls[0]");
                if (StringsKt.startsWith$default((String)string, (String)"turn:", (boolean)false, (int)2, null)) {
                    List list = server.getUrls();
                    String string2 = server.getUsername();
                    Intrinsics.checkNotNull((Object)string2);
                    String string3 = server.getCredential();
                    Intrinsics.checkNotNull((Object)string3);
                    servers.add(IceCandidateFactory.INSTANCE.makeTurnServer(list, string2, string3));
                    continue;
                }
                HMSLogger.INSTANCE.w(HMSConfiguration.TAG, Intrinsics.stringPlus((String)"Unknown server received: ", (Object)server));
            }
            HMSLogger.d(HMSConfiguration.TAG, Intrinsics.stringPlus((String)"parsed ice-server: ", servers));
            boolean bl2 = bl = servers.size() > 0;
            if (!bl) {
                boolean bl3 = false;
                String string = Intrinsics.stringPlus((String)"Expected at least one ice-server in config=", (Object)config);
                throw new IllegalArgumentException(string.toString());
            }
            return new HMSConfiguration((List<? extends PeerConnection.IceServer>)servers);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

