/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection.stats.clientside.manager;

import android.content.Context;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.degredation.QualityLimitationReasons;
import live.hms.video.connection.stats.BitrateCalculator;
import live.hms.video.connection.stats.clientside.manager.StatsSamplingManager;
import live.hms.video.connection.stats.clientside.model.AudioAnalytics;
import live.hms.video.connection.stats.clientside.model.PublishAnalyticPayload;
import live.hms.video.connection.stats.clientside.model.VideoAnalytics;
import live.hms.video.connection.stats.clientside.sampler.PublishAudioStatsSampler;
import live.hms.video.connection.stats.clientside.sampler.PublishVideoStatsSampler;
import live.hms.video.connection.stats.clientside.sampler.SubscribeAudioStatsSampler;
import live.hms.video.connection.stats.clientside.sampler.SubscribeVideoStatsSampler;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.signal.init.Stats;
import live.hms.video.utils.HMSUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.RTCStats;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u001a\u0010]\u001a\u00020^2\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020`05J\u001a\u0010a\u001a\u00020^2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020`05J&\u0010c\u001a\u0004\u0018\u00010`2\u0006\u0010d\u001a\u00020\n2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020`05H\u0002J\u001e\u0010e\u001a\u0004\u0018\u00010`2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020`0gH\u0002J2\u0010h\u001a\u0004\u0018\u00010`2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020`0j2\u0012\u0010k\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020`05H\u0002J*\u0010l\u001a\u00020^2\u0006\u0010#\u001a\u00020$2\b\u0010m\u001a\u0004\u0018\u00010n2\u0006\u0010o\u001a\u00020$2\b\u0010p\u001a\u0004\u0018\u00010nJ\u0010\u0010q\u001a\u00020^2\b\b\u0002\u0010r\u001a\u00020$J\"\u0010s\u001a\u00020\u0016*\u00020`2\b\u0010t\u001a\u0004\u0018\u00010u2\n\b\u0002\u0010v\u001a\u0004\u0018\u00010\nH\u0002R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010%\"\u0004\b)\u0010'R\u001a\u0010*\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u00104\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u000206058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b7\u00108R\u001a\u0010;\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0018\"\u0004\b=\u0010\u001aR\u001a\u0010>\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0010\"\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0010\"\u0004\bD\u0010AR\u001a\u0010E\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0010\"\u0004\bG\u0010AR\u001a\u0010H\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\u0010\"\u0004\bJ\u0010AR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010,R\u001a\u0010L\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\u0018\"\u0004\bN\u0010\u001aR\u001a\u0010O\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u0010\"\u0004\bQ\u0010AR\u001a\u0010R\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u0010\"\u0004\bT\u0010AR'\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020V058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bX\u0010:\u001a\u0004\bW\u00108R'\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020Z058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u0010:\u001a\u0004\b[\u00108\u00a8\u0006w"}, d2={"Llive/hms/video/connection/stats/clientside/manager/StatsSamplingManager;", "", "statsInitTime", "", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "applicationContext", "Landroid/content/Context;", "getPeerFromVideoTrackID", "Lkotlin/Function1;", "", "Llive/hms/video/sdk/models/HMSPeer;", "(JLlive/hms/video/events/AnalyticsEventsService;Landroid/content/Context;Lkotlin/jvm/functions/Function1;)V", "DEFAULT_PUBLISH_INTERVAL", "", "getDEFAULT_PUBLISH_INTERVAL", "()I", "DEFAULT_SAMPLE_DURATION", "getDEFAULT_SAMPLE_DURATION", "DEFAULT_SUBSCRIBE_SAMPLE_DURATION", "getDEFAULT_SUBSCRIBE_SAMPLE_DURATION", "START_VIDEO_SAMPLE_DURATION", "", "getSTART_VIDEO_SAMPLE_DURATION", "()D", "setSTART_VIDEO_SAMPLE_DURATION", "(D)V", "getAnalyticsEventsService", "()Llive/hms/video/events/AnalyticsEventsService;", "getApplicationContext", "()Landroid/content/Context;", "bitrateCalculator", "Llive/hms/video/connection/stats/BitrateCalculator;", "getGetPeerFromVideoTrackID", "()Lkotlin/jvm/functions/Function1;", "isPublishStatsEnabled", "", "()Z", "setPublishStatsEnabled", "(Z)V", "isSubscribeStatsEnabled", "setSubscribeStatsEnabled", "lastPublishedPublisherStatsTime", "getLastPublishedPublisherStatsTime", "()J", "setLastPublishedPublisherStatsTime", "(J)V", "lastPublishedSubscriberStatsTime", "getLastPublishedSubscriberStatsTime", "setLastPublishedSubscriberStatsTime", "localPublisherAudioSampler", "Llive/hms/video/connection/stats/clientside/sampler/PublishAudioStatsSampler;", "localPublisherVideoSamplerMap", "", "Llive/hms/video/connection/stats/clientside/sampler/PublishVideoStatsSampler;", "getLocalPublisherVideoSamplerMap", "()Ljava/util/Map;", "localPublisherVideoSamplerMap$delegate", "Lkotlin/Lazy;", "publishLastTimeStamp", "getPublishLastTimeStamp", "setPublishLastTimeStamp", "publishStatsMaxSamplePushInterval", "getPublishStatsMaxSamplePushInterval", "setPublishStatsMaxSamplePushInterval", "(I)V", "publishStatsMaxSampleWindowSize", "getPublishStatsMaxSampleWindowSize", "setPublishStatsMaxSampleWindowSize", "sequenceNumber", "getSequenceNumber", "setSequenceNumber", "sequenceSusbcriberNumber", "getSequenceSusbcriberNumber", "setSequenceSusbcriberNumber", "getStatsInitTime", "subscribeLastTimeStamp", "getSubscribeLastTimeStamp", "setSubscribeLastTimeStamp", "subscribeStatsMaxSamplePushInterval", "getSubscribeStatsMaxSamplePushInterval", "setSubscribeStatsMaxSamplePushInterval", "subscribeStatsMaxSampleWindowSize", "getSubscribeStatsMaxSampleWindowSize", "setSubscribeStatsMaxSampleWindowSize", "subscriberAudioSamplerMap", "Llive/hms/video/connection/stats/clientside/sampler/SubscribeAudioStatsSampler;", "getSubscriberAudioSamplerMap", "subscriberAudioSamplerMap$delegate", "subscriberVideoSamplerMap", "Llive/hms/video/connection/stats/clientside/sampler/SubscribeVideoStatsSampler;", "getSubscriberVideoSamplerMap", "subscriberVideoSamplerMap$delegate", "collectPublishStats", "", "allPublishStats", "Lorg/webrtc/RTCStats;", "collectSubscribeStats", "allSubscriberStats", "getCorrespondingAudioStats", "audioTrackID", "getSelectedCandidateInfo", "stats", "", "getTrackExtraEntry", "entry", "", "allStats", "setConfig", "publishStats", "Llive/hms/video/signal/init/Stats;", "isSubscriberStatsEnabled", "subscriberStats", "shouldPublishStats", "forcePublish", "toBitrate", "bytesTransported", "Ljava/math/BigInteger;", "rid", "lib_release"})
public final class StatsSamplingManager {
    private final long statsInitTime;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final Function1<String, HMSPeer> getPeerFromVideoTrackID;
    private final int DEFAULT_SAMPLE_DURATION;
    private final int DEFAULT_SUBSCRIBE_SAMPLE_DURATION;
    private final int DEFAULT_PUBLISH_INTERVAL;
    private boolean isPublishStatsEnabled;
    private boolean isSubscribeStatsEnabled;
    private int publishStatsMaxSampleWindowSize;
    private int publishStatsMaxSamplePushInterval;
    private int subscribeStatsMaxSampleWindowSize;
    private int subscribeStatsMaxSamplePushInterval;
    private long lastPublishedPublisherStatsTime;
    private long lastPublishedSubscriberStatsTime;
    private double START_VIDEO_SAMPLE_DURATION;
    private double publishLastTimeStamp;
    private double subscribeLastTimeStamp;
    private int sequenceNumber;
    private int sequenceSusbcriberNumber;
    @Nullable
    private PublishAudioStatsSampler localPublisherAudioSampler;
    @NotNull
    private final Lazy localPublisherVideoSamplerMap$delegate;
    @NotNull
    private final Lazy subscriberAudioSamplerMap$delegate;
    @NotNull
    private final Lazy subscriberVideoSamplerMap$delegate;
    @NotNull
    private final BitrateCalculator bitrateCalculator;

    public StatsSamplingManager(long statsInitTime, @NotNull AnalyticsEventsService analyticsEventsService2, @NotNull Context applicationContext, @NotNull Function1<? super String, ? extends HMSPeer> getPeerFromVideoTrackID) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(getPeerFromVideoTrackID, (String)"getPeerFromVideoTrackID");
        this.statsInitTime = statsInitTime;
        this.analyticsEventsService = analyticsEventsService2;
        this.applicationContext = applicationContext;
        this.getPeerFromVideoTrackID = getPeerFromVideoTrackID;
        this.DEFAULT_SAMPLE_DURATION = 30000;
        this.DEFAULT_SUBSCRIBE_SAMPLE_DURATION = 60000;
        this.DEFAULT_PUBLISH_INTERVAL = 300000;
        this.publishStatsMaxSampleWindowSize = this.DEFAULT_SAMPLE_DURATION;
        this.publishStatsMaxSamplePushInterval = this.DEFAULT_PUBLISH_INTERVAL;
        this.subscribeStatsMaxSampleWindowSize = this.DEFAULT_SUBSCRIBE_SAMPLE_DURATION;
        this.subscribeStatsMaxSamplePushInterval = this.DEFAULT_PUBLISH_INTERVAL;
        this.lastPublishedPublisherStatsTime = this.statsInitTime;
        this.lastPublishedSubscriberStatsTime = this.statsInitTime;
        this.START_VIDEO_SAMPLE_DURATION = -1.0;
        this.sequenceNumber = 1;
        this.sequenceSusbcriberNumber = 1;
        this.localPublisherVideoSamplerMap$delegate = LazyKt.lazy((Function0)localPublisherVideoSamplerMap.2.INSTANCE);
        this.subscriberAudioSamplerMap$delegate = LazyKt.lazy((Function0)subscriberAudioSamplerMap.2.INSTANCE);
        this.subscriberVideoSamplerMap$delegate = LazyKt.lazy((Function0)subscriberVideoSamplerMap.2.INSTANCE);
        this.bitrateCalculator = new BitrateCalculator();
    }

    public final long getStatsInitTime() {
        return this.statsInitTime;
    }

    @NotNull
    public final AnalyticsEventsService getAnalyticsEventsService() {
        return this.analyticsEventsService;
    }

    @NotNull
    public final Context getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public final Function1<String, HMSPeer> getGetPeerFromVideoTrackID() {
        return this.getPeerFromVideoTrackID;
    }

    public final int getDEFAULT_SAMPLE_DURATION() {
        return this.DEFAULT_SAMPLE_DURATION;
    }

    public final int getDEFAULT_SUBSCRIBE_SAMPLE_DURATION() {
        return this.DEFAULT_SUBSCRIBE_SAMPLE_DURATION;
    }

    public final int getDEFAULT_PUBLISH_INTERVAL() {
        return this.DEFAULT_PUBLISH_INTERVAL;
    }

    public final boolean isPublishStatsEnabled() {
        return this.isPublishStatsEnabled;
    }

    public final void setPublishStatsEnabled(boolean bl) {
        this.isPublishStatsEnabled = bl;
    }

    public final boolean isSubscribeStatsEnabled() {
        return this.isSubscribeStatsEnabled;
    }

    public final void setSubscribeStatsEnabled(boolean bl) {
        this.isSubscribeStatsEnabled = bl;
    }

    public final int getPublishStatsMaxSampleWindowSize() {
        return this.publishStatsMaxSampleWindowSize;
    }

    public final void setPublishStatsMaxSampleWindowSize(int n) {
        this.publishStatsMaxSampleWindowSize = n;
    }

    public final int getPublishStatsMaxSamplePushInterval() {
        return this.publishStatsMaxSamplePushInterval;
    }

    public final void setPublishStatsMaxSamplePushInterval(int n) {
        this.publishStatsMaxSamplePushInterval = n;
    }

    public final int getSubscribeStatsMaxSampleWindowSize() {
        return this.subscribeStatsMaxSampleWindowSize;
    }

    public final void setSubscribeStatsMaxSampleWindowSize(int n) {
        this.subscribeStatsMaxSampleWindowSize = n;
    }

    public final int getSubscribeStatsMaxSamplePushInterval() {
        return this.subscribeStatsMaxSamplePushInterval;
    }

    public final void setSubscribeStatsMaxSamplePushInterval(int n) {
        this.subscribeStatsMaxSamplePushInterval = n;
    }

    public final long getLastPublishedPublisherStatsTime() {
        return this.lastPublishedPublisherStatsTime;
    }

    public final void setLastPublishedPublisherStatsTime(long l) {
        this.lastPublishedPublisherStatsTime = l;
    }

    public final long getLastPublishedSubscriberStatsTime() {
        return this.lastPublishedSubscriberStatsTime;
    }

    public final void setLastPublishedSubscriberStatsTime(long l) {
        this.lastPublishedSubscriberStatsTime = l;
    }

    public final double getSTART_VIDEO_SAMPLE_DURATION() {
        return this.START_VIDEO_SAMPLE_DURATION;
    }

    public final void setSTART_VIDEO_SAMPLE_DURATION(double d) {
        this.START_VIDEO_SAMPLE_DURATION = d;
    }

    public final double getPublishLastTimeStamp() {
        return this.publishLastTimeStamp;
    }

    public final void setPublishLastTimeStamp(double d) {
        this.publishLastTimeStamp = d;
    }

    public final double getSubscribeLastTimeStamp() {
        return this.subscribeLastTimeStamp;
    }

    public final void setSubscribeLastTimeStamp(double d) {
        this.subscribeLastTimeStamp = d;
    }

    public final int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(int n) {
        this.sequenceNumber = n;
    }

    public final int getSequenceSusbcriberNumber() {
        return this.sequenceSusbcriberNumber;
    }

    public final void setSequenceSusbcriberNumber(int n) {
        this.sequenceSusbcriberNumber = n;
    }

    private final Map<String, PublishVideoStatsSampler> getLocalPublisherVideoSamplerMap() {
        Lazy lazy = this.localPublisherVideoSamplerMap$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<String, SubscribeAudioStatsSampler> getSubscriberAudioSamplerMap() {
        Lazy lazy = this.subscriberAudioSamplerMap$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<String, SubscribeVideoStatsSampler> getSubscriberVideoSamplerMap() {
        Lazy lazy = this.subscriberVideoSamplerMap$delegate;
        return (Map)lazy.getValue();
    }

    public final void shouldPublishStats(boolean forcePublish) {
        Object localVideoSampler;
        Map.Entry<String, Object> entry;
        long currentTime;
        if (this.isPublishStatsEnabled && ((currentTime = System.currentTimeMillis()) >= this.lastPublishedPublisherStatsTime + (long)this.publishStatsMaxSamplePushInterval || forcePublish)) {
            Map.Entry<String, PublishVideoStatsSampler> entry2;
            this.lastPublishedPublisherStatsTime = currentTime;
            List videos = new ArrayList();
            Map.Entry<String, PublishVideoStatsSampler> entry4 = this.getLocalPublisherVideoSamplerMap();
            Iterator<Map.Entry<String, PublishVideoStatsSampler>> iterator = entry4.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PublishVideoStatsSampler> entry3 = entry4 = iterator.next();
                String statsSamplingManager2 = (String)entry3.getKey();
                entry2 = entry4;
                PublishVideoStatsSampler publishVideoStatsSampler = (PublishVideoStatsSampler)entry2.getValue();
                if (!publishVideoStatsSampler.hasSample() && !forcePublish) continue;
                entry2 = videos;
                entry = publishVideoStatsSampler.getCollectedSamples(forcePublish);
                entry2.add(entry);
            }
            StatsSamplingManager n2 = this;
            int n = n2.sequenceNumber;
            n2.sequenceNumber = n + 1;
            int n3 = n;
            int entry6 = this.publishStatsMaxSampleWindowSize;
            long l = this.statsInitTime;
            PublishAudioStatsSampler publishAudioStatsSampler = this.localPublisherAudioSampler;
            entry = (publishAudioStatsSampler == null ? false : publishAudioStatsSampler.hasSample()) || forcePublish ? CollectionsKt.listOfNotNull((publishAudioStatsSampler = this.localPublisherAudioSampler) == null ? null : publishAudioStatsSampler.getCollectedSamples(forcePublish)) : CollectionsKt.emptyList();
            int n4 = HMSUtils.INSTANCE.getBatteryPercentage(this.applicationContext);
            PublishAnalyticPayload payload = new PublishAnalyticPayload(n3, entry6, l, videos, (List<AudioAnalytics>)((Object)entry), n4);
            this.analyticsEventsService.queue(AnalyticsEventFactory.clientSideStats$default(AnalyticsEventFactory.INSTANCE, payload, false, 2, null)).flush();
            Iterator<Map.Entry<String, PublishVideoStatsSampler>> iterator2 = this.localPublisherAudioSampler;
            if (iterator2 != null) {
                ((PublishAudioStatsSampler)((Object)iterator2)).resetSamples();
            }
            Map<String, PublishVideoStatsSampler> n6 = this.getLocalPublisherVideoSamplerMap();
            iterator2 = n6.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, PublishVideoStatsSampler> entry5;
                entry2 = entry5 = iterator2.next();
                String string = entry2.getKey();
                entry = entry5;
                localVideoSampler = (PublishVideoStatsSampler)entry.getValue();
                ((PublishVideoStatsSampler)localVideoSampler).resetSamples();
            }
        }
        if (this.isSubscribeStatsEnabled && ((currentTime = System.currentTimeMillis()) >= this.lastPublishedSubscriberStatsTime + (long)this.subscribeStatsMaxSamplePushInterval || forcePublish)) {
            Object sampler;
            Object audioSampler;
            this.lastPublishedSubscriberStatsTime = currentTime;
            List audios = new ArrayList();
            List videos = new ArrayList();
            Map<String, SubscribeAudioStatsSampler> map = this.getSubscriberAudioSamplerMap();
            for (Map.Entry<String, SubscribeAudioStatsSampler> entry6 : map.entrySet()) {
                localVideoSampler = entry6;
                String string = localVideoSampler.getKey();
                entry = entry6;
                audioSampler = entry.getValue();
                if (!((SubscribeAudioStatsSampler)audioSampler).hasSample()) continue;
                entry = audios;
                AudioAnalytics audioAnalytics = ((SubscribeAudioStatsSampler)audioSampler).getCollectedSamples(forcePublish);
                entry.add(audioAnalytics);
            }
            Map<String, SubscribeVideoStatsSampler> map2 = this.getSubscriberVideoSamplerMap();
            for (Map.Entry<String, Object> entry7 : map2.entrySet()) {
                audioSampler = entry7;
                String string = (String)audioSampler.getKey();
                entry = entry7;
                SubscribeVideoStatsSampler videoSampler232 = (SubscribeVideoStatsSampler)entry.getValue();
                if (!videoSampler232.hasSample()) continue;
                entry = videos;
                VideoAnalytics videoAnalytics = videoSampler232.getCollectedSamples(forcePublish);
                entry.add(videoAnalytics);
            }
            StatsSamplingManager statsSamplingManager2 = this;
            int videoSampler232 = statsSamplingManager2.sequenceSusbcriberNumber;
            statsSamplingManager2.sequenceSusbcriberNumber = videoSampler232 + 1;
            int n = videoSampler232;
            int n5 = this.subscribeStatsMaxSampleWindowSize;
            long videoSampler232 = this.statsInitTime;
            int n6 = HMSUtils.INSTANCE.getBatteryPercentage(this.applicationContext);
            PublishAnalyticPayload payload = new PublishAnalyticPayload(n, n5, videoSampler232, videos, audios, n6);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.clientSideStats(payload, true)).flush();
            Map<String, SubscribeAudioStatsSampler> map3 = this.getSubscriberAudioSamplerMap();
            for (Map.Entry<String, SubscribeAudioStatsSampler> entry8 : map3.entrySet()) {
                entry = entry8;
                String key = entry.getKey();
                Map.Entry<String, SubscribeAudioStatsSampler> entry9 = entry8;
                sampler = entry9.getValue();
                ((SubscribeAudioStatsSampler)sampler).resetSamples();
            }
            Map<String, SubscribeVideoStatsSampler> map4 = this.getSubscriberVideoSamplerMap();
            for (Map.Entry<String, SubscribeVideoStatsSampler> entry10 : map4.entrySet()) {
                sampler = entry10;
                String key = (String)sampler.getKey();
                Map.Entry<String, SubscribeVideoStatsSampler> entry11 = entry10;
                sampler = entry11.getValue();
                ((SubscribeVideoStatsSampler)sampler).resetSamples();
            }
        }
    }

    public static /* synthetic */ void shouldPublishStats$default(StatsSamplingManager statsSamplingManager2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        statsSamplingManager2.shouldPublishStats(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void collectPublishStats(@NotNull Map<String, RTCStats> allPublishStats) {
        Intrinsics.checkNotNullParameter(allPublishStats, (String)"allPublishStats");
        if (!this.isPublishStatsEnabled) {
            return;
        }
        this.publishLastTimeStamp = System.currentTimeMillis();
        StatsSamplingManager.shouldPublishStats$default(this, false, 1, null);
        Object object = allPublishStats;
        for (Map.Entry<String, RTCStats> stats : object.entrySet()) {
            Unit unit;
            Map primaryEntry;
            Object publishCandidatePairInfo;
            Object v;
            Object object2;
            Object object3;
            RTCStats extraData;
            Map primaryEntry2;
            if (Intrinsics.areEqual((Object)stats.getValue().getType(), (Object)"outbound-rtp")) {
                Unit unit2;
                double availableOutgoingBitrate;
                Map map;
                Object object4;
                Object qualityLimitationMap;
                RTCStats width;
                String trackId;
                primaryEntry2 = stats.getValue().getMembers();
                double primaryTimestamp = stats.getValue().getTimestampUs();
                extraData = this.getTrackExtraEntry(stats, allPublishStats);
                RTCStats publishCandidatePairInfo2 = this.getSelectedCandidateInfo(allPublishStats);
                if (Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"video")) {
                    Object var9_13;
                    Object object5 = extraData;
                    Object v0 = var9_13 = object5 == null ? null : ((object3 = object5.getMembers()) == null ? null : object3.get("trackIdentifier"));
                    if ((var9_13 instanceof String ? (String)var9_13 : null) != null) {
                        int n;
                        Object object6;
                        void key$iv;
                        void $this$getOrPut$iv;
                        Object object7;
                        object5 = extraData;
                        Object v1 = var9_13 = object5 == null ? null : ((object3 = object5.getMembers()) == null ? null : object3.get("trackIdentifier"));
                        if ((var9_13 instanceof String ? (String)var9_13 : null) == null) {
                            return;
                        }
                        object5 = primaryEntry2.get("ssrc");
                        trackId = String.valueOf(object5 instanceof Long ? (Long)object5 : null);
                        Object object8 = primaryEntry2.get("frameWidth");
                        object3 = object8 instanceof Long ? (Long)object8 : null;
                        width = object3 == null ? null : Integer.valueOf((int)((Long)object3).longValue());
                        object2 = primaryEntry2.get("frameHeight");
                        object8 = object2 instanceof Long ? (Long)object2 : null;
                        Integer height = object8 == null ? null : Integer.valueOf((int)((Long)object8).longValue());
                        v = primaryEntry2.get("totalPacketSendDelay");
                        Double d = v instanceof Double ? (Double)v : null;
                        double totalPacketSendDelay = d == null ? 0.0 : d;
                        Object v2 = primaryEntry2.get("packetsSent");
                        Long l = v2 instanceof Long ? (Long)v2 : null;
                        long packetsSent = l == null ? 0L : l;
                        v2 = primaryEntry2.get("qualityLimitationDurations");
                        qualityLimitationMap = v2 instanceof HashMap ? (HashMap)v2 : null;
                        object4 = primaryEntry2.get("qualityLimitationReason");
                        String string = object4 instanceof String ? (String)object4 : null;
                        object4 = qualityLimitationMap;
                        Double d2 = object4 == null ? null : (Double)((HashMap)object4).get("bandwidth");
                        object4 = qualityLimitationMap;
                        Double d3 = object4 == null ? null : (Double)((HashMap)object4).get("cpu");
                        object4 = qualityLimitationMap;
                        Double d4 = object4 == null ? null : (Double)((HashMap)object4).get("none");
                        object4 = qualityLimitationMap;
                        QualityLimitationReasons qualityReasons = new QualityLimitationReasons(string, d2, d3, d4, object4 == null ? null : (Double)((HashMap)object4).get("other"), null, 32, null);
                        Object v3 = primaryEntry2.get("framesPerSecond");
                        Number fps = v3 instanceof Number ? (Number)((Number)v3) : (Number)null;
                        Object object9 = publishCandidatePairInfo2;
                        String string2 = object9 == null ? null : ((object7 = object9.getMembers()) == null ? null : (String)object7.get("availableOutgoingBitrate"));
                        Object object10 = string2 instanceof Double ? (Double)((Object)string2) : null;
                        double availableOutgoingBitrate2 = object10 == null ? 0.0 : (Double)object10;
                        object10 = this.getLocalPublisherVideoSamplerMap();
                        string2 = trackId;
                        object9 = string2;
                        string2 = object9 == null ? "" : object9;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            Map map2;
                            Object var28_52;
                            boolean bl = false;
                            RTCStats rTCStats = extraData;
                            Object v6 = rTCStats == null ? null : (var28_52 = (map2 = rTCStats.getMembers()) == null ? null : map2.get("trackIdentifier"));
                            if (var28_52 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                            }
                            PublishVideoStatsSampler answer$iv = new PublishVideoStatsSampler(this.getPublishStatsMaxSampleWindowSize(), var28_52, (String)primaryEntry2.get("rid"), String.valueOf((Long)primaryEntry2.get("ssrc")), null, 16, null);
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object6 = answer$iv;
                        } else {
                            object6 = value$iv;
                        }
                        object10 = object6;
                        PublishVideoStatsSampler $this$collectPublishStats_u24lambda_u2d1 = (PublishVideoStatsSampler)object10;
                        boolean bl = false;
                        object7 = fps;
                        int n2 = object7 == null ? 0 : (n = ((Number)object7).intValue());
                        Object object11 = object7 = trackId;
                        object7 = extraData;
                        $this$collectPublishStats_u24lambda_u2d1.add((Integer)width, height, qualityReasons, availableOutgoingBitrate2, n2, (String)(object11 == null ? "" : object11), object7 == null ? 0.0 : this.toBitrate((RTCStats)object7, (BigInteger)primaryEntry2.get("bytesSent"), (String)primaryEntry2.get("rid")), totalPacketSendDelay, packetsSent, this.getPublishLastTimeStamp());
                        continue;
                    }
                }
                if (!Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"audio") || ((trackId = (width = extraData) == null ? null : ((object3 = width.getMembers()) == null ? null : (String)object3.get("trackIdentifier"))) instanceof String ? (String)trackId : null) == null) continue;
                Map primaryEntry3 = stats.getValue().getMembers();
                double primaryTimestamp2 = stats.getValue().getTimestampUs();
                RTCStats extraData2 = this.getTrackExtraEntry(stats, allPublishStats);
                publishCandidatePairInfo = this.getSelectedCandidateInfo(allPublishStats);
                object4 = publishCandidatePairInfo;
                RTCStats qualityReasons = object4 == null ? null : ((map = object4.getMembers()) == null ? null : (RTCStats)map.get("availableOutgoingBitrate"));
                qualityLimitationMap = qualityReasons instanceof Double ? (Double)qualityReasons : null;
                double d = availableOutgoingBitrate = qualityLimitationMap == null ? 0.0 : (Double)qualityLimitationMap;
                if (this.localPublisherAudioSampler == null) {
                    qualityReasons = extraData2;
                    Object object12 = qualityReasons == null ? null : (qualityLimitationMap = (object4 = qualityReasons.getMembers()) == null ? null : (Object)object4.get("trackIdentifier"));
                    if (qualityLimitationMap == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    this.localPublisherAudioSampler = new PublishAudioStatsSampler(this.publishStatsMaxSampleWindowSize, (String)qualityLimitationMap, String.valueOf((Long)primaryEntry3.get("ssrc")), null, 8, null);
                }
                if ((qualityLimitationMap = this.localPublisherAudioSampler) == null) {
                    unit2 = null;
                    continue;
                }
                qualityReasons = extraData2;
                ((PublishAudioStatsSampler)qualityLimitationMap).add(availableOutgoingBitrate, qualityReasons == null ? 0.0 : StatsSamplingManager.toBitrate$default(this, qualityReasons, (BigInteger)primaryEntry3.get("bytesSent"), null, 2, null));
                unit2 = Unit.INSTANCE;
                continue;
            }
            if (!Intrinsics.areEqual((Object)stats.getValue().getType(), (Object)"remote-inbound-rtp")) continue;
            primaryEntry2 = stats.getValue().getMembers();
            RTCStats extraData3 = this.getTrackExtraEntry(stats, allPublishStats);
            if (Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"video") && (Long)primaryEntry2.get("ssrc") != null) {
                Object v12;
                primaryEntry = stats.getValue().getMembers();
                extraData = this.getTrackExtraEntry(stats, allPublishStats);
                object3 = primaryEntry.get("roundTripTime");
                Double primaryTimestamp2 = object3 instanceof Double ? (Double)object3 : null;
                double roundTripTime = primaryTimestamp2 == null ? 0.0 : primaryTimestamp2;
                publishCandidatePairInfo = primaryEntry.get("jitter");
                Double extraData2 = publishCandidatePairInfo instanceof Double ? (Double)publishCandidatePairInfo : null;
                double jitter = extraData2 == null ? 0.0 : extraData2;
                Object object13 = primaryEntry.get("packetsLost");
                publishCandidatePairInfo = object13 instanceof Integer ? (Integer)object13 : null;
                int packetsLost = publishCandidatePairInfo == null ? 0 : (Integer)publishCandidatePairInfo;
                object13 = primaryEntry.get("ssrc");
                String ssrc = String.valueOf(object13 instanceof Long ? (Long)object13 : null);
                object13 = this.getLocalPublisherVideoSamplerMap().get(ssrc);
                if (object13 == null) {
                    v12 = null;
                    continue;
                }
                Object $this$collectPublishStats_u24lambda_u2d2 = v = object13;
                boolean bl = false;
                ((PublishVideoStatsSampler)$this$collectPublishStats_u24lambda_u2d2).add(jitter, packetsLost, roundTripTime);
                v12 = v;
                continue;
            }
            if (!Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"audio")) continue;
            primaryEntry = stats.getValue().getMembers();
            extraData = this.getTrackExtraEntry(stats, allPublishStats);
            object3 = primaryEntry.get("roundTripTime");
            Double jitter = object3 instanceof Double ? (Double)object3 : null;
            double roundTripTime = jitter == null ? 0.0 : jitter;
            object2 = primaryEntry.get("jitter");
            Double packetsLost = object2 instanceof Double ? (Double)object2 : null;
            double jitter2 = packetsLost == null ? 0.0 : packetsLost;
            Object v4 = primaryEntry.get("packetsLost");
            object2 = v4 instanceof Integer ? (Integer)v4 : null;
            int packetsLost2 = object2 == null ? 0 : (Integer)object2;
            object2 = this.localPublisherAudioSampler;
            if (object2 == null) {
                unit = null;
                continue;
            }
            ((PublishAudioStatsSampler)object2).add(jitter2, packetsLost2, roundTripTime);
            unit = Unit.INSTANCE;
        }
        Object object14 = this.localPublisherAudioSampler;
        Boolean bl = object14 == null ? null : Boolean.valueOf(PublishAudioStatsSampler.shouldSample$default((PublishAudioStatsSampler)object14, this.publishLastTimeStamp, false, 2, null));
        object = this.getLocalPublisherVideoSamplerMap();
        object14 = object.entrySet().iterator();
        while (object14.hasNext()) {
            Object extraData3 = object = object14.next();
            String key = (String)extraData3.getKey();
            Object object15 = object;
            PublishVideoStatsSampler localVideoSampler = (PublishVideoStatsSampler)object15.getValue();
            PublishVideoStatsSampler.shouldSample$default(localVideoSampler, this.publishLastTimeStamp, false, 2, null);
        }
    }

    private final RTCStats getSelectedCandidateInfo(Map<String, ? extends RTCStats> stats) {
        RTCStats rTCStats;
        Map map;
        Object selectedPairId;
        RTCStats rTCStats2;
        Object v0 = stats == null ? null : ((rTCStats2 = stats.get("RTCTransport_0_1")) == null ? null : (selectedPairId = (map = rTCStats2.getMembers()) == null ? null : map.get("selectedCandidatePairId")));
        if (selectedPairId != null) {
            map = stats;
            rTCStats = map.get(selectedPairId);
        } else {
            rTCStats = null;
        }
        RTCStats candidatePairInfo = rTCStats;
        return candidatePairInfo;
    }

    private final RTCStats getTrackExtraEntry(Map.Entry<String, RTCStats> entry, Map<String, RTCStats> allStats) {
        Object trackId = entry.getValue().getMembers().get("trackId");
        Map<String, RTCStats> map = allStats;
        return map.get(trackId);
    }

    private final double toBitrate(RTCStats $this$toBitrate, BigInteger bytesTransported, String rid) {
        String string;
        Map map = $this$toBitrate.getMembers();
        String trackId = map == null ? null : map.get("trackIdentifier");
        double remoteTimeStamp = $this$toBitrate.getTimestampUs();
        String string2 = string = rid;
        double d = this.bitrateCalculator.getBitrateFromTrackUpdatePrev(trackId, remoteTimeStamp, bytesTransported, string2 == null ? "" : string2);
        return d;
    }

    static /* synthetic */ double toBitrate$default(StatsSamplingManager statsSamplingManager2, RTCStats rTCStats, BigInteger bigInteger, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return statsSamplingManager2.toBitrate(rTCStats, bigInteger, string);
    }

    public final void setConfig(boolean isPublishStatsEnabled, @Nullable Stats publishStats, boolean isSubscriberStatsEnabled, @Nullable Stats subscriberStats) {
        this.isPublishStatsEnabled = isPublishStatsEnabled;
        Stats stats = publishStats;
        if ((stats == null ? null : stats.getMaxSampleWindowSize()) != null && !Intrinsics.areEqual((Float)publishStats.getMaxSampleWindowSize(), (float)0.0f)) {
            this.publishStatsMaxSampleWindowSize = (int)publishStats.getMaxSampleWindowSize().floatValue() * 1000;
        }
        if (((stats = publishStats) == null ? null : stats.getMaxSamplePushInterval()) != null && !Intrinsics.areEqual((Float)((stats = publishStats) == null ? null : stats.getMaxSamplePushInterval()), (float)0.0f)) {
            this.publishStatsMaxSamplePushInterval = (int)publishStats.getMaxSamplePushInterval().floatValue() * 1000;
        }
        this.isSubscribeStatsEnabled = isSubscriberStatsEnabled;
        stats = subscriberStats;
        if ((stats == null ? null : stats.getMaxSampleWindowSize()) != null && !Intrinsics.areEqual((Float)subscriberStats.getMaxSampleWindowSize(), (float)0.0f)) {
            this.subscribeStatsMaxSampleWindowSize = (int)subscriberStats.getMaxSampleWindowSize().floatValue() * 1000;
        }
        if (((stats = subscriberStats) == null ? null : stats.getMaxSamplePushInterval()) != null && !Intrinsics.areEqual((Float)subscriberStats.getMaxSamplePushInterval(), (float)0.0f)) {
            this.subscribeStatsMaxSamplePushInterval = (int)subscriberStats.getMaxSamplePushInterval().floatValue() * 1000;
        }
    }

    public final void collectSubscribeStats(@NotNull Map<String, RTCStats> allSubscriberStats) {
        Object audioSampler;
        Map.Entry<String, Object> entry;
        String key;
        Object primaryEntry;
        Intrinsics.checkNotNullParameter(allSubscriberStats, (String)"allSubscriberStats");
        if (!this.isSubscribeStatsEnabled) {
            return;
        }
        this.subscribeLastTimeStamp = System.currentTimeMillis();
        StatsSamplingManager.shouldPublishStats$default(this, false, 1, null);
        Map<String, RTCStats> entry22 = allSubscriberStats;
        for (Map.Entry<String, RTCStats> entry2 : entry22.entrySet()) {
            SubscribeVideoStatsSampler subscribeVideoStatsSampler;
            String trackID;
            Object object;
            Object object2;
            Object packetsLost;
            Map map;
            if (Intrinsics.areEqual((Object)entry2.getValue().getType(), (Object)"inbound-rtp")) {
                Object v;
                Object object3;
                Object fecPacketsReceived;
                Double d;
                Number fecPacketsDiscarded;
                Number audioTotalSamplesReceived;
                Object object4;
                Object silentConcealedSamples;
                Object v2;
                Number concealedSamples;
                RTCStats extraData = this.getTrackExtraEntry(entry2, allSubscriberStats);
                primaryEntry = entry2.getValue().getMembers();
                RTCStats rTCStats = extraData;
                Object var7_16 = rTCStats == null ? null : ((map = rTCStats.getMembers()) == null ? null : map.get("trackIdentifier"));
                String trackID2 = var7_16 instanceof String ? (String)var7_16 : null;
                Long ssrc = (Long)primaryEntry.get("ssrc");
                if (Intrinsics.areEqual((Object)String.valueOf(entry2.getValue().getMembers().get("kind")), (Object)"audio") && trackID2 != null) {
                    SubscribeAudioStatsSampler subscribeAudioStatsSampler;
                    double d2;
                    map = primaryEntry.get("jitter");
                    String jitter = String.valueOf(map instanceof Double ? (Double)((Object)map) : null);
                    double bitrate = d2 = StatsSamplingManager.toBitrate$default(this, extraData, (BigInteger)primaryEntry.get("bytesReceived"), null, 2, null);
                    Object v3 = primaryEntry.get("packetsReceived");
                    String packetsReceived = String.valueOf(v3 instanceof Long ? (Long)v3 : null);
                    Object v4 = primaryEntry.get("packetsLost");
                    packetsLost = String.valueOf(v4 instanceof Integer ? (Integer)v4 : null);
                    Object object5 = primaryEntry.get("audioLevel");
                    Double d3 = object5 instanceof Double ? (Double)object5 : null;
                    double audioLevel = d3 == null ? 0.0 : d3;
                    Object object6 = primaryEntry.get("concealedSamples");
                    object5 = object6 instanceof BigInteger ? (BigInteger)object6 : null;
                    concealedSamples = object5 == null ? Integer.valueOf(0) : object5;
                    v2 = primaryEntry.get("silentConcealedSamples");
                    object6 = v2 instanceof BigInteger ? (BigInteger)v2 : null;
                    silentConcealedSamples = object6 == null ? Integer.valueOf(0) : object6;
                    long audioConcealedSamples = ((Number)concealedSamples).longValue() - ((Number)silentConcealedSamples).longValue();
                    Object object7 = primaryEntry.get("totalSamplesReceived");
                    object4 = object7 instanceof BigInteger ? (BigInteger)object7 : null;
                    audioTotalSamplesReceived = object4 == null ? Integer.valueOf(0) : object4;
                    Object object8 = primaryEntry.get("concealmentEvents");
                    object7 = object8 instanceof BigInteger ? (BigInteger)object8 : null;
                    Object audioConcealmentEvents = object7 == null ? Integer.valueOf(0) : object7;
                    Object object9 = primaryEntry.get("fecPacketsDiscarded");
                    object8 = object9 instanceof BigInteger ? (BigInteger)object9 : null;
                    fecPacketsDiscarded = object8 == null ? Integer.valueOf(0) : object8;
                    d = primaryEntry.get("fecPacketsReceived");
                    object9 = d instanceof BigInteger ? (BigInteger)((Object)d) : null;
                    fecPacketsReceived = object9 == null ? Integer.valueOf(0) : object9;
                    Object object10 = primaryEntry.get("totalSamplesDuration");
                    object3 = object10 instanceof Double ? (Double)object10 : null;
                    double totalSamplesDuration = object3 == null ? 0.0 : (Double)object3;
                    v = primaryEntry.get("jitterBufferEmittedCount");
                    object10 = v instanceof BigInteger ? (BigInteger)v : null;
                    Object jitterBufferEmittedCount = object10 == null ? Integer.valueOf(0) : object10;
                    Object v5 = primaryEntry.get("jitterBufferDelay");
                    Double d4 = v5 instanceof Double ? (Double)v5 : null;
                    double jitterBufferDelay2 = d4 == null ? 0.0 : d4;
                    Object $this$getOrPut$iv = this.getSubscriberAudioSamplerMap();
                    boolean $i$f$getOrPut = false;
                    SubscribeAudioStatsSampler value$iv = $this$getOrPut$iv.get(trackID2);
                    if (value$iv == null) {
                        boolean bl = false;
                        SubscribeAudioStatsSampler answer$iv = new SubscribeAudioStatsSampler(this.getSubscribeStatsMaxSampleWindowSize(), trackID2, String.valueOf(ssrc));
                        $this$getOrPut$iv.put(trackID2, answer$iv);
                        subscribeAudioStatsSampler = answer$iv;
                    } else {
                        subscribeAudioStatsSampler = value$iv;
                    }
                    $this$getOrPut$iv = subscribeAudioStatsSampler;
                    SubscribeAudioStatsSampler $this$collectSubscribeStats_u24lambda_u2d4 = (SubscribeAudioStatsSampler)$this$getOrPut$iv;
                    boolean bl = false;
                    Object object11 = packetsReceived;
                    long l = Long.parseLong((String)object11);
                    object11 = packetsLost;
                    $this$collectSubscribeStats_u24lambda_u2d4.add(audioLevel, audioConcealedSamples, audioTotalSamplesReceived, (Number)audioConcealmentEvents, fecPacketsDiscarded, (Number)fecPacketsReceived, (float)totalSamplesDuration, l, Long.parseLong((String)object11), jitterBufferDelay2, (Number)jitterBufferEmittedCount);
                }
                if (Intrinsics.areEqual((Object)String.valueOf(entry2.getValue().getMembers().get("kind")), (Object)"video") && trackID2 != null) {
                    SubscribeVideoStatsSampler subscribeVideoStatsSampler2;
                    SubscribeVideoStatsSampler subscribeVideoStatsSampler3;
                    object2 = primaryEntry.get("framesReceived");
                    Integer bitrate = object2 instanceof Integer ? (Integer)object2 : null;
                    int framesReceived = bitrate == null ? 0 : bitrate;
                    packetsLost = primaryEntry.get("framesDropped");
                    Long packetsReceived = packetsLost instanceof Long ? (Long)packetsLost : null;
                    long framesDropped = packetsReceived == null ? 0L : packetsReceived;
                    object = primaryEntry.get("framesDecoded");
                    Long audioLevel = object instanceof Long ? (Long)object : null;
                    long framesDecoded = audioLevel == null ? 0L : audioLevel;
                    silentConcealedSamples = primaryEntry.get("pliCount");
                    concealedSamples = silentConcealedSamples instanceof Long ? (Long)silentConcealedSamples : null;
                    long pliCount = concealedSamples == null ? 0L : concealedSamples;
                    v2 = primaryEntry.get("nackCount");
                    Long audioConcealedSamples = v2 instanceof Long ? (Long)v2 : null;
                    long nackCount = audioConcealedSamples == null ? 0L : audioConcealedSamples;
                    object4 = primaryEntry.get("frameWidth");
                    audioTotalSamplesReceived = object4 instanceof Long ? (Long)object4 : null;
                    long frameWidth = audioTotalSamplesReceived == null ? 0L : audioTotalSamplesReceived;
                    fecPacketsReceived = primaryEntry.get("frameHeight");
                    fecPacketsDiscarded = fecPacketsReceived instanceof Long ? (Long)fecPacketsReceived : null;
                    long frameHeight = fecPacketsDiscarded == null ? 0L : fecPacketsDiscarded;
                    Object v6 = primaryEntry.get("jitterBufferEmittedCount");
                    fecPacketsReceived = v6 instanceof BigInteger ? (BigInteger)v6 : null;
                    Object jitterBufferEmittedCount = fecPacketsReceived == null ? Integer.valueOf(0) : fecPacketsReceived;
                    object3 = primaryEntry.get("jitterBufferDelay");
                    d = object3 instanceof Double ? (Double)object3 : null;
                    double jitterBufferDelay = d == null ? 0.0 : d;
                    v = primaryEntry.get("estimatedPlayoutTimestamp");
                    Double jitterBufferDelay2 = v instanceof Double ? (Double)v : null;
                    double estimatedPlayoutTimestamp = jitterBufferDelay2 == null ? 0.0 : jitterBufferDelay2;
                    Map<String, SubscribeVideoStatsSampler> $this$getOrPut$iv = this.getSubscriberVideoSamplerMap();
                    boolean $i$f$getOrPut = false;
                    SubscribeVideoStatsSampler value$iv = $this$getOrPut$iv.get(trackID2);
                    if (value$iv == null) {
                        boolean bl = false;
                        SubscribeVideoStatsSampler answer$iv = new SubscribeVideoStatsSampler(this.getSubscribeStatsMaxSampleWindowSize(), trackID2, String.valueOf(ssrc));
                        $this$getOrPut$iv.put(trackID2, answer$iv);
                        subscribeVideoStatsSampler3 = answer$iv;
                    } else {
                        subscribeVideoStatsSampler3 = value$iv;
                    }
                    SubscribeVideoStatsSampler $this$collectSubscribeStats_u24lambda_u2d6 = subscribeVideoStatsSampler2 = subscribeVideoStatsSampler3;
                    boolean bl = false;
                    $this$collectSubscribeStats_u24lambda_u2d6.add(framesReceived, framesDropped, framesDecoded, pliCount, nackCount, frameWidth, frameHeight, (Number)jitterBufferEmittedCount, jitterBufferDelay);
                    $this$collectSubscribeStats_u24lambda_u2d6.add(estimatedPlayoutTimestamp, (HMSPeer)this.getGetPeerFromVideoTrackID().invoke((Object)trackID2), (Function1<? super String, ? extends RTCStats>)((Function1)new Function1<String, RTCStats>(this, allSubscriberStats){
                        final /* synthetic */ StatsSamplingManager this$0;
                        final /* synthetic */ Map<String, RTCStats> $allSubscriberStats;
                        {
                            this.this$0 = $receiver;
                            this.$allSubscriberStats = $allSubscriberStats;
                            super(1);
                        }

                        @Nullable
                        public final RTCStats invoke(@NotNull String trackID) {
                            Intrinsics.checkNotNullParameter((Object)trackID, (String)"trackID");
                            return StatsSamplingManager.access$getCorrespondingAudioStats(this.this$0, trackID, this.$allSubscriberStats);
                        }
                    }));
                }
            }
            if (!Intrinsics.areEqual((Object)entry2.getValue().getType(), (Object)"track")) continue;
            primaryEntry = entry2.getValue().getMembers().get("trackIdentifier");
            String string = trackID = primaryEntry instanceof String ? (String)primaryEntry : null;
            if (!Intrinsics.areEqual((Object)String.valueOf(entry2.getValue().getMembers().get("kind")), (Object)"video") || trackID == null) continue;
            primaryEntry = entry2.getValue().getMembers();
            map = primaryEntry.get("pauseCount");
            Long framesReceived = map instanceof Long ? (Long)((Object)map) : null;
            long pauseCount = framesReceived == null ? 0L : framesReceived;
            Object v = primaryEntry.get("freezeCount");
            object2 = v instanceof Long ? (Long)v : null;
            long freezeCount = object2 == null ? 0L : (Long)object2;
            Object v7 = primaryEntry.get("totalPausesDuration");
            packetsLost = v7 instanceof Double ? (Double)v7 : null;
            double totalPausesDuration = packetsLost == null ? 0.0 : (Double)packetsLost;
            Object nackCount = primaryEntry.get("totalFreezesDuration");
            object = nackCount instanceof Double ? (Double)nackCount : null;
            double totalFreezesDuration = object == null ? 0.0 : (Double)object;
            Map<String, SubscribeVideoStatsSampler> $this$getOrPut$iv = this.getSubscriberVideoSamplerMap();
            boolean $i$f$getOrPut = false;
            SubscribeVideoStatsSampler value$iv = $this$getOrPut$iv.get(trackID);
            if (value$iv == null) {
                boolean bl = false;
                SubscribeVideoStatsSampler answer$iv = new SubscribeVideoStatsSampler(this.getSubscribeStatsMaxSampleWindowSize(), trackID, "");
                $this$getOrPut$iv.put(trackID, answer$iv);
                subscribeVideoStatsSampler = answer$iv;
            } else {
                subscribeVideoStatsSampler = value$iv;
            }
            object = subscribeVideoStatsSampler;
            SubscribeVideoStatsSampler $this$collectSubscribeStats_u24lambda_u2d8 = (SubscribeVideoStatsSampler)object;
            boolean bl = false;
            $this$collectSubscribeStats_u24lambda_u2d8.add(pauseCount, freezeCount, totalPausesDuration, totalFreezesDuration);
        }
        Map<String, SubscribeAudioStatsSampler> map = this.getSubscriberAudioSamplerMap();
        for (Map.Entry<String, Object> entry3 : map.entrySet()) {
            primaryEntry = entry3;
            key = primaryEntry.getKey();
            entry = entry3;
            audioSampler = (SubscribeAudioStatsSampler)entry.getValue();
            SubscribeAudioStatsSampler.shouldSample$default((SubscribeAudioStatsSampler)audioSampler, this.subscribeLastTimeStamp, false, 2, null);
        }
        Map<String, SubscribeVideoStatsSampler> map2 = this.getSubscriberVideoSamplerMap();
        for (Map.Entry<String, Object> entry4 : map2.entrySet()) {
            audioSampler = entry4;
            key = (String)audioSampler.getKey();
            entry = entry4;
            SubscribeVideoStatsSampler videoSampler = (SubscribeVideoStatsSampler)entry.getValue();
            SubscribeVideoStatsSampler.shouldSample$default(videoSampler, this.subscribeLastTimeStamp, false, 2, null);
        }
    }

    private final RTCStats getCorrespondingAudioStats(String audioTrackID, Map<String, RTCStats> allSubscriberStats) {
        Map<String, RTCStats> map = allSubscriberStats;
        for (Map.Entry<String, RTCStats> stats : map.entrySet()) {
            String currentTrackId;
            Object v = stats.getValue().getMembers().get("trackIdentifier");
            String string = currentTrackId = v instanceof String ? (String)v : null;
            if (!Intrinsics.areEqual((Object)stats.getValue().getType(), (Object)"inbound-rtp") || !Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"audio") || !Intrinsics.areEqual((Object)audioTrackID, (Object)currentTrackId)) continue;
            return stats.getValue();
        }
        return null;
    }

    public static final /* synthetic */ RTCStats access$getCorrespondingAudioStats(StatsSamplingManager $this, String audioTrackID, Map allSubscriberStats) {
        return $this.getCorrespondingAudioStats(audioTrackID, allSubscriberStats);
    }
}

