/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.error;

import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.audio.BluetoothErrorType;
import live.hms.video.error.HMSAction;
import live.hms.video.error.HMSException;
import live.hms.video.media.streams.models.PreferStateResponseError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\t\b\t\n\u000b\f\r\u000e\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\u0011"}, d2={"Llive/hms/video/error/ErrorFactory;", "", "()V", "BluetoothError", "Llive/hms/video/error/HMSException;", "bluetoothErrorType", "Llive/hms/video/audio/BluetoothErrorType;", "ReadPhoneStateError", "APIErrors", "Action", "AudioOutputErrors", "GenericErrors", "MediaPluginErrors", "TracksErrors", "WebSocketConnectionErrors", "WebrtcErrors", "WebsocketMethodErrors", "lib_release"})
public final class ErrorFactory {
    @NotNull
    public static final ErrorFactory INSTANCE = new ErrorFactory();

    private ErrorFactory() {
    }

    @JvmStatic
    @NotNull
    public static final HMSException ReadPhoneStateError() {
        return new HMSException(3016, "ReadPhoneStateError", Action.NONE.toString(), "Read phone state permission not granted", "READ_PHONE_STATE, a dangerous level permission, is required on Android 12 and above to enable devices to work", null, false, new HashMap(), 64, null);
    }

    @JvmStatic
    @NotNull
    public static final HMSException BluetoothError(@NotNull BluetoothErrorType bluetoothErrorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)bluetoothErrorType), (String)"bluetoothErrorType");
        int code = bluetoothErrorType == BluetoothErrorType.NO_BLUETOOTH_CONNECT_PERMISSION ? 3012 : 3013;
        return new HMSException(code, "Bluetooth Inaccessible", Action.NONE.toString(), bluetoothErrorType.getDescription(), bluetoothErrorType.getDescription(), null, false, new HashMap<String, Object>());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Llive/hms/video/error/ErrorFactory$Action;", "", "(Ljava/lang/String;I)V", "NONE", "TRACK", "INIT", "PUBLISH", "JOIN", "PREVIEW", "SUBSCRIBE", "GET_TOKEN", "GET_LAYOUT_CONFIG", "DATA_CHANNEL_SEND", "lib_release"})
    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action NONE = new Action();
        public static final /* enum */ Action TRACK = new Action();
        public static final /* enum */ Action INIT = new Action();
        public static final /* enum */ Action PUBLISH = new Action();
        public static final /* enum */ Action JOIN = new Action();
        public static final /* enum */ Action PREVIEW = new Action();
        public static final /* enum */ Action SUBSCRIBE = new Action();
        public static final /* enum */ Action GET_TOKEN = new Action();
        public static final /* enum */ Action GET_LAYOUT_CONFIG = new Action();
        public static final /* enum */ Action DATA_CHANNEL_SEND = new Action();
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        static {
            $VALUES = actionArray = new Action[]{Action.NONE, Action.TRACK, Action.INIT, Action.PUBLISH, Action.JOIN, Action.PREVIEW, Action.SUBSCRIBE, Action.GET_TOKEN, Action.GET_LAYOUT_CONFIG, Action.DATA_CHANNEL_SEND};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\r\u00a8\u0006\u000f"}, d2={"Llive/hms/video/error/ErrorFactory$WebSocketConnectionErrors;", "", "()V", "GenericConnect", "Llive/hms/video/error/HMSException;", "action", "Llive/hms/video/error/ErrorFactory$Action;", "description", "", "cause", "", "params", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "WebSocketConnectionLost", "lib_release"})
    public static final class WebSocketConnectionErrors {
        @NotNull
        public static final WebSocketConnectionErrors INSTANCE = new WebSocketConnectionErrors();

        private WebSocketConnectionErrors() {
        }

        @NotNull
        public final HMSException GenericConnect(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(1000, "GenericConnect", action.toString(), "Something went wrong", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException GenericConnect$default(WebSocketConnectionErrors webSocketConnectionErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return webSocketConnectionErrors.GenericConnect(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException WebSocketConnectionLost(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(1003, "WebSocketConnectionLost", action.toString(), "Network connection lost ", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException WebSocketConnectionLost$default(WebSocketConnectionErrors webSocketConnectionErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return webSocketConnectionErrors.WebSocketConnectionLost(action, string, throwable, hashMap);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJR\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\r\u00a8\u0006\u0015"}, d2={"Llive/hms/video/error/ErrorFactory$APIErrors;", "", "()V", "ConnectionLost", "Llive/hms/video/error/HMSException;", "action", "Llive/hms/video/error/ErrorFactory$Action;", "description", "", "cause", "", "params", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "EndpointUnreachable", "HTTPError", "code", "", "InvalidEndpointURL", "InvalidTokenFormat", "ServerErrors", "lib_release"})
    public static final class APIErrors {
        @NotNull
        public static final APIErrors INSTANCE = new APIErrors();

        private APIErrors() {
        }

        @NotNull
        public final HMSException ServerErrors(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(2000, "ServerErrors", action.toString(), "[INIT]: Server error", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException ServerErrors$default(APIErrors aPIErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return aPIErrors.ServerErrors(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException ConnectionLost(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(2001, "ConnectionLost", action.toString(), "[INIT]: Network error", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException ConnectionLost$default(APIErrors aPIErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return aPIErrors.ConnectionLost(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException HTTPError(int code, @NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(code, "HTTPError", action.toString(), "Bad Request", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException HTTPError$default(APIErrors aPIErrors, int n, Action action, String string, Throwable throwable, HashMap hashMap, int n2, Object object) {
            if ((n2 & 4) != 0) {
                string = "";
            }
            if ((n2 & 8) != 0) {
                throwable = null;
            }
            if ((n2 & 0x10) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return aPIErrors.HTTPError(n, action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException InvalidEndpointURL(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(2002, "InvalidEndpointURL", action.toString(), "Endpoint URL is invalid", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException InvalidEndpointURL$default(APIErrors aPIErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return aPIErrors.InvalidEndpointURL(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException EndpointUnreachable(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(2003, "EndpointUnreachable", action.toString(), "Endpoint is not reachable.", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException EndpointUnreachable$default(APIErrors aPIErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return aPIErrors.EndpointUnreachable(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException InvalidTokenFormat(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(2004, "InvalidTokenFormat", action.toString(), "Token is not in proper JWT format", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException InvalidTokenFormat$default(APIErrors aPIErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return aPIErrors.InvalidTokenFormat(action, string, throwable, hashMap);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\\\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2$\b\u0002\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\u0010J\\\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2$\b\u0002\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\u0010JJ\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2$\b\u0002\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\u0010JT\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2$\b\u0002\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\u00102\b\b\u0002\u0010\n\u001a\u00020\u000bJJ\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2$\b\u0002\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\u0010JJ\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2$\b\u0002\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\u0010JJ\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2$\b\u0002\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\u0010JJ\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2$\b\u0002\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\u0010J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u001d\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u001e"}, d2={"Llive/hms/video/error/ErrorFactory$TracksErrors;", "", "()V", "CantAccessCaptureDevice", "Llive/hms/video/error/HMSException;", "action", "Llive/hms/video/error/ErrorFactory$Action;", "deviceInfo", "", "description", "isTerminal", "", "cause", "", "params", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "CantFindCameraIdForParticularFace", "face", "CodecChangeNotPermitted", "GenericTrack", "InvalidVideoSettings", "MicCaptureFailed", "NothingToReturn", "PeerConnectionFactoryDisposed", "PreferLayerFailed", "preferStateResponseError", "Llive/hms/video/media/streams/models/PreferStateResponseError;", "PreferLayerFailedUnknownError", "PreferLayerTimeoutError", "lib_release"})
    public static final class TracksErrors {
        @NotNull
        public static final TracksErrors INSTANCE = new TracksErrors();

        private TracksErrors() {
        }

        @NotNull
        public final HMSException GenericTrack(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params, boolean isTerminal) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = action.toString();
            return new HMSException(3000, "GenericTrack", string, "[PUBLISH]: Something went wrong", description, cause, isTerminal, params);
        }

        public static /* synthetic */ HMSException GenericTrack$default(TracksErrors tracksErrors, Action action, String string, Throwable throwable, HashMap hashMap, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            if ((n & 0x10) != 0) {
                bl = true;
            }
            return tracksErrors.GenericTrack(action, string, throwable, hashMap, bl);
        }

        @NotNull
        public final HMSException CantAccessCaptureDevice(@NotNull Action action, @NotNull String deviceInfo, @NotNull String description, boolean isTerminal, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(3001, "CantAccessCaptureDevice", action.toString(), StringsKt.replace$default((String)"[PUBLISH]: No permission to access capture device - {device_type}", (String)"{device_type}", (String)deviceInfo, (boolean)false, (int)4, null), description, cause, isTerminal, params);
        }

        public static /* synthetic */ HMSException CantAccessCaptureDevice$default(TracksErrors tracksErrors, Action action, String string, String string2, boolean bl, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = "";
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                throwable = null;
            }
            if ((n & 0x20) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return tracksErrors.CantAccessCaptureDevice(action, string, string2, bl, throwable, hashMap);
        }

        @NotNull
        public final HMSException CantFindCameraIdForParticularFace(@NotNull Action action, @NotNull String face, @NotNull String description, boolean isTerminal, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)face, (String)"face");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(3002, "CantFindCameraIdForParticularFace", action.toString(), "Couldn't find " + face + " facing camera. Please restart your device", description, cause, isTerminal, params);
        }

        public static /* synthetic */ HMSException CantFindCameraIdForParticularFace$default(TracksErrors tracksErrors, Action action, String string, String string2, boolean bl, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = "";
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                throwable = null;
            }
            if ((n & 0x20) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return tracksErrors.CantFindCameraIdForParticularFace(action, string, string2, bl, throwable, hashMap);
        }

        @NotNull
        public final HMSException PeerConnectionFactoryDisposed(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(3004, "PeerConnectionFactoryDisposed", action.toString(), "[PUBLISH]: Peer Connection Factory Disposed", description, cause, false, params);
        }

        public static /* synthetic */ HMSException PeerConnectionFactoryDisposed$default(TracksErrors tracksErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return tracksErrors.PeerConnectionFactoryDisposed(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException NothingToReturn(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(3005, "NothingToReturn", action.toString(), "There is no media to return. Please select either video or audio or both.", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException NothingToReturn$default(TracksErrors tracksErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return tracksErrors.NothingToReturn(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException InvalidVideoSettings(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(3006, "InvalidVideoSettings", action.toString(), "Cannot enable simulcast when no video settings are provided", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException InvalidVideoSettings$default(TracksErrors tracksErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return tracksErrors.InvalidVideoSettings(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException CodecChangeNotPermitted(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(3007, "CodecChangeNotPermitted", action.toString(), "Codec can't be changed mid call.", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException CodecChangeNotPermitted$default(TracksErrors tracksErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return tracksErrors.CodecChangeNotPermitted(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException MicCaptureFailed(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(3011, "Mic Capture Failed", action.toString(), "Mic Capture Failed", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException MicCaptureFailed$default(TracksErrors tracksErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return tracksErrors.MicCaptureFailed(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException PreferLayerFailed(@NotNull PreferStateResponseError preferStateResponseError, @NotNull Action action) {
            Intrinsics.checkNotNullParameter((Object)preferStateResponseError, (String)"preferStateResponseError");
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            String string = action.toString();
            Object object = preferStateResponseError.getCode();
            int n = object == null ? 0 : (Integer)object;
            String string2 = preferStateResponseError.getMessage();
            object = string2 == null ? "" : string2;
            string2 = Intrinsics.stringPlus((String)"Prefer layer change failed. Data: ", (Object)preferStateResponseError.getData());
            return new HMSException(n, "Prefer Layer failed", string, (String)object, string2, null, false, null, 224, null);
        }

        public static /* synthetic */ HMSException PreferLayerFailed$default(TracksErrors tracksErrors, PreferStateResponseError preferStateResponseError, Action action, int n, Object object) {
            if ((n & 2) != 0) {
                action = Action.NONE;
            }
            return tracksErrors.PreferLayerFailed(preferStateResponseError, action);
        }

        @NotNull
        public final HMSException PreferLayerFailedUnknownError(@NotNull Action action) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            String string = action.toString();
            return new HMSException(3014, "Prefer Layer failed", string, "Unknown prefer layer error", "Unknown error for prefer layer", null, false, null, 224, null);
        }

        public static /* synthetic */ HMSException PreferLayerFailedUnknownError$default(TracksErrors tracksErrors, Action action, int n, Object object) {
            if ((n & 1) != 0) {
                action = Action.NONE;
            }
            return tracksErrors.PreferLayerFailedUnknownError(action);
        }

        @NotNull
        public final HMSException PreferLayerTimeoutError(@NotNull Action action) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            String string = action.toString();
            return new HMSException(3015, "Prefer Layer failed", string, "Prefer layer timed out", "The server did not acknowledge the request to change the preferred layer.", null, false, null, 224, null);
        }

        public static /* synthetic */ HMSException PreferLayerTimeoutError$default(TracksErrors tracksErrors, Action action, int n, Object object) {
            if ((n & 1) != 0) {
                action = Action.NONE;
            }
            return tracksErrors.PreferLayerTimeoutError(action);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\r\u00a8\u0006\u0012"}, d2={"Llive/hms/video/error/ErrorFactory$WebrtcErrors;", "", "()V", "CreateAnswerFailed", "Llive/hms/video/error/HMSException;", "action", "Llive/hms/video/error/ErrorFactory$Action;", "description", "", "cause", "", "params", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "CreateOfferFailed", "ICEFailure", "SetLocalDescriptionFailed", "SetRemoteDescriptionFailed", "lib_release"})
    public static final class WebrtcErrors {
        @NotNull
        public static final WebrtcErrors INSTANCE = new WebrtcErrors();

        private WebrtcErrors() {
        }

        @NotNull
        public final HMSException CreateOfferFailed(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(4001, "CreateOfferFailed", action.toString(), StringsKt.replace$default((String)"[{action}]: Failed to create offer. ", (String)"{action}", (String)action.toString(), (boolean)false, (int)4, null), description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException CreateOfferFailed$default(WebrtcErrors webrtcErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return webrtcErrors.CreateOfferFailed(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException CreateAnswerFailed(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(4002, "CreateAnswerFailed", action.toString(), StringsKt.replace$default((String)"[{action}]: Failed to create answer. ", (String)"{action}", (String)action.toString(), (boolean)false, (int)4, null), description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException CreateAnswerFailed$default(WebrtcErrors webrtcErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return webrtcErrors.CreateAnswerFailed(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException SetLocalDescriptionFailed(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(4003, "SetLocalDescriptionFailed", action.toString(), StringsKt.replace$default((String)"[{action}]: Failed to set offer. ", (String)"{action}", (String)action.toString(), (boolean)false, (int)4, null), description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException SetLocalDescriptionFailed$default(WebrtcErrors webrtcErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return webrtcErrors.SetLocalDescriptionFailed(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException SetRemoteDescriptionFailed(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(4004, "SetRemoteDescriptionFailed", action.toString(), StringsKt.replace$default((String)"[{action}]: Failed to set answer. ", (String)"{action}", (String)action.toString(), (boolean)false, (int)4, null), description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException SetRemoteDescriptionFailed$default(WebrtcErrors webrtcErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return webrtcErrors.SetRemoteDescriptionFailed(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException ICEFailure(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(4005, "ICEFailure", action.toString(), StringsKt.replace$default((String)"[{action}]: Ice connection state FAILED", (String)"{action}", (String)action.toString(), (boolean)false, (int)4, null), description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException ICEFailure$default(WebrtcErrors webrtcErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return webrtcErrors.ICEFailure(action, string, throwable, hashMap);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJP\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\r\u00a8\u0006\u0012"}, d2={"Llive/hms/video/error/ErrorFactory$WebsocketMethodErrors;", "", "()V", "AlreadyJoined", "Llive/hms/video/error/HMSException;", "action", "Llive/hms/video/error/ErrorFactory$Action;", "description", "", "cause", "", "params", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "PreviewAlreadyStarted", "ServerErrors", "code", "", "lib_release"})
    public static final class WebsocketMethodErrors {
        @NotNull
        public static final WebsocketMethodErrors INSTANCE = new WebsocketMethodErrors();

        private WebsocketMethodErrors() {
        }

        @NotNull
        public final HMSException ServerErrors(int code, @NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(code, "ServerErrors", action.toString(), StringsKt.replace$default((String)("" + '[' + (Object)((Object)action) + "]: {server_error}"), (String)"{server_error}", (String)description, (boolean)false, (int)4, null), description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException ServerErrors$default(WebsocketMethodErrors websocketMethodErrors, int n, Action action, String string, Throwable throwable, HashMap hashMap, int n2, Object object) {
            if ((n2 & 8) != 0) {
                throwable = null;
            }
            if ((n2 & 0x10) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return websocketMethodErrors.ServerErrors(n, action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException AlreadyJoined(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(5001, "AlreadyJoined", action.toString(), "[JOIN]: You have already joined this room.", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException AlreadyJoined$default(WebsocketMethodErrors websocketMethodErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return websocketMethodErrors.AlreadyJoined(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException PreviewAlreadyStarted(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            String string = action.toString();
            return new HMSException(5002, "PreviewAlreadyStarted", string, "[PREVIEW]: Preview has already been started for this room.", "[PREVIEW]: Preview has already been started for this room.", cause, false, params);
        }

        public static /* synthetic */ HMSException PreviewAlreadyStarted$default(WebsocketMethodErrors websocketMethodErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return websocketMethodErrors.PreviewAlreadyStarted(action, string, throwable, hashMap);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJL\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJR\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJL\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJL\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJH\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJJ\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\rJH\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\r\u00a8\u0006\u001b"}, d2={"Llive/hms/video/error/ErrorFactory$GenericErrors;", "", "()V", "APINotSupported", "Llive/hms/video/error/HMSException;", "action", "Llive/hms/video/error/ErrorFactory$Action;", "description", "", "cause", "", "params", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "CannotSendMessage", "InvalidResolutionForRtmpStreaming", "JsonParsingFailed", "jsonMessage", "NotConnected", "NotReady", "PeerMetadataMissing", "PollNotFound", "PollQuestionIterationFailure", "RTCTrackMissing", "Signalling", "TrackMetadataMissing", "Unknown", "lib_release"})
    public static final class GenericErrors {
        @NotNull
        public static final GenericErrors INSTANCE = new GenericErrors();

        private GenericErrors() {
        }

        @NotNull
        public final HMSException NotConnected(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6000, "NotConnected", action.toString(), "Client is not connected", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException NotConnected$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.NotConnected(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException Signalling(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6001, "Signalling", action.toString(), StringsKt.replace$default((String)StringsKt.replace$default((String)"Unknown signalling error: {action} {error_info} ", (String)"{action}", (String)action.toString(), (boolean)false, (int)4, null), (String)"{error_info}", (String)description, (boolean)false, (int)4, null), description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException Signalling$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.Signalling(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException Unknown(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6002, "Unknown", action.toString(), StringsKt.replace$default((String)"Unknown exception: {error_info}", (String)"{error_info}", (String)description, (boolean)false, (int)4, null), description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException Unknown$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.Unknown(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException NotReady(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6003, "NotReady", action.toString(), "WebRTC engine is not ready yet", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException NotReady$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.NotReady(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException JsonParsingFailed(@NotNull Action action, @NotNull String jsonMessage, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)jsonMessage, (String)"jsonMessage");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6004, "JsonParsingFailed", action.toString(), StringsKt.replace$default((String)"Failed to parse JSON message - {json_message}", (String)"{json_message}", (String)jsonMessage, (boolean)false, (int)4, null), description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException JsonParsingFailed$default(GenericErrors genericErrors, Action action, String string, String string2, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = "";
            }
            if ((n & 8) != 0) {
                throwable = null;
            }
            if ((n & 0x10) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.JsonParsingFailed(action, string, string2, throwable, hashMap);
        }

        @NotNull
        public final HMSException TrackMetadataMissing(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6005, "TrackMetadataMissing", action.toString(), "Track Metadata Missing", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException TrackMetadataMissing$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.TrackMetadataMissing(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException RTCTrackMissing(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6006, "RTCTrackMissing", action.toString(), "RTC Track missing", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException RTCTrackMissing$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.RTCTrackMissing(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException PeerMetadataMissing(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6007, "PeerMetadataMissing", action.toString(), "Peer Metadata Missing", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException PeerMetadataMissing$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.PeerMetadataMissing(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException CannotSendMessage(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6008, "CannotSendMessage", action.toString(), "Client is not connected", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException CannotSendMessage$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 1) != 0) {
                action = Action.NONE;
            }
            if ((n & 2) != 0) {
                string = "Cannot send message. Peer is null. The sdk must be disconnected from a room.";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.CannotSendMessage(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException InvalidResolutionForRtmpStreaming(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6009, "InvalidRtmpStreamResolution", action.toString(), "Invalid resolution for rtmp streaming. Valid values are between 480, 1280. Width and height both cannot be over 720 at the same time.", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException InvalidResolutionForRtmpStreaming$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 1) != 0) {
                action = Action.NONE;
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.InvalidResolutionForRtmpStreaming(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException APINotSupported(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6010, "APINotSupported", action.toString(), "This API is not support on the current Android Version", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException APINotSupported$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 1) != 0) {
                action = Action.NONE;
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.APINotSupported(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException PollQuestionIterationFailure(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6011, "Poll Question Iteration Failure", action.toString(), "Client is not connected", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException PollQuestionIterationFailure$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 1) != 0) {
                action = Action.NONE;
            }
            if ((n & 2) != 0) {
                string = "Poll question iteration failure";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.PollQuestionIterationFailure(action, string, throwable, hashMap);
        }

        @NotNull
        public final HMSException PollNotFound(@NotNull Action action, @NotNull String description, @Nullable Throwable cause, @NotNull HashMap<String, Object> params) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            return new HMSException(6012, "Poll Question Iteration Failure", action.toString(), "Client is not connected", description, cause, false, params, 64, null);
        }

        public static /* synthetic */ HMSException PollNotFound$default(GenericErrors genericErrors, Action action, String string, Throwable throwable, HashMap hashMap, int n, Object object) {
            if ((n & 1) != 0) {
                action = Action.NONE;
            }
            if ((n & 2) != 0) {
                string = "Poll not found";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                hashMap = new HashMap<String, Object>();
            }
            return genericErrors.PollNotFound(action, string, throwable, hashMap);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Llive/hms/video/error/ErrorFactory$MediaPluginErrors;", "", "()V", "AddAlreadyInProgress", "Llive/hms/video/error/HMSException;", "action", "Llive/hms/video/error/HMSAction;", "description", "", "InitFailed", "PlatformNotSupported", "ProcessingFailed", "lib_release"})
    public static final class MediaPluginErrors {
        @NotNull
        public static final MediaPluginErrors INSTANCE = new MediaPluginErrors();

        private MediaPluginErrors() {
        }

        @NotNull
        public final HMSException PlatformNotSupported(@NotNull HMSAction action, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new HMSException(7001, "PlatformNotSupported", action.toString(), "Check HMS Docs to see the list of supported platforms", description, null, false, null, 224, null);
        }

        public static /* synthetic */ HMSException PlatformNotSupported$default(MediaPluginErrors mediaPluginErrors, HMSAction hMSAction, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            return mediaPluginErrors.PlatformNotSupported(hMSAction, string);
        }

        @NotNull
        public final HMSException InitFailed(@NotNull HMSAction action, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new HMSException(7002, "InitFailed", action.toString(), "Plugin init failed", description, null, false, null, 224, null);
        }

        public static /* synthetic */ HMSException InitFailed$default(MediaPluginErrors mediaPluginErrors, HMSAction hMSAction, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            return mediaPluginErrors.InitFailed(hMSAction, string);
        }

        @NotNull
        public final HMSException ProcessingFailed(@NotNull HMSAction action, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new HMSException(7003, "ProcessingFailed", action.toString(), "Plugin processing failed", description, null, false, null, 224, null);
        }

        public static /* synthetic */ HMSException ProcessingFailed$default(MediaPluginErrors mediaPluginErrors, HMSAction hMSAction, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            return mediaPluginErrors.ProcessingFailed(hMSAction, string);
        }

        @NotNull
        public final HMSException AddAlreadyInProgress(@NotNull HMSAction action, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new HMSException(7004, "AddAlreadyInProgress", action.toString(), "Plugin add already in progress", description, null, false, null, 224, null);
        }

        public static /* synthetic */ HMSException AddAlreadyInProgress$default(MediaPluginErrors mediaPluginErrors, HMSAction hMSAction, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            return mediaPluginErrors.AddAlreadyInProgress(hMSAction, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Llive/hms/video/error/ErrorFactory$AudioOutputErrors;", "", "()V", "bluetoothScoInitFailure", "Llive/hms/video/error/HMSException;", "lib_release"})
    public static final class AudioOutputErrors {
        @NotNull
        public static final AudioOutputErrors INSTANCE = new AudioOutputErrors();

        private AudioOutputErrors() {
        }

        @NotNull
        public final HMSException bluetoothScoInitFailure() {
            return new HMSException(7005, "BluetoothScoInitFailed", HMSAction.AUDIO_OUTPUT.toString(), "Bluetooth Connection Init Failed", "bluetooth headset is not available or in a processing state", new Throwable("Bluetooth Connection Init Failed"), false, new HashMap<String, Object>());
        }
    }
}

