/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection.stats.clientside.sampler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.degredation.QualityLimitationReasons;
import live.hms.video.connection.stats.clientside.model.QualityLimitation;
import live.hms.video.connection.stats.clientside.model.Size;
import live.hms.video.connection.stats.clientside.model.VideoAnalytics;
import live.hms.video.connection.stats.clientside.model.VideoSamplesPublish;
import live.hms.video.connection.stats.clientside.sampler.VideoStatsSampler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u001e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00182\u0006\u0010@\u001a\u00020\u0003J_\u0010<\u001a\u00020=2\b\u0010A\u001a\u0004\u0018\u00010\u00182\b\u0010B\u001a\u0004\u0018\u00010\u00182\u0006\u0010)\u001a\u00020*2\u0006\u0010C\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u0003\u00a2\u0006\u0002\u0010FJ\u0006\u0010G\u001a\u00020=J\u0010\u0010H\u001a\u00020I2\b\b\u0002\u0010J\u001a\u00020KJ\u0006\u0010L\u001a\u00020KJ\b\u0010M\u001a\u00020=H\u0002J\u0006\u0010N\u001a\u00020=J\u0018\u0010O\u001a\u00020K2\u0006\u0010P\u001a\u00020\u00032\b\b\u0002\u0010Q\u001a\u00020KJ\u0010\u0010R\u001a\u00020K2\u0006\u0010P\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b!\u0010\u0014R\u001a\u0010$\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00100R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00100R\u001a\u00105\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u000b\"\u0004\b7\u0010\u000fR\u001a\u00108\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010&\"\u0004\b:\u0010(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u00100\u00a8\u0006S"}, d2={"Llive/hms/video/connection/stats/clientside/sampler/VideoStatsSampler;", "", "SAMPLE_DURATION", "", "trackId", "", "rid", "ssrc", "source", "(DLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSAMPLE_DURATION", "()D", "START_VIDEO_SAMPLE_DURATION", "getSTART_VIDEO_SAMPLE_DURATION", "setSTART_VIDEO_SAMPLE_DURATION", "(D)V", "avgAvailableOutgoingBitrateBps", "", "", "getAvgAvailableOutgoingBitrateBps", "()Ljava/util/List;", "avgBitrateBps", "getAvgBitrateBps", "fps", "", "getFps", "jitterMs", "getJitterMs", "lastKnownHeight", "Ljava/lang/Integer;", "lastKnownWidth", "localVideoSamples", "Llive/hms/video/connection/stats/clientside/model/VideoSamplesPublish;", "getLocalVideoSamples", "localVideoSamples$delegate", "Lkotlin/Lazy;", "packetsSent", "getPacketsSent", "()J", "setPacketsSent", "(J)V", "qualityReasons", "Llive/hms/video/connection/degredation/QualityLimitationReasons;", "getQualityReasons", "()Llive/hms/video/connection/degredation/QualityLimitationReasons;", "setQualityReasons", "(Llive/hms/video/connection/degredation/QualityLimitationReasons;)V", "getRid", "()Ljava/lang/String;", "roundTripTimeMs", "getRoundTripTimeMs", "getSource", "getSsrc", "totalPacketSendDelay", "getTotalPacketSendDelay", "setTotalPacketSendDelay", "totalPacketsLost", "getTotalPacketsLost", "setTotalPacketsLost", "getTrackId", "add", "", "jitter", "packetLoss", "roundTripTime", "width", "height", "availableOutgoingBitrate", "bitRate", "timestamp", "(Ljava/lang/Integer;Ljava/lang/Integer;Llive/hms/video/connection/degredation/QualityLimitationReasons;DILjava/lang/String;DDJD)V", "clearCurrentSampledStats", "getCollectedSamples", "Llive/hms/video/connection/stats/clientside/model/VideoAnalytics;", "force", "", "hasSample", "reset", "resetSamples", "shouldSample", "currentTimeStamp", "isForceSample", "shouldSampleVideo", "lib_release"})
public final class VideoStatsSampler {
    private final double SAMPLE_DURATION;
    @NotNull
    private final String trackId;
    @Nullable
    private final String rid;
    @NotNull
    private final String ssrc;
    @NotNull
    private final String source;
    @NotNull
    private final Lazy localVideoSamples$delegate;
    @Nullable
    private Integer lastKnownWidth;
    @Nullable
    private Integer lastKnownHeight;
    @NotNull
    private final List<Long> roundTripTimeMs;
    @NotNull
    private final List<Double> jitterMs;
    private long totalPacketsLost;
    private double totalPacketSendDelay;
    private long packetsSent;
    @NotNull
    private final List<Long> avgBitrateBps;
    @NotNull
    private final List<Integer> fps;
    @NotNull
    private final List<Long> avgAvailableOutgoingBitrateBps;
    @Nullable
    private QualityLimitationReasons qualityReasons;
    private double START_VIDEO_SAMPLE_DURATION;

    public VideoStatsSampler(double SAMPLE_DURATION, @NotNull String trackId, @Nullable String rid, @NotNull String ssrc, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        Intrinsics.checkNotNullParameter((Object)ssrc, (String)"ssrc");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.SAMPLE_DURATION = SAMPLE_DURATION;
        this.trackId = trackId;
        this.rid = rid;
        this.ssrc = ssrc;
        this.source = source;
        this.localVideoSamples$delegate = LazyKt.lazy((Function0)localVideoSamples.2.INSTANCE);
        this.roundTripTimeMs = new ArrayList();
        this.jitterMs = new ArrayList();
        this.avgBitrateBps = new ArrayList();
        this.fps = new ArrayList();
        this.avgAvailableOutgoingBitrateBps = new ArrayList();
        this.START_VIDEO_SAMPLE_DURATION = -1.0;
    }

    public /* synthetic */ VideoStatsSampler(double d, String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string4 = "regular";
        }
        this(d, string, string2, string3, string4);
    }

    public final double getSAMPLE_DURATION() {
        return this.SAMPLE_DURATION;
    }

    @NotNull
    public final String getTrackId() {
        return this.trackId;
    }

    @Nullable
    public final String getRid() {
        return this.rid;
    }

    @NotNull
    public final String getSsrc() {
        return this.ssrc;
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    private final List<VideoSamplesPublish> getLocalVideoSamples() {
        Lazy lazy = this.localVideoSamples$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<Long> getRoundTripTimeMs() {
        return this.roundTripTimeMs;
    }

    @NotNull
    public final List<Double> getJitterMs() {
        return this.jitterMs;
    }

    public final long getTotalPacketsLost() {
        return this.totalPacketsLost;
    }

    public final void setTotalPacketsLost(long l) {
        this.totalPacketsLost = l;
    }

    public final double getTotalPacketSendDelay() {
        return this.totalPacketSendDelay;
    }

    public final void setTotalPacketSendDelay(double d) {
        this.totalPacketSendDelay = d;
    }

    public final long getPacketsSent() {
        return this.packetsSent;
    }

    public final void setPacketsSent(long l) {
        this.packetsSent = l;
    }

    @NotNull
    public final List<Long> getAvgBitrateBps() {
        return this.avgBitrateBps;
    }

    @NotNull
    public final List<Integer> getFps() {
        return this.fps;
    }

    @NotNull
    public final List<Long> getAvgAvailableOutgoingBitrateBps() {
        return this.avgAvailableOutgoingBitrateBps;
    }

    @Nullable
    public final QualityLimitationReasons getQualityReasons() {
        return this.qualityReasons;
    }

    public final void setQualityReasons(@Nullable QualityLimitationReasons qualityLimitationReasons) {
        this.qualityReasons = qualityLimitationReasons;
    }

    public final double getSTART_VIDEO_SAMPLE_DURATION() {
        return this.START_VIDEO_SAMPLE_DURATION;
    }

    public final void setSTART_VIDEO_SAMPLE_DURATION(double d) {
        this.START_VIDEO_SAMPLE_DURATION = d;
    }

    public final boolean shouldSample(double currentTimeStamp, boolean isForceSample) {
        if (isForceSample || this.shouldSampleVideo(currentTimeStamp)) {
            float f;
            Number number;
            VideoStatsSampler videoStatsSampler = this;
            Collection collection = videoStatsSampler.getLocalVideoSamples();
            long l = (long)currentTimeStamp;
            int n = this.roundTripTimeMs.isEmpty() ? 0 : (int)CollectionsKt.averageOfLong((Iterable)this.roundTripTimeMs);
            long l2 = this.avgAvailableOutgoingBitrateBps.isEmpty() ? 0L : (long)CollectionsKt.averageOfLong((Iterable)this.avgAvailableOutgoingBitrateBps);
            long l3 = this.avgBitrateBps.isEmpty() ? 0L : (long)CollectionsKt.averageOfLong((Iterable)this.avgBitrateBps);
            float f2 = this.jitterMs.isEmpty() ? 0.0f : (float)CollectionsKt.averageOfDouble((Iterable)this.jitterMs);
            long l4 = this.totalPacketsLost;
            int n2 = this.fps.isEmpty() ? 0 : (int)CollectionsKt.averageOfInt((Iterable)this.fps);
            Object object = this.qualityReasons;
            float f3 = object == null ? 0.0f : ((number = ((QualityLimitationReasons)object).getBandWidth()) == null ? 0.0f : (f = (float)((Double)number).doubleValue()));
            object = this.qualityReasons;
            QualityLimitation qualityLimitation = new QualityLimitation(f3, object == null ? 0.0f : ((number = ((QualityLimitationReasons)object).getCpu()) == null ? 0.0f : (f = (float)((Double)number).doubleValue())));
            number = this.lastKnownWidth;
            int n3 = number == null ? 0 : (Integer)number;
            number = this.lastKnownHeight;
            object = new Size(n3, number == null ? 0 : (Integer)number);
            long l5 = this.packetsSent;
            double d = this.totalPacketSendDelay;
            VideoSamplesPublish videoSamplesPublish = new VideoSamplesPublish(qualityLimitation, n2, (Size)object, l, n, f2, l4, l3, l2, d, l5);
            collection.add(videoSamplesPublish);
            this.reset();
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean shouldSample$default(VideoStatsSampler videoStatsSampler, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return videoStatsSampler.shouldSample(d, bl);
    }

    public final void add(@Nullable Integer width, @Nullable Integer height, @NotNull QualityLimitationReasons qualityReasons, double availableOutgoingBitrate, int fps, @NotNull String trackId, double bitRate, double totalPacketSendDelay, long packetsSent, double timestamp) {
        Intrinsics.checkNotNullParameter((Object)qualityReasons, (String)"qualityReasons");
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        if (this.lastKnownWidth != null && this.lastKnownHeight != null && !Intrinsics.areEqual((Object)this.lastKnownWidth, (Object)width) && !Intrinsics.areEqual((Object)this.lastKnownHeight, (Object)height)) {
            this.lastKnownWidth = width;
            this.lastKnownHeight = height;
            double d = timestamp;
            this.shouldSample(d, true);
        } else {
            this.lastKnownWidth = width;
            this.lastKnownHeight = height;
            VideoStatsSampler videoStatsSampler = this;
            Collection collection = videoStatsSampler.avgAvailableOutgoingBitrateBps;
            Number number = (long)availableOutgoingBitrate;
            collection.add(number);
            this.qualityReasons = qualityReasons;
            videoStatsSampler = this;
            collection = videoStatsSampler.fps;
            number = fps;
            collection.add(number);
            videoStatsSampler = this;
            collection = videoStatsSampler.avgBitrateBps;
            number = (long)bitRate * 1000L;
            collection.add(number);
        }
        this.packetsSent = packetsSent;
        this.totalPacketSendDelay = totalPacketSendDelay;
    }

    public final void add(double jitter, int packetLoss, double roundTripTime) {
        this.totalPacketsLost = packetLoss;
        VideoStatsSampler videoStatsSampler = this;
        Collection collection = videoStatsSampler.jitterMs;
        Number number = jitter * 1000.0;
        collection.add(number);
        videoStatsSampler = this;
        collection = videoStatsSampler.roundTripTimeMs;
        number = (long)(roundTripTime * 1000.0);
        collection.add(number);
    }

    private final void reset() {
        this.START_VIDEO_SAMPLE_DURATION = 0.0;
        this.roundTripTimeMs.clear();
        this.avgAvailableOutgoingBitrateBps.clear();
        this.fps.clear();
        this.jitterMs.clear();
        this.totalPacketsLost = 0L;
        this.avgBitrateBps.clear();
    }

    private final boolean shouldSampleVideo(double currentTimeStamp) {
        if (this.START_VIDEO_SAMPLE_DURATION <= 0.0) {
            this.START_VIDEO_SAMPLE_DURATION = currentTimeStamp;
            return false;
        }
        if (currentTimeStamp - this.START_VIDEO_SAMPLE_DURATION >= this.SAMPLE_DURATION) {
            this.START_VIDEO_SAMPLE_DURATION = currentTimeStamp;
            return true;
        }
        return false;
    }

    public final boolean hasSample() {
        return !this.getLocalVideoSamples().isEmpty();
    }

    @NotNull
    public final VideoAnalytics getCollectedSamples(boolean force) {
        if (force) {
            this.shouldSample(System.currentTimeMillis(), true);
        }
        List local = new ArrayList();
        Iterable $this$forEach$iv = this.getLocalVideoSamples();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VideoSamplesPublish it = (VideoSamplesPublish)element$iv;
            boolean bl = false;
            local.add(VideoSamplesPublish.copy$default(it, null, 0, null, 0L, 0, 0.0f, 0L, 0L, 0L, 0.0, 0L, 2047, null));
        }
        String string = this.rid;
        String string2 = this.trackId;
        String string3 = this.ssrc;
        String string4 = this.source;
        return new VideoAnalytics(string, local, string2, string3, string4);
    }

    public static /* synthetic */ VideoAnalytics getCollectedSamples$default(VideoStatsSampler videoStatsSampler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return videoStatsSampler.getCollectedSamples(bl);
    }

    public final void resetSamples() {
        this.getLocalVideoSamples().clear();
    }

    public final void clearCurrentSampledStats() {
        this.resetSamples();
        this.reset();
    }
}

