/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection.stats.clientside.manager;

import android.content.Context;
import android.util.Log;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.degredation.QualityLimitationReasons;
import live.hms.video.connection.stats.BitrateCalculator;
import live.hms.video.connection.stats.clientside.manager.StatsSamplingManager;
import live.hms.video.connection.stats.clientside.model.AudioAnalytics;
import live.hms.video.connection.stats.clientside.model.PublishAnalyticPayload;
import live.hms.video.connection.stats.clientside.model.VideoAnalytics;
import live.hms.video.connection.stats.clientside.sampler.LocalAudioStatsSampler;
import live.hms.video.connection.stats.clientside.sampler.SubscribeAudioStatsSample;
import live.hms.video.connection.stats.clientside.sampler.VideoStatsSampler;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.signal.init.Stats;
import live.hms.video.utils.HMSUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.RTCStats;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010T\u001a\u00020U2\u0012\u0010V\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020W0/J\u001a\u0010X\u001a\u00020U2\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020W0/J\u001e\u0010Z\u001a\u0004\u0018\u00010W2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020W0\\H\u0002J2\u0010]\u001a\u0004\u0018\u00010W2\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020W0_2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020W0/H\u0002J*\u0010a\u001a\u00020U2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010b\u001a\u0004\u0018\u00010c2\u0006\u0010d\u001a\u00020\u001e2\b\u0010e\u001a\u0004\u0018\u00010cJ\u0010\u0010f\u001a\u00020U2\b\b\u0002\u0010g\u001a\u00020\u001eJ\"\u0010h\u001a\u00020\u0012*\u00020W2\b\u0010i\u001a\u0004\u0018\u00010j2\n\b\u0002\u0010k\u001a\u0004\u0018\u000100H\u0002R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001a\u0010$\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b2\u00103R\u001a\u00106\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0014\"\u0004\b8\u0010\u0016R\u001a\u00109\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\f\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\f\"\u0004\b?\u0010<R\u001a\u0010@\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\f\"\u0004\bB\u0010<R\u001a\u0010C\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\f\"\u0004\bE\u0010<R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010&R\u001a\u0010G\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u0014\"\u0004\bI\u0010\u0016R\u001a\u0010J\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\f\"\u0004\bL\u0010<R\u001a\u0010M\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\f\"\u0004\bO\u0010<R'\u0010P\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020Q0/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bS\u00105\u001a\u0004\bR\u00103\u00a8\u0006l"}, d2={"Llive/hms/video/connection/stats/clientside/manager/StatsSamplingManager;", "", "statsInitTime", "", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "applicationContext", "Landroid/content/Context;", "(JLlive/hms/video/events/AnalyticsEventsService;Landroid/content/Context;)V", "DEFAULT_PUBLISH_INTERVAL", "", "getDEFAULT_PUBLISH_INTERVAL", "()I", "DEFAULT_SAMPLE_DURATION", "getDEFAULT_SAMPLE_DURATION", "DEFAULT_SUBSCRIBE_SAMPLE_DURATION", "getDEFAULT_SUBSCRIBE_SAMPLE_DURATION", "START_VIDEO_SAMPLE_DURATION", "", "getSTART_VIDEO_SAMPLE_DURATION", "()D", "setSTART_VIDEO_SAMPLE_DURATION", "(D)V", "getAnalyticsEventsService", "()Llive/hms/video/events/AnalyticsEventsService;", "getApplicationContext", "()Landroid/content/Context;", "bitrateCalculator", "Llive/hms/video/connection/stats/BitrateCalculator;", "isPublishStatsEnabled", "", "()Z", "setPublishStatsEnabled", "(Z)V", "isSubscribeStatsEnabled", "setSubscribeStatsEnabled", "lastPublishedPublisherStatsTime", "getLastPublishedPublisherStatsTime", "()J", "setLastPublishedPublisherStatsTime", "(J)V", "lastPublishedSubscriberStatsTime", "getLastPublishedSubscriberStatsTime", "setLastPublishedSubscriberStatsTime", "localPublisherAudioSampler", "Llive/hms/video/connection/stats/clientside/sampler/LocalAudioStatsSampler;", "localPublisherVideoSamplerMap", "", "", "Llive/hms/video/connection/stats/clientside/sampler/VideoStatsSampler;", "getLocalPublisherVideoSamplerMap", "()Ljava/util/Map;", "localPublisherVideoSamplerMap$delegate", "Lkotlin/Lazy;", "publishLastTimeStamp", "getPublishLastTimeStamp", "setPublishLastTimeStamp", "publishStatsMaxSamplePushInterval", "getPublishStatsMaxSamplePushInterval", "setPublishStatsMaxSamplePushInterval", "(I)V", "publishStatsMaxSampleWindowSize", "getPublishStatsMaxSampleWindowSize", "setPublishStatsMaxSampleWindowSize", "sequenceNumber", "getSequenceNumber", "setSequenceNumber", "sequenceSusbcriberNumber", "getSequenceSusbcriberNumber", "setSequenceSusbcriberNumber", "getStatsInitTime", "subscribeLastTimeStamp", "getSubscribeLastTimeStamp", "setSubscribeLastTimeStamp", "subscribeStatsMaxSamplePushInterval", "getSubscribeStatsMaxSamplePushInterval", "setSubscribeStatsMaxSamplePushInterval", "subscribeStatsMaxSampleWindowSize", "getSubscribeStatsMaxSampleWindowSize", "setSubscribeStatsMaxSampleWindowSize", "subscriberAudioSamplerMap", "Llive/hms/video/connection/stats/clientside/sampler/SubscribeAudioStatsSample;", "getSubscriberAudioSamplerMap", "subscriberAudioSamplerMap$delegate", "collectPublishStats", "", "allPublishStats", "Lorg/webrtc/RTCStats;", "collectSubscribeStats", "allSubscriberStats", "getSelectedCandidateInfo", "stats", "", "getTrackExtraEntry", "entry", "", "allStats", "setConfig", "publishStats", "Llive/hms/video/signal/init/Stats;", "isSubscriberStatsEnabled", "subscriberStats", "shouldPublishStats", "forcePublish", "toBitrate", "bytesTransported", "Ljava/math/BigInteger;", "rid", "lib_release"})
public final class StatsSamplingManager {
    private final long statsInitTime;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @NotNull
    private final Context applicationContext;
    private final int DEFAULT_SAMPLE_DURATION;
    private final int DEFAULT_SUBSCRIBE_SAMPLE_DURATION;
    private final int DEFAULT_PUBLISH_INTERVAL;
    private boolean isPublishStatsEnabled;
    private boolean isSubscribeStatsEnabled;
    private int publishStatsMaxSampleWindowSize;
    private int publishStatsMaxSamplePushInterval;
    private int subscribeStatsMaxSampleWindowSize;
    private int subscribeStatsMaxSamplePushInterval;
    private long lastPublishedPublisherStatsTime;
    private long lastPublishedSubscriberStatsTime;
    private double START_VIDEO_SAMPLE_DURATION;
    private double publishLastTimeStamp;
    private double subscribeLastTimeStamp;
    private int sequenceNumber;
    private int sequenceSusbcriberNumber;
    @Nullable
    private LocalAudioStatsSampler localPublisherAudioSampler;
    @NotNull
    private final Lazy localPublisherVideoSamplerMap$delegate;
    @NotNull
    private final Lazy subscriberAudioSamplerMap$delegate;
    @NotNull
    private final BitrateCalculator bitrateCalculator;

    public StatsSamplingManager(long statsInitTime, @NotNull AnalyticsEventsService analyticsEventsService2, @NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.statsInitTime = statsInitTime;
        this.analyticsEventsService = analyticsEventsService2;
        this.applicationContext = applicationContext;
        this.DEFAULT_SAMPLE_DURATION = 30000;
        this.DEFAULT_SUBSCRIBE_SAMPLE_DURATION = 60000;
        this.DEFAULT_PUBLISH_INTERVAL = 300000;
        this.publishStatsMaxSampleWindowSize = this.DEFAULT_SAMPLE_DURATION;
        this.publishStatsMaxSamplePushInterval = this.DEFAULT_PUBLISH_INTERVAL;
        this.subscribeStatsMaxSampleWindowSize = this.DEFAULT_SUBSCRIBE_SAMPLE_DURATION;
        this.subscribeStatsMaxSamplePushInterval = this.DEFAULT_PUBLISH_INTERVAL;
        this.lastPublishedPublisherStatsTime = this.statsInitTime;
        this.lastPublishedSubscriberStatsTime = this.statsInitTime;
        this.START_VIDEO_SAMPLE_DURATION = -1.0;
        this.sequenceNumber = 1;
        this.sequenceSusbcriberNumber = 1;
        this.localPublisherVideoSamplerMap$delegate = LazyKt.lazy((Function0)localPublisherVideoSamplerMap.2.INSTANCE);
        this.subscriberAudioSamplerMap$delegate = LazyKt.lazy((Function0)subscriberAudioSamplerMap.2.INSTANCE);
        this.bitrateCalculator = new BitrateCalculator();
    }

    public final long getStatsInitTime() {
        return this.statsInitTime;
    }

    @NotNull
    public final AnalyticsEventsService getAnalyticsEventsService() {
        return this.analyticsEventsService;
    }

    @NotNull
    public final Context getApplicationContext() {
        return this.applicationContext;
    }

    public final int getDEFAULT_SAMPLE_DURATION() {
        return this.DEFAULT_SAMPLE_DURATION;
    }

    public final int getDEFAULT_SUBSCRIBE_SAMPLE_DURATION() {
        return this.DEFAULT_SUBSCRIBE_SAMPLE_DURATION;
    }

    public final int getDEFAULT_PUBLISH_INTERVAL() {
        return this.DEFAULT_PUBLISH_INTERVAL;
    }

    public final boolean isPublishStatsEnabled() {
        return this.isPublishStatsEnabled;
    }

    public final void setPublishStatsEnabled(boolean bl) {
        this.isPublishStatsEnabled = bl;
    }

    public final boolean isSubscribeStatsEnabled() {
        return this.isSubscribeStatsEnabled;
    }

    public final void setSubscribeStatsEnabled(boolean bl) {
        this.isSubscribeStatsEnabled = bl;
    }

    public final int getPublishStatsMaxSampleWindowSize() {
        return this.publishStatsMaxSampleWindowSize;
    }

    public final void setPublishStatsMaxSampleWindowSize(int n) {
        this.publishStatsMaxSampleWindowSize = n;
    }

    public final int getPublishStatsMaxSamplePushInterval() {
        return this.publishStatsMaxSamplePushInterval;
    }

    public final void setPublishStatsMaxSamplePushInterval(int n) {
        this.publishStatsMaxSamplePushInterval = n;
    }

    public final int getSubscribeStatsMaxSampleWindowSize() {
        return this.subscribeStatsMaxSampleWindowSize;
    }

    public final void setSubscribeStatsMaxSampleWindowSize(int n) {
        this.subscribeStatsMaxSampleWindowSize = n;
    }

    public final int getSubscribeStatsMaxSamplePushInterval() {
        return this.subscribeStatsMaxSamplePushInterval;
    }

    public final void setSubscribeStatsMaxSamplePushInterval(int n) {
        this.subscribeStatsMaxSamplePushInterval = n;
    }

    public final long getLastPublishedPublisherStatsTime() {
        return this.lastPublishedPublisherStatsTime;
    }

    public final void setLastPublishedPublisherStatsTime(long l) {
        this.lastPublishedPublisherStatsTime = l;
    }

    public final long getLastPublishedSubscriberStatsTime() {
        return this.lastPublishedSubscriberStatsTime;
    }

    public final void setLastPublishedSubscriberStatsTime(long l) {
        this.lastPublishedSubscriberStatsTime = l;
    }

    public final double getSTART_VIDEO_SAMPLE_DURATION() {
        return this.START_VIDEO_SAMPLE_DURATION;
    }

    public final void setSTART_VIDEO_SAMPLE_DURATION(double d) {
        this.START_VIDEO_SAMPLE_DURATION = d;
    }

    public final double getPublishLastTimeStamp() {
        return this.publishLastTimeStamp;
    }

    public final void setPublishLastTimeStamp(double d) {
        this.publishLastTimeStamp = d;
    }

    public final double getSubscribeLastTimeStamp() {
        return this.subscribeLastTimeStamp;
    }

    public final void setSubscribeLastTimeStamp(double d) {
        this.subscribeLastTimeStamp = d;
    }

    public final int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(int n) {
        this.sequenceNumber = n;
    }

    public final int getSequenceSusbcriberNumber() {
        return this.sequenceSusbcriberNumber;
    }

    public final void setSequenceSusbcriberNumber(int n) {
        this.sequenceSusbcriberNumber = n;
    }

    private final Map<String, VideoStatsSampler> getLocalPublisherVideoSamplerMap() {
        Lazy lazy = this.localPublisherVideoSamplerMap$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<String, SubscribeAudioStatsSample> getSubscriberAudioSamplerMap() {
        Lazy lazy = this.subscriberAudioSamplerMap$delegate;
        return (Map)lazy.getValue();
    }

    public final void shouldPublishStats(boolean forcePublish) {
        Iterator localVideoSampler;
        Map.Entry key;
        Iterator iterator;
        Object payload;
        int n;
        Map.Entry entry;
        long currentTime;
        if (this.isPublishStatsEnabled && ((currentTime = System.currentTimeMillis()) >= this.lastPublishedPublisherStatsTime + (long)this.publishStatsMaxSamplePushInterval || forcePublish)) {
            Map.Entry entry2;
            Object key22;
            this.lastPublishedPublisherStatsTime = currentTime;
            List videos = new ArrayList();
            Map.Entry entry3 = this.getLocalPublisherVideoSamplerMap();
            Iterator<Map.Entry<String, VideoStatsSampler>> iterator2 = entry3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry4 = entry3 = iterator2.next();
                key22 = (String)entry4.getKey();
                entry2 = entry3;
                VideoStatsSampler localVideoSampler22 = (VideoStatsSampler)entry2.getValue();
                if (!localVideoSampler22.hasSample() && !forcePublish) continue;
                entry2 = videos;
                entry = localVideoSampler22.getCollectedSamples(forcePublish);
                entry2.add(entry);
            }
            key22 = this;
            int localVideoSampler22 = ((StatsSamplingManager)key22).sequenceNumber;
            ((StatsSamplingManager)key22).sequenceNumber = localVideoSampler22 + 1;
            int n2 = localVideoSampler22;
            int key22 = this.publishStatsMaxSampleWindowSize;
            long localVideoSampler22 = this.statsInitTime;
            LocalAudioStatsSampler localAudioStatsSampler = this.localPublisherAudioSampler;
            entry = (localAudioStatsSampler == null ? false : localAudioStatsSampler.hasSample()) || forcePublish ? CollectionsKt.listOfNotNull((localAudioStatsSampler = this.localPublisherAudioSampler) == null ? null : localAudioStatsSampler.getCollectedSamples(forcePublish)) : CollectionsKt.emptyList();
            n = HMSUtils.INSTANCE.getBatteryPercentage(this.applicationContext);
            payload = new PublishAnalyticPayload(n2, key22, localVideoSampler22, videos, (List<AudioAnalytics>)((Object)entry), n);
            this.analyticsEventsService.queue(AnalyticsEventFactory.clientSideStats$default(AnalyticsEventFactory.INSTANCE, (PublishAnalyticPayload)payload, false, 2, null)).flush();
            iterator = this.localPublisherAudioSampler;
            if (iterator != null) {
                ((LocalAudioStatsSampler)((Object)iterator)).resetSamples();
            }
            key = this.getLocalPublisherVideoSamplerMap();
            iterator = key.entrySet().iterator();
            while (iterator.hasNext()) {
                entry2 = key = iterator.next();
                String key3 = (String)entry2.getKey();
                entry = key;
                localVideoSampler = (VideoStatsSampler)entry.getValue();
                ((VideoStatsSampler)((Object)localVideoSampler)).resetSamples();
            }
        }
        if (this.isSubscribeStatsEnabled && ((currentTime = System.currentTimeMillis()) >= this.lastPublishedSubscriberStatsTime + (long)this.subscribeStatsMaxSamplePushInterval || forcePublish)) {
            this.lastPublishedSubscriberStatsTime = currentTime;
            List audios = new ArrayList();
            iterator = this.getSubscriberAudioSamplerMap();
            payload = iterator.entrySet().iterator();
            while (payload.hasNext()) {
                Iterator key3 = iterator = payload.next();
                key = (String)key3.getKey();
                localVideoSampler = iterator;
                SubscribeAudioStatsSample audioSampler22 = (SubscribeAudioStatsSample)localVideoSampler.getValue();
                if (!audioSampler22.hasSample()) continue;
                localVideoSampler = audios;
                entry = audioSampler22.getCollectedSamples();
                localVideoSampler.add(entry);
            }
            StatsSamplingManager statsSamplingManager2 = this;
            int audioSampler22 = statsSamplingManager2.sequenceSusbcriberNumber;
            statsSamplingManager2.sequenceSusbcriberNumber = audioSampler22 + 1;
            int n3 = audioSampler22;
            int n4 = this.subscribeStatsMaxSampleWindowSize;
            long audioSampler22 = this.statsInitTime;
            entry = CollectionsKt.emptyList();
            n = HMSUtils.INSTANCE.getBatteryPercentage(this.applicationContext);
            payload = new PublishAnalyticPayload(n3, n4, audioSampler22, (List<VideoAnalytics>)((Object)entry), audios, n);
            Log.d((String)"SubscriberStats", (String)Intrinsics.stringPlus((String)"payload ", (Object)payload));
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.clientSideStats((PublishAnalyticPayload)payload, true)).flush();
            Object object = this.getSubscriberAudioSamplerMap();
            Iterator<Map.Entry<String, SubscribeAudioStatsSample>> iterator3 = object.entrySet().iterator();
            while (iterator3.hasNext()) {
                localVideoSampler = object = iterator3.next();
                String key4 = (String)localVideoSampler.getKey();
                entry = object;
                SubscribeAudioStatsSample sampler = (SubscribeAudioStatsSample)entry.getValue();
                sampler.resetSamples();
            }
        }
    }

    public static /* synthetic */ void shouldPublishStats$default(StatsSamplingManager statsSamplingManager2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        statsSamplingManager2.shouldPublishStats(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void collectPublishStats(@NotNull Map<String, RTCStats> allPublishStats) {
        Intrinsics.checkNotNullParameter(allPublishStats, (String)"allPublishStats");
        if (!this.isPublishStatsEnabled) {
            return;
        }
        this.publishLastTimeStamp = System.currentTimeMillis();
        StatsSamplingManager.shouldPublishStats$default(this, false, 1, null);
        Object object = allPublishStats;
        for (Map.Entry<String, RTCStats> stats : object.entrySet()) {
            Unit unit;
            Map primaryEntry;
            Object publishCandidatePairInfo;
            Object v;
            Object object2;
            Object object3;
            RTCStats extraData;
            Map primaryEntry2;
            if (Intrinsics.areEqual((Object)stats.getValue().getType(), (Object)"outbound-rtp")) {
                Unit unit2;
                double availableOutgoingBitrate;
                Map map;
                Object object4;
                Object qualityLimitationMap;
                RTCStats width;
                String trackId;
                primaryEntry2 = stats.getValue().getMembers();
                double primaryTimestamp = stats.getValue().getTimestampUs();
                extraData = this.getTrackExtraEntry(stats, allPublishStats);
                RTCStats publishCandidatePairInfo2 = this.getSelectedCandidateInfo(allPublishStats);
                if (Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"video")) {
                    Object var9_13;
                    Object object5 = extraData;
                    Object v0 = var9_13 = object5 == null ? null : ((object3 = object5.getMembers()) == null ? null : object3.get("trackIdentifier"));
                    if ((var9_13 instanceof String ? (String)var9_13 : null) != null) {
                        int n;
                        Object object6;
                        void key$iv;
                        void $this$getOrPut$iv;
                        Object object7;
                        object5 = extraData;
                        Object v1 = var9_13 = object5 == null ? null : ((object3 = object5.getMembers()) == null ? null : object3.get("trackIdentifier"));
                        if ((var9_13 instanceof String ? (String)var9_13 : null) == null) {
                            return;
                        }
                        object5 = primaryEntry2.get("ssrc");
                        trackId = String.valueOf(object5 instanceof Long ? (Long)object5 : null);
                        Object object8 = primaryEntry2.get("frameWidth");
                        object3 = object8 instanceof Long ? (Long)object8 : null;
                        width = object3 == null ? null : Integer.valueOf((int)((Long)object3).longValue());
                        object2 = primaryEntry2.get("frameHeight");
                        object8 = object2 instanceof Long ? (Long)object2 : null;
                        Integer height = object8 == null ? null : Integer.valueOf((int)((Long)object8).longValue());
                        v = primaryEntry2.get("totalPacketSendDelay");
                        Double d = v instanceof Double ? (Double)v : null;
                        double totalPacketSendDelay = d == null ? 0.0 : d;
                        Object v2 = primaryEntry2.get("packetsSent");
                        Long l = v2 instanceof Long ? (Long)v2 : null;
                        long packetsSent = l == null ? 0L : l;
                        v2 = primaryEntry2.get("qualityLimitationDurations");
                        qualityLimitationMap = v2 instanceof HashMap ? (HashMap)v2 : null;
                        object4 = primaryEntry2.get("qualityLimitationReason");
                        String string = object4 instanceof String ? (String)object4 : null;
                        object4 = qualityLimitationMap;
                        Double d2 = object4 == null ? null : (Double)((HashMap)object4).get("bandwidth");
                        object4 = qualityLimitationMap;
                        Double d3 = object4 == null ? null : (Double)((HashMap)object4).get("cpu");
                        object4 = qualityLimitationMap;
                        Double d4 = object4 == null ? null : (Double)((HashMap)object4).get("none");
                        object4 = qualityLimitationMap;
                        QualityLimitationReasons qualityReasons = new QualityLimitationReasons(string, d2, d3, d4, object4 == null ? null : (Double)((HashMap)object4).get("other"), null, 32, null);
                        Object v3 = primaryEntry2.get("framesPerSecond");
                        Number fps = v3 instanceof Number ? (Number)((Number)v3) : (Number)null;
                        Object object9 = publishCandidatePairInfo2;
                        String string2 = object9 == null ? null : ((object7 = object9.getMembers()) == null ? null : (String)object7.get("availableOutgoingBitrate"));
                        Object object10 = string2 instanceof Double ? (Double)((Object)string2) : null;
                        double availableOutgoingBitrate2 = object10 == null ? 0.0 : (Double)object10;
                        object10 = this.getLocalPublisherVideoSamplerMap();
                        string2 = trackId;
                        object9 = string2;
                        string2 = object9 == null ? "" : object9;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            Map map2;
                            Object var28_52;
                            boolean bl = false;
                            RTCStats rTCStats = extraData;
                            Object v6 = rTCStats == null ? null : (var28_52 = (map2 = rTCStats.getMembers()) == null ? null : map2.get("trackIdentifier"));
                            if (var28_52 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                            }
                            VideoStatsSampler answer$iv = new VideoStatsSampler(this.getPublishStatsMaxSampleWindowSize(), var28_52, (String)primaryEntry2.get("rid"), String.valueOf((Long)primaryEntry2.get("ssrc")), null, 16, null);
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object6 = answer$iv;
                        } else {
                            object6 = value$iv;
                        }
                        object10 = object6;
                        VideoStatsSampler $this$collectPublishStats_u24lambda_u2d1 = (VideoStatsSampler)object10;
                        boolean bl = false;
                        object7 = fps;
                        int n2 = object7 == null ? 0 : (n = ((Number)object7).intValue());
                        Object object11 = object7 = trackId;
                        object7 = extraData;
                        $this$collectPublishStats_u24lambda_u2d1.add((Integer)width, height, qualityReasons, availableOutgoingBitrate2, n2, (String)(object11 == null ? "" : object11), object7 == null ? 0.0 : this.toBitrate((RTCStats)object7, (BigInteger)primaryEntry2.get("bytesSent"), (String)primaryEntry2.get("rid")), totalPacketSendDelay, packetsSent, this.getPublishLastTimeStamp());
                        continue;
                    }
                }
                if (!Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"audio") || ((trackId = (width = extraData) == null ? null : ((object3 = width.getMembers()) == null ? null : (String)object3.get("trackIdentifier"))) instanceof String ? (String)trackId : null) == null) continue;
                Map primaryEntry3 = stats.getValue().getMembers();
                double primaryTimestamp2 = stats.getValue().getTimestampUs();
                RTCStats extraData2 = this.getTrackExtraEntry(stats, allPublishStats);
                publishCandidatePairInfo = this.getSelectedCandidateInfo(allPublishStats);
                object4 = publishCandidatePairInfo;
                RTCStats qualityReasons = object4 == null ? null : ((map = object4.getMembers()) == null ? null : (RTCStats)map.get("availableOutgoingBitrate"));
                qualityLimitationMap = qualityReasons instanceof Double ? (Double)qualityReasons : null;
                double d = availableOutgoingBitrate = qualityLimitationMap == null ? 0.0 : (Double)qualityLimitationMap;
                if (this.localPublisherAudioSampler == null) {
                    qualityReasons = extraData2;
                    Object object12 = qualityReasons == null ? null : (qualityLimitationMap = (object4 = qualityReasons.getMembers()) == null ? null : (Object)object4.get("trackIdentifier"));
                    if (qualityLimitationMap == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    this.localPublisherAudioSampler = new LocalAudioStatsSampler(this.publishStatsMaxSampleWindowSize, (String)qualityLimitationMap, String.valueOf((Long)primaryEntry3.get("ssrc")), null, 8, null);
                }
                if ((qualityLimitationMap = this.localPublisherAudioSampler) == null) {
                    unit2 = null;
                    continue;
                }
                qualityReasons = extraData2;
                ((LocalAudioStatsSampler)qualityLimitationMap).add(availableOutgoingBitrate, qualityReasons == null ? 0.0 : StatsSamplingManager.toBitrate$default(this, qualityReasons, (BigInteger)primaryEntry3.get("bytesSent"), null, 2, null));
                unit2 = Unit.INSTANCE;
                continue;
            }
            if (!Intrinsics.areEqual((Object)stats.getValue().getType(), (Object)"remote-inbound-rtp")) continue;
            primaryEntry2 = stats.getValue().getMembers();
            RTCStats extraData3 = this.getTrackExtraEntry(stats, allPublishStats);
            if (Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"video") && (Long)primaryEntry2.get("ssrc") != null) {
                Object v12;
                primaryEntry = stats.getValue().getMembers();
                extraData = this.getTrackExtraEntry(stats, allPublishStats);
                object3 = primaryEntry.get("roundTripTime");
                Double primaryTimestamp2 = object3 instanceof Double ? (Double)object3 : null;
                double roundTripTime = primaryTimestamp2 == null ? 0.0 : primaryTimestamp2;
                publishCandidatePairInfo = primaryEntry.get("jitter");
                Double extraData2 = publishCandidatePairInfo instanceof Double ? (Double)publishCandidatePairInfo : null;
                double jitter = extraData2 == null ? 0.0 : extraData2;
                Object object13 = primaryEntry.get("packetsLost");
                publishCandidatePairInfo = object13 instanceof Integer ? (Integer)object13 : null;
                int packetsLost = publishCandidatePairInfo == null ? 0 : (Integer)publishCandidatePairInfo;
                object13 = primaryEntry.get("ssrc");
                String ssrc = String.valueOf(object13 instanceof Long ? (Long)object13 : null);
                object13 = this.getLocalPublisherVideoSamplerMap().get(ssrc);
                if (object13 == null) {
                    v12 = null;
                    continue;
                }
                Object $this$collectPublishStats_u24lambda_u2d2 = v = object13;
                boolean bl = false;
                ((VideoStatsSampler)$this$collectPublishStats_u24lambda_u2d2).add(jitter, packetsLost, roundTripTime);
                v12 = v;
                continue;
            }
            if (!Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"audio")) continue;
            primaryEntry = stats.getValue().getMembers();
            extraData = this.getTrackExtraEntry(stats, allPublishStats);
            object3 = primaryEntry.get("roundTripTime");
            Double jitter = object3 instanceof Double ? (Double)object3 : null;
            double roundTripTime = jitter == null ? 0.0 : jitter;
            object2 = primaryEntry.get("jitter");
            Double packetsLost = object2 instanceof Double ? (Double)object2 : null;
            double jitter2 = packetsLost == null ? 0.0 : packetsLost;
            Object v4 = primaryEntry.get("packetsLost");
            object2 = v4 instanceof Integer ? (Integer)v4 : null;
            int packetsLost2 = object2 == null ? 0 : (Integer)object2;
            object2 = this.localPublisherAudioSampler;
            if (object2 == null) {
                unit = null;
                continue;
            }
            ((LocalAudioStatsSampler)object2).add(jitter2, packetsLost2, roundTripTime);
            unit = Unit.INSTANCE;
        }
        Object object14 = this.localPublisherAudioSampler;
        Boolean bl = object14 == null ? null : Boolean.valueOf(LocalAudioStatsSampler.shouldSample$default((LocalAudioStatsSampler)object14, this.publishLastTimeStamp, false, 2, null));
        object = this.getLocalPublisherVideoSamplerMap();
        object14 = object.entrySet().iterator();
        while (object14.hasNext()) {
            Object extraData3 = object = object14.next();
            String key = (String)extraData3.getKey();
            Object object15 = object;
            VideoStatsSampler localVideoSampler = (VideoStatsSampler)object15.getValue();
            VideoStatsSampler.shouldSample$default(localVideoSampler, this.publishLastTimeStamp, false, 2, null);
        }
    }

    private final RTCStats getSelectedCandidateInfo(Map<String, ? extends RTCStats> stats) {
        RTCStats rTCStats;
        Map map;
        Object selectedPairId;
        RTCStats rTCStats2;
        Object v0 = stats == null ? null : ((rTCStats2 = stats.get("RTCTransport_0_1")) == null ? null : (selectedPairId = (map = rTCStats2.getMembers()) == null ? null : map.get("selectedCandidatePairId")));
        if (selectedPairId != null) {
            map = stats;
            rTCStats = map.get(selectedPairId);
        } else {
            rTCStats = null;
        }
        RTCStats candidatePairInfo = rTCStats;
        return candidatePairInfo;
    }

    private final RTCStats getTrackExtraEntry(Map.Entry<String, RTCStats> entry, Map<String, RTCStats> allStats) {
        Object trackId = entry.getValue().getMembers().get("trackId");
        Map<String, RTCStats> map = allStats;
        return map.get(trackId);
    }

    private final double toBitrate(RTCStats $this$toBitrate, BigInteger bytesTransported, String rid) {
        String string;
        Map map = $this$toBitrate.getMembers();
        String trackId = map == null ? null : map.get("trackIdentifier");
        double remoteTimeStamp = $this$toBitrate.getTimestampUs();
        String string2 = string = rid;
        double d = this.bitrateCalculator.getBitrateFromTrackUpdatePrev(trackId, remoteTimeStamp, bytesTransported, string2 == null ? "" : string2);
        return d;
    }

    static /* synthetic */ double toBitrate$default(StatsSamplingManager statsSamplingManager2, RTCStats rTCStats, BigInteger bigInteger, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return statsSamplingManager2.toBitrate(rTCStats, bigInteger, string);
    }

    public final void setConfig(boolean isPublishStatsEnabled, @Nullable Stats publishStats, boolean isSubscriberStatsEnabled, @Nullable Stats subscriberStats) {
        this.isPublishStatsEnabled = isPublishStatsEnabled;
        Stats stats = publishStats;
        if ((stats == null ? null : stats.getMaxSampleWindowSize()) != null && !Intrinsics.areEqual((Float)publishStats.getMaxSampleWindowSize(), (float)0.0f)) {
            this.publishStatsMaxSampleWindowSize = (int)publishStats.getMaxSampleWindowSize().floatValue() * 1000;
        }
        if (((stats = publishStats) == null ? null : stats.getMaxSamplePushInterval()) != null && !Intrinsics.areEqual((Float)((stats = publishStats) == null ? null : stats.getMaxSamplePushInterval()), (float)0.0f)) {
            this.publishStatsMaxSamplePushInterval = (int)publishStats.getMaxSamplePushInterval().floatValue() * 1000;
        }
        this.isSubscribeStatsEnabled = isSubscriberStatsEnabled;
        stats = subscriberStats;
        if ((stats == null ? null : stats.getMaxSampleWindowSize()) != null && !Intrinsics.areEqual((Float)subscriberStats.getMaxSampleWindowSize(), (float)0.0f)) {
            this.subscribeStatsMaxSampleWindowSize = (int)subscriberStats.getMaxSampleWindowSize().floatValue() * 1000;
        }
        if (((stats = subscriberStats) == null ? null : stats.getMaxSamplePushInterval()) != null && !Intrinsics.areEqual((Float)subscriberStats.getMaxSamplePushInterval(), (float)0.0f)) {
            this.subscribeStatsMaxSamplePushInterval = (int)subscriberStats.getMaxSamplePushInterval().floatValue() * 1000;
        }
    }

    public final void collectSubscribeStats(@NotNull Map<String, RTCStats> allSubscriberStats) {
        Object primaryEntry;
        Intrinsics.checkNotNullParameter(allSubscriberStats, (String)"allSubscriberStats");
        if (!this.isSubscribeStatsEnabled) {
            return;
        }
        this.subscribeLastTimeStamp = System.currentTimeMillis();
        StatsSamplingManager.shouldPublishStats$default(this, false, 1, null);
        Object object = allSubscriberStats;
        for (Map.Entry<String, RTCStats> stats : object.entrySet()) {
            Map map;
            if (!Intrinsics.areEqual((Object)stats.getValue().getType(), (Object)"inbound-rtp")) continue;
            RTCStats extraData = this.getTrackExtraEntry(stats, allSubscriberStats);
            primaryEntry = stats.getValue().getMembers();
            RTCStats rTCStats = extraData;
            Object var7_7 = rTCStats == null ? null : ((map = rTCStats.getMembers()) == null ? null : map.get("trackIdentifier"));
            String trackID = var7_7 instanceof String ? (String)var7_7 : null;
            Long ssrc = (Long)primaryEntry.get("ssrc");
            if (Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"audio") && trackID != null) {
                SubscribeAudioStatsSample subscribeAudioStatsSample2;
                double d;
                Log.d((String)"TAG", (String)Intrinsics.stringPlus((String)"stats ", stats));
                map = primaryEntry.get("jitter");
                String jitter = String.valueOf(map instanceof Double ? (Double)((Object)map) : null);
                double bitrate = d = StatsSamplingManager.toBitrate$default(this, extraData, (BigInteger)primaryEntry.get("bytesReceived"), null, 2, null);
                Object v = primaryEntry.get("packetsReceived");
                String packetsReceived = String.valueOf(v instanceof Long ? (Long)v : null);
                Object v2 = primaryEntry.get("packetsLost");
                String packetsLost = String.valueOf(v2 instanceof Integer ? (Integer)v2 : null);
                Object object2 = primaryEntry.get("audioLevel");
                Double d2 = object2 instanceof Double ? (Double)object2 : null;
                double audioLevel = d2 == null ? 0.0 : d2;
                Object object3 = primaryEntry.get("concealedSamples");
                object2 = object3 instanceof BigInteger ? (BigInteger)object3 : null;
                Object concealedSamples = object2 == null ? Integer.valueOf(0) : object2;
                Object v3 = primaryEntry.get("silentConcealedSamples");
                object3 = v3 instanceof BigInteger ? (BigInteger)v3 : null;
                Object silentConcealedSamples = object3 == null ? Integer.valueOf(0) : object3;
                long audioConcealedSamples = ((Number)concealedSamples).longValue() - ((Number)silentConcealedSamples).longValue();
                Object object4 = primaryEntry.get("totalSamplesReceived");
                BigInteger bigInteger = object4 instanceof BigInteger ? (BigInteger)object4 : null;
                Number audioTotalSamplesReceived = bigInteger == null ? Integer.valueOf(0) : bigInteger;
                Object object5 = primaryEntry.get("concealmentEvents");
                object4 = object5 instanceof BigInteger ? (BigInteger)object5 : null;
                Object audioConcealmentEvents = object4 == null ? Integer.valueOf(0) : object4;
                Object object6 = primaryEntry.get("fecPacketsDiscarded");
                object5 = object6 instanceof BigInteger ? (BigInteger)object6 : null;
                Object fecPacketsDiscarded = object5 == null ? Integer.valueOf(0) : object5;
                Object v4 = primaryEntry.get("fecPacketsReceived");
                object6 = v4 instanceof BigInteger ? (BigInteger)v4 : null;
                Object fecPacketsReceived = object6 == null ? Integer.valueOf(0) : object6;
                Object v5 = primaryEntry.get("totalSamplesDuration");
                Double d3 = v5 instanceof Double ? (Double)v5 : null;
                double totalSamplesDuration = d3 == null ? 0.0 : d3;
                Object v6 = primaryEntry.get("[jitterBufferDelay]");
                Object object7 = v6 instanceof Double ? (Double)v6 : null;
                double jitterBufferDelay = object7 == null ? 0.0 : (Double)object7;
                Map<String, SubscribeAudioStatsSample> $this$getOrPut$iv = this.getSubscriberAudioSamplerMap();
                boolean $i$f$getOrPut = false;
                SubscribeAudioStatsSample value$iv = $this$getOrPut$iv.get(trackID);
                if (value$iv == null) {
                    boolean bl = false;
                    SubscribeAudioStatsSample answer$iv = new SubscribeAudioStatsSample(this.getSubscribeStatsMaxSampleWindowSize(), trackID, String.valueOf(ssrc));
                    $this$getOrPut$iv.put(trackID, answer$iv);
                    subscribeAudioStatsSample2 = answer$iv;
                } else {
                    subscribeAudioStatsSample2 = value$iv;
                }
                object7 = subscribeAudioStatsSample2;
                SubscribeAudioStatsSample $this$collectSubscribeStats_u24lambda_u2d4 = (SubscribeAudioStatsSample)object7;
                boolean bl = false;
                String string = packetsReceived;
                long l = Long.parseLong(string);
                string = packetsLost;
                $this$collectSubscribeStats_u24lambda_u2d4.add(audioLevel, audioConcealedSamples, audioTotalSamplesReceived, (Number)audioConcealmentEvents, (Number)fecPacketsDiscarded, (Number)fecPacketsReceived, (float)totalSamplesDuration, l, Long.parseLong(string), jitterBufferDelay);
            }
            if (!Intrinsics.areEqual((Object)String.valueOf(stats.getValue().getMembers().get("kind")), (Object)"video") || trackID == null) continue;
        }
        object = this.getSubscriberAudioSamplerMap();
        Iterator<Map.Entry<String, Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            primaryEntry = object = iterator.next();
            String key = (String)primaryEntry.getKey();
            Object object8 = object;
            SubscribeAudioStatsSample audioSampler = (SubscribeAudioStatsSample)object8.getValue();
            audioSampler.shouldSample(this.subscribeLastTimeStamp);
        }
    }
}

