/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.events;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.audio.HMSAudioManager;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.IAnalyticsPropertiesProvider;
import live.hms.video.sdk.models.enums.HMSAnalyticsEventLevel;
import live.hms.video.sdk.models.enums.RetrySchedulerState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0004J\u0016\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0010J\u001e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\t2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010%J\u001d\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.J\"\u0010/\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\t2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010%J\u000e\u00100\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J.\u00101\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020\tJ\u000e\u00105\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.J\u000e\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010:\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Llive/hms/video/events/AnalyticsEventFactory;", "", "()V", "cRequestedAt", "", "cRespondedAt", "audioEchoCancellation", "Llive/hms/video/events/AnalyticsEvent;", "isHardware", "", "audioFocusStarted", "eventTime", "", "isLegacyAudioFocus", "audioPublishFail", "error", "Llive/hms/video/error/HMSException;", "cameraCapturingException", "exception", "", "connect", "source", "Llive/hms/video/sdk/models/enums/RetrySchedulerState;", "degradation", "trackId", "disconnect", "focusOwnedStatus", "owned", "genericHMSExceptionEvent", "hmsException", "join", "requestedAt", "Ljava/util/Date;", "respondedAt", "joinStatusEvent", "eventSuccessful", "eventMap", "Ljava/util/HashMap;", "networkQualityInPreviewResults", "score", "", "speedKilobytesPerSecond", "", "(ILjava/lang/Double;)Llive/hms/video/events/AnalyticsEvent;", "performance", "stats", "Llive/hms/video/events/IAnalyticsPropertiesProvider;", "previewStatusEvent", "publishFail", "restoration", "degradedAt", "durationDegraded", "hidden", "rtcStats", "selectedAudioDevice", "selectedDevice", "Llive/hms/video/audio/HMSAudioManager$AudioDevice;", "subscribeFail", "videoPublishFail", "lib_release"})
public final class AnalyticsEventFactory {
    @NotNull
    public static final AnalyticsEventFactory INSTANCE = new AnalyticsEventFactory();
    @NotNull
    private static final String cRequestedAt = "requested_at";
    @NotNull
    private static final String cRespondedAt = "responded_at";

    private AnalyticsEventFactory() {
    }

    @NotNull
    public final AnalyticsEvent disconnect(@NotNull HMSException error, @NotNull RetrySchedulerState source) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        Map map = properties;
        String string = "transport_state";
        String string2 = source.getCurrentState();
        map.put(string, string2);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "disconnected";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent join(@NotNull Date requestedAt, @NotNull Date respondedAt, @NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)requestedAt, (String)"requestedAt");
        Intrinsics.checkNotNullParameter((Object)respondedAt, (String)"respondedAt");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)cRequestedAt, (Object)String.valueOf(requestedAt.getTime())), TuplesKt.to((Object)cRespondedAt, (Object)String.valueOf(respondedAt.getTime()))};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        properties.putAll((Map)error.toAnalyticsProperties());
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "join.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent publishFail(@NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "publish.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent audioPublishFail(@NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "audiopresence.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent videoPublishFail(@NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "videopresence.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent subscribeFail(@NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "subscribe.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent connect(@NotNull HMSException error, @NotNull RetrySchedulerState source) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        Map map = properties;
        String string = "transport_state";
        String string2 = source.getCurrentState();
        map.put(string, string2);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "connect.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent networkQualityInPreviewResults(int score, @Nullable Double speedKilobytesPerSecond) {
        Double d = speedKilobytesPerSecond;
        Object downLink = d == null ? "null" : d;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"score", (Object)score), TuplesKt.to((Object)"downLink", (Object)downLink)};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "perf.networkquality.preview";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent performance(@NotNull IAnalyticsPropertiesProvider stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        HashMap<String, Object> properties = stats.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "perf.stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent rtcStats(@NotNull IAnalyticsPropertiesProvider stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        HashMap<String, Object> properties = stats.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "rtc.stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent degradation(long eventTime, @NotNull String trackId) {
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"trackID", (Object)trackId), TuplesKt.to((Object)"degradedAt", (Object)String.valueOf(eventTime))};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "video.degradation.stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent restoration(long eventTime, @NotNull String trackId, long degradedAt, long durationDegraded, boolean hidden) {
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"trackID", (Object)trackId), TuplesKt.to((Object)"recoveredAt", (Object)String.valueOf(eventTime)), TuplesKt.to((Object)"degradedAt", (Object)String.valueOf(degradedAt)), TuplesKt.to((Object)"duration", (Object)String.valueOf(durationDegraded)), TuplesKt.to((Object)"hidden", (Object)String.valueOf(hidden))};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "video.degradation.stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent audioFocusStarted(long eventTime, boolean isLegacyAudioFocus) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"time", (Object)String.valueOf(eventTime)), TuplesKt.to((Object)"focus", (Object)(isLegacyAudioFocus ? "legacy" : "8.0-focus"))};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "audio.focus.type";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent selectedAudioDevice(@NotNull HMSAudioManager.AudioDevice selectedDevice) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)selectedDevice), (String)"selectedDevice");
        Pair[] pairArray = new Pair[1];
        HMSAudioManager.AudioDevice audioDevice = selectedDevice;
        int n = WhenMappings.$EnumSwitchMapping$0[audioDevice.ordinal()];
        switch (n) {
            case 1: {
                string = "speakerphone";
                break;
            }
            case 2: {
                string = "wiredhs";
                break;
            }
            case 3: {
                string = "earpiece";
                break;
            }
            case 4: {
                string = "bt";
                break;
            }
            case 5: {
                string = "auto";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        pairArray[0] = TuplesKt.to((Object)"speakerOutput", (Object)string);
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "audio.stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent focusOwnedStatus(@NotNull String owned) {
        Intrinsics.checkNotNullParameter((Object)owned, (String)"owned");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"focusGained", (Object)owned)};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "audio.focus.owned";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent audioEchoCancellation(boolean isHardware) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"isHardwareAEC", (Object)isHardware)};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "aec.isHardware";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent joinStatusEvent(boolean eventSuccessful, @NotNull HashMap<String, Object> eventMap) {
        Intrinsics.checkNotNullParameter(eventMap, (String)"eventMap");
        String status = eventSuccessful ? "success" : "failure";
        HMSAnalyticsEventLevel level = eventSuccessful ? HMSAnalyticsEventLevel.INFO : HMSAnalyticsEventLevel.ERROR;
        String name = Intrinsics.stringPlus((String)"join.", (Object)status);
        return new AnalyticsEvent(name, level, false, (HashMap)MapsKt.toMap((Map)eventMap, (Map)new HashMap()));
    }

    @NotNull
    public final AnalyticsEvent previewStatusEvent(boolean eventSuccessful, @NotNull HashMap<String, Object> eventMap) {
        Intrinsics.checkNotNullParameter(eventMap, (String)"eventMap");
        String status = eventSuccessful ? "success" : "failure";
        HMSAnalyticsEventLevel level = eventSuccessful ? HMSAnalyticsEventLevel.INFO : HMSAnalyticsEventLevel.ERROR;
        String name = Intrinsics.stringPlus((String)"preview.", (Object)status);
        return new AnalyticsEvent(name, level, false, (HashMap)MapsKt.toMap((Map)eventMap, (Map)new HashMap()));
    }

    @NotNull
    public final AnalyticsEvent genericHMSExceptionEvent(@NotNull HMSException hmsException) {
        Intrinsics.checkNotNullParameter((Object)hmsException, (String)"hmsException");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"error_code", (Object)hmsException.getCode()), TuplesKt.to((Object)"error_message", (Object)String.valueOf(hmsException.getMessage())), TuplesKt.to((Object)"error_description", (Object)String.valueOf(hmsException.getCause())), TuplesKt.to((Object)"is_terminal", (Object)hmsException.isTerminal())};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        return new AnalyticsEvent(hmsException.getName(), HMSAnalyticsEventLevel.ERROR, false, properties);
    }

    @NotNull
    public final AnalyticsEvent cameraCapturingException(@NotNull Throwable exception) {
        Object object;
        Object[] objectArray;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String name = "camera.captureImageAtMaxSupportedResolution.error";
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"error_code", (Object)"7006");
        pairArray[1] = TuplesKt.to((Object)"is_terminal", (Object)"false");
        pairArray[2] = TuplesKt.to((Object)"name", (Object)"Error in capturing image from camera pipeline");
        Throwable throwable = exception;
        Object object3 = throwable.getMessage();
        pairArray[3] = TuplesKt.to((Object)"error_message", (Object)String.valueOf(object3 == null ? null : (object2 = (objectArray = object3))));
        throwable = exception;
        object3 = throwable.getStackTrace();
        if (object3 == null) {
            object = null;
        } else {
            objectArray = object3;
            object2 = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"toString(this)");
            object = object2;
        }
        throwable = object;
        object3 = throwable;
        pairArray[4] = TuplesKt.to((Object)"error_description", (Object)StringsKt.take((String)(object3 == null ? "" : object3), (int)1024));
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        return new AnalyticsEvent(name, HMSAnalyticsEventLevel.ERROR, false, properties);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSAudioManager.AudioDevice.values().length];
            nArray[HMSAudioManager.AudioDevice.SPEAKER_PHONE.ordinal()] = 1;
            nArray[HMSAudioManager.AudioDevice.WIRED_HEADSET.ordinal()] = 2;
            nArray[HMSAudioManager.AudioDevice.EARPIECE.ordinal()] = 3;
            nArray[HMSAudioManager.AudioDevice.BLUETOOTH.ordinal()] = 4;
            nArray[HMSAudioManager.AudioDevice.AUTOMATIC.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

