/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.database.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import live.hms.video.database.converters.TypeConverter;
import live.hms.video.database.dao.AnalyticsEventsDao;
import live.hms.video.database.entity.AnalyticsEntityModel;
import live.hms.video.database.entity.AnalyticsPeer;

public final class AnalyticsEventsDao_Impl
implements AnalyticsEventsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AnalyticsEntityModel> __insertionAdapterOfAnalyticsEntityModel;
    private final EntityDeletionOrUpdateAdapter<AnalyticsEntityModel> __deletionAdapterOfAnalyticsEntityModel;
    private final SharedSQLiteStatement __preparedStmtOfDeleteLogById;

    public AnalyticsEventsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAnalyticsEntityModel = new EntityInsertionAdapter<AnalyticsEntityModel>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `analytics_table` (`timestamp`,`eventId`,`payload`,`eventName`,`token`,`isQa`,`peerId`,`role`,`joinedAt`,`leftAt`,`roomName`,`sessionStartedAt`,`userData`,`userName`,`templateId`,`sessionId`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AnalyticsEntityModel value) {
                stmt.bindLong(1, value.getTimestamp());
                if (value.getEventId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEventId());
                }
                String _tmp = TypeConverter.mapToString(value.getPayload());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                if (value.getEventName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getEventName());
                }
                if (value.getToken() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getToken());
                }
                int _tmp_1 = value.isQa() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_1);
                AnalyticsPeer _tmpAnalyticsPeer = value.getAnalyticsPeer();
                if (_tmpAnalyticsPeer != null) {
                    if (_tmpAnalyticsPeer.getPeerId() == null) {
                        stmt.bindNull(7);
                    } else {
                        stmt.bindString(7, _tmpAnalyticsPeer.getPeerId());
                    }
                    if (_tmpAnalyticsPeer.getRole() == null) {
                        stmt.bindNull(8);
                    } else {
                        stmt.bindString(8, _tmpAnalyticsPeer.getRole());
                    }
                    if (_tmpAnalyticsPeer.getJoinedAt() == null) {
                        stmt.bindNull(9);
                    } else {
                        stmt.bindLong(9, _tmpAnalyticsPeer.getJoinedAt().longValue());
                    }
                    if (_tmpAnalyticsPeer.getLeftAt() == null) {
                        stmt.bindNull(10);
                    } else {
                        stmt.bindLong(10, _tmpAnalyticsPeer.getLeftAt().longValue());
                    }
                    if (_tmpAnalyticsPeer.getRoomName() == null) {
                        stmt.bindNull(11);
                    } else {
                        stmt.bindString(11, _tmpAnalyticsPeer.getRoomName());
                    }
                    if (_tmpAnalyticsPeer.getSessionStartedAt() == null) {
                        stmt.bindNull(12);
                    } else {
                        stmt.bindLong(12, _tmpAnalyticsPeer.getSessionStartedAt().longValue());
                    }
                    if (_tmpAnalyticsPeer.getUserData() == null) {
                        stmt.bindNull(13);
                    } else {
                        stmt.bindString(13, _tmpAnalyticsPeer.getUserData());
                    }
                    if (_tmpAnalyticsPeer.getUserName() == null) {
                        stmt.bindNull(14);
                    } else {
                        stmt.bindString(14, _tmpAnalyticsPeer.getUserName());
                    }
                    if (_tmpAnalyticsPeer.getTemplateId() == null) {
                        stmt.bindNull(15);
                    } else {
                        stmt.bindString(15, _tmpAnalyticsPeer.getTemplateId());
                    }
                    if (_tmpAnalyticsPeer.getSessionId() == null) {
                        stmt.bindNull(16);
                    } else {
                        stmt.bindString(16, _tmpAnalyticsPeer.getSessionId());
                    }
                } else {
                    stmt.bindNull(7);
                    stmt.bindNull(8);
                    stmt.bindNull(9);
                    stmt.bindNull(10);
                    stmt.bindNull(11);
                    stmt.bindNull(12);
                    stmt.bindNull(13);
                    stmt.bindNull(14);
                    stmt.bindNull(15);
                    stmt.bindNull(16);
                }
            }
        };
        this.__deletionAdapterOfAnalyticsEntityModel = new EntityDeletionOrUpdateAdapter<AnalyticsEntityModel>(__db){

            public String createQuery() {
                return "DELETE FROM `analytics_table` WHERE `eventId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AnalyticsEntityModel value) {
                if (value.getEventId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEventId());
                }
            }
        };
        this.__preparedStmtOfDeleteLogById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete FROM analytics_table WHERE eventId = ?";
                return "Delete FROM analytics_table WHERE eventId = ?";
            }
        };
    }

    @Override
    public Object addEvent(final AnalyticsEntityModel analyticsModel, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AnalyticsEventsDao_Impl.this.__db.beginTransaction();
                try {
                    AnalyticsEventsDao_Impl.this.__insertionAdapterOfAnalyticsEntityModel.insert((Object)analyticsModel);
                    AnalyticsEventsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AnalyticsEventsDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object deleteLog(final AnalyticsEntityModel analyticsModel, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AnalyticsEventsDao_Impl.this.__db.beginTransaction();
                try {
                    AnalyticsEventsDao_Impl.this.__deletionAdapterOfAnalyticsEntityModel.handle((Object)analyticsModel);
                    AnalyticsEventsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AnalyticsEventsDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object deleteLogById(final String eventId, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AnalyticsEventsDao_Impl.this.__preparedStmtOfDeleteLogById.acquire();
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, eventId);
                }
                AnalyticsEventsDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AnalyticsEventsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AnalyticsEventsDao_Impl.this.__db.endTransaction();
                    AnalyticsEventsDao_Impl.this.__preparedStmtOfDeleteLogById.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object getAllEvents(Continuation<? super List<AnalyticsEntityModel>> continuation) {
        String _sql = "Select * FROM analytics_table";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * FROM analytics_table", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<AnalyticsEntityModel>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AnalyticsEntityModel> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AnalyticsEventsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventId");
                    int _cursorIndexOfPayload = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payload");
                    int _cursorIndexOfEventName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventName");
                    int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"token");
                    int _cursorIndexOfIsQa = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isQa");
                    int _cursorIndexOfPeerId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"peerId");
                    int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"role");
                    int _cursorIndexOfJoinedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"joinedAt");
                    int _cursorIndexOfLeftAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leftAt");
                    int _cursorIndexOfRoomName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roomName");
                    int _cursorIndexOfSessionStartedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionStartedAt");
                    int _cursorIndexOfUserData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userData");
                    int _cursorIndexOfUserName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userName");
                    int _cursorIndexOfTemplateId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"templateId");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    ArrayList<AnalyticsEntityModel> _result = new ArrayList<AnalyticsEntityModel>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        AnalyticsPeer _tmpAnalyticsPeer;
                        if (!(_cursor.isNull(_cursorIndexOfPeerId) && _cursor.isNull(_cursorIndexOfRole) && _cursor.isNull(_cursorIndexOfJoinedAt) && _cursor.isNull(_cursorIndexOfLeftAt) && _cursor.isNull(_cursorIndexOfRoomName) && _cursor.isNull(_cursorIndexOfSessionStartedAt) && _cursor.isNull(_cursorIndexOfUserData) && _cursor.isNull(_cursorIndexOfUserName) && _cursor.isNull(_cursorIndexOfTemplateId) && _cursor.isNull(_cursorIndexOfSessionId))) {
                            String _tmpPeerId = _cursor.isNull(_cursorIndexOfPeerId) ? null : _cursor.getString(_cursorIndexOfPeerId);
                            String _tmpRole = _cursor.isNull(_cursorIndexOfRole) ? null : _cursor.getString(_cursorIndexOfRole);
                            Long _tmpJoinedAt = _cursor.isNull(_cursorIndexOfJoinedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfJoinedAt));
                            Long _tmpLeftAt = _cursor.isNull(_cursorIndexOfLeftAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLeftAt));
                            String _tmpRoomName = _cursor.isNull(_cursorIndexOfRoomName) ? null : _cursor.getString(_cursorIndexOfRoomName);
                            Long _tmpSessionStartedAt = _cursor.isNull(_cursorIndexOfSessionStartedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfSessionStartedAt));
                            String _tmpUserData = _cursor.isNull(_cursorIndexOfUserData) ? null : _cursor.getString(_cursorIndexOfUserData);
                            String _tmpUserName = _cursor.isNull(_cursorIndexOfUserName) ? null : _cursor.getString(_cursorIndexOfUserName);
                            String _tmpTemplateId = _cursor.isNull(_cursorIndexOfTemplateId) ? null : _cursor.getString(_cursorIndexOfTemplateId);
                            String _tmpSessionId = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                            _tmpAnalyticsPeer = new AnalyticsPeer(_tmpPeerId, _tmpRole, _tmpJoinedAt, _tmpLeftAt, _tmpRoomName, _tmpSessionStartedAt, _tmpUserData, _tmpUserName, _tmpTemplateId, _tmpSessionId);
                        } else {
                            _tmpAnalyticsPeer = null;
                        }
                        AnalyticsEntityModel _item = new AnalyticsEntityModel();
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        String _tmpEventId = _cursor.isNull(_cursorIndexOfEventId) ? null : _cursor.getString(_cursorIndexOfEventId);
                        _item.setEventId(_tmpEventId);
                        String _tmp = _cursor.isNull(_cursorIndexOfPayload) ? null : _cursor.getString(_cursorIndexOfPayload);
                        HashMap<String, Object> _tmpPayload = TypeConverter.toHashMap(_tmp);
                        _item.setPayload(_tmpPayload);
                        String _tmpEventName = _cursor.isNull(_cursorIndexOfEventName) ? null : _cursor.getString(_cursorIndexOfEventName);
                        _item.setEventName(_tmpEventName);
                        String _tmpToken = _cursor.isNull(_cursorIndexOfToken) ? null : _cursor.getString(_cursorIndexOfToken);
                        _item.setToken(_tmpToken);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsQa);
                        boolean _tmpIsQa = _tmp_1 != 0;
                        _item.setQa(_tmpIsQa);
                        _item.setAnalyticsPeer(_tmpAnalyticsPeer);
                        _result.add(_item);
                    }
                    ArrayList<AnalyticsEntityModel> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

