/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\fJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Llive/hms/video/utils/HmsCamera;", "", "context", "Landroid/content/Context;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Landroid/content/Context;Llive/hms/video/events/AnalyticsEventsService;)V", "backCameraId", "", "getContext", "()Landroid/content/Context;", "enumerator", "Lorg/webrtc/CameraEnumerator;", "frontCameraId", "enumerateAndAssignFrontBackValues", "", "getCachedCameraFacing", "Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "deviceId", "getCam2", "getCameraFaceFromId", "getCameraIdFromFace", "face", "throwException", "", "getDeviceId", "getEnumerator", "getWebrtcCameraFacing", "lib_release"})
public final class HmsCamera {
    @NotNull
    private final Context context;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @Nullable
    private String frontCameraId;
    @Nullable
    private String backCameraId;
    @NotNull
    private CameraEnumerator enumerator;

    public HmsCamera(@NotNull Context context, @NotNull AnalyticsEventsService analyticsEventsService) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService, (String)"analyticsEventsService");
        this.context = context;
        this.analyticsEventsService = analyticsEventsService;
        this.enumerator = Camera2Enumerator.isSupported((Context)this.context) ? (CameraEnumerator)new Camera2Enumerator(this.context) : (CameraEnumerator)new Camera1Enumerator(false);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final CameraEnumerator getEnumerator() {
        return this.enumerator;
    }

    @NotNull
    public final String getDeviceId(@NotNull HMSVideoTrackSettings.CameraFacing face) throws HMSException {
        Intrinsics.checkNotNullParameter((Object)((Object)face), (String)"face");
        try {
            String cacheCameraId = this.getCameraIdFromFace(face, false);
            if (cacheCameraId != null) {
                return cacheCameraId;
            }
            this.enumerateAndAssignFrontBackValues();
            String string = this.getCameraIdFromFace(face, true);
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        catch (NoSuchElementException e) {
            HMSException cantFindCameraIdForParticularOrientation = ErrorFactory.TracksErrors.CantFindCameraIdForParticularFace$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, HmsCamera.getDeviceId$getFaceString(face), "No camera device found for " + (Object)((Object)face) + " among " + Arrays.toString(this.enumerator.getDeviceNames()), false, null, null, 56, null);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.videoPublishFail(cantFindCameraIdForParticularOrientation)).flush();
            throw cantFindCameraIdForParticularOrientation;
        }
        catch (Exception e) {
            HMSException cameraCaptureException = ErrorFactory.TracksErrors.CantAccessCaptureDevice$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "camera", String.valueOf(e.getMessage()), false, null, null, 48, null);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.videoPublishFail(cameraCaptureException)).flush();
            throw cameraCaptureException;
        }
    }

    private final String getCameraIdFromFace(HMSVideoTrackSettings.CameraFacing face, boolean throwException) {
        String string;
        CharSequence charSequence;
        if (this.frontCameraId == null && this.backCameraId == null && throwException) {
            throw new NoSuchElementException(Intrinsics.stringPlus((String)"both, front and back cameraId returned null for face ", (Object)((Object)face)));
        }
        if (this.frontCameraId == null && this.backCameraId == null) {
            return null;
        }
        if (face == HMSVideoTrackSettings.CameraFacing.FRONT && !((charSequence = (CharSequence)this.frontCameraId) == null || charSequence.length() == 0)) {
            String string2 = this.frontCameraId;
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else if (face == HMSVideoTrackSettings.CameraFacing.BACK && !((charSequence = (CharSequence)this.backCameraId) == null || charSequence.length() == 0)) {
            String string3 = this.backCameraId;
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        } else {
            if (throwException) {
                throw new NoSuchElementException("Couldn't find " + (Object)((Object)face) + " facing camera. Please restart your device");
            }
            return null;
        }
        return string;
    }

    @Nullable
    public final HMSVideoTrackSettings.CameraFacing getCameraFaceFromId(@NotNull String deviceId) {
        HMSVideoTrackSettings.CameraFacing cameraFacing;
        HMSVideoTrackSettings.CameraFacing cameraFacing2;
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        HMSVideoTrackSettings.CameraFacing cameraFacing3 = this.getCachedCameraFacing(deviceId);
        HMSVideoTrackSettings.CameraFacing cameraFacing4 = cameraFacing3 == null ? ((cameraFacing2 = this.getWebrtcCameraFacing(deviceId)) == null ? ((cameraFacing = this.getCam2(deviceId)) == null ? this.getCachedCameraFacing(deviceId) : cameraFacing) : cameraFacing2) : cameraFacing3;
        return cameraFacing4;
    }

    private final HMSVideoTrackSettings.CameraFacing getCachedCameraFacing(String deviceId) {
        String string = deviceId;
        return Intrinsics.areEqual((Object)string, (Object)this.frontCameraId) ? HMSVideoTrackSettings.CameraFacing.FRONT : (Intrinsics.areEqual((Object)string, (Object)this.backCameraId) ? HMSVideoTrackSettings.CameraFacing.BACK : null);
    }

    private final HMSVideoTrackSettings.CameraFacing getWebrtcCameraFacing(String deviceId) {
        Object object;
        HmsCamera hmsCamera = this;
        try {
            object = Result.Companion;
            HmsCamera $this$getWebrtcCameraFacing_u24lambda_u2d0 = hmsCamera;
            boolean bl = false;
            HMSVideoTrackSettings.CameraFacing cameraFacing = $this$getWebrtcCameraFacing_u24lambda_u2d0.enumerator.isFrontFacing(deviceId) ? HMSVideoTrackSettings.CameraFacing.FRONT : ($this$getWebrtcCameraFacing_u24lambda_u2d0.enumerator.isBackFacing(deviceId) ? HMSVideoTrackSettings.CameraFacing.BACK : null);
            object = Result.constructor-impl((Object)((Object)cameraFacing));
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        hmsCamera = object;
        return (HMSVideoTrackSettings.CameraFacing)((Object)(Result.isFailure-impl((Object)hmsCamera) ? null : hmsCamera));
    }

    private final HMSVideoTrackSettings.CameraFacing getCam2(String deviceId) {
        Object object;
        HmsCamera hmsCamera = this;
        try {
            HMSVideoTrackSettings.CameraFacing cameraFacing;
            block15: {
                Object v3;
                block18: {
                    block13: {
                        block17: {
                            CameraManager cameraManager;
                            HmsCamera $this$getCam2_u24lambda_u2d1;
                            block16: {
                                block14: {
                                    object = Result.Companion;
                                    $this$getCam2_u24lambda_u2d1 = hmsCamera;
                                    boolean bl = false;
                                    if (!Camera2Enumerator.isSupported((Context)$this$getCam2_u24lambda_u2d1.getContext())) break block13;
                                    Object object2 = $this$getCam2_u24lambda_u2d1.getContext().getSystemService("camera");
                                    if (object2 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
                                    }
                                    cameraManager = (CameraManager)object2;
                                    if (!$this$getCam2_u24lambda_u2d1.enumerator.isBackFacing(deviceId)) break block14;
                                    cameraFacing = HMSVideoTrackSettings.CameraFacing.BACK;
                                    break block15;
                                }
                                if (!$this$getCam2_u24lambda_u2d1.enumerator.isFrontFacing(deviceId)) break block16;
                                cameraFacing = HMSVideoTrackSettings.CameraFacing.FRONT;
                                break block15;
                            }
                            if ($this$getCam2_u24lambda_u2d1.frontCameraId != null && $this$getCam2_u24lambda_u2d1.backCameraId != null || !$this$getCam2_u24lambda_u2d1.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.external")) break block17;
                            CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(deviceId);
                            Object object3 = characteristics;
                            Integer facing = object3 == null ? null : (Integer)object3.get(CameraCharacteristics.LENS_FACING);
                            Object object4 = object3 = facing;
                            int n = 0;
                            if (object4 != null && (Integer)object4 == 0) {
                                cameraFacing = HMSVideoTrackSettings.CameraFacing.FRONT;
                            } else {
                                Object object5 = object3;
                                n = 1;
                                if (object5 != null && (Integer)object5 == n) {
                                    cameraFacing = HMSVideoTrackSettings.CameraFacing.BACK;
                                } else if (object3 == null) {
                                    cameraFacing = null;
                                } else {
                                    $this$getCam2_u24lambda_u2d1.enumerateAndAssignFrontBackValues();
                                    if ($this$getCam2_u24lambda_u2d1.frontCameraId == null) {
                                        $this$getCam2_u24lambda_u2d1.frontCameraId = deviceId;
                                        cameraFacing = HMSVideoTrackSettings.CameraFacing.FRONT;
                                    } else if ($this$getCam2_u24lambda_u2d1.backCameraId == null) {
                                        $this$getCam2_u24lambda_u2d1.backCameraId = deviceId;
                                        cameraFacing = HMSVideoTrackSettings.CameraFacing.BACK;
                                    } else {
                                        cameraFacing = null;
                                    }
                                }
                            }
                            break block15;
                        }
                        v3 = null;
                        break block18;
                    }
                    v3 = null;
                }
                cameraFacing = v3;
            }
            HMSVideoTrackSettings.CameraFacing cameraFacing2 = cameraFacing;
            object = Result.constructor-impl((Object)((Object)cameraFacing2));
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        hmsCamera = object;
        return (HMSVideoTrackSettings.CameraFacing)((Object)(Result.isFailure-impl((Object)hmsCamera) ? null : hmsCamera));
    }

    private final void enumerateAndAssignFrontBackValues() {
        Object[] objectArray;
        Object object;
        String[] stringArray = this;
        try {
            object = Result.Companion;
            String[] $this$enumerateAndAssignFrontBackValues_u24lambda_u2d2 = stringArray;
            boolean bl = false;
            if (Camera2Enumerator.isSupported((Context)$this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.getContext())) {
                String[] stringArray2;
                int $i$f$emptyArray;
                String[] $this$orEmpty$iv = $this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.enumerator.getDeviceNames();
                boolean $i$f$orEmpty22 = false;
                String[] stringArray3 = $this$orEmpty$iv;
                if (stringArray3 == null) {
                    $i$f$emptyArray = 0;
                    stringArray2 = new String[]{};
                } else {
                    stringArray2 = stringArray3;
                }
                String[] cameraDevices = stringArray2;
                String[] $i$f$orEmpty22 = $this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.getContext().getSystemService("camera");
                if ($i$f$orEmpty22 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
                }
                CameraManager cameraManager = (CameraManager)$i$f$orEmpty22;
                $i$f$orEmpty22 = cameraDevices;
                int n = 0;
                $i$f$emptyArray = $i$f$orEmpty22.length;
                while (n < $i$f$emptyArray) {
                    String cameraDeviceId = $i$f$orEmpty22[n];
                    ++n;
                    if ($this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.frontCameraId == null && $this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.enumerator.isFrontFacing(cameraDeviceId)) {
                        $this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.frontCameraId = cameraDeviceId;
                    }
                    if ($this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.backCameraId != null || !$this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.enumerator.isBackFacing(cameraDeviceId)) continue;
                    $this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.backCameraId = cameraDeviceId;
                }
                if (($this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.frontCameraId == null || $this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.backCameraId == null) && $this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.external")) {
                    for (String cameraDeviceId : cameraDevices) {
                        CameraCharacteristics cameraCharacteristics;
                        CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(cameraDeviceId);
                        if ($this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.frontCameraId != null || !((cameraCharacteristics = characteristics) == null ? false : Intrinsics.areEqual((Object)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING), (Object)2))) continue;
                        $this$enumerateAndAssignFrontBackValues_u24lambda_u2d2.frontCameraId = cameraDeviceId;
                    }
                }
            }
            objectArray = Unit.INSTANCE;
            object = Result.constructor-impl((Object)objectArray);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object cam2EnumResult = object;
        if (this.frontCameraId == null && this.backCameraId == null || Result.isFailure-impl((Object)cam2EnumResult)) {
            this.enumerator = (CameraEnumerator)new Camera1Enumerator();
            stringArray = this.enumerator.getDeviceNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"enumerator.deviceNames");
            Object[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            objectArray = $this$forEach$iv;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object element$iv = objectArray[n];
                ++n;
                String deviceId = (String)element$iv;
                boolean bl = false;
                if (this.frontCameraId == null && this.enumerator.isFrontFacing(deviceId)) {
                    this.frontCameraId = deviceId;
                }
                if (this.backCameraId != null || !this.enumerator.isBackFacing(deviceId)) continue;
                this.backCameraId = deviceId;
            }
        }
    }

    private static final String getDeviceId$getFaceString(HMSVideoTrackSettings.CameraFacing face) {
        String string;
        HMSVideoTrackSettings.CameraFacing cameraFacing = face;
        int n = WhenMappings.$EnumSwitchMapping$0[cameraFacing.ordinal()];
        switch (n) {
            case 1: {
                string = "front facing";
                break;
            }
            case 2: {
                string = "back facing";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSVideoTrackSettings.CameraFacing.values().length];
            nArray[HMSVideoTrackSettings.CameraFacing.FRONT.ordinal()] = 1;
            nArray[HMSVideoTrackSettings.CameraFacing.BACK.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

