/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Llive/hms/video/utils/HmsCamera;", "", "context", "Landroid/content/Context;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Landroid/content/Context;Llive/hms/video/events/AnalyticsEventsService;)V", "backCameraId", "", "getContext", "()Landroid/content/Context;", "enumerator", "Lorg/webrtc/CameraEnumerator;", "frontCameraId", "getCameraIdFromFace", "face", "Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "throwException", "", "getDeviceId", "getEnumerator", "lib_release"})
public final class HmsCamera {
    @NotNull
    private final Context context;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @Nullable
    private String frontCameraId;
    @Nullable
    private String backCameraId;
    @NotNull
    private CameraEnumerator enumerator;

    public HmsCamera(@NotNull Context context, @NotNull AnalyticsEventsService analyticsEventsService) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService, (String)"analyticsEventsService");
        this.context = context;
        this.analyticsEventsService = analyticsEventsService;
        this.enumerator = Camera2Enumerator.isSupported((Context)this.context) ? (CameraEnumerator)new Camera2Enumerator(this.context) : (CameraEnumerator)new Camera1Enumerator(false);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final CameraEnumerator getEnumerator() {
        return this.enumerator;
    }

    @NotNull
    public final String getDeviceId(@NotNull HMSVideoTrackSettings.CameraFacing face) throws HMSException {
        Intrinsics.checkNotNullParameter((Object)((Object)face), (String)"face");
        try {
            Object[] objectArray;
            Object object;
            String cacheCameraId = this.getCameraIdFromFace(face, false);
            if (cacheCameraId != null) {
                return cacheCameraId;
            }
            String[] stringArray = this;
            try {
                object = Result.Companion;
                String[] $this$getDeviceId_u24lambda_u2d0 = stringArray;
                boolean bl = false;
                if (Camera2Enumerator.isSupported((Context)$this$getDeviceId_u24lambda_u2d0.getContext())) {
                    String[] stringArray2;
                    int $i$f$emptyArray;
                    String[] $this$orEmpty$iv = $this$getDeviceId_u24lambda_u2d0.enumerator.getDeviceNames();
                    boolean $i$f$orEmpty22 = false;
                    String[] stringArray3 = $this$orEmpty$iv;
                    if (stringArray3 == null) {
                        $i$f$emptyArray = 0;
                        stringArray2 = new String[]{};
                    } else {
                        stringArray2 = stringArray3;
                    }
                    String[] cameraDevices = stringArray2;
                    String[] $i$f$orEmpty22 = $this$getDeviceId_u24lambda_u2d0.getContext().getSystemService("camera");
                    if ($i$f$orEmpty22 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
                    }
                    CameraManager cameraManager = (CameraManager)$i$f$orEmpty22;
                    $i$f$orEmpty22 = cameraDevices;
                    int n = 0;
                    $i$f$emptyArray = $i$f$orEmpty22.length;
                    while (n < $i$f$emptyArray) {
                        String cameraDeviceId = $i$f$orEmpty22[n];
                        ++n;
                        if ($this$getDeviceId_u24lambda_u2d0.frontCameraId == null && $this$getDeviceId_u24lambda_u2d0.enumerator.isFrontFacing(cameraDeviceId)) {
                            $this$getDeviceId_u24lambda_u2d0.frontCameraId = cameraDeviceId;
                        }
                        if ($this$getDeviceId_u24lambda_u2d0.backCameraId != null || !$this$getDeviceId_u24lambda_u2d0.enumerator.isBackFacing(cameraDeviceId)) continue;
                        $this$getDeviceId_u24lambda_u2d0.backCameraId = cameraDeviceId;
                    }
                    if (($this$getDeviceId_u24lambda_u2d0.frontCameraId == null || $this$getDeviceId_u24lambda_u2d0.backCameraId == null) && $this$getDeviceId_u24lambda_u2d0.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.external")) {
                        for (String cameraDeviceId : cameraDevices) {
                            CameraCharacteristics cameraCharacteristics;
                            CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(cameraDeviceId);
                            if ($this$getDeviceId_u24lambda_u2d0.frontCameraId != null || !((cameraCharacteristics = characteristics) == null ? false : Intrinsics.areEqual((Object)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING), (Object)2))) continue;
                            $this$getDeviceId_u24lambda_u2d0.frontCameraId = cameraDeviceId;
                        }
                    }
                }
                objectArray = Unit.INSTANCE;
                object = Result.constructor-impl((Object)objectArray);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object cam2EnumResult = object;
            if (this.frontCameraId == null && this.backCameraId == null || Result.isFailure-impl((Object)cam2EnumResult)) {
                this.enumerator = (CameraEnumerator)new Camera1Enumerator();
                stringArray = this.enumerator.getDeviceNames();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"enumerator.deviceNames");
                Object[] $this$forEach$iv = stringArray;
                boolean $i$f$forEach = false;
                objectArray = $this$forEach$iv;
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    Object element$iv = objectArray[n];
                    ++n;
                    String deviceId = (String)element$iv;
                    boolean bl = false;
                    if (this.frontCameraId == null && this.enumerator.isFrontFacing(deviceId)) {
                        this.frontCameraId = deviceId;
                    }
                    if (this.backCameraId != null || !this.enumerator.isBackFacing(deviceId)) continue;
                    this.backCameraId = deviceId;
                }
            }
            String string = this.getCameraIdFromFace(face, true);
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        catch (NoSuchElementException e) {
            HMSException cantFindCameraIdForParticularOrientation = ErrorFactory.TracksErrors.CantFindCameraIdForParticularFace$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, HmsCamera.getDeviceId$getFaceString(face), "No camera device found for " + (Object)((Object)face) + " among " + Arrays.toString(this.enumerator.getDeviceNames()), false, null, null, 56, null);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.videoPublishFail(cantFindCameraIdForParticularOrientation)).flush();
            throw cantFindCameraIdForParticularOrientation;
        }
        catch (Exception e) {
            HMSException cameraCaptureException = ErrorFactory.TracksErrors.CantAccessCaptureDevice$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "camera", String.valueOf(e.getMessage()), false, null, null, 48, null);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.videoPublishFail(cameraCaptureException)).flush();
            throw cameraCaptureException;
        }
    }

    private final String getCameraIdFromFace(HMSVideoTrackSettings.CameraFacing face, boolean throwException) {
        String string;
        CharSequence charSequence;
        if (this.frontCameraId == null && this.backCameraId == null && throwException) {
            throw new NoSuchElementException(Intrinsics.stringPlus((String)"both, front and back cameraId returned null for face ", (Object)((Object)face)));
        }
        if (this.frontCameraId == null && this.backCameraId == null) {
            return null;
        }
        if (face == HMSVideoTrackSettings.CameraFacing.FRONT && !((charSequence = (CharSequence)this.frontCameraId) == null || charSequence.length() == 0)) {
            String string2 = this.frontCameraId;
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else if (face == HMSVideoTrackSettings.CameraFacing.BACK && !((charSequence = (CharSequence)this.backCameraId) == null || charSequence.length() == 0)) {
            String string3 = this.backCameraId;
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        } else {
            if (throwException) {
                throw new NoSuchElementException("Couldn't find " + (Object)((Object)face) + " facing camera. Please restart your device");
            }
            return null;
        }
        return string;
    }

    private static final String getDeviceId$getFaceString(HMSVideoTrackSettings.CameraFacing face) {
        String string;
        HMSVideoTrackSettings.CameraFacing cameraFacing = face;
        int n = WhenMappings.$EnumSwitchMapping$0[cameraFacing.ordinal()];
        switch (n) {
            case 1: {
                string = "front facing";
                break;
            }
            case 2: {
                string = "back facing";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSVideoTrackSettings.CameraFacing.values().length];
            nArray[HMSVideoTrackSettings.CameraFacing.FRONT.ordinal()] = 1;
            nArray[HMSVideoTrackSettings.CameraFacing.BACK.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

