/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.view.WindowManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0004J\b\u0010\u001a\u001a\u00020\u0004H\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fJ\u0012\u0010\u001f\u001a\u00020\u001c2\n\u0010 \u001a\u00060!j\u0002`\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006#"}, d2={"Llive/hms/video/utils/HMSUtils;", "", "()V", "TAG", "", "agent", "getAgent", "()Ljava/lang/String;", "agentUrlEncoded", "getAgentUrlEncoded", "addAndConvertBuffers", "", "a1", "", "a1Limit", "", "a2", "a2Limit", "getDeviceId", "context", "Landroid/content/Context;", "getOrientation", "getUniqueEventId", "event", "Llive/hms/video/events/AnalyticsEvent;", "getUserAgent", "getUserAgentEncoded", "hasOrientationChange", "", "currentOrientation", "oldOrientation", "shouldRetry", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "lib_release"})
public final class HMSUtils {
    @NotNull
    public static final HMSUtils INSTANCE = new HMSUtils();
    @NotNull
    private static final String TAG = "HMSUtils";
    @NotNull
    private static final String agent = INSTANCE.getUserAgent();
    @NotNull
    private static final String agentUrlEncoded = INSTANCE.getUserAgentEncoded();

    private HMSUtils() {
    }

    @NotNull
    public final String getAgent() {
        return agent;
    }

    @NotNull
    public final String getAgentUrlEncoded() {
        return agentUrlEncoded;
    }

    @NotNull
    public final String getUniqueEventId(@NotNull AnalyticsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int n = (event.getTimestamp() + event.getName()).hashCode();
        return String.valueOf(Math.abs(n));
    }

    @NotNull
    public final String getUserAgent() {
        String string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        String buildModel = StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null);
        String userAgent = "hmsClient/2.4.4 Android/" + Build.VERSION.SDK_INT + " (" + buildModel + ')';
        HMSLogger.d(TAG, Intrinsics.stringPlus((String)"getUserAgent: ", (Object)userAgent));
        return userAgent;
    }

    private final String getUserAgentEncoded() {
        String string;
        try {
            string = URLEncoder.encode(agent, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            URLEncoder.encode(agent, \"UTF-8\")\n        }");
        }
        catch (UnsupportedEncodingException e) {
            string = StringsKt.replace$default((String)agent, (String)" ", (String)"_", (boolean)false, (int)4, null);
        }
        return string;
    }

    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public final String getDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id").toString();
    }

    public final int getOrientation(@NotNull Context context) {
        int n;
        Integer n2;
        WindowManager windowManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        WindowManager windowManager2 = windowManager = object instanceof WindowManager ? (WindowManager)object : null;
        Integer n3 = n2 = windowManager == null ? null : ((object = windowManager.getDefaultDisplay()) == null ? null : Integer.valueOf(object.getRotation()));
        int n4 = 1;
        if (n3 != null && n3 == n4) {
            n = 90;
        } else {
            Integer n5 = n2;
            n4 = 2;
            if (n5 != null && n5 == n4) {
                n = 180;
            } else {
                Integer n6 = n2;
                n4 = 3;
                n = n6 != null && n6 == n4 ? 270 : 0;
            }
        }
        return n;
    }

    public final boolean hasOrientationChange(int currentOrientation, int oldOrientation) {
        int n;
        return currentOrientation != oldOrientation && Math.abs(n = currentOrientation - oldOrientation) != 180;
    }

    public final boolean shouldRetry(@NotNull Exception ex) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return ex instanceof HMSException ? ArraysKt.contains((Object[])(objectArray = new Integer[]{2003, 1003}), (Object)((HMSException)ex).getCode()) || StringsKt.startsWith$default((String)String.valueOf(((HMSException)ex).getCode()), (String)"5", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)String.valueOf(((HMSException)ex).getCode()), (String)"429", (boolean)false, (int)2, null) : false;
    }

    @NotNull
    public final byte[] addAndConvertBuffers(@NotNull short[] a1, int a1Limit, @NotNull short[] a2, int a2Limit) {
        Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        int size = Math.max(a1Limit, a2Limit);
        if (size < 0) {
            return new byte[0];
        }
        byte[] buff = new byte[size * 2];
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                int sum = 0;
                int n2 = i >= a1Limit ? a2[i] : (sum = i >= a2Limit ? a1[i] : a1[i] + a2[i]);
                if (sum > Short.MAX_VALUE) {
                    sum = Short.MAX_VALUE;
                }
                if (sum < Short.MIN_VALUE) {
                    sum = Short.MIN_VALUE;
                }
                int byteIndex = i * 2;
                buff[byteIndex] = (byte)(sum & 0xFF);
                buff[byteIndex + 1] = (byte)(sum >> 8 & 0xFF);
            } while (n < size);
        }
        return buff;
    }
}

