/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.settings;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.events.IAnalyticsPropertiesProvider;
import live.hms.video.media.codec.HMSAudioCodec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018`\u0019H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Llive/hms/video/media/settings/HMSAudioTrackSettings;", "Llive/hms/video/events/IAnalyticsPropertiesProvider;", "volume", "", "maxBitrate", "", "codec", "Llive/hms/video/media/codec/HMSAudioCodec;", "useHardwareAcousticEchoCanceler", "", "(DILlive/hms/video/media/codec/HMSAudioCodec;Z)V", "getCodec", "()Llive/hms/video/media/codec/HMSAudioCodec;", "getMaxBitrate", "()I", "getUseHardwareAcousticEchoCanceler", "()Z", "getVolume", "()D", "builder", "Llive/hms/video/media/settings/HMSAudioTrackSettings$Builder;", "toAnalyticsProperties", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "Builder", "lib_release"})
public final class HMSAudioTrackSettings
implements IAnalyticsPropertiesProvider {
    private final double volume;
    private final int maxBitrate;
    @NotNull
    private final HMSAudioCodec codec;
    private final boolean useHardwareAcousticEchoCanceler;

    private HMSAudioTrackSettings(double volume, int maxBitrate, HMSAudioCodec codec, boolean useHardwareAcousticEchoCanceler) {
        this.volume = volume;
        this.maxBitrate = maxBitrate;
        this.codec = codec;
        this.useHardwareAcousticEchoCanceler = useHardwareAcousticEchoCanceler;
    }

    public final double getVolume() {
        return this.volume;
    }

    public final int getMaxBitrate() {
        return this.maxBitrate;
    }

    @NotNull
    public final HMSAudioCodec getCodec() {
        return this.codec;
    }

    public final boolean getUseHardwareAcousticEchoCanceler() {
        return this.useHardwareAcousticEchoCanceler;
    }

    @Override
    @NotNull
    public HashMap<String, Object> toAnalyticsProperties() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"audio_bitrate", (Object)this.maxBitrate), TuplesKt.to((Object)"audio_codec", (Object)((Object)this.codec))};
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    @NotNull
    public final Builder builder() {
        return new Builder().volume(this.volume).maxBitrate(this.maxBitrate).codec(this.codec).setUseHardwareAcousticEchoCanceler(this.useHardwareAcousticEchoCanceler);
    }

    public /* synthetic */ HMSAudioTrackSettings(double volume, int maxBitrate, HMSAudioCodec codec, boolean useHardwareAcousticEchoCanceler, DefaultConstructorMarker $constructor_marker) {
        this(volume, maxBitrate, codec, useHardwareAcousticEchoCanceler);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\u00002\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Llive/hms/video/media/settings/HMSAudioTrackSettings$Builder;", "", "()V", "codec", "Llive/hms/video/media/codec/HMSAudioCodec;", "maxBitRate", "", "useHardwareAcousticEchoCanceler", "", "volume", "", "build", "Llive/hms/video/media/settings/HMSAudioTrackSettings;", "maxBitrate", "setUseHardwareAcousticEchoCanceler", "lib_release"})
    public static final class Builder {
        private double volume = 1.0;
        private int maxBitRate = 32000;
        @NotNull
        private HMSAudioCodec codec = HMSAudioCodec.OPUS;
        private boolean useHardwareAcousticEchoCanceler = true;

        @NotNull
        public final Builder volume(@FloatRange(from=0.0, to=1.0, fromInclusive=true, toInclusive=true) double volume) {
            Builder builder;
            Builder $this$volume_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$volume_u24lambda_u2d0.volume = volume;
            return builder;
        }

        @NotNull
        public final Builder maxBitrate(@IntRange(from=1L) int maxBitRate) {
            Builder builder;
            Builder $this$maxBitrate_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$maxBitrate_u24lambda_u2d1.maxBitRate = maxBitRate;
            return builder;
        }

        @NotNull
        public final Builder codec(@NotNull HMSAudioCodec codec) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)codec), (String)"codec");
            Builder $this$codec_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$codec_u24lambda_u2d2.codec = codec;
            return builder;
        }

        @NotNull
        public final Builder setUseHardwareAcousticEchoCanceler(boolean useHardwareAcousticEchoCanceler) {
            Builder builder;
            Builder $this$setUseHardwareAcousticEchoCanceler_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$setUseHardwareAcousticEchoCanceler_u24lambda_u2d3.useHardwareAcousticEchoCanceler = useHardwareAcousticEchoCanceler;
            return builder;
        }

        @NotNull
        public final HMSAudioTrackSettings build() {
            return new HMSAudioTrackSettings(this.volume, this.maxBitRate, this.codec, this.useHardwareAcousticEchoCanceler, null);
        }
    }
}

