/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.utils.HMSConstantsKt;
import live.hms.video.utils.HMSCoroutineScope;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0001`\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Llive/hms/video/sdk/InconsistencyDetector;", "", "analyticsService", "Llive/hms/video/events/AnalyticsEventsService;", "store", "Llive/hms/video/sdk/SDKStore;", "(Llive/hms/video/events/AnalyticsEventsService;Llive/hms/video/sdk/SDKStore;)V", "task", "Ljava/util/concurrent/ScheduledFuture;", "checkForInconsistency", "", "fireInconsistencyEvent", "", "error", "Llive/hms/video/error/HMSException;", "getInconsistencyParams", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "start", "force", "stop", "Companion", "lib_release"})
public final class InconsistencyDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsEventsService analyticsService;
    @NotNull
    private final SDKStore store;
    @Nullable
    private ScheduledFuture<?> task;
    @NotNull
    private static final String TAG = "InconsistencyDetector";

    public InconsistencyDetector(@NotNull AnalyticsEventsService analyticsService, @NotNull SDKStore store) {
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.analyticsService = analyticsService;
        this.store = store;
    }

    private final HashMap<String, Object> getInconsistencyParams() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"trackStatesInfo.count", (Object)this.store.getCountTracksMetadata()), TuplesKt.to((Object)"tracksToProcess.count", (Object)this.store.getCountTracks()), TuplesKt.to((Object)"room.peers.count", (Object)this.store.getCountPeers())};
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    private final void fireInconsistencyEvent(HMSException error) {
        AnalyticsEvent event = AnalyticsEventFactory.INSTANCE.consistency(error);
        this.analyticsService.queue(event).flush();
    }

    private final boolean checkForInconsistency() {
        long now = System.currentTimeMillis();
        ArrayList<HMSException> inconsistencies = new ArrayList<HMSException>();
        this.store.forEachTrackWithTime((Function2<? super HMSTrack, ? super Long, Unit>)((Function2)new Function2<HMSTrack, Long, Unit>(this, now, inconsistencies){
            final /* synthetic */ InconsistencyDetector this$0;
            final /* synthetic */ long $now;
            final /* synthetic */ ArrayList<HMSException> $inconsistencies;
            {
                this.this$0 = $receiver;
                this.$now = $now;
                this.$inconsistencies = $inconsistencies;
                super(2);
            }

            public final void invoke(@NotNull HMSTrack track, long time) {
                HMSException error;
                Intrinsics.checkNotNullParameter((Object)track, (String)"track");
                SDKStore.TrackMetadataPair trackData = InconsistencyDetector.access$getStore$p(this.this$0).getTrackDataById(track.getTrackId());
                boolean hasTrackData = InconsistencyDetector.access$getStore$p(this.this$0).hasTrackMetadataFor(track.getTrackId());
                HMSPeer peer = InconsistencyDetector.access$getStore$p(this.this$0).getPeerByTrackId(track.getTrackId());
                if (this.$now > time + 5000L && !hasTrackData) {
                    error = ErrorFactory.GenericErrors.TrackMetadataMissing$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.NONE, "Could not find track metadata for track=" + track + ", peer=" + peer, null, InconsistencyDetector.access$getInconsistencyParams(this.this$0), 4, null);
                    this.$inconsistencies.add(error);
                }
                if (this.$now > time + 5000L && peer == null) {
                    error = ErrorFactory.GenericErrors.PeerMetadataMissing$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.NONE, "Could not find peer for track=" + track + ", trackData=" + trackData, null, InconsistencyDetector.access$getInconsistencyParams(this.this$0), 4, null);
                    this.$inconsistencies.add(error);
                }
            }
        }));
        this.store.forEachTrackDataWithTime((Function3<? super String, ? super HMSNotifications.Track, ? super Long, Unit>)((Function3)new Function3<String, HMSNotifications.Track, Long, Unit>(this, now, inconsistencies){
            final /* synthetic */ InconsistencyDetector this$0;
            final /* synthetic */ long $now;
            final /* synthetic */ ArrayList<HMSException> $inconsistencies;
            {
                this.this$0 = $receiver;
                this.$now = $now;
                this.$inconsistencies = $inconsistencies;
                super(3);
            }

            public final void invoke(@NotNull String peerId, @NotNull HMSNotifications.Track trackData, long time) {
                HMSException error;
                Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
                Intrinsics.checkNotNullParameter((Object)trackData, (String)"trackData");
                HMSTrack track = InconsistencyDetector.access$getStore$p(this.this$0).getTrackById(trackData.getTrackId());
                HMSPeer peer = InconsistencyDetector.access$getStore$p(this.this$0).getPeerById(peerId);
                if (this.$now > time + 5000L && track == null) {
                    error = ErrorFactory.GenericErrors.RTCTrackMissing$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.NONE, "Could not find RTC Track for track-data=" + trackData + ", peer=" + peer, null, InconsistencyDetector.access$getInconsistencyParams(this.this$0), 4, null);
                    this.$inconsistencies.add(error);
                }
                if (this.$now > time + 5000L && peer == null) {
                    error = ErrorFactory.GenericErrors.PeerMetadataMissing$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.NONE, "Could not find peer for track-data=" + trackData + ", track=" + track, null, InconsistencyDetector.access$getInconsistencyParams(this.this$0), 4, null);
                    this.$inconsistencies.add(error);
                }
            }
        }));
        HMSLogger.INSTANCE.v(TAG, "checkForInconsistency: inconsistencies=" + inconsistencies + " stats=" + this.getInconsistencyParams());
        Iterable $this$forEach$iv = inconsistencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HMSException it = (HMSException)element$iv;
            boolean bl = false;
            HMSLogger.INSTANCE.w(TAG, it.getDescription());
            this.fireInconsistencyEvent(it);
        }
        Collection collection = inconsistencies;
        return !collection.isEmpty();
    }

    public final void start(boolean force) {
        if (this.task == null) {
            this.task = HMSCoroutineScope.INSTANCE.scheduleWithFixedDelay(1000L, HMSConstantsKt.getCInconsistencyDetectBufferDelayTimeUnit(), (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ InconsistencyDetector this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ScheduledFuture scheduledFuture;
                            ResultKt.throwOnFailure((Object)object);
                            if (InconsistencyDetector.access$checkForInconsistency(this.this$0) && (scheduledFuture = InconsistencyDetector.access$getTask$p(this.this$0)) != null) {
                                Boxing.boxBoolean((boolean)scheduledFuture.cancel(false));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else if (force) {
            this.stop();
            InconsistencyDetector.start$default(this, false, 1, null);
        } else {
            HMSLogger.INSTANCE.w(TAG, "start: Ignoring this call as already an old task running");
        }
    }

    public static /* synthetic */ void start$default(InconsistencyDetector inconsistencyDetector2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        inconsistencyDetector2.start(bl);
    }

    public final void stop() {
        ScheduledFuture<?> scheduledFuture = this.task;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.task = null;
    }

    public static final /* synthetic */ SDKStore access$getStore$p(InconsistencyDetector $this) {
        return $this.store;
    }

    public static final /* synthetic */ HashMap access$getInconsistencyParams(InconsistencyDetector $this) {
        return $this.getInconsistencyParams();
    }

    public static final /* synthetic */ boolean access$checkForInconsistency(InconsistencyDetector $this) {
        return $this.checkForInconsistency();
    }

    public static final /* synthetic */ ScheduledFuture access$getTask$p(InconsistencyDetector $this) {
        return $this.task;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/sdk/InconsistencyDetector$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

