/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net.utils;

import android.support.annotation.NonNull;
import android.util.Log;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;

public abstract class RxAdapter<T>
extends BaseAdapter {
    private Observable<T> observable;
    private Subscription curSubscription;
    private List<T> items = new ArrayList<T>();
    private final Subscriber<T> subscriber = new Subscriber<T>(){

        public void onCompleted() {
            RxAdapter.this.onComplete();
        }

        public void onError(Throwable e) {
            RxAdapter.this.onError(e);
        }

        public void onNext(T t) {
            RxAdapter.this.onNext(t);
            RxAdapter.this.items.add(t);
            RxAdapter.this.notifyDataSetChanged();
        }
    };

    public int getCount() {
        return this.items.size();
    }

    public T getItem(int position) {
        return this.items.get(position);
    }

    protected void onComplete() {
        Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"onComplete");
    }

    protected void onError(Throwable e) {
        Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"onError", (Throwable)e);
    }

    protected void onNext(T t) {
    }

    public Subscription subscribe(@NonNull Observable<T> observable) {
        return this.subscribe(null, observable);
    }

    @Deprecated
    public Subscription subscribe(Object context, @NonNull Observable<T> observable) {
        if (this.curSubscription != null && !this.curSubscription.isUnsubscribed()) {
            this.curSubscription.unsubscribe();
        }
        this.observable = RxAdapter.bind(observable);
        this.curSubscription = RxAdapter.bind(observable).subscribe(this.subscriber);
        if (!this.items.isEmpty()) {
            this.items.clear();
            this.notifyDataSetChanged();
        }
        return this.curSubscription;
    }

    private static final <T> Observable<T> bind(@NonNull Observable<T> observable) {
        return observable.observeOn(AndroidSchedulers.mainThread());
    }
}

