/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net.utils;

import android.support.annotation.NonNull;
import android.util.Log;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.List;
import li.vin.net.Page;
import li.vin.net.VinliItem;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.subscriptions.Subscriptions;

public abstract class PageAdapter<T extends VinliItem>
extends BaseAdapter {
    private final List<Page<T>> pages = new ArrayList<Page<T>>();
    private final Subscriber<Page<T>> subscriber = new Subscriber<Page<T>>(){

        public void onCompleted() {
        }

        public void onError(Throwable e) {
            PageAdapter.this.onPageError(e);
        }

        public void onNext(Page<T> page) {
            PageAdapter.this.onPageLoaded(page);
            PageAdapter.this.pages.add(page);
            PageAdapter.this.count = PageAdapter.this.count + page.size();
            PageAdapter.this.notifyDataSetChanged();
        }
    };
    private int count = 0;

    protected void onPageLoaded(Page<T> page) {
    }

    protected void onPageError(Throwable e) {
        Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"onPageError", (Throwable)e);
    }

    public int getCount() {
        return this.count;
    }

    public T getItem(int position) {
        if (position < 0 || position >= this.count) {
            throw new IllegalArgumentException(position + " is outside of the acceptable range 0.." + this.count);
        }
        int il = this.pages.size();
        int pos = 0;
        for (int i = 0; i < il; ++i) {
            Page<T> page = this.pages.get(i);
            int nextPos = pos + page.size();
            if (nextPos > position) {
                int itemPos = position - pos;
                return (T)((VinliItem)page.getItems().get(itemPos));
            }
            pos = nextPos;
        }
        throw new AssertionError((Object)"should never get here");
    }

    public long getItemId(int position) {
        return this.getItem(position).id().hashCode();
    }

    public boolean hasNext() {
        return this.pages.isEmpty() || this.pages.get(this.pages.size() - 1).hasNextPage();
    }

    public Subscription subscribe(@NonNull Observable<Page<T>> observable) {
        return this.subscribe(null, observable);
    }

    @Deprecated
    public Subscription subscribe(Object context, @NonNull Observable<Page<T>> observable) {
        if (!this.pages.isEmpty()) {
            this.pages.clear();
            this.count = 0;
            this.notifyDataSetChanged();
        }
        return PageAdapter.bind(observable).subscribe(this.subscriber);
    }

    public Subscription loadNext() {
        return this.loadNext(null);
    }

    @Deprecated
    public Subscription loadNext(Object context) {
        if (this.hasNext()) {
            return PageAdapter.bind(this.pages.get(this.pages.size() - 1).loadNextPage()).subscribe(this.subscriber);
        }
        return Subscriptions.empty();
    }

    private static <T extends VinliItem> Observable<Page<T>> bind(@NonNull Observable<Page<T>> observable) {
        return observable.observeOn(AndroidSchedulers.mainThread());
    }
}

