/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Locale;
import li.vin.net.AutoParcel_Wrapped;
import li.vin.net.Vinli;
import rx.functions.Func1;

abstract class Wrapped<T> {
    public static final Func1 PLUCK_ITEM = new Func1<Wrapped<?>, Object>(){

        public Object call(Wrapped<?> tWrapped) {
            return tWrapped.item();
        }
    };

    Wrapped() {
    }

    public static final <T> Func1<Wrapped<T>, T> pluckItem() {
        return PLUCK_ITEM;
    }

    public static final <T> Wrapped<T> create(@NonNull T item) {
        return new AutoParcel_Wrapped<T>(item);
    }

    @Nullable
    public abstract T item();

    static final class Adapter<T>
    extends TypeAdapter<Wrapped<T>> {
        private final String itemName;
        private final Class<T> wrappedCls;
        private Gson gson;

        public static final <T> Adapter<T> create(Class<T> itemCls) {
            return Adapter.create(itemCls, itemCls.getSimpleName().toLowerCase(Locale.US));
        }

        public static final <T> Adapter<T> create(Class<T> itemCls, String itemName) {
            return new Adapter<T>(itemCls, itemName);
        }

        private Adapter(Class<T> wrappedCls, String itemName) {
            this.itemName = itemName;
            this.wrappedCls = wrappedCls;
        }

        public void write(JsonWriter out, Wrapped<T> value) throws IOException {
            if (this.gson == null) {
                this.gson = Vinli.curApp().gson();
            }
            out.beginObject();
            out.name(this.itemName);
            this.gson.toJson(value.item(), this.wrappedCls, out);
            out.endObject();
        }

        public Wrapped<T> read(JsonReader in) throws IOException {
            if (this.gson == null) {
                this.gson = Vinli.curApp().gson();
            }
            in.beginObject();
            String name = in.nextName();
            if (!this.itemName.equals(name)) {
                throw new IOException(name + " does not match expected name " + this.itemName);
            }
            Object item = this.gson.fromJson(in, this.wrappedCls);
            in.endObject();
            return new AutoParcel_Wrapped<Object>(item);
        }
    }
}

