/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_Vehicle;
import li.vin.net.BatteryStatus;
import li.vin.net.Collision;
import li.vin.net.DistanceList;
import li.vin.net.DistanceUnit;
import li.vin.net.Dtc;
import li.vin.net.Event;
import li.vin.net.Location;
import li.vin.net.Message;
import li.vin.net.Odometer;
import li.vin.net.OdometerTrigger;
import li.vin.net.Page;
import li.vin.net.ReportCard;
import li.vin.net.Snapshot;
import li.vin.net.TimeSeries;
import li.vin.net.Trip;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import retrofit2.http.Query;
import rx.Observable;

public abstract class Vehicle
implements VinliItem {
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<Vehicle>>(){}.getType();
    static final Type PAGE_TYPE = new TypeToken<Page<Vehicle>>(){}.getType();

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Vehicle.class, AutoParcelAdapter.create(AutoParcel_Vehicle.class));
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(Vehicle.class));
        gb.registerTypeAdapter(PAGE_TYPE, Page.Adapter.create(PAGE_TYPE, Vehicle.class));
    }

    @Nullable
    public abstract String make();

    @Nullable
    public abstract String model();

    @Nullable
    public abstract String year();

    @Nullable
    public abstract String trim();

    @Nullable
    public abstract String vin();

    @Nullable
    public abstract String lastStartup();

    @NonNull
    public abstract LinkedTreeMap<String, Object> data();

    public static Observable<Vehicle> vehicleWithId(@NonNull String vehicleId) {
        return Vinli.curApp().vehicle(vehicleId);
    }

    public static Observable<Page<Vehicle>> vehiclesWithDeviceId(@NonNull String deviceId) {
        return Vehicle.vehiclesWithDeviceId(deviceId, null, null);
    }

    public static Observable<Page<Vehicle>> vehiclesWithDeviceId(@NonNull String deviceId, @Nullable Integer limit, @Nullable Integer offset) {
        return Vinli.curApp().vehicles().vehicles(deviceId, limit, offset);
    }

    public static Observable<Vehicle> latestVehicleWithDeviceId(@NonNull String deviceId) {
        return Vinli.curApp().vehicles().latestVehicle(deviceId).map(Wrapped.pluckItem());
    }

    public Observable<TimeSeries<Trip>> trips() {
        return this.trips((Long)null, null, null, null);
    }

    public Observable<TimeSeries<Trip>> trips(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().trips().vehicleTrips(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<Trip>> trips(@Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().trips().vehicleTrips(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<DistanceList> distances() {
        return this.distances((Long)null, null, null);
    }

    public Observable<DistanceList> distances(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable DistanceUnit unit) {
        return Vinli.curApp().distances().distances(this.id(), sinceMs, untilMs, unit == null ? null : unit.getDistanceUnitStr());
    }

    @Deprecated
    public Observable<DistanceList> distances(@Nullable String since, @Nullable String until, @Nullable DistanceUnit unit) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'", Locale.getDefault());
        Date sinceDate = null;
        Date untilDate = null;
        try {
            sinceDate = since != null ? format.parse(since) : null;
            untilDate = until != null ? format.parse(until) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.distances(sinceDate, untilDate, unit);
    }

    @Deprecated
    public Observable<DistanceList> distances(@Nullable Date since, @Nullable Date until, @Nullable DistanceUnit unit) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().distances().distances(this.id(), sinceMs, untilMs, unit == null ? null : unit.getDistanceUnitStr());
    }

    public Observable<DistanceList.Distance> bestDistance() {
        return this.bestDistance(null);
    }

    public Observable<DistanceList.Distance> bestDistance(@Nullable DistanceUnit unit) {
        return Vinli.curApp().distances().bestDistance(this.id(), unit == null ? null : unit.getDistanceUnitStr()).map(Wrapped.pluckItem());
    }

    public Observable<TimeSeries<Odometer>> odometerReports() {
        return this.odometerReports((Long)null, null, null, null);
    }

    public Observable<TimeSeries<Odometer>> odometerReports(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().distances().odometerReports(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<Odometer>> odometerReports(@Nullable String since, @Nullable String until) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'", Locale.getDefault());
        Date sinceDate = null;
        Date untilDate = null;
        try {
            sinceDate = since != null ? format.parse(since) : null;
            untilDate = until != null ? format.parse(until) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.odometerReports(sinceDate, untilDate, null, null);
    }

    @Deprecated
    public Observable<TimeSeries<Odometer>> odometerReports(@Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().distances().odometerReports(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<OdometerTrigger>> odomterTriggers() {
        return this.odometerTriggers((Long)null, null, null, null);
    }

    public Observable<TimeSeries<OdometerTrigger>> odometerTriggers(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().distances().odometerTriggers(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<OdometerTrigger>> odometerTriggers(@Nullable String since, @Nullable String until) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'", Locale.getDefault());
        Date sinceDate = null;
        Date untilDate = null;
        try {
            sinceDate = since != null ? format.parse(since) : null;
            untilDate = until != null ? format.parse(until) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.odometerTriggers(sinceDate, untilDate, null, null);
    }

    @Deprecated
    public Observable<TimeSeries<OdometerTrigger>> odometerTriggers(@Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().distances().odometerTriggers(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<Collision>> collisions() {
        return this.collisions((Long)null, null, null, null);
    }

    public Observable<TimeSeries<Collision>> collisions(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().collisions().collisionsForVehicle(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<Collision>> collisions(@Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().collisions().collisionsForVehicle(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<ReportCard>> reportCards() {
        return this.reportCards((Long)null, null, null, null);
    }

    public Observable<TimeSeries<ReportCard>> reportCards(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().reportCards().reportCardsForVehicle(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<ReportCard>> reportCards(@Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().reportCards().reportCardsForVehicle(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<BatteryStatus> currentBatteryStatus() {
        return BatteryStatus.currentBatteryStatusForVehicle(this.id());
    }

    public Observable<TimeSeries<Dtc>> dtcs(@Query(value="since") @Nullable Long since, @Query(value="until") @Nullable Long until, @Query(value="limit") @Nullable Integer limit, @Query(value="sortDir") @Nullable String sortDir) {
        return Vinli.curApp().diagnostics().codes(this.id(), since, until, limit, sortDir);
    }

    public Observable<TimeSeries<Event>> events() {
        return this.events(null, null, null, null, null, null);
    }

    public Observable<TimeSeries<Event>> events(@Nullable String type, @Nullable String objectId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().events().vehicleEvents(this.id(), type, objectId, sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<Message>> messages() {
        return this.messages(null, null, null, null);
    }

    public Observable<TimeSeries<Message>> messages(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().messages().vehicleMessages(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<Location>> locations() {
        return this.locations(null, null, null, null);
    }

    public Observable<TimeSeries<Location>> locations(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().locations().vehicleLocations(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<Snapshot>> snapshots(@NonNull String fields) {
        return this.snapshots(fields, null, null, null, null);
    }

    public Observable<TimeSeries<Snapshot>> snapshots(@NonNull String fields, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().snapshots().vehicleSnapshots(this.id(), fields, sinceMs, untilMs, limit, sortDir);
    }

    LinkedTreeMap<String, Object> engine() {
        return (LinkedTreeMap)this.data().get((Object)"engine");
    }

    Double engineDisplacement() {
        return (Double)this.data().get((Object)"engineDisplacement");
    }

    LinkedTreeMap<String, Object> transmission() {
        return (LinkedTreeMap)this.data().get((Object)"transmission");
    }

    String manufacturer() {
        return this.data().get((Object)"manufacturer").toString();
    }

    LinkedTreeMap<String, Object> categories() {
        return (LinkedTreeMap)this.data().get((Object)"categories");
    }

    LinkedTreeMap<String, Object> epaMpg() {
        return (LinkedTreeMap)this.data().get((Object)"epaMpg");
    }

    String drive() {
        return this.data().get((Object)"drive").toString();
    }

    String numDoors() {
        return this.data().get((Object)"numDoors").toString();
    }

    Vehicle() {
    }
}

