/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_Trip;
import li.vin.net.AutoParcel_Trip_Links;
import li.vin.net.AutoParcel_Trip_Point;
import li.vin.net.AutoParcel_Trip_Stats;
import li.vin.net.Coordinate;
import li.vin.net.Device;
import li.vin.net.Event;
import li.vin.net.Location;
import li.vin.net.ReportCard;
import li.vin.net.TimeSeries;
import li.vin.net.Vehicle;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import rx.Observable;

public abstract class Trip
implements VinliItem {
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<Trip>>(){}.getType();
    static final Type TIME_SERIES_TYPE = new TypeToken<TimeSeries<Trip>>(){}.getType();

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Trip.class, AutoParcelAdapter.create(AutoParcel_Trip.class));
        gb.registerTypeAdapter(Links.class, AutoParcelAdapter.create(AutoParcel_Trip_Links.class));
        gb.registerTypeAdapter(Stats.class, AutoParcelAdapter.create(AutoParcel_Trip_Stats.class));
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(Trip.class));
        gb.registerTypeAdapter(TIME_SERIES_TYPE, TimeSeries.Adapter.create(TIME_SERIES_TYPE, Trip.class));
        Point.registerGson(gb);
    }

    public abstract String start();

    public abstract String stop();

    public abstract String status();

    public abstract String vehicleId();

    public abstract String deviceId();

    @Nullable
    public abstract Point startPoint();

    @Nullable
    public abstract Point stopPoint();

    @Nullable
    public abstract String preview();

    public abstract Stats stats();

    public static Observable<Trip> tripWithId(@NonNull String tripId) {
        return Vinli.curApp().trip(tripId);
    }

    public static Observable<TimeSeries<Trip>> tripsWithDeviceId(@NonNull String deviceId) {
        return Trip.tripsWithDeviceId(deviceId, (Long)null, null, null, null);
    }

    public static Observable<TimeSeries<Trip>> tripsWithDeviceId(@NonNull String deviceId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().trips().trips(deviceId, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public static Observable<TimeSeries<Trip>> tripsWithDeviceId(@NonNull String deviceId, @Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().trips().trips(deviceId, sinceMs, untilMs, limit, sortDir);
    }

    public static Observable<TimeSeries<Trip>> tripsWithVehicleId(@NonNull String vehicleId) {
        return Trip.tripsWithVehicleId(vehicleId, (Long)null, null, null, null);
    }

    public static Observable<TimeSeries<Trip>> tripsWithVehicleId(@NonNull String vehicleId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().trips().vehicleTrips(vehicleId, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public static Observable<TimeSeries<Trip>> tripsWithVehicleId(@NonNull String vehicleId, @Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().trips().vehicleTrips(vehicleId, sinceMs, untilMs, limit, sortDir);
    }

    public Observable<Device> device() {
        return Vinli.curApp().device(this.deviceId());
    }

    public Observable<Vehicle> vehicle() {
        return Vinli.curApp().vehicle(this.vehicleId());
    }

    public Observable<TimeSeries<Location>> locations() {
        return Vinli.curApp().locations().locationsForUrl(this.links().locations());
    }

    public Observable<TimeSeries<Event>> events() {
        return Vinli.curApp().events().eventsForUrl(this.links().events());
    }

    public Observable<ReportCard> reportCard() {
        return Vinli.curApp().reportCards().reportCardForTrip(this.id()).map(Wrapped.pluckItem());
    }

    abstract Links links();

    Trip() {
    }

    public static abstract class Point
    implements Parcelable {
        @Nullable
        public abstract Coordinate coordinates();

        Point() {
        }

        static final void registerGson(GsonBuilder gb) {
            gb.registerTypeAdapter(Point.class, (Object)new PointAdapter());
        }

        static final Builder builder() {
            return new AutoParcel_Trip_Point.Builder();
        }

        private static final class PointAdapter
        extends TypeAdapter<Point> {
            private PointAdapter() {
            }

            public void write(JsonWriter out, Point value) throws IOException {
                throw new UnsupportedOperationException("Writing a Point is not supported");
            }

            public Point read(JsonReader in) throws IOException {
                Builder b = Point.builder();
                Gson gson = Vinli.curApp().gson();
                boolean hasValidCoordinates = false;
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                in.beginObject();
                while (in.hasNext()) {
                    String name;
                    switch (name = in.nextName()) {
                        case "coordinates": {
                            if (in.peek() == JsonToken.NULL) {
                                in.nextNull();
                                b.coordinates(null);
                                hasValidCoordinates = false;
                                break;
                            }
                            b.coordinates((Coordinate)gson.fromJson(in, Coordinate.class));
                            hasValidCoordinates = true;
                            break;
                        }
                        case "type": {
                            if (in.peek() == JsonToken.NULL) {
                                in.nextNull();
                                break;
                            }
                            in.nextString();
                        }
                    }
                }
                in.endObject();
                if (!hasValidCoordinates) {
                    return null;
                }
                return b.build();
            }
        }

        static interface Builder {
            public Builder coordinates(@Nullable Coordinate var1);

            public Point build();
        }
    }

    public static abstract class Stats
    implements Parcelable {
        public abstract float averageLoad();

        public abstract float averageMovingSpeed();

        public abstract float averageSpeed();

        public abstract float distance();

        public abstract float distanceByGPS();

        public abstract float distanceByVSS();

        public abstract long duration();

        public abstract float fuelConsumed();

        public abstract float fuelEconomy();

        public abstract int hardAccelCount();

        public abstract int hardBrakeCount();

        public abstract int locationCount();

        public abstract float maxSpeed();

        public abstract int messageCount();

        public abstract float stdDevMovingSpeed();

        public abstract int stopCount();
    }

    static abstract class Links
    implements Parcelable {
        public abstract String self();

        public abstract String device();

        public abstract String vehicle();

        public abstract String locations();

        public abstract String events();

        Links() {
        }
    }
}

