/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_TimeSeries;
import li.vin.net.AutoParcel_TimeSeries_Meta;
import li.vin.net.AutoParcel_TimeSeries_Meta_Pagination;
import li.vin.net.AutoParcel_TimeSeries_Meta_Pagination_Links;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import rx.Observable;
import rx.functions.Func1;
import rx.internal.operators.OnSubscribeFromIterable;

public abstract class TimeSeries<T extends VinliItem>
implements Parcelable {
    static final Func1 EXTRACT_ITEMS = new Func1<TimeSeries<?>, Observable<?>>(){

        public Observable<?> call(TimeSeries<?> tTimeSeries) {
            return tTimeSeries.observeItems();
        }
    };
    static final Func1 ALL_ITEMS = new Func1<TimeSeries<? extends VinliItem>, Observable<? extends VinliItem>>(){

        public Observable<? extends VinliItem> call(TimeSeries<? extends VinliItem> tTimeSeries) {
            if (tTimeSeries.hasPrior()) {
                return tTimeSeries.observeItems().concatWith(tTimeSeries.loadPrior().flatMap(ALL_ITEMS));
            }
            if (tTimeSeries.hasNext()) {
                return tTimeSeries.observeItems().concatWith(tTimeSeries.loadNext().flatMap(ALL_ITEMS));
            }
            return tTimeSeries.observeItems();
        }
    };

    public static final <T extends VinliItem> Func1<TimeSeries<T>, Observable<T>> extractItems() {
        return EXTRACT_ITEMS;
    }

    public static final <T extends VinliItem> Func1<TimeSeries<T>, Observable<T>> allItems() {
        return ALL_ITEMS;
    }

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Meta.class, AutoParcelAdapter.create(AutoParcel_TimeSeries_Meta.class));
        gb.registerTypeAdapter(Meta.Pagination.class, AutoParcelAdapter.create(AutoParcel_TimeSeries_Meta_Pagination.class));
        gb.registerTypeAdapter(Meta.Pagination.Links.class, AutoParcelAdapter.create(AutoParcel_TimeSeries_Meta_Pagination_Links.class));
    }

    abstract List<T> items();

    abstract Meta meta();

    abstract Type type();

    abstract String className();

    private Observable<TimeSeries<T>> loadLink(@NonNull String link) {
        Class<?> clz;
        try {
            clz = Class.forName(this.className());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Vinli.curApp().pagingTsObservable(clz, link);
    }

    public int size() {
        return this.items().size();
    }

    public int total() {
        return this.size() + this.meta().pagination().remaining();
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items());
    }

    public Observable<T> observeItems() {
        return Observable.create((Observable.OnSubscribe)new OnSubscribeFromIterable(this.items()));
    }

    public Observable<TimeSeries<T>> loadPrior() {
        Meta.Pagination.Links links = this.meta().pagination().links();
        if (links == null) {
            return Observable.error((Throwable)new IOException("no links"));
        }
        String link = links.prior();
        if (link == null) {
            return Observable.error((Throwable)new IOException("no prior link"));
        }
        return this.loadLink(link);
    }

    public Observable<TimeSeries<T>> loadNext() {
        Meta.Pagination.Links links = this.meta().pagination().links();
        if (links == null) {
            return Observable.error((Throwable)new IOException("no links"));
        }
        String link = links.next();
        if (link == null) {
            return Observable.error((Throwable)new IOException("no next link"));
        }
        return this.loadLink(link);
    }

    public boolean hasPrior() {
        Meta.Pagination.Links links = this.meta().pagination().links();
        return links != null && links.prior() != null;
    }

    public boolean hasNext() {
        Meta.Pagination.Links links = this.meta().pagination().links();
        return links != null && links.next() != null;
    }

    TimeSeries() {
    }

    static final class Adapter<T extends VinliItem>
    extends TypeAdapter<TimeSeries<T>> {
        private final Type pageType;
        private final Class<T> itemCls;
        private final String collectionName;
        private Gson gson;

        public static final <T extends VinliItem> Adapter<T> create(Type pageType, Class<T> itemCls) {
            return Adapter.create(pageType, itemCls, itemCls.getSimpleName().toLowerCase(Locale.US) + 's');
        }

        public static final <T extends VinliItem> Adapter<T> create(Type pageType, Class<T> itemCls, String collectionName) {
            return new Adapter<T>(pageType, itemCls, collectionName);
        }

        private Adapter(Type pageType, Class<T> itemCls, String collectionName) {
            this.pageType = pageType;
            this.itemCls = itemCls;
            this.collectionName = collectionName;
        }

        public void write(JsonWriter out, TimeSeries<T> value) throws IOException {
            throw new UnsupportedOperationException("writing a time series is not supported");
        }

        public TimeSeries<T> read(JsonReader in) throws IOException {
            if (this.gson == null) {
                this.gson = Vinli.curApp().gson();
            }
            Builder b = new AutoParcel_TimeSeries.Builder().type(this.pageType).className(this.itemCls.getName());
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if ("meta".equals(name)) {
                    b.meta((Meta)this.gson.fromJson(in, Meta.class));
                    continue;
                }
                if (this.collectionName.equals(name)) {
                    ArrayList<Object> items = new ArrayList<Object>();
                    in.beginArray();
                    while (in.hasNext()) {
                        items.add(this.gson.fromJson(in, this.itemCls));
                    }
                    in.endArray();
                    b.items(items);
                    continue;
                }
                throw new IOException("unrecognized key '" + name + "' while parsing " + this.collectionName);
            }
            in.endObject();
            return b.build();
        }
    }

    static interface Builder<T extends VinliItem> {
        public Builder<T> items(List<T> var1);

        public Builder<T> meta(Meta var1);

        public Builder<T> type(Type var1);

        public Builder<T> className(String var1);

        public TimeSeries<T> build();
    }

    static abstract class Meta
    implements Parcelable {
        Meta() {
        }

        public abstract Pagination pagination();

        public static abstract class Pagination
        implements Parcelable {
            public abstract int remaining();

            public abstract int limit();

            public abstract String until();

            @Nullable
            public abstract Links links();

            public static abstract class Links
            implements Parcelable {
                @Nullable
                public abstract String prior();

                @Nullable
                public abstract String next();
            }
        }
    }
}

