/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import li.vin.net.AutoParcel_StreamMessage_GeometryFilter_Seed;
import li.vin.net.AutoParcel_StreamMessage_ParametricFilter_Seed;
import li.vin.net.Coordinate;
import li.vin.net.Duktaper;
import li.vin.net.Message;
import li.vin.net.SupportedPids;
import li.vin.net.Vinli;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class StreamMessage {
    private static final float ACCEL_CONVERT = 5.985718E-4f;
    private static final SimpleDateFormat VINLI_DATE_FMT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
    private String type;
    private StreamMessageSubject subject;
    private StreamMessagePayload payload;
    private Double bearing;

    public static Func1<StreamMessage, Observable<String>> onlyWithRawVal(final @NonNull DataType dataType) {
        return new Func1<StreamMessage, Observable<String>>(){

            public Observable<String> call(StreamMessage message) {
                String val = message.rawVal(dataType);
                if (val == null) {
                    return Observable.empty();
                }
                return Observable.just((Object)val);
            }
        };
    }

    public static Func1<StreamMessage, Observable<Double>> onlyWithDoubleVal(final @NonNull DataType dataType) {
        return new Func1<StreamMessage, Observable<Double>>(){

            public Observable<Double> call(StreamMessage message) {
                double val = message.doubleVal(dataType, -1.073741824E9);
                if (Double.compare(val, -1.073741824E9) == 0) {
                    return Observable.empty();
                }
                return Observable.just((Object)val);
            }
        };
    }

    public static Func1<StreamMessage, Observable<Long>> onlyWithLongVal(final @NonNull DataType dataType) {
        return new Func1<StreamMessage, Observable<Long>>(){

            public Observable<Long> call(StreamMessage message) {
                long val = message.longVal(dataType, -1073741824L);
                if (val == -1073741824L) {
                    return Observable.empty();
                }
                return Observable.just((Object)val);
            }
        };
    }

    public static Func1<StreamMessage, Observable<Float>> onlyWithFloatVal(final @NonNull DataType dataType) {
        return new Func1<StreamMessage, Observable<Float>>(){

            public Observable<Float> call(StreamMessage message) {
                float val = message.floatVal(dataType, -1.0737418E9f);
                if (Float.compare(val, -1.0737418E9f) == 0) {
                    return Observable.empty();
                }
                return Observable.just((Object)Float.valueOf(val));
            }
        };
    }

    public static Func1<StreamMessage, Observable<Integer>> onlyWithIntVal(final @NonNull DataType dataType) {
        return new Func1<StreamMessage, Observable<Integer>>(){

            public Observable<Integer> call(StreamMessage message) {
                int val = message.intVal(dataType, -1073741824);
                if (val == -1073741824) {
                    return Observable.empty();
                }
                return Observable.just((Object)val);
            }
        };
    }

    public static Func1<StreamMessage, Observable<Coordinate>> coordinate() {
        return new Func1<StreamMessage, Observable<Coordinate>>(){

            public Observable<Coordinate> call(StreamMessage message) {
                Coordinate coordinate = message.coord();
                if (coordinate == null) {
                    return Observable.empty();
                }
                return Observable.just((Object)coordinate);
            }
        };
    }

    public static Func1<StreamMessage, Observable<Double>> onlyWithBearing() {
        return new Func1<StreamMessage, Observable<Double>>(){

            public Observable<Double> call(StreamMessage streamMessage) {
                Double val = streamMessage.bearing();
                if (val == null) {
                    return Observable.empty();
                }
                return Observable.just((Object)val);
            }
        };
    }

    static void processRawLine(@Nullable String line, @NonNull Duktaper dt, @NonNull Subscriber<? super StreamMessage> subscriber) {
        String pfx;
        if (subscriber.isUnsubscribed()) {
            return;
        }
        if (line == null || (line = line.trim()).length() < 2) {
            return;
        }
        int colonIndex = line.indexOf(58);
        if (colonIndex != -1) {
            if (colonIndex == line.length() - 1) {
                return;
            }
            pfx = line.substring(0, colonIndex);
            line = line.substring(colonIndex + 1);
        } else if (line.length() == 2) {
            pfx = line;
            line = null;
        } else if (line.startsWith("41")) {
            pfx = "41";
            line = line.substring(2);
        } else {
            return;
        }
        if (pfx.equals("41") && line != null && line.length() > 2) {
            StreamMessage.processObd(line.substring(0, 2), line.substring(2), dt, subscriber);
        } else if (pfx.equals("A") && line != null && line.length() >= 14) {
            StreamMessage sm = StreamMessage.emptyStreamMessage();
            boolean accelFound = false;
            try {
                sm.payload.data.put((Object)"udpCollision", (Object)(Integer.valueOf(line.substring(line.length() - 2), 16) == 0 ? Boolean.FALSE : Boolean.TRUE));
                accelFound = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                float xAccel = (float)Integer.valueOf(line.substring(0, 4), 16).shortValue() * 5.985718E-4f;
                float yAccel = (float)Integer.valueOf(line.substring(4, 8), 16).shortValue() * 5.985718E-4f;
                float zAccel = (float)Integer.valueOf(line.substring(8, 12), 16).shortValue() * 5.985718E-4f;
                sm.payload.data.put((Object)"accel", (Object)new Message.AccelData(xAccel, yAccel, zAccel, xAccel, yAccel, zAccel));
                accelFound = true;
            }
            catch (Exception xAccel) {
                // empty catch block
            }
            if (accelFound) {
                subscriber.onNext((Object)sm);
            }
        } else if (pfx.equals("G") && line != null) {
            try {
                String[] split = line.split(",");
                if (split.length == 2) {
                    double lat = Double.parseDouble(split[0]);
                    double lon = Double.parseDouble(split[1]);
                    StreamMessage sm = StreamMessage.emptyStreamMessage();
                    LinkedTreeMap loc = new LinkedTreeMap();
                    sm.payload.data.put((Object)"location", (Object)loc);
                    loc.put((Object)"type", (Object)"Point");
                    loc.put((Object)"coordinates", (Object)new Object[]{lon, lat});
                    subscriber.onNext((Object)sm);
                }
            }
            catch (Exception split) {}
        } else if (pfx.equals("S") && line != null) {
            String sigType2;
            StreamMessage sm = StreamMessage.emptyStreamMessage();
            String[] split = line.split(",");
            boolean sigFound = false;
            if (split.length > 0 && (sigType2 = split[0]) != null && !(sigType2 = sigType2.trim()).isEmpty() && !sigType2.equalsIgnoreCase("null")) {
                sm.payload.data.put((Object)"udpSignalType", (Object)sigType2);
                sigFound = true;
            }
            if (split.length > 1) {
                try {
                    sm.payload.data.put((Object)"udpSignalStrength", (Object)Integer.parseInt(split[1].trim()));
                    sigFound = true;
                }
                catch (Exception sigType2) {
                    // empty catch block
                }
            }
            if (sigFound) {
                subscriber.onNext((Object)sm);
            }
        } else if (pfx.equals("B") && line != null && line.length() == 4) {
            StreamMessage sm = StreamMessage.emptyStreamMessage();
            boolean voltageFound = false;
            try {
                sm.payload.data.put((Object)"udpBatteryVoltage", (Object)((double)Integer.valueOf(line, 16).intValue() * 0.006));
                voltageFound = true;
            }
            catch (Exception sigFound) {
                // empty catch block
            }
            if (voltageFound) {
                subscriber.onNext((Object)sm);
            }
        } else if (pfx.equals("SVER") && line != null) {
            StreamMessage sm = StreamMessage.emptyStreamMessage();
            sm.payload.data.put((Object)"udpStmVersion", (Object)line);
            subscriber.onNext((Object)sm);
        } else if (pfx.equals("HVER") && line != null) {
            StreamMessage sm = StreamMessage.emptyStreamMessage();
            sm.payload.data.put((Object)"udpHeVersion", (Object)line);
            subscriber.onNext((Object)sm);
        } else if (pfx.equals("BVER") && line != null) {
            StreamMessage sm = StreamMessage.emptyStreamMessage();
            sm.payload.data.put((Object)"udpBleVersion", (Object)line);
            subscriber.onNext((Object)sm);
        } else if (pfx.equals("K") && line != null) {
            StreamMessage sm = StreamMessage.emptyStreamMessage();
            boolean supportedPidsFound = false;
            try {
                sm.payload.data.put((Object)"udpSupportedPids", (Object)new SupportedPids(line).getSupport());
                supportedPidsFound = true;
            }
            catch (Exception sigFound) {
                // empty catch block
            }
            if (supportedPidsFound) {
                subscriber.onNext((Object)sm);
            }
        } else if (pfx.equals("V") && line != null) {
            if (!line.startsWith("NULL") && line.matches("^[A-Z0-9]{17}$")) {
                StreamMessage sm = StreamMessage.emptyStreamMessage();
                sm.payload.data.put((Object)"udpVin", (Object)line);
                subscriber.onNext((Object)sm);
            }
        } else if (pfx.equals("D") && line != null) {
            StreamMessage sm = StreamMessage.emptyStreamMessage();
            boolean foundDtcs = false;
            try {
                String[] split = line.split(",");
                HashSet<String> dtcs = new HashSet<String>();
                for (String s : split) {
                    if (s == null || TextUtils.getTrimmedLength((CharSequence)s) == 0) continue;
                    dtcs.add(s);
                }
                sm.payload.data.put((Object)"udpDtcs", (Object)dtcs.toArray(new String[dtcs.size()]));
                foundDtcs = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (foundDtcs) {
                subscriber.onNext((Object)sm);
            }
        } else if (pfx.equals("P0")) {
            StreamMessage sm = StreamMessage.emptyStreamMessage();
            sm.payload.data.put((Object)"udpPower", (Object)Boolean.FALSE);
            subscriber.onNext((Object)sm);
        } else if (pfx.equals("P1")) {
            StreamMessage sm = StreamMessage.emptyStreamMessage();
            sm.payload.data.put((Object)"udpPower", (Object)Boolean.TRUE);
            subscriber.onNext((Object)sm);
        }
    }

    private static void processObd(String key, String val, Duktaper dt, Subscriber<? super StreamMessage> subscriber) {
        try {
            JSONArray arr;
            String eval = dt.evaluate(String.format("JSON.stringify(mainlib.translate('01-%1$s', '%2$s'));", key, val));
            Object json = new JSONTokener(eval).nextValue();
            if (json instanceof JSONObject) {
                arr = new JSONArray();
                arr.put(json);
            } else if (json instanceof JSONArray) {
                arr = (JSONArray)json;
            } else {
                throw new RuntimeException("not json.");
            }
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject jobj = null;
                try {
                    jobj = arr.getJSONObject(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (jobj == null) continue;
                String k = null;
                try {
                    k = jobj.getString("key");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (k == null) continue;
                String type = null;
                try {
                    type = jobj.getString("dataType");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (type == null) continue;
                if (type.equalsIgnoreCase("decimal")) {
                    try {
                        double ret = jobj.getDouble("value");
                        StreamMessage sm = StreamMessage.emptyStreamMessage();
                        sm.payload.data.put((Object)k, (Object)ret);
                        if (subscriber.isUnsubscribed()) continue;
                        subscriber.onNext((Object)sm);
                    }
                    catch (Exception ret) {}
                    continue;
                }
                try {
                    String ret = jobj.getString("value");
                    StreamMessage sm = StreamMessage.emptyStreamMessage();
                    sm.payload.data.put((Object)k, (Object)ret);
                    if (subscriber.isUnsubscribed()) continue;
                    subscriber.onNext((Object)sm);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NonNull
    private static StreamMessage emptyStreamMessage() {
        StreamMessage sm = new StreamMessage();
        sm.payload = new StreamMessagePayload();
        sm.type = "pub";
        sm.payload.id = UUID.randomUUID().toString();
        sm.payload.timestamp = StreamMessage.VINLI_DATE_FMT.format(new Date());
        sm.payload.data = new LinkedTreeMap();
        return sm;
    }

    StreamMessage() {
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public Message.AccelData accel() {
        try {
            return (Message.AccelData)new Gson().fromJson(this.rawVal("accel"), Message.AccelData.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public Coordinate coord() {
        try {
            Object[] coords;
            if (this.payload == null || this.payload.data == null) {
                return null;
            }
            Object locObj = this.payload.data.get((Object)"location");
            if (!(locObj instanceof LinkedTreeMap)) {
                return null;
            }
            Object coordObj = ((LinkedTreeMap)locObj).get((Object)"coordinates");
            if (coordObj instanceof Collection) {
                coords = ((Collection)coordObj).toArray();
            } else if (coordObj instanceof Object[]) {
                coords = (Object[])coordObj;
            } else {
                return null;
            }
            return Coordinate.builder().lat(((Number)coords[1]).floatValue()).lon(((Number)coords[0]).floatValue()).build();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public String timestamp() {
        return this.payload == null ? null : this.payload.timestamp;
    }

    @Nullable
    public Double bearing() {
        return this.bearing;
    }

    void setBearing(Double bearing) {
        this.bearing = bearing;
    }

    @Nullable
    public String rawVal(@NonNull String key) {
        try {
            if (this.payload == null || this.payload.data == null) {
                return null;
            }
            Object val = this.payload.data.get((Object)key);
            if (val == null) {
                return null;
            }
            if (val instanceof String) {
                return (String)val;
            }
            if (val instanceof Number) {
                return val.toString();
            }
            if (val instanceof LinkedTreeMap) {
                return StreamMessage.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)val)).toString();
            }
            if (val instanceof Collection) {
                return StreamMessage.convertCollectionToJSON((Collection)val).toString();
            }
            if (val instanceof Object[]) {
                return StreamMessage.convertArrayToJSON((Object[])val).toString();
            }
            if (val instanceof JSONObject || val instanceof JSONArray) {
                return val.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public String rawVal(@NonNull DataType dataType) {
        return this.rawVal(dataType.toString());
    }

    public double doubleVal(@NonNull String key, double def) {
        String raw = this.rawVal(key);
        if (raw != null) {
            try {
                return Double.parseDouble(raw);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public double doubleVal(@NonNull DataType dataType, double def) {
        return this.doubleVal(dataType.toString(), def);
    }

    public long longVal(@NonNull String key, long def) {
        return Math.round(this.doubleVal(key, (double)def));
    }

    public long longVal(@NonNull DataType dataType, long def) {
        return this.longVal(dataType.toString(), def);
    }

    public float floatVal(@NonNull String key, float def) {
        return Double.valueOf(this.doubleVal(key, (double)def)).floatValue();
    }

    public float floatVal(@NonNull DataType dataType, float def) {
        return this.floatVal(dataType.toString(), def);
    }

    public int intVal(@NonNull String key, int def) {
        return Long.valueOf(this.longVal(key, (long)def)).intValue();
    }

    public int intVal(@NonNull DataType dataType, int def) {
        return this.intVal(dataType.toString(), def);
    }

    @NonNull
    private static JSONObject convertLinkedTreeMapToJSON(LinkedTreeMap<String, Object> ltm) {
        Object[] objs;
        JSONObject jo = new JSONObject();
        for (Object obj : objs = ltm.entrySet().toArray()) {
            Map.Entry o = (Map.Entry)obj;
            try {
                if (o.getValue() instanceof LinkedTreeMap) {
                    jo.put(o.getKey().toString(), (Object)StreamMessage.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)o.getValue())));
                    continue;
                }
                jo.put(o.getKey().toString(), o.getValue());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jo;
    }

    @NonNull
    private static JSONArray convertCollectionToJSON(@NonNull Collection<Object> col) {
        JSONArray ja = new JSONArray();
        for (Object o : col) {
            if (o instanceof LinkedTreeMap) {
                ja.put((Object)StreamMessage.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)o)));
                continue;
            }
            ja.put(o);
        }
        return ja;
    }

    @NonNull
    private static JSONArray convertArrayToJSON(@NonNull Object[] arr) {
        JSONArray ja = new JSONArray();
        for (Object o : arr) {
            if (o instanceof LinkedTreeMap) {
                ja.put((Object)StreamMessage.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)o)));
                continue;
            }
            ja.put(o);
        }
        return ja;
    }

    static {
        VINLI_DATE_FMT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static abstract class GeometryFilter {
        static final String TYPE = "geometry";

        public abstract Direction direction();

        public abstract List<Coordinate.Seed> geometry();

        public abstract String deviceId();

        GeometryFilter() {
        }

        static final void registerGson(GsonBuilder gb) {
            gb.registerTypeAdapter(Seed.class, (Object)new Seed.Adapter());
        }

        public static final Seed.Builder create() {
            return new AutoParcel_StreamMessage_GeometryFilter_Seed.Builder();
        }

        public static abstract class Seed {
            private final String type = "geometry";

            @NonNull
            public abstract Direction direction();

            @NonNull
            public abstract List<Coordinate.Seed> geometry();

            @Nullable
            public abstract String deviceId();

            Seed() {
            }

            static final class Adapter
            extends TypeAdapter<Seed> {
                private Gson gson;

                Adapter() {
                }

                public void write(JsonWriter out, Seed value) throws IOException {
                    if (this.gson == null) {
                        this.gson = Vinli.curApp().gson();
                    }
                    out.beginObject();
                    out.name("type").value("filter");
                    if (value.deviceId() != null) {
                        out.name("id").value(value.deviceId());
                    }
                    out.name("filter").beginObject();
                    out.name("type").value(GeometryFilter.TYPE);
                    out.name("direction").value(value.direction().getDirectionAsString());
                    out.name(GeometryFilter.TYPE).beginObject();
                    out.name("type").value("Polygon");
                    out.name("coordinates").beginArray().beginArray();
                    for (Coordinate.Seed seed : value.geometry()) {
                        this.gson.toJson((Object)seed, Coordinate.Seed.class, out);
                    }
                    out.endArray().endArray();
                    out.endObject();
                    out.endObject();
                    out.endObject();
                }

                public Seed read(JsonReader in) throws IOException {
                    throw new UnsupportedOperationException("reading a GeometryFilter.Seed is not supported");
                }
            }

            public static abstract class Builder {
                public abstract Builder direction(@NonNull Direction var1);

                public abstract Builder geometry(@NonNull List<Coordinate.Seed> var1);

                public abstract Builder deviceId(@Nullable String var1);

                public abstract Seed build();

                Builder() {
                }
            }
        }

        public static enum Direction {
            INSIDE("inside"),
            OUTSIDE("outside");

            private String str;

            private Direction(String str) {
                this.str = str;
            }

            String getDirectionAsString() {
                return this.str;
            }
        }
    }

    public static abstract class ParametricFilter {
        static final String TYPE = "parametric";

        public abstract String parameter();

        public abstract Float min();

        public abstract Float max();

        public abstract String deviceId();

        ParametricFilter() {
        }

        static final void registerGson(GsonBuilder gb) {
            gb.registerTypeAdapter(Seed.class, (Object)new Seed.Adapter());
        }

        public static final Seed.Builder create() {
            return new AutoParcel_StreamMessage_ParametricFilter_Seed.Builder();
        }

        public static abstract class Seed {
            private final String type = "parametric";

            @NonNull
            public abstract String parameter();

            @Nullable
            public abstract Float min();

            @Nullable
            public abstract Float max();

            @Nullable
            public abstract String deviceId();

            Seed() {
            }

            static final class Adapter
            extends TypeAdapter<Seed> {
                private Gson gson;

                Adapter() {
                }

                public void write(JsonWriter out, Seed value) throws IOException {
                    if (this.gson == null) {
                        this.gson = Vinli.curApp().gson();
                    }
                    out.beginObject();
                    out.name("type").value("filter");
                    if (value.deviceId() != null) {
                        out.name("id").value(value.deviceId());
                    }
                    out.name("filter").beginObject();
                    out.name("type").value(ParametricFilter.TYPE);
                    out.name("parameter").value(value.parameter());
                    if (value.min() != null) {
                        out.name("min").value((Number)value.min());
                    }
                    if (value.max() != null) {
                        out.name("max").value((Number)value.max());
                    }
                    out.endObject();
                    out.endObject();
                }

                public Seed read(JsonReader in) throws IOException {
                    throw new UnsupportedOperationException("reading a ParametricFilter.Seed is not supported");
                }
            }

            public static abstract class Builder {
                public abstract Builder parameter(@NonNull String var1);

                public abstract Builder min(@Nullable Float var1);

                public abstract Builder max(@Nullable Float var1);

                public abstract Builder deviceId(@Nullable String var1);

                public abstract Seed build();

                Builder() {
                }
            }
        }
    }

    static class StreamMessagePayload {
        private String id;
        private String timestamp;
        private LinkedTreeMap<String, Object> data;

        StreamMessagePayload() {
        }
    }

    static class StreamMessageSubject {
        private String id;
        private String type;

        StreamMessageSubject() {
        }
    }

    public static enum DataType {
        RPM("rpm"),
        VEHICLE_SPEED("vehicleSpeed"),
        MASS_AIRFLOW("massAirFlow"),
        CALCULATED_ENGINE_LOAD("calculatedLoadValue"),
        ENGINE_COOLANT_TEMP("coolantTemp"),
        THROTTLE_POSITION("absoluteThrottleSensorPosition"),
        TIME_SINCE_ENGINE_START("runTimeSinceEngineStart"),
        FUEL_PRESSURE("fuelPressure"),
        INTAKE_AIR_TEMP("intakeAirTemperature"),
        INTAKE_MANIFOLD_PRESSURE("intakeManifoldPressure"),
        TIMING_ADVANCE("timingAdvance"),
        FUEL_RAIL_PRESSURE("fuelRailPressure");

        @NonNull
        private final String name;

        private DataType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

