/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.squareup.okhttp.HttpUrl;
import li.vin.net.Endpoint;
import li.vin.net.R;

public class SignInActivity
extends Activity {
    private static final String TAG = SignInActivity.class.getSimpleName();
    private static final String CLIENT_ID = "li.vin.net.SignInActivity#CLIENT_ID";
    private static final String REDIRECT_URI = "li.vin.net.SignInActivity#REDIRECT_URI";
    private static final String PENDING_INTENT = "li.vin.net.SignInActivity#PENDING_INTENT";
    private static final String ACTION_ERROR = "li.vin.net.signIn.ERROR";
    private static final String ACTION_APPROVED = "li.vin.net.signIn.APPROVED";
    private static final HttpUrl OAUTH_ENPOINT = new HttpUrl.Builder().scheme("https").host("auth" + Endpoint.domain()).addPathSegment("oauth").addPathSegment("authorization").addPathSegment("new").addQueryParameter("response_type", "token").build();

    static final Intent newIntent(@NonNull Context context, @NonNull String clientId, @NonNull String redirectUri, @NonNull PendingIntent pendingIntent) {
        Intent signInIntent = new Intent(context, SignInActivity.class);
        signInIntent.putExtra(CLIENT_ID, clientId);
        signInIntent.putExtra(REDIRECT_URI, redirectUri);
        signInIntent.putExtra(PENDING_INTENT, (Parcelable)pendingIntent);
        return signInIntent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getIntent().getExtras();
        if (extras == null) {
            throw new AssertionError((Object)"missing app info extras");
        }
        String clientId = extras.getString(CLIENT_ID);
        if (clientId == null) {
            throw new AssertionError((Object)"missing client ID");
        }
        final String redirectUri = extras.getString(REDIRECT_URI);
        if (redirectUri == null) {
            throw new AssertionError((Object)"missing redirect URI");
        }
        final PendingIntent pendingIntent = (PendingIntent)extras.getParcelable(PENDING_INTENT);
        if (pendingIntent == null) {
            throw new AssertionError((Object)"missing pending intent");
        }
        this.setContentView(R.layout.activity_vinli_sign_in);
        WebView wv = (WebView)this.findViewById(R.id.sign_in);
        wv.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Log.d((String)TAG, (String)("shouldOverrideUrlLoading: " + url));
                if (url.startsWith(redirectUri)) {
                    Intent resultIntent;
                    String error = null;
                    String accessToken = null;
                    try {
                        String[] fragmentPieces;
                        HttpUrl uri = HttpUrl.parse((String)url);
                        for (String piece : fragmentPieces = uri.fragment().split("&")) {
                            if (piece.startsWith("access_token=")) {
                                accessToken = piece.substring("access_token=".length());
                            } else {
                                if (!piece.startsWith("error=")) continue;
                                error = piece.substring("error=".length());
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        error = "redirect parse error: " + e;
                    }
                    if (error == null) {
                        if (accessToken == null) {
                            resultIntent = new Intent(SignInActivity.ACTION_ERROR);
                            resultIntent.putExtra("li.vin.net.Vinli#SIGN_IN_ERROR", "missing access_token");
                        } else {
                            Log.d((String)TAG, (String)("oauth accessToken: " + accessToken));
                            resultIntent = new Intent(SignInActivity.ACTION_APPROVED);
                            resultIntent.putExtra("li.vin.net.Vinli#ACCESS_TOKEN", accessToken);
                        }
                    } else {
                        Log.d((String)TAG, (String)("oauth error: " + error));
                        resultIntent = new Intent(SignInActivity.ACTION_ERROR);
                        resultIntent.putExtra("li.vin.net.Vinli#SIGN_IN_ERROR", error);
                    }
                    try {
                        pendingIntent.send((Context)SignInActivity.this, 0, resultIntent);
                        SignInActivity.this.finish();
                    }
                    catch (Exception e) {
                        Log.d((String)TAG, (String)("pending intent send error: " + e));
                    }
                    return true;
                }
                if (url.toLowerCase().contains("sign-up")) {
                    try {
                        SignInActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
                    }
                    catch (Exception e) {
                        Log.d((String)TAG, (String)"failed to launch sign up url", (Throwable)e);
                    }
                    return true;
                }
                return false;
            }
        });
        String url = OAUTH_ENPOINT.newBuilder().host("auth" + Endpoint.domain()).setQueryParameter("client_id", clientId).setQueryParameter("redirect_uri", redirectUri).toString();
        Log.d((String)"SignInActivity", (String)("loading url: " + url));
        wv.loadUrl(url);
    }
}

