/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_ObjectRef;
import li.vin.net.AutoParcel_Rule;
import li.vin.net.AutoParcel_Rule_Links;
import li.vin.net.AutoParcel_Rule_ParametricBoundary;
import li.vin.net.AutoParcel_Rule_ParametricBoundary_Seed;
import li.vin.net.AutoParcel_Rule_PolygonBoundary;
import li.vin.net.AutoParcel_Rule_PolygonBoundary_Seed;
import li.vin.net.AutoParcel_Rule_RadiusBoundary;
import li.vin.net.AutoParcel_Rule_RadiusBoundary_Seed;
import li.vin.net.AutoParcel_Rule_Seed;
import li.vin.net.Event;
import li.vin.net.ObjectRef;
import li.vin.net.Page;
import li.vin.net.Subscription;
import li.vin.net.TimeSeries;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import rx.Observable;

public abstract class Rule
implements VinliItem {
    static final Type PAGE_TYPE = new TypeToken<Page<Rule>>(){}.getType();
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<Rule>>(){}.getType();

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Rule.class, (Object)new RuleAdapter());
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(Rule.class));
        gb.registerTypeAdapter(PAGE_TYPE, Page.Adapter.create(PAGE_TYPE, Rule.class));
        gb.registerTypeAdapter(Links.class, AutoParcelAdapter.create(AutoParcel_Rule_Links.class));
        gb.registerTypeAdapter(ParametricBoundary.class, AutoParcelAdapter.create(AutoParcel_Rule_ParametricBoundary.class));
        gb.registerTypeAdapter(ParametricBoundary.Seed.class, AutoParcelAdapter.create(AutoParcel_Rule_ParametricBoundary_Seed.class));
        gb.registerTypeAdapter(RadiusBoundary.class, AutoParcelAdapter.create(AutoParcel_Rule_RadiusBoundary.class));
        gb.registerTypeAdapter(RadiusBoundary.Seed.class, AutoParcelAdapter.create(AutoParcel_Rule_RadiusBoundary_Seed.class));
        gb.registerTypeAdapter(PolygonBoundary.class, AutoParcelAdapter.create(AutoParcel_Rule_PolygonBoundary.class));
        gb.registerTypeAdapter(PolygonBoundary.Seed.class, AutoParcelAdapter.create(AutoParcel_Rule_PolygonBoundary_Seed.class));
        gb.registerTypeAdapter(Seed.class, (Object)new Seed.Adapter());
    }

    public static Observable<Rule> ruleWithId(@NonNull String ruleId) {
        return Vinli.curApp().rule(ruleId);
    }

    public static Observable<Page<Rule>> rulesWithDeviceId(@NonNull String deviceId) {
        return Rule.rulesWithDeviceId(deviceId, null, null);
    }

    public static Observable<Page<Rule>> rulesWithDeviceId(@NonNull String deviceId, @Nullable Integer limit, @Nullable Integer offset) {
        return Vinli.curApp().rules().rules(deviceId, limit, offset);
    }

    public static Observable<Page<Rule>> rulesWithVehicleId(@NonNull String vehicleId) {
        return Rule.rulesWithVehicleId(vehicleId, null, null);
    }

    public static Observable<Page<Rule>> rulesWithVehicleId(@NonNull String vehicleId, @Nullable Integer limit, @Nullable Integer offset) {
        return Vinli.curApp().rules().vehicleRules(vehicleId, limit, offset);
    }

    public static final Seed.Saver create() {
        return new AutoParcel_Rule_Seed.Builder();
    }

    public abstract String name();

    public abstract boolean evaluated();

    @Nullable
    public abstract Boolean covered();

    @Nullable
    public abstract String createdAt();

    @Nullable
    public abstract String deviceId();

    @Nullable
    public abstract PolygonBoundary polygonBoundary();

    @Nullable
    public abstract RadiusBoundary radiusBoundary();

    @NonNull
    public abstract List<ParametricBoundary> parametricBoundaries();

    @NonNull
    public abstract ObjectRef object();

    abstract Links links();

    Rule() {
    }

    public Observable<TimeSeries<Event>> events() {
        return Event.eventsWithDeviceId(this.deviceId(), "rule-*", this.id(), (Long)null, null, null, null);
    }

    public Observable<Page<Subscription>> subscriptions() {
        return Subscription.subscriptionsWithDeviceId(this.deviceId(), null, null, this.id(), "rule");
    }

    public Observable<Rule> fill() {
        return Rule.ruleWithId(this.id());
    }

    public Observable<Void> delete() {
        return Vinli.curApp().rules().delete(this.id());
    }

    private static final class RuleAdapter
    extends TypeAdapter<Rule> {
        private Gson gson;

        private RuleAdapter() {
        }

        public void write(JsonWriter out, Rule value) throws IOException {
            throw new UnsupportedOperationException("writing a Rule is not supported");
        }

        public Rule read(JsonReader in) throws IOException {
            if (this.gson == null) {
                this.gson = Vinli.curApp().gson();
            }
            Builder b = new AutoParcel_Rule.Builder().parametricBoundaries(Collections.emptyList());
            in.beginObject();
            block40: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "id": {
                        b.id(in.nextString());
                        continue block40;
                    }
                    case "name": {
                        b.name(in.nextString());
                        continue block40;
                    }
                    case "evaluated": {
                        b.evaluated(in.nextBoolean());
                        continue block40;
                    }
                    case "covered": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            continue block40;
                        }
                        b.covered(in.nextBoolean());
                        continue block40;
                    }
                    case "createdAt": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            continue block40;
                        }
                        b.createdAt(in.nextString());
                        continue block40;
                    }
                    case "deviceId": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            continue block40;
                        }
                        b.deviceId(in.nextString());
                        continue block40;
                    }
                    case "boundaries": {
                        ArrayList<ParametricBoundary> parametricBoundaries = new ArrayList<ParametricBoundary>();
                        in.beginArray();
                        block41: while (in.hasNext()) {
                            String type;
                            JsonObject boundary = (JsonObject)TypeAdapters.JSON_ELEMENT.read(in);
                            switch (type = boundary.getAsJsonPrimitive("type").getAsString()) {
                                case "parametric": {
                                    parametricBoundaries.add((ParametricBoundary)this.gson.fromJson((JsonElement)boundary, ParametricBoundary.class));
                                    continue block41;
                                }
                                case "polygon": {
                                    b.polygonBoundary((PolygonBoundary)this.gson.fromJson((JsonElement)boundary, PolygonBoundary.class));
                                    continue block41;
                                }
                                case "radius": {
                                    b.radiusBoundary((RadiusBoundary)this.gson.fromJson((JsonElement)boundary, RadiusBoundary.class));
                                    continue block41;
                                }
                            }
                            in.skipValue();
                        }
                        in.endArray();
                        b.parametricBoundaries(parametricBoundaries);
                        continue block40;
                    }
                    case "links": {
                        b.links((Links)this.gson.fromJson(in, Links.class));
                        continue block40;
                    }
                    case "object": {
                        ObjectRef.Builder bld = new AutoParcel_ObjectRef.Builder();
                        in.beginObject();
                        while (in.hasNext()) {
                            switch (in.nextName()) {
                                case "id": {
                                    bld = ((ObjectRef.Builder)bld).id(in.nextString());
                                    break;
                                }
                                case "type": {
                                    bld = ((ObjectRef.Builder)bld).type(in.nextString());
                                    break;
                                }
                            }
                        }
                        in.endObject();
                        b.object(((ObjectRef.Builder)bld).build());
                        continue block40;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return b.build();
        }
    }

    public static abstract class Seed {
        @NonNull
        public abstract String name();

        @Nullable
        public abstract PolygonBoundary.Seed polygonBoundary();

        @Nullable
        public abstract RadiusBoundary.Seed radiusBoundary();

        @Nullable
        public abstract List<ParametricBoundary.Seed> parametricBoundaries();

        @Nullable
        public abstract String deviceId();

        @Nullable
        public abstract String vehicleId();

        Seed() {
        }

        static final class Adapter
        extends TypeAdapter<Seed> {
            private Gson gson;

            Adapter() {
            }

            public void write(JsonWriter out, Seed value) throws IOException {
                List<ParametricBoundary.Seed> parametricBoundaries;
                RadiusBoundary.Seed radiusBoundary;
                if (this.gson == null) {
                    this.gson = Vinli.curApp().gson();
                }
                out.beginObject();
                out.name("rule").beginObject();
                out.name("name").value(value.name());
                out.name("boundaries").beginArray();
                PolygonBoundary.Seed polyBoundary = value.polygonBoundary();
                if (polyBoundary != null) {
                    this.gson.toJson((Object)polyBoundary, PolygonBoundary.Seed.class, out);
                }
                if ((radiusBoundary = value.radiusBoundary()) != null) {
                    this.gson.toJson((Object)radiusBoundary, RadiusBoundary.Seed.class, out);
                }
                if ((parametricBoundaries = value.parametricBoundaries()) != null) {
                    for (ParametricBoundary.Seed pb : parametricBoundaries) {
                        this.gson.toJson((Object)pb, ParametricBoundary.Seed.class, out);
                    }
                }
                out.endArray();
                out.endObject();
                out.endObject();
            }

            public Seed read(JsonReader in) throws IOException {
                throw new UnsupportedOperationException("reading a RuleSeed is not supported");
            }
        }

        public static abstract class Saver {
            public abstract Saver name(@NonNull String var1);

            public abstract Saver polygonBoundary(@Nullable PolygonBoundary.Seed var1);

            public abstract Saver radiusBoundary(@Nullable RadiusBoundary.Seed var1);

            public abstract Saver parametricBoundaries(@Nullable List<ParametricBoundary.Seed> var1);

            public abstract Saver deviceId(@Nullable String var1);

            public abstract Saver vehicleId(@Nullable String var1);

            Saver() {
            }

            abstract Seed autoBuild();

            public Observable<Rule> save() {
                Seed s = this.autoBuild();
                return Vinli.curApp().rules().create(s.deviceId(), s).map(Wrapped.pluckItem());
            }

            public Observable<Rule> vehicleSave() {
                Seed s = this.autoBuild();
                return Vinli.curApp().rules().vehicleCreate(s.vehicleId(), s).map(Wrapped.pluckItem());
            }
        }
    }

    public static abstract class PolygonBoundary
    implements VinliItem {
        static final String TYPE = "polygon";

        static final Builder builder() {
            return new AutoParcel_Rule_PolygonBoundary.Builder();
        }

        public static final Seed.Builder create() {
            return new AutoParcel_Rule_PolygonBoundary_Seed.Builder();
        }

        public abstract List<List<double[]>> coordinates();

        PolygonBoundary() {
        }

        public static abstract class Seed {
            private final String type = "polygon";

            public abstract List<List<double[]>> coordinates();

            public static abstract class Builder {
                public abstract Builder coordinates(List<List<double[]>> var1);

                public abstract Seed build();

                Builder() {
                }
            }
        }

        static interface Builder {
            public Builder id(String var1);

            public Builder coordinates(List<List<double[]>> var1);

            public PolygonBoundary build();
        }
    }

    public static abstract class RadiusBoundary
    implements VinliItem {
        static final String TYPE = "radius";

        static final Builder builder() {
            return new AutoParcel_Rule_RadiusBoundary.Builder();
        }

        public static final Seed.Builder create() {
            return new AutoParcel_Rule_RadiusBoundary_Seed.Builder();
        }

        public abstract float radius();

        public abstract float lon();

        public abstract float lat();

        RadiusBoundary() {
        }

        public static abstract class Seed {
            private final String type = "radius";

            public abstract float radius();

            public abstract float lon();

            public abstract float lat();

            public static abstract class Builder {
                public abstract Builder radius(float var1);

                public abstract Builder lon(float var1);

                public abstract Builder lat(float var1);

                public abstract Seed build();

                Builder() {
                }
            }
        }

        static interface Builder {
            public Builder id(String var1);

            public Builder radius(float var1);

            public Builder lon(float var1);

            public Builder lat(float var1);

            public RadiusBoundary build();
        }
    }

    public static abstract class ParametricBoundary
    implements VinliItem {
        static final String TYPE = "parametric";

        static final Builder builder() {
            return new AutoParcel_Rule_ParametricBoundary.Builder();
        }

        public static final Seed.Builder create() {
            return new AutoParcel_Rule_ParametricBoundary_Seed.Builder();
        }

        public abstract String parameter();

        @Nullable
        public abstract Float min();

        @Nullable
        public abstract Float max();

        ParametricBoundary() {
        }

        public static abstract class Seed {
            private final String type = "parametric";

            @NonNull
            public abstract String parameter();

            @Nullable
            public abstract Float min();

            @Nullable
            public abstract Float max();

            Seed() {
            }

            public static abstract class Builder {
                public abstract Builder parameter(@NonNull String var1);

                public abstract Builder min(@Nullable Float var1);

                public abstract Builder max(@Nullable Float var1);

                public abstract Seed build();

                Builder() {
                }
            }
        }

        static interface Builder {
            public Builder id(String var1);

            public Builder parameter(String var1);

            public Builder min(Float var1);

            public Builder max(Float var1);

            public ParametricBoundary build();
        }
    }

    static abstract class Builder {
        Builder() {
        }

        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder evaluated(boolean var1);

        public abstract Builder covered(@Nullable Boolean var1);

        public abstract Builder createdAt(@Nullable String var1);

        public abstract Builder deviceId(@Nullable String var1);

        public abstract Builder polygonBoundary(@Nullable PolygonBoundary var1);

        public abstract Builder radiusBoundary(@Nullable RadiusBoundary var1);

        public abstract Builder parametricBoundaries(List<ParametricBoundary> var1);

        public abstract Builder links(Links var1);

        public abstract Builder object(ObjectRef var1);

        public abstract Rule build();
    }

    static abstract class Links
    implements Parcelable {
        public abstract String self();

        @Nullable
        public abstract String events();

        @Nullable
        public abstract String subscriptions();

        Links() {
        }
    }
}

