/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_Odometer;
import li.vin.net.AutoParcel_Odometer_Links;
import li.vin.net.AutoParcel_Odometer_Seed;
import li.vin.net.DistanceUnit;
import li.vin.net.TimeSeries;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import rx.Observable;

public abstract class Odometer
implements VinliItem {
    static final Type TIME_SERIES_TYPE = new TypeToken<TimeSeries<Odometer>>(){}.getType();
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<Odometer>>(){}.getType();

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Odometer.class, AutoParcelAdapter.create(AutoParcel_Odometer.class));
        gb.registerTypeAdapter(Links.class, AutoParcelAdapter.create(AutoParcel_Odometer_Links.class));
        gb.registerTypeAdapter(Seed.class, (Object)new Seed.Adapter());
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(Odometer.class));
        gb.registerTypeAdapter(TIME_SERIES_TYPE, TimeSeries.Adapter.create(TIME_SERIES_TYPE, Odometer.class));
    }

    public static Observable<Odometer> odometerWithId(@NonNull String odometerId) {
        return Vinli.curApp().odometerReport(odometerId);
    }

    public static Observable<TimeSeries<Odometer>> odometersWithVehicleId(@NonNull String vehicleId) {
        return Odometer.odometersWithVehicleId(vehicleId, (Long)null, null, null, null);
    }

    public static Observable<TimeSeries<Odometer>> odometersWithVehicleId(@NonNull String vehicleId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().distances().odometerReports(vehicleId, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public static Observable<TimeSeries<Odometer>> odometersWithVehicleId(@NonNull String vehicleId, @Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().distances().odometerReports(vehicleId, sinceMs, untilMs, limit, sortDir);
    }

    public abstract String vehicleId();

    public abstract Double reading();

    public abstract String date();

    abstract Links links();

    public static final Seed.Saver create() {
        return new AutoParcel_Odometer_Seed.Builder();
    }

    public Observable<Void> delete() {
        return Vinli.curApp().distances().deleteOdometerReport(this.id());
    }

    public static abstract class Seed {
        @NonNull
        public abstract Double reading();

        @Nullable
        public abstract String date();

        @NonNull
        public abstract DistanceUnit unit();

        @NonNull
        public abstract String vehicleId();

        Seed() {
        }

        static final class Adapter
        extends TypeAdapter<Seed> {
            private Gson gson;

            Adapter() {
            }

            public void write(JsonWriter out, Seed value) throws IOException {
                if (this.gson == null) {
                    this.gson = Vinli.curApp().gson();
                }
                out.beginObject();
                out.name("odometer").beginObject();
                out.name("reading").value((Number)value.reading());
                String date = value.date();
                if (date != null) {
                    out.name("date").value(value.date());
                }
                out.name("unit").value(value.unit().getDistanceUnitStr());
                out.endObject();
                out.endObject();
            }

            public Seed read(JsonReader in) throws IOException {
                throw new UnsupportedOperationException("reading a OdometerSeed is not supported");
            }
        }

        public static abstract class Saver {
            public abstract Saver reading(@NonNull Double var1);

            public abstract Saver date(@Nullable String var1);

            public abstract Saver unit(@NonNull DistanceUnit var1);

            public abstract Saver vehicleId(@NonNull String var1);

            Saver() {
            }

            abstract Seed autoBuild();

            public Observable<Odometer> save() {
                Seed s = this.autoBuild();
                return Vinli.curApp().distances().createOdometerReport(s.vehicleId(), s).map(Wrapped.pluckItem());
            }
        }
    }

    static abstract class Links
    implements Parcelable {
        public abstract String vehicle();

        Links() {
        }
    }
}

