/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Looper;
import android.support.annotation.NonNull;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;

final class ObserverManager {
    static <T> void registerObserver(@NonNull Observer<T> cb, @NonNull Observable<T> observable) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new IllegalStateException("Must be called on UI thread.");
        }
        Subscription sub = observable.observeOn(AndroidSchedulers.mainThread()).subscribe(cb);
        if (!ObserverManager.callbacks().add(new CallbackSubscriptionTuple(cb, sub))) {
            throw new IllegalStateException("callback already registered.");
        }
    }

    static <T> void unregisterObserver(@NonNull Observer<T> cb) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new IllegalStateException("Must be called on UI thread.");
        }
        Iterator<CallbackSubscriptionTuple> i = ObserverManager.callbacks().iterator();
        while (i.hasNext()) {
            CallbackSubscriptionTuple cbSub = i.next();
            if (!cbSub.cb.equals(cb)) continue;
            cbSub.sub.unsubscribe();
            i.remove();
            return;
        }
    }

    private static Set<CallbackSubscriptionTuple> callbacks() {
        return InitOnDemandHolder.sCallbacks;
    }

    private ObserverManager() {
    }

    private static final class CallbackSubscriptionTuple {
        final Observer<?> cb;
        final Subscription sub;

        CallbackSubscriptionTuple(Observer<?> cb, Subscription sub) {
            this.cb = cb;
            this.sub = sub;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallbackSubscriptionTuple that = (CallbackSubscriptionTuple)o;
            return this.cb.equals(that.cb);
        }

        public int hashCode() {
            return this.cb.hashCode();
        }
    }

    private static final class InitOnDemandHolder {
        private static final Set<CallbackSubscriptionTuple> sCallbacks = new HashSet<CallbackSubscriptionTuple>();

        private InitOnDemandHolder() {
        }
    }
}

