/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Date;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_Notification;
import li.vin.net.AutoParcel_Notification_Links;
import li.vin.net.Page;
import li.vin.net.TimeSeries;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import rx.Observable;

public abstract class Notification
implements VinliItem {
    static final Type PAGE_TYPE = new TypeToken<Page<Notification>>(){}.getType();
    static final Type TIME_SERIES_TYPE = new TypeToken<TimeSeries<Notification>>(){}.getType();
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<Notification>>(){}.getType();

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Notification.class, AutoParcelAdapter.create(AutoParcel_Notification.class));
        gb.registerTypeAdapter(PAGE_TYPE, Page.Adapter.create(PAGE_TYPE, Notification.class));
        gb.registerTypeAdapter(TIME_SERIES_TYPE, TimeSeries.Adapter.create(TIME_SERIES_TYPE, Notification.class));
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(Notification.class));
        gb.registerTypeAdapter(Links.class, AutoParcelAdapter.create(AutoParcel_Notification_Links.class));
    }

    public static Observable<Notification> notificationWithId(@NonNull String notificationId) {
        return Vinli.curApp().notification(notificationId);
    }

    public static Observable<TimeSeries<Notification>> notificationsWithSubscriptionId(@NonNull String subscriptionId) {
        return Notification.notificationsWithSubscriptionId(subscriptionId, (Long)null, null, null, null);
    }

    public static Observable<TimeSeries<Notification>> notificationsWithSubscriptionId(@NonNull String subscriptionId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().notifications().notificationsForSubscription(subscriptionId, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public static Observable<TimeSeries<Notification>> notificationsWithSubscriptionId(@NonNull String subscriptionId, @Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().notifications().notificationsForSubscription(subscriptionId, sinceMs, untilMs, limit, sortDir);
    }

    public static Observable<TimeSeries<Notification>> notificationsWithEventId(@NonNull String eventId) {
        return Notification.notificationsWithEventId(eventId, (Long)null, null, null, null);
    }

    public static Observable<TimeSeries<Notification>> notificationsWithEventId(@NonNull String eventId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().notifications().notificationsForEvent(eventId, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public static Observable<TimeSeries<Notification>> notificationsWithEventId(@NonNull String eventId, @Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().notifications().notificationsForEvent(eventId, sinceMs, untilMs, limit, sortDir);
    }

    public abstract String createdAt();

    public abstract String eventId();

    public abstract String eventTimestamp();

    public abstract String eventType();

    public abstract String notifiedAt();

    public abstract String payload();

    public abstract String respondedAt();

    public abstract String response();

    public abstract int responseCode();

    public abstract String state();

    public abstract String subscriptionId();

    public abstract String url();

    abstract Links links();

    static abstract class Links {
        public abstract String self();

        public abstract String subscription();

        public abstract String event();

        Links() {
        }
    }
}

