/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.support.annotation.NonNull;
import java.lang.reflect.Method;
import rx.exceptions.Exceptions;

final class Duktaper {
    @NonNull
    private final Class<?> duktapeCls;
    @NonNull
    private final Object duktapeInst;
    private volatile Method evaluateStrStr;
    private volatile Method evaluateStr;

    @NonNull
    public static Duktaper create() {
        try {
            Class<?> duktapeCls = Class.forName("com.squareup.duktape.Duktape");
            if (duktapeCls == null) {
                throw new NullPointerException();
            }
            Object duktapeInst = duktapeCls.getDeclaredMethod("create", new Class[0]).invoke(null, new Object[0]);
            if (duktapeInst == null) {
                throw new NullPointerException();
            }
            return new Duktaper(duktapeCls, duktapeInst);
        }
        catch (UnsatisfiedLinkError ule) {
            throw Exceptions.propagate((Throwable)new RuntimeException("cannot link Duktape lib naturally."));
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private Duktaper(@NonNull Class<?> duktapeCls, @NonNull Object duktapeInst) {
        this.duktapeCls = duktapeCls;
        this.duktapeInst = duktapeInst;
    }

    public String evaluate(String script, String fileName) {
        try {
            return (String)this.evaluateStrStr().invoke(this.duktapeInst, script, fileName);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String evaluate(String script) {
        try {
            return (String)this.evaluateStr().invoke(this.duktapeInst, script);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void close() {
        try {
            this.duktapeCls.getDeclaredMethod("close", new Class[0]).invoke(this.duktapeInst, new Object[0]);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method evaluateStrStr() throws NoSuchMethodException {
        Method result = this.evaluateStrStr;
        if (result == null) {
            Duktaper duktaper = this;
            synchronized (duktaper) {
                result = this.evaluateStrStr;
                if (result == null) {
                    this.evaluateStrStr = result = this.duktapeCls.getDeclaredMethod("evaluate", String.class, String.class);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method evaluateStr() throws NoSuchMethodException {
        Method result = this.evaluateStr;
        if (result == null) {
            Duktaper duktaper = this;
            synchronized (duktaper) {
                result = this.evaluateStr;
                if (result == null) {
                    this.evaluateStr = result = this.duktapeCls.getDeclaredMethod("evaluate", String.class);
                }
            }
        }
        return result;
    }
}

