/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.support.annotation.NonNull;
import li.vin.net.DistanceList;
import li.vin.net.Odometer;
import li.vin.net.OdometerTrigger;
import li.vin.net.TimeSeries;
import li.vin.net.Wrapped;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;

public interface Distances {
    @GET(value="vehicles/{vehicleId}/distances")
    public Observable<DistanceList> distances(@Path(value="vehicleId") String var1, @Query(value="since") Long var2, @Query(value="until") Long var3, @Header(value="x-vinli-unit") String var4);

    @GET(value="vehicles/{vehicleId}/distances/_best")
    public Observable<Wrapped<DistanceList.Distance>> bestDistance(@Path(value="vehicleId") String var1, @Header(value="x-vinli-unit") String var2);

    @POST(value="vehicles/{vehicleId}/odometers")
    public Observable<Wrapped<Odometer>> createOdometerReport(@Path(value="vehicleId") String var1, @Body Odometer.Seed var2);

    @GET(value="vehicles/{vehicleId}/odometers")
    public Observable<TimeSeries<Odometer>> odometerReports(@Path(value="vehicleId") String var1, @Query(value="since") Long var2, @Query(value="until") Long var3, @Query(value="limit") Integer var4, @Query(value="sortDir") String var5);

    @GET(value="odometers/{odometerId}")
    public Observable<Wrapped<Odometer>> odometerReport(@Path(value="odometerId") String var1);

    @DELETE(value="odometers/{odometerId}")
    public Observable<Void> deleteOdometerReport(@Path(value="odometerId") String var1);

    @GET
    public Observable<TimeSeries<Odometer>> odometerReportsForUrl(@Url @NonNull String var1);

    @POST(value="vehicles/{vehicleId}/odometer_triggers")
    public Observable<Wrapped<OdometerTrigger>> createOdometerTrigger(@Path(value="vehicleId") String var1, @Body OdometerTrigger.Seed var2);

    @GET(value="odometer_triggers/{odometerTriggerId}")
    public Observable<Wrapped<OdometerTrigger>> odometerTrigger(@Path(value="odometerTriggerId") String var1);

    @DELETE(value="odometer_triggers/{odometerTriggerId}")
    public Observable<Void> deleteOdometerTrigger(@Path(value="odometerTriggerId") String var1);

    @GET(value="vehicles/{vehicleId}/odometer_triggers")
    public Observable<TimeSeries<OdometerTrigger>> odometerTriggers(@Path(value="vehicleId") String var1, @Query(value="since") Long var2, @Query(value="until") Long var3, @Query(value="limit") Integer var4, @Query(value="sortDir") String var5);

    @GET
    public Observable<TimeSeries<OdometerTrigger>> odometerTriggersForUrl(@Url @NonNull String var1);
}

