/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import li.vin.net.Coordinate;

class BearingCalculator {
    private static final double DISTANCE_THRESHOLD = 2.5E-4;
    private BearingFilter bearingFilter = new BearingFilter();
    private Coordinate previousLatLng = null;

    public void addCoordinate(Coordinate coordinate, String timestamp) {
        if (this.previousLatLng == null) {
            this.previousLatLng = coordinate;
            return;
        }
        double distance = Math.sqrt(Math.pow(coordinate.lat() - this.previousLatLng.lat(), 2.0) + Math.pow(coordinate.lon() - this.previousLatLng.lon(), 2.0));
        if (distance > 2.5E-4) {
            this.calcBearing(timestamp, coordinate, this.previousLatLng);
            this.previousLatLng = coordinate;
        }
    }

    private void calcBearing(String newTimestamp, Coordinate newCoord, Coordinate prevCoord) {
        double dLat = newCoord.lat() - prevCoord.lat();
        double dLon = newCoord.lon() - prevCoord.lon();
        double bearing = Math.atan2(Math.abs(dLat), Math.abs(dLon));
        bearing = Math.toDegrees(bearing);
        if (dLat > 0.0 && dLon == 0.0) {
            bearing = 0.0;
        } else if (dLat == 0.0 && dLon > 0.0) {
            bearing = 90.0;
        } else if (dLat < 0.0 && dLon == 0.0) {
            bearing = 180.0;
        } else if (dLat == 0.0 && dLon < 0.0) {
            bearing = 270.0;
        } else if (dLat > 0.0 && dLon > 0.0) {
            bearing = 90.0 - bearing;
        } else if (dLat > 0.0 && dLon < 0.0) {
            bearing += 270.0;
        } else if (dLat < 0.0 && dLon > 0.0) {
            bearing += 90.0;
        } else if (dLat < 0.0 && dLon < 0.0) {
            bearing = 180.0 + (90.0 - bearing);
        }
        this.bearingFilter.addBearing(bearing, BearingCalculator.posixFromISO(newTimestamp));
    }

    public double currentBearing() {
        return this.bearingFilter.getFilteredBearing();
    }

    private static long posixFromISO(String isoDate) {
        SimpleDateFormat fromFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
        Date date = null;
        try {
            date = fromFormat.parse(isoDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
        return date.getTime();
    }

    private static class BearingFilter {
        private static final int SIZE = 32;
        private static final long SHORTENED_TIME = 4000L;
        private LinkedList<Bearing> bearingList = new LinkedList();

        public void addBearing(double bearing, long posixTimestamp) {
            this.bearingList.addLast(new Bearing(bearing, posixTimestamp));
            if (this.bearingList.size() > 32) {
                this.bearingList.removeFirst();
            }
        }

        public double getFilteredBearing() {
            if (this.bearingList.size() == 0) {
                return 0.0;
            }
            LinkedList<Bearing> recentBearings = new LinkedList<Bearing>();
            Bearing latestBearing = this.bearingList.getLast();
            for (Bearing bearing : this.bearingList) {
                if (latestBearing.timestamp - bearing.timestamp > 4000L) continue;
                recentBearings.addLast(bearing);
            }
            double x = 0.0;
            double y = 0.0;
            Bearing previous = null;
            for (Bearing bearing : recentBearings) {
                long timestampDiff = bearing.timestamp - ((Bearing)recentBearings.getFirst()).timestamp;
                if (timestampDiff == 0L) {
                    timestampDiff = 1L;
                }
                x += Math.cos(Math.toRadians(bearing.bearing)) * (double)(previous == null ? 1L : timestampDiff);
                y += Math.sin(Math.toRadians(bearing.bearing)) * (double)(previous == null ? 1L : timestampDiff);
                previous = bearing;
            }
            return Math.toDegrees(Math.atan2(y, x));
        }

        public static class Bearing {
            public double bearing;
            public long timestamp;

            public Bearing(double bearing, long timestamp) {
                this.bearing = bearing;
                this.timestamp = timestamp;
            }
        }
    }
}

