/*
 * Decompiled with CFR 0.152.
 */
package lc.kra.system.keyboard;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import lc.kra.system.GlobalHookMode;
import lc.kra.system.LibraryLoader;
import lc.kra.system.keyboard.event.GlobalKeyEvent;
import lc.kra.system.keyboard.event.GlobalKeyListener;

public class GlobalKeyboardHook {
    private static final int STATUS_SUCCESS = 0;
    private NativeKeyboardHook keyboardHook;
    private BlockingQueue<GlobalKeyEvent> inputBuffer = new LinkedBlockingQueue<GlobalKeyEvent>();
    private boolean menuPressed;
    private boolean shiftPressed;
    private boolean controlPressed;
    private boolean winPressed;
    private boolean extendedKey;
    private List<GlobalKeyListener> listeners = new CopyOnWriteArrayList<GlobalKeyListener>();
    private Set<Integer> heldDownKeyCodes = new HashSet<Integer>();
    private Thread eventDispatcher = new Thread(){
        {
            this.setName("Global Keyboard Hook Dispatcher");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (GlobalKeyboardHook.this.isAlive()) {
                    GlobalKeyEvent event = (GlobalKeyEvent)GlobalKeyboardHook.this.inputBuffer.take();
                    if (event.getTransitionState() == 1) {
                        GlobalKeyboardHook.this.keyPressed(event);
                        continue;
                    }
                    GlobalKeyboardHook.this.keyReleased(event);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public GlobalKeyboardHook() throws UnsatisfiedLinkError {
        this(false);
    }

    public GlobalKeyboardHook(boolean raw) throws UnsatisfiedLinkError {
        this(raw ? GlobalHookMode.RAW : GlobalHookMode.DEFAULT);
    }

    public GlobalKeyboardHook(GlobalHookMode mode) throws UnsatisfiedLinkError {
        LibraryLoader.loadLibrary();
        this.keyboardHook = new NativeKeyboardHook(mode){

            @Override
            public void handleKey(int virtualKeyCode, int transitionState, char keyChar, long deviceHandle) {
                GlobalKeyboardHook.this.switchControlKeys(virtualKeyCode, transitionState);
                GlobalKeyboardHook.this.inputBuffer.add(new GlobalKeyEvent(this, virtualKeyCode, transitionState, keyChar, GlobalKeyboardHook.this.menuPressed, GlobalKeyboardHook.this.shiftPressed, GlobalKeyboardHook.this.controlPressed, GlobalKeyboardHook.this.winPressed, GlobalKeyboardHook.this.extendedKey, deviceHandle));
            }
        };
        this.eventDispatcher.start();
    }

    public void addKeyListener(GlobalKeyListener listener) {
        this.listeners.add(listener);
    }

    public void removeKeyListener(GlobalKeyListener listener) {
        this.listeners.remove(listener);
    }

    private void keyPressed(GlobalKeyEvent event) {
        this.heldDownKeyCodes.add(event.getVirtualKeyCode());
        for (GlobalKeyListener listener : this.listeners) {
            listener.keyPressed(event);
        }
    }

    private void keyReleased(GlobalKeyEvent event) {
        this.heldDownKeyCodes.remove(event.getVirtualKeyCode());
        for (GlobalKeyListener listener : this.listeners) {
            listener.keyReleased(event);
        }
    }

    public boolean isKeyHeldDown(int virtualKeyCode) {
        return this.heldDownKeyCodes.contains(virtualKeyCode);
    }

    public boolean areKeysHeldDown(int ... virtualKeyCodes) {
        for (int keyCode : virtualKeyCodes) {
            if (this.isKeyHeldDown(keyCode)) continue;
            return false;
        }
        return true;
    }

    public boolean isAlive() {
        return this.keyboardHook != null && this.keyboardHook.isAlive();
    }

    public void shutdownHook() {
        if (this.isAlive()) {
            this.keyboardHook.unregisterHook();
            try {
                this.keyboardHook.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Map<Long, String> listKeyboards() throws UnsatisfiedLinkError {
        LibraryLoader.loadLibrary();
        return NativeKeyboardHook.listDevices();
    }

    private void switchControlKeys(int virtualKeyCode, int transitionState) {
        boolean downTransition = transitionState == 1;
        switch (virtualKeyCode) {
            case 92: {
                this.extendedKey = downTransition;
            }
            case 91: {
                this.winPressed = downTransition;
                break;
            }
            case 165: {
                this.extendedKey = downTransition;
            }
            case 18: 
            case 164: {
                this.menuPressed = downTransition;
                break;
            }
            case 161: {
                this.extendedKey = downTransition;
            }
            case 16: 
            case 160: {
                this.shiftPressed = downTransition;
                break;
            }
            case 163: {
                this.extendedKey = downTransition;
            }
            case 17: 
            case 162: {
                this.controlPressed = downTransition;
            }
        }
    }

    private static abstract class NativeKeyboardHook
    extends Thread {
        private int status;
        private GlobalHookMode mode;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NativeKeyboardHook(GlobalHookMode mode) {
            super("Global Keyboard Hook Thread");
            this.setDaemon(false);
            this.setPriority(10);
            NativeKeyboardHook nativeKeyboardHook = this;
            synchronized (nativeKeyboardHook) {
                this.mode = mode;
                try {
                    this.start();
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (this.status != 0) {
                    throw new RuntimeException("Low-level keyboard hook failed (" + this.status + ")");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.status = this.registerHook(this.mode.ordinal());
            NativeKeyboardHook nativeKeyboardHook = this;
            synchronized (nativeKeyboardHook) {
                this.notifyAll();
            }
        }

        public final native int registerHook(int var1);

        public final native void unregisterHook();

        public static final native Map<Long, String> listDevices();

        public abstract void handleKey(int var1, int var2, char var3, long var4);
    }
}

