/*
 * Decompiled with CFR 0.152.
 */
package lc.kra.system;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.zip.CRC32;

public class LibraryLoader {
    private static final String LIBRARY_NAME = "systemhook";
    private static boolean libraryLoad;

    public static synchronized void loadLibrary() throws UnsatisfiedLinkError {
        if (libraryLoad) {
            return;
        }
        String libName = System.getProperty("systemhook.lib.name", System.mapLibraryName(LIBRARY_NAME).replaceAll("\\.jnilib$", "\\.dylib"));
        String libPath = System.getProperty("systemhook.lib.path");
        try {
            if (libPath == null) {
                System.loadLibrary(libName);
            } else {
                System.load(new File(libPath, libName).getAbsolutePath());
            }
            libraryLoad = true;
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            libName = System.mapLibraryName("systemhook-" + LibraryLoader.getOperatingSystemName() + '-' + LibraryLoader.getOperatingSystemArchitecture()).replaceAll("\\.jnilib$", "\\.dylib");
            String libNameExtension = libName.substring(libName.lastIndexOf(46));
            String libResourcePath = LibraryLoader.class.getPackage().getName().replace('.', '/') + "/lib/" + libName;
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int read;
                inputStream = LibraryLoader.class.getClassLoader().getResourceAsStream(libResourcePath);
                if (inputStream == null) {
                    throw new FileNotFoundException("lib: " + libName + " not found in lib directory");
                }
                File tempFile = File.createTempFile("systemhook-", libNameExtension);
                CRC32 checksum = new CRC32();
                outputStream = new FileOutputStream(tempFile);
                byte[] buffer = new byte[1024];
                while ((read = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, read);
                    checksum.update(buffer, 0, read);
                }
                outputStream.close();
                File libFile = new File(tempFile.getParentFile(), "systemhook+" + checksum.getValue() + libNameExtension);
                if (!libFile.exists()) {
                    tempFile.renameTo(libFile);
                } else {
                    tempFile.delete();
                }
                System.load(libFile.getAbsolutePath());
                libraryLoad = true;
            }
            catch (IOException e) {
                throw new UnsatisfiedLinkError(e.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return;
        }
    }

    private static String getOperatingSystemName() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (osName.startsWith("windows")) {
            return "windows";
        }
        if (osName.startsWith("linux")) {
            return "linux";
        }
        if (osName.startsWith("mac os")) {
            return "darwin";
        }
        if (osName.startsWith("sunos") || osName.startsWith("solaris")) {
            return "solaris";
        }
        return osName;
    }

    private static String getOperatingSystemArchitecture() {
        String osArch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if ((osArch.startsWith("i") || osArch.startsWith("x")) && osArch.endsWith("86")) {
            return "x86";
        }
        if ((osArch.equals("i86") || osArch.startsWith("amd")) && osArch.endsWith("64")) {
            return "amd64";
        }
        if (osArch.startsWith("arm")) {
            return "arm";
        }
        if (osArch.startsWith("sparc")) {
            return !osArch.endsWith("64") ? "sparc" : "sparc64";
        }
        if (osArch.startsWith("ppc")) {
            return !osArch.endsWith("64") ? "ppc" : "ppc64";
        }
        return osArch;
    }
}

