/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import kr.jm.utils.elasticsearch.JMElasticsearchUtil;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;

public class JMElasticsearchDelete {
    private final Client esClient;

    public JMElasticsearchDelete(Client elasticsearchClient) {
        this.esClient = elasticsearchClient;
    }

    public DeleteResponse deleteQuery(DeleteRequestBuilder deleteRequestBuilder) {
        return (DeleteResponse)JMElasticsearchUtil.logRequestQueryAndReturn("deleteQuery", deleteRequestBuilder, deleteRequestBuilder.execute());
    }

    public AcknowledgedResponse deleteIndices(String ... indices) {
        DeleteIndexRequestBuilder requestBuilder = this.esClient.admin().indices().prepareDelete(indices);
        return (AcknowledgedResponse)JMElasticsearchUtil.logRequestQueryAndReturn("deleteIndices", requestBuilder, requestBuilder.execute());
    }

    public DeleteResponse deleteDoc(String index, String type, String id) {
        return this.deleteQuery(this.esClient.prepareDelete(index, type, id));
    }
}

