/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import java.util.Map;
import kr.jm.utils.elasticsearch.JMElasticsearchUtil;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;

public class JMElasticsearchIndex {
    private Client jmESClient;

    public JMElasticsearchIndex(Client elasticsearchClient) {
        this.jmESClient = elasticsearchClient;
    }

    public IndexResponse indexQuery(IndexRequestBuilder indexRequestBuilder) {
        return (IndexResponse)JMElasticsearchUtil.logRequestQueryAndReturn("indexQuery", indexRequestBuilder, indexRequestBuilder.execute());
    }

    public ActionFuture<IndexResponse> indexQueryAsync(IndexRequestBuilder indexRequestBuilder) {
        return JMElasticsearchUtil.logRequestQuery("indexQueryAsync", indexRequestBuilder, new Object[0]).execute();
    }

    private IndexRequestBuilder buildIndexRequest(String jsonSource, String index, String type, String id) {
        return this.buildIndexRequest(JMElasticsearchUtil.buildSourceByJsonMapper(jsonSource), index, type, id);
    }

    private IndexRequestBuilder buildIndexRequest(Map<String, ?> source, String index, String type, String id) {
        return this.getPrepareIndex(index, type, id).setSource(source);
    }

    private IndexRequestBuilder getPrepareIndex(String index, String type, String id) {
        return id == null ? this.jmESClient.prepareIndex(index, type) : this.jmESClient.prepareIndex(index, type, id);
    }

    private UpdateRequestBuilder buildPrepareUpsert(String index, String type, String id, String jsonString) {
        return this.jmESClient.prepareUpdate(index, type, id).setDoc(new Object[]{jsonString}).setUpsert(new IndexRequest(index, type, id).source(new Object[]{jsonString}));
    }

    private UpdateRequestBuilder buildPrepareUpsert(String index, String type, String id, Map<String, ?> source) {
        return this.jmESClient.prepareUpdate(index, type, id).setDoc(source).setUpsert(new IndexRequest(index, type, id).source(source));
    }

    public UpdateResponse upsertQuery(UpdateRequestBuilder updateRequestBuilder) {
        return (UpdateResponse)JMElasticsearchUtil.logRequestQueryAndReturn("upsertQuery", updateRequestBuilder, updateRequestBuilder.execute());
    }

    public ActionFuture<UpdateResponse> upsertQueryAsync(UpdateRequestBuilder updateRequestBuilder) {
        return JMElasticsearchUtil.logRequestQuery("upsertQueryAsync", updateRequestBuilder, new Object[0]).execute();
    }

    public UpdateResponse upsertData(Map<String, ?> source, String index, String type, String id) {
        return this.upsertQuery(this.buildPrepareUpsert(index, type, id, source));
    }

    public ActionFuture<UpdateResponse> upsertDataAsync(Map<String, ?> source, String index, String type, String id) {
        return this.upsertQueryAsync(this.buildPrepareUpsert(index, type, id, source));
    }

    public UpdateResponse upsertData(String jsonSource, String index, String type, String id) {
        return this.upsertQuery(this.buildPrepareUpsert(index, type, id, jsonSource));
    }

    public ActionFuture<UpdateResponse> upsertDataAsync(String jsonSource, String index, String type, String id) {
        return this.upsertQueryAsync(this.buildPrepareUpsert(index, type, id, jsonSource));
    }

    public UpdateResponse upsertDataWithObjectMapper(Object sourceObject, String index, String type, String id) {
        return this.upsertData(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject), index, type, id);
    }

    public ActionFuture<UpdateResponse> upsertDataASyncWithObjectMapper(Object sourceObject, String index, String type, String id) {
        return this.upsertDataAsync(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject), index, type, id);
    }

    public IndexResponse sendData(Map<String, ?> source, String index, String type, String id) {
        return this.indexQuery(this.buildIndexRequest(source, index, type, id));
    }

    public String sendData(Map<String, ?> source, String index, String type) {
        return this.sendData(source, index, type, null).getId();
    }

    public IndexResponse sendData(String jsonSource, String index, String type, String id) {
        return this.indexQuery(this.buildIndexRequest(jsonSource, index, type, id));
    }

    public String sendData(String jsonSource, String index, String type) {
        return this.sendData(jsonSource, index, type, null).getId();
    }

    public IndexResponse sendDataWithObjectMapper(Object sourceObject, String index, String type, String id) {
        return this.sendData(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject), index, type, id);
    }

    public String sendDataWithObjectMapper(Object sourceObject, String index, String type) {
        return this.sendDataWithObjectMapper(sourceObject, index, type, null).getId();
    }

    public ActionFuture<IndexResponse> sendDataAsync(Map<String, ?> source, String index, String type, String id) {
        return this.indexQueryAsync(this.buildIndexRequest(source, index, type, id));
    }

    public ActionFuture<IndexResponse> sendDataAsync(Map<String, ?> source, String index, String type) {
        return this.indexQueryAsync(this.buildIndexRequest(source, index, type, null));
    }

    public ActionFuture<IndexResponse> sendDataAsync(String jsonSource, String index, String type, String id) {
        return this.indexQueryAsync(this.buildIndexRequest(jsonSource, index, type, id));
    }

    public ActionFuture<IndexResponse> sendDataAsync(String jsonSource, String index, String type) {
        return this.indexQueryAsync(this.buildIndexRequest(jsonSource, index, type, null));
    }

    public ActionFuture<IndexResponse> sendDataAsyncWithObjectMapper(Object sourceObject, String index, String type, String id) {
        return this.indexQueryAsync(this.buildIndexRequest(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject), index, type, id));
    }

    public ActionFuture<IndexResponse> sendDataAsyncWithObjectMapper(Object sourceObject, String index, String type) {
        return this.indexQueryAsync(this.buildIndexRequest(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject), index, type, null));
    }
}

