/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.elasticsearch;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kr.jm.utils.elasticsearch.JMElasticsearchClient;
import kr.jm.utils.elasticsearch.JMElasticsearchUtil;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMPredicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JMElasticsearchBulk {
    private static final Logger log = LoggerFactory.getLogger(JMElasticsearchBulk.class);
    private JMElasticsearchClient jmESClient;
    private BulkProcessor bulkProcessor;
    private ActionListener<BulkResponse> bulkResponseActionListener = new ActionListener<BulkResponse>(){

        public void onResponse(BulkResponse bulkResponse) {
            if (bulkResponse.hasFailures()) {
                JMExceptionManager.handleException((Logger)log, (Throwable)new RuntimeException("ElasticSearch Insert Bulk Error !!!"), (String)"onResponse", (Object[])new Object[]{bulkResponse.buildFailureMessage()});
            } else {
                JMElasticsearchBulk.this.logBulkSendingSuccess(bulkResponse);
            }
        }

        public void onFailure(Exception e) {
            JMExceptionManager.handleException((Logger)log, (Throwable)e, (String)"onFailure", (Object[])new Object[0]);
        }
    };
    private BulkProcessor.Listener bulkProcessorListener = new BulkProcessor.Listener(){

        public void beforeBulk(long executionId, BulkRequest bulkRequest) {
            log.debug("[Before] Sending Bulk - size = {}, estimatedSizeInBytes = {}", (Object)bulkRequest.requests().size(), (Object)bulkRequest.estimatedSizeInBytes());
        }

        public void afterBulk(long executionId, BulkRequest bulkRequest, Throwable failure) {
            JMExceptionManager.handleException((Logger)log, (Throwable)failure, (String)"afterBulk", (Object[])new Object[]{executionId, bulkRequest.getDescription()});
        }

        public void afterBulk(long executionId, BulkRequest request, BulkResponse bulkResponse) {
            JMElasticsearchBulk.this.logBulkSendingSuccess(bulkResponse);
        }
    };

    JMElasticsearchBulk(JMElasticsearchClient jmElasticsearchClient) {
        this.jmESClient = jmElasticsearchClient;
    }

    private void logBulkSendingSuccess(BulkResponse bulkResponse) {
        log.debug("[Success] Sending Bulk - size = {}, tookInMillis = {}", (Object)bulkResponse.getItems().length, (Object)bulkResponse.getTook().millis());
    }

    private BulkProcessor setAndReturnBulkProcessor(BulkProcessor bulkProcessor) {
        this.bulkProcessor = bulkProcessor;
        return this.bulkProcessor;
    }

    public void setBulkProcessor(int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        this.setBulkProcessor(this.bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds);
    }

    public void setBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        this.bulkProcessor = this.buildBulkProcessor(bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds);
    }

    public BulkProcessor.Builder getBulkProcessorBuilder(BulkProcessor.Listener bulkProcessorListener, Integer bulkActions, ByteSizeValue byteSizeValue, TimeValue flushInterval, Integer concurrentRequests, BackoffPolicy backoffPolicy) {
        BulkProcessor.Builder builder = BulkProcessor.builder((Client)this.jmESClient, (BulkProcessor.Listener)bulkProcessorListener);
        JMOptional.ifNotNull((Object)bulkActions, arg_0 -> ((BulkProcessor.Builder)builder).setBulkActions(arg_0));
        JMOptional.ifNotNull((Object)byteSizeValue, arg_0 -> ((BulkProcessor.Builder)builder).setBulkSize(arg_0));
        JMOptional.ifNotNull((Object)flushInterval, arg_0 -> ((BulkProcessor.Builder)builder).setFlushInterval(arg_0));
        JMOptional.ifNotNull((Object)concurrentRequests, arg_0 -> ((BulkProcessor.Builder)builder).setConcurrentRequests(arg_0));
        JMOptional.ifNotNull((Object)backoffPolicy, arg_0 -> ((BulkProcessor.Builder)builder).setBackoffPolicy(arg_0));
        return builder;
    }

    public BulkProcessor buildBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds, Integer concurrentRequests, BackoffPolicy backoffPolicy) {
        return this.getBulkProcessorBuilder(bulkProcessorListener, bulkActions, new ByteSizeValue(bulkSizeKB, ByteSizeUnit.KB), TimeValue.timeValueSeconds((long)flushIntervalSeconds), concurrentRequests, backoffPolicy).build();
    }

    public BulkProcessor buildBulkProcessor(BulkProcessor.Listener bulkProcessorListener, int bulkActions, long bulkSizeKB, int flushIntervalSeconds) {
        return this.buildBulkProcessor(bulkProcessorListener, bulkActions, bulkSizeKB, flushIntervalSeconds, null, null);
    }

    public void sendWithBulkProcessor(List<? extends Map<String, ?>> bulkSource, String index, String type) {
        this.sendWithBulkProcessor(bulkSource.stream().map(source -> this.buildIndexRequest(index, type, null).source(source)).collect(Collectors.toList()));
    }

    public void sendWithBulkProcessor(Map<String, ?> source, String index, String type) {
        this.sendWithBulkProcessor(source, index, type, null);
    }

    public void sendWithBulkProcessor(Map<String, ?> source, String index, String type, String id) {
        this.sendWithBulkProcessor(this.buildIndexRequest(index, type, id).source(source));
    }

    public void sendWithBulkProcessorAndObjectMapper(List<Object> bulkObject, String index, String type) {
        this.sendWithBulkProcessor(bulkObject.stream().map(sourceObject -> this.buildIndexRequest(index, type, null).source(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject))).collect(Collectors.toList()));
    }

    private IndexRequest buildIndexRequest(String index, String type, String id) {
        return id == null ? new IndexRequest(index, type) : new IndexRequest(index, type, id);
    }

    public void sendWithBulkProcessorAndObjectMapper(Object object, String index, String type) {
        this.sendWithBulkProcessorAndObjectMapper(object, index, type, null);
    }

    public void sendWithBulkProcessorAndObjectMapper(Object object, String index, String type, String id) {
        this.sendWithBulkProcessor(this.buildIndexRequest(index, type, id).source(JMElasticsearchUtil.buildSourceByJsonMapper(object)));
    }

    public void sendWithBulkProcessor(List<IndexRequest> indexRequestList) {
        indexRequestList.forEach(this::sendWithBulkProcessor);
    }

    public void sendWithBulkProcessor(IndexRequest indexRequest) {
        Optional.ofNullable(this.bulkProcessor).orElseGet(() -> this.setAndReturnBulkProcessor(BulkProcessor.builder((Client)this.jmESClient, (BulkProcessor.Listener)this.bulkProcessorListener).build())).add(indexRequest);
    }

    public void closeBulkProcessor() {
        Optional.ofNullable(this.bulkProcessor).filter(JMPredicate.peek(BulkProcessor::flush)).ifPresent(BulkProcessor::close);
    }

    public void sendBulkDataAsync(List<? extends Map<String, ?>> bulkSourceList, String index, String type) {
        this.executeBulkRequestAsync(this.buildBulkIndexRequestBuilder(bulkSourceList.stream().map(source -> this.jmESClient.prepareIndex(index, type).setSource(source)).collect(Collectors.toList())));
    }

    public void sendBulkDataAsync(List<? extends Map<String, ?>> bulkSourceList, String index, String type, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.executeBulkRequestAsync(this.buildBulkIndexRequestBuilder(bulkSourceList.stream().map(source -> this.jmESClient.prepareIndex(index, type).setSource(source)).collect(Collectors.toList())), bulkResponseActionListener);
    }

    public void sendBulkDataWithObjectMapperAsync(List<Object> objectBulkData, String index, String type) {
        this.executeBulkRequestAsync(this.buildBulkIndexRequestBuilder(objectBulkData.stream().map(sourceObject -> this.jmESClient.prepareIndex(index, type).setSource(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject))).collect(Collectors.toList())));
    }

    public void sendBulkDataWithObjectMapperAsync(List<Object> objectBulkData, String index, String type, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.executeBulkRequestAsync(this.buildBulkIndexRequestBuilder(objectBulkData.stream().map(sourceObject -> this.jmESClient.prepareIndex(index, type).setSource(JMElasticsearchUtil.buildSourceByJsonMapper(sourceObject))).collect(Collectors.toList())), bulkResponseActionListener);
    }

    public BulkRequestBuilder buildBulkIndexRequestBuilder(List<IndexRequestBuilder> indexRequestBuilderList) {
        BulkRequestBuilder bulkRequestBuilder = this.jmESClient.prepareBulk();
        for (IndexRequestBuilder indexRequestBuilder : indexRequestBuilderList) {
            bulkRequestBuilder.add(indexRequestBuilder);
        }
        return bulkRequestBuilder;
    }

    public BulkRequestBuilder buildDeleteBulkRequestBuilder(List<DeleteRequestBuilder> deleteRequestBuilderList) {
        BulkRequestBuilder bulkRequestBuilder = this.jmESClient.prepareBulk();
        for (DeleteRequestBuilder deleteRequestBuilder : deleteRequestBuilderList) {
            bulkRequestBuilder.add(deleteRequestBuilder);
        }
        return bulkRequestBuilder;
    }

    public BulkRequestBuilder buildUpdateBulkRequestBuilder(List<UpdateRequestBuilder> updateRequestBuilderList) {
        BulkRequestBuilder bulkRequestBuilder = this.jmESClient.prepareBulk();
        for (UpdateRequestBuilder updateRequestBuilder : updateRequestBuilderList) {
            bulkRequestBuilder.add(updateRequestBuilder);
        }
        return bulkRequestBuilder;
    }

    public void executeBulkRequestAsync(BulkRequestBuilder bulkRequestBuilder) {
        this.executeBulkRequestAsync(bulkRequestBuilder, this.bulkResponseActionListener);
    }

    public void executeBulkRequestAsync(BulkRequestBuilder bulkRequestBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        JMLog.info((Logger)log, (String)"executeBulkRequestAsync", (Object[])new Object[]{bulkRequestBuilder, bulkResponseActionListener});
        bulkRequestBuilder.execute(bulkResponseActionListener);
    }

    public BulkResponse executeBulkRequest(BulkRequestBuilder bulkRequestBuilder) {
        JMLog.info((Logger)log, (String)"executeBulkRequest", (Object[])new Object[]{bulkRequestBuilder});
        return (BulkResponse)bulkRequestBuilder.execute().actionGet();
    }

    public boolean deleteBulkDocs(String index, String type) {
        return this.executeBulkRequest(this.buildDeleteBulkRequestBuilder(this.buildAllDeleteRequestBuilderList(index, type))).hasFailures();
    }

    public BulkResponse deleteBulkDocs(String index, String type, QueryBuilder filterQueryBuilder) {
        return this.executeBulkRequest(this.buildDeleteBulkRequestBuilder(this.buildExtractDeleteRequestBuilderList(index, type, filterQueryBuilder)));
    }

    public boolean deleteBulkDocs(List<String> indexList, List<String> typeList, QueryBuilder filterQueryBuilder) {
        return indexList.stream().flatMap(index -> typeList.stream().map(type -> this.deleteBulkDocs((String)index, (String)type, filterQueryBuilder))).noneMatch(BulkResponse::hasFailures);
    }

    public void deleteBulkDocsAsync(String index, String type) {
        this.executeBulkRequestAsync(this.buildDeleteBulkRequestBuilder(this.buildAllDeleteRequestBuilderList(index, type)));
    }

    public void deleteBulkDocsAsync(String index, String type, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.executeBulkRequestAsync(this.buildDeleteBulkRequestBuilder(this.buildAllDeleteRequestBuilderList(index, type)), bulkResponseActionListener);
    }

    public void deleteBulkDocsAsync(String index, String type, QueryBuilder filterQueryBuilder) {
        this.executeBulkRequestAsync(this.buildDeleteBulkRequestBuilder(this.buildExtractDeleteRequestBuilderList(index, type, filterQueryBuilder)));
    }

    public void deleteBulkDocsAsync(List<String> indexList, List<String> typeList, QueryBuilder filterQueryBuilder) {
        indexList.forEach(index -> typeList.forEach(type -> this.deleteBulkDocsAsync((String)index, (String)type, filterQueryBuilder)));
    }

    public void deleteBulkDocsAsync(String index, String type, QueryBuilder filterQueryBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        this.executeBulkRequestAsync(this.buildDeleteBulkRequestBuilder(this.buildExtractDeleteRequestBuilderList(index, type, filterQueryBuilder)), bulkResponseActionListener);
    }

    public void deleteBulkDocsAsync(List<String> indexList, List<String> typeList, QueryBuilder filterQueryBuilder, ActionListener<BulkResponse> bulkResponseActionListener) {
        indexList.forEach(index -> typeList.forEach(type -> this.deleteBulkDocsAsync((String)index, (String)type, filterQueryBuilder, bulkResponseActionListener)));
    }

    private List<DeleteRequestBuilder> buildAllDeleteRequestBuilderList(String index, String type) {
        return this.buildDeleteRequestBuilderList(index, type, this.jmESClient.getAllIdList(index, type));
    }

    private List<DeleteRequestBuilder> buildExtractDeleteRequestBuilderList(String index, String type, QueryBuilder filterQueryBuilder) {
        return this.buildDeleteRequestBuilderList(index, type, this.jmESClient.extractIdList(index, type, filterQueryBuilder));
    }

    private List<DeleteRequestBuilder> buildDeleteRequestBuilderList(String index, String type, List<String> idList) {
        return idList.stream().map(id -> this.jmESClient.prepareDelete(index, type, (String)id)).collect(Collectors.toList());
    }
}

