/*
 * Decompiled with CFR 0.152.
 */
package kr.jadekim.protobuf.generator.file;

import com.google.protobuf.Descriptors;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.TypeSpec;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kr.jadekim.protobuf.generator.ImportName;
import kr.jadekim.protobuf.generator.ImportNameKt;
import kr.jadekim.protobuf.generator.file.FileGenerator;
import kr.jadekim.protobuf.generator.type.EnumTypeGenerator;
import kr.jadekim.protobuf.generator.type.MessageTypeGenerator;
import kr.jadekim.protobuf.generator.util.extention.OutputKt;
import kr.jadekim.protobuf.generator.util.extention.SpecKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lkr/jadekim/protobuf/generator/file/TypeFileGenerator;", "Lkr/jadekim/protobuf/generator/file/FileGenerator;", "enumTypeGenerator", "Lkr/jadekim/protobuf/generator/type/EnumTypeGenerator;", "messageTypeGenerator", "Lkr/jadekim/protobuf/generator/type/MessageTypeGenerator;", "(Lkr/jadekim/protobuf/generator/type/EnumTypeGenerator;Lkr/jadekim/protobuf/generator/type/MessageTypeGenerator;)V", "getEnumTypeGenerator", "()Lkr/jadekim/protobuf/generator/type/EnumTypeGenerator;", "getMessageTypeGenerator", "()Lkr/jadekim/protobuf/generator/type/MessageTypeGenerator;", "generate", "Lcom/squareup/kotlinpoet/FileSpec;", "descriptor", "Lcom/google/protobuf/Descriptors$FileDescriptor;", "kotlin-protobuf-generator"})
public final class TypeFileGenerator
implements FileGenerator {
    @NotNull
    private final EnumTypeGenerator enumTypeGenerator;
    @NotNull
    private final MessageTypeGenerator messageTypeGenerator;

    public TypeFileGenerator(@NotNull EnumTypeGenerator enumTypeGenerator, @NotNull MessageTypeGenerator messageTypeGenerator) {
        Intrinsics.checkNotNullParameter(enumTypeGenerator, "enumTypeGenerator");
        Intrinsics.checkNotNullParameter(messageTypeGenerator, "messageTypeGenerator");
        this.enumTypeGenerator = enumTypeGenerator;
        this.messageTypeGenerator = messageTypeGenerator;
    }

    @NotNull
    public final EnumTypeGenerator getEnumTypeGenerator() {
        return this.enumTypeGenerator;
    }

    @NotNull
    public final MessageTypeGenerator getMessageTypeGenerator() {
        return this.messageTypeGenerator;
    }

    @Override
    @NotNull
    public FileSpec generate(@NotNull Descriptors.FileDescriptor descriptor2) {
        Set<ImportName> imports2;
        Pair<TypeSpec, Set<ImportName>> pair;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        FileSpec.Builder spec = FileSpec.Companion.builder(OutputKt.getOutputPackage(descriptor2), OutputKt.getOutputFileName(descriptor2));
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue(descriptor2.getName(), "descriptor.name");
        spec.addFileComment("Transform from %L", objectArray);
        SpecKt.addSyntaxAnnotation(spec, descriptor2);
        SpecKt.addGeneratorVersionAnnotation(spec);
        for (Descriptors.EnumDescriptor enumDescriptor : descriptor2.getEnumTypes()) {
            Intrinsics.checkNotNullExpressionValue(enumDescriptor, "enumDescriptor");
            pair = this.enumTypeGenerator.generate(enumDescriptor);
            TypeSpec enumSpec = pair.component1();
            imports2 = pair.component2();
            ImportNameKt.addTo((Collection<ImportName>)imports2, spec);
            spec.addType(enumSpec);
        }
        for (Descriptors.Descriptor messageDescriptor : descriptor2.getMessageTypes()) {
            Intrinsics.checkNotNullExpressionValue(messageDescriptor, "messageDescriptor");
            pair = this.messageTypeGenerator.generate(messageDescriptor);
            TypeSpec messageSpec = pair.component1();
            imports2 = pair.component2();
            ImportNameKt.addTo((Collection<ImportName>)imports2, spec);
            spec.addType(messageSpec);
        }
        return spec.build();
    }
}

