/*
 * Decompiled with CFR 0.152.
 */
package kr.jadekim.protobuf.generator.file;

import com.google.protobuf.Descriptors;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.ParameterizedTypeNames;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kr.jadekim.protobuf.converter.mapper.ProtobufTypeMapper;
import kr.jadekim.protobuf.generator.util.extention.SpecKt;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="", level=DeprecationLevel.ERROR)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0017"}, d2={"Lkr/jadekim/protobuf/generator/file/TypeRegistryGenerator;", "", "packageName", "", "fileName", "(Ljava/lang/String;Ljava/lang/String;)V", "enumRegistry", "", "Lcom/squareup/kotlinpoet/TypeName;", "getFileName", "()Ljava/lang/String;", "messageMapperRegistry", "messageRegistry", "getPackageName", "generate", "Lcom/squareup/kotlinpoet/FileSpec;", "registerEnum", "", "typeUrl", "typeName", "Lcom/squareup/kotlinpoet/ClassName;", "registerMessage", "registerMessageMapper", "kotlin-protobuf-generator"})
@SourceDebugExtension(value={"SMAP\nTypeRegistryGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeRegistryGenerator.kt\nkr/jadekim/protobuf/generator/file/TypeRegistryGenerator\n+ 2 TypeName.kt\ncom/squareup/kotlinpoet/TypeNames\n*L\n1#1,78:1\n357#2:79\n357#2:80\n357#2:81\n357#2:82\n*S KotlinDebug\n*F\n+ 1 TypeRegistryGenerator.kt\nkr/jadekim/protobuf/generator/file/TypeRegistryGenerator\n*L\n32#1:79\n44#1:80\n50#1:81\n58#1:82\n*E\n"})
public final class TypeRegistryGenerator {
    @NotNull
    private final String packageName;
    @NotNull
    private final String fileName;
    @NotNull
    private final Map<String, TypeName> enumRegistry;
    @NotNull
    private final Map<String, TypeName> messageRegistry;
    @NotNull
    private final Map<String, TypeName> messageMapperRegistry;

    public TypeRegistryGenerator(@NotNull String packageName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        this.packageName = packageName;
        this.fileName = fileName;
        this.enumRegistry = new LinkedHashMap();
        this.messageRegistry = new LinkedHashMap();
        this.messageMapperRegistry = new LinkedHashMap();
    }

    public /* synthetic */ TypeRegistryGenerator(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            StringBuilder stringBuilder = new StringBuilder().append("kr.jadekim.protobuf.registry.");
            String string3 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue(string3, "randomUUID().toString()");
            string = stringBuilder.append(StringsKt.replace$default(string3, "-", "", false, 4, null)).toString();
        }
        if ((n & 2) != 0) {
            string2 = "type_registry.kt";
        }
        this(string, string2);
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final FileSpec generate() {
        FileSpec.Builder spec = FileSpec.Companion.builder(this.packageName, this.fileName);
        SpecKt.addGeneratorVersionAnnotation(spec);
        CodeBlock.Builder enumRegistryBlock = CodeBlock.Companion.builder();
        Object object = new Object[]{Reflection.getOrCreateKotlinClass(String.class), Reflection.getOrCreateKotlinClass(Descriptors.EnumDescriptor.class)};
        enumRegistryBlock.add("mapOf<%T, %T>(", (Object[])object);
        for (Map.Entry entry : this.enumRegistry.entrySet()) {
            String string = (String)entry.getKey();
            TypeName typeName = (TypeName)entry.getValue();
            Object[] objectArray = new Object[]{string, typeName};
            enumRegistryBlock.add("%S to %T.getDescriptor(),\n", objectArray);
        }
        enumRegistryBlock.add(")", new Object[0]);
        object = new TypeName[2];
        object[0] = TypeNames.STRING;
        boolean bl = false;
        object[1] = ParameterizedTypeNames.asTypeName(Reflection.typeOf(Descriptors.EnumDescriptor.class));
        spec.addProperty(PropertySpec.Companion.builder("ENUM_REGISTRY", (TypeName)ParameterizedTypeName.Companion.get(TypeNames.MAP, (TypeName[])object), new KModifier[0]).initializer(enumRegistryBlock.build()).build());
        CodeBlock.Builder messageRegistryBlock = CodeBlock.Companion.builder();
        Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(String.class), Reflection.getOrCreateKotlinClass(Descriptors.Descriptor.class)};
        messageRegistryBlock.add("mapOf<%T, %T>(", objectArray);
        for (Map.Entry<String, TypeName> entry : this.messageRegistry.entrySet()) {
            String string = entry.getKey();
            TypeName typeName = entry.getValue();
            Object[] objectArray2 = new Object[]{string, typeName};
            messageRegistryBlock.add("%S to %T.getDescriptor(),\n", objectArray2);
        }
        messageRegistryBlock.add(")", new Object[0]);
        TypeName[] typeNameArray = new TypeName[2];
        typeNameArray[0] = TypeNames.STRING;
        boolean bl2 = false;
        typeNameArray[1] = ParameterizedTypeNames.asTypeName(Reflection.typeOf(Descriptors.Descriptor.class));
        spec.addProperty(PropertySpec.Companion.builder("MESSAGE_REGISTRY", (TypeName)ParameterizedTypeName.Companion.get(TypeNames.MAP, typeNameArray), new KModifier[0]).initializer(messageRegistryBlock.build()).build());
        CodeBlock.Builder builder = CodeBlock.Companion.builder();
        Object[] objectArray3 = new Object[2];
        objectArray3[0] = TypeNames.STRING;
        boolean bl3 = false;
        objectArray3[1] = ParameterizedTypeNames.asTypeName(Reflection.typeOf(ProtobufTypeMapper.class, KTypeProjection.Companion.getSTAR(), KTypeProjection.Companion.getSTAR()));
        builder.add("mapOf<%T, %T>(", objectArray3);
        for (Map.Entry<String, TypeName> entry : this.messageMapperRegistry.entrySet()) {
            String typeUrl = entry.getKey();
            TypeName typeName = entry.getValue();
            Object[] objectArray4 = new Object[]{typeUrl, typeName};
            builder.add("%S to %T,\n", objectArray4);
        }
        builder.add(")", new Object[0]);
        TypeName[] typeNameArray2 = new TypeName[2];
        typeNameArray2[0] = TypeNames.STRING;
        boolean bl4 = false;
        typeNameArray2[1] = ParameterizedTypeNames.asTypeName(Reflection.typeOf(ProtobufTypeMapper.class, KTypeProjection.Companion.getSTAR(), KTypeProjection.Companion.getSTAR()));
        spec.addProperty(PropertySpec.Companion.builder("MESSAGE_MAPPER_REGISTRY", (TypeName)ParameterizedTypeName.Companion.get(TypeNames.MAP, typeNameArray2), new KModifier[0]).initializer(builder.build()).build());
        return spec.build();
    }

    public final void registerEnum(@NotNull String typeUrl, @NotNull ClassName typeName) {
        Intrinsics.checkNotNullParameter(typeUrl, "typeUrl");
        Intrinsics.checkNotNullParameter(typeName, "typeName");
        this.enumRegistry.put(typeUrl, typeName);
    }

    public final void registerMessage(@NotNull String typeUrl, @NotNull ClassName typeName) {
        Intrinsics.checkNotNullParameter(typeUrl, "typeUrl");
        Intrinsics.checkNotNullParameter(typeName, "typeName");
        this.messageRegistry.put(typeUrl, typeName);
    }

    public final void registerMessageMapper(@NotNull String typeUrl, @NotNull ClassName typeName) {
        Intrinsics.checkNotNullParameter(typeUrl, "typeUrl");
        Intrinsics.checkNotNullParameter(typeName, "typeName");
        this.messageMapperRegistry.put(typeUrl, typeName);
    }

    public TypeRegistryGenerator() {
        this(null, null, 3, null);
    }
}

