/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.emulators;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SocketEmulatorInputStream
extends InputStream {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private byte[] bytes = null;
    private int pos = 0;

    public SocketEmulatorInputStream(byte[] hexStringToByteArray) {
        this();
        this.setBytesToRead(hexStringToByteArray);
    }

    public SocketEmulatorInputStream() {
        log.info("Created input stream emulator");
    }

    public final void setBytesToRead(byte[] hexStringToByteArray) {
        log.debug("Set bytes to read: " + Integer.toString(hexStringToByteArray.length));
        this.bytes = hexStringToByteArray;
    }

    public final void setBytesToRead(String str) {
        this.setBytesToRead(str.getBytes());
    }

    @Override
    public int read() throws IOException {
        if (this.bytes == null) {
            log.debug("Expected emulator data was not set");
            return -1;
        }
        if (this.pos >= this.bytes.length) {
            log.debug("End of data  reached, resetting buffer");
            this.bytes = null;
            this.pos = 0;
            return -1;
        }
        byte byteToret = this.bytes[this.pos];
        ++this.pos;
        return byteToret;
    }
}

