/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.emulators;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.util.Set;
import java.util.logging.Level;
import kg.apc.emulators.DatagramSocketEmulator;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DatagramChannelEmul
extends DatagramChannel {
    private ByteBuffer writtenBytes;
    private ByteBuffer bytesToRead;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private DatagramSocket socket;

    public DatagramChannelEmul() {
        super(null);
        try {
            this.socket = new DatagramSocketEmulator();
        }
        catch (SocketException ex) {
            java.util.logging.Logger.getLogger(DatagramChannelEmul.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static DatagramChannel open() throws IOException {
        return new DatagramChannelEmul();
    }

    @Override
    public DatagramChannel bind(SocketAddress socketAddress) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> DatagramChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DatagramSocket socket() {
        return this.socket;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        ByteBuffer chunk;
        if (this.bytesToRead == null || this.bytesToRead.remaining() == 0) {
            log.debug("No more data to read");
            return -1;
        }
        int cnt = dst.capacity() < this.bytesToRead.capacity() ? dst.capacity() : this.bytesToRead.capacity();
        if (cnt < (chunk = this.bytesToRead.duplicate()).capacity()) {
            log.debug("Setting limit to " + cnt);
            chunk.limit(cnt);
        }
        log.debug("Emulating read: " + this.getString(chunk));
        chunk.rewind();
        dst.put(chunk);
        this.bytesToRead = null;
        return cnt;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        log.debug("Emulating write: " + this.getString(src));
        this.writtenBytes = src;
        while (src.hasRemaining()) {
            src.get();
        }
        return src.capacity();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        log.debug("Close selectable channel");
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        log.debug("Configure blocking: " + block);
    }

    public ByteBuffer getWrittenBytes() {
        ByteBuffer res = this.writtenBytes;
        this.writtenBytes = null;
        return res;
    }

    public void setBytesToRead(ByteBuffer wrap) {
        log.debug("Set bytes to read: " + this.getString(wrap));
        this.bytesToRead = wrap;
    }

    private String getString(ByteBuffer src) {
        if (src == null) {
            log.error("Null buffer!");
            return "";
        }
        return src.toString();
    }

    @Override
    public DatagramChannel connect(SocketAddress remote) throws IOException {
        return this;
    }

    @Override
    public DatagramChannel disconnect() throws IOException {
        return this;
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SocketAddress receive(ByteBuffer dst) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int send(ByteBuffer src, SocketAddress target) throws IOException {
        return this.write(src);
    }

    @Override
    public MembershipKey join(InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MembershipKey join(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress1) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

