/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.cmd;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;

public final class UniversalRunner {
    public static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String jarDirectory;
    private static final FilenameFilter jarFilter;

    private static List<URL> buildUpdatedClassPath(String jarDir, StringBuffer classpath) {
        File f;
        LinkedList<URL> jars = new LinkedList<URL>();
        LinkedList<File> libDirs = new LinkedList<File>();
        for (f = new File(jarDir); f != null; f = f.getParentFile()) {
            libDirs.add(f.getAbsoluteFile());
        }
        f = new File(jarDir + File.separator + "ext");
        if (f.exists()) {
            libDirs.add(f.getAbsoluteFile());
        }
        for (File libDir : libDirs) {
            File[] libJars = libDir.listFiles(jarFilter);
            if (libJars == null) continue;
            UniversalRunner.addFiles(libJars, jars, classpath);
        }
        return jars;
    }

    private static void addFiles(File[] libJars, List<URL> jars, StringBuffer classpath) {
        for (File libJar : libJars) {
            try {
                String s = libJar.getPath();
                jars.add(new File(s).toURI().toURL());
                classpath.append(File.pathSeparator);
                classpath.append(s);
            }
            catch (MalformedURLException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static String getJARLocation() {
        return jarDirectory;
    }

    public static void main(String[] args) throws Throwable {
        try {
            Class<?> initialClass = Thread.currentThread().getContextClassLoader().loadClass("kg.apc.cmdtools.PluginsCMD");
            Object instance = initialClass.newInstance();
            Method startup = initialClass.getMethod("processParams", new String[0].getClass());
            Object res = startup.invoke(instance, new Object[]{args});
            int rc = (Integer)res;
            if (rc != 0) {
                System.exit(rc);
            }
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                System.err.println("ERROR: " + e.getCause().toString());
                System.err.println("*** Problem's technical details go below ***");
                System.err.println("Home directory was detected as: " + jarDirectory);
                throw e.getCause();
            }
            System.err.println("Home directory was detected as: " + jarDirectory);
            throw e;
        }
    }

    static {
        jarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        System.setProperty("java.awt.headless", "true");
        StringBuffer classpath = new StringBuffer();
        File self = new File(UniversalRunner.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        jarDirectory = self.getParent();
        List<URL> jars = UniversalRunner.buildUpdatedClassPath(jarDirectory, classpath);
        String cp = classpath.toString();
        System.setProperty(JAVA_CLASS_PATH, cp);
        URL[] urls = jars.toArray(new URL[0]);
        URLClassLoader loader = new URLClassLoader(urls);
        Thread.currentThread().setContextClassLoader(loader);
    }
}

