/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.avalon;

import java.text.ParseException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.cli.avalon.CLOption;
import org.apache.commons.cli.avalon.CLOptionDescriptor;
import org.apache.commons.cli.avalon.ParserControl;
import org.apache.commons.cli.avalon.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLArgsParser {
    private static final int INVALID = Integer.MAX_VALUE;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_REQUIRE_2ARGS = 1;
    private static final int STATE_REQUIRE_ARG = 2;
    private static final int STATE_OPTIONAL_ARG = 3;
    private static final int STATE_NO_OPTIONS = 4;
    private static final int STATE_OPTION_MODE = 5;
    private static final int TOKEN_SEPARATOR = 0;
    private static final int TOKEN_STRING = 1;
    private static final char[] ARG_SEPARATORS = new char[]{'\u0000', '='};
    private static final char[] NULL_SEPARATORS = new char[]{'\u0000'};
    private final CLOptionDescriptor[] m_optionDescriptors;
    private final Vector<CLOption> m_options;
    private Hashtable<Object, CLOption> m_optionIndex;
    private final ParserControl m_control;
    private String m_errorMessage;
    private String[] m_unparsedArgs = new String[0];
    private char m_ch;
    private String[] m_args;
    private boolean m_isLong;
    private int m_argIndex;
    private int m_stringIndex;
    private int m_stringLength;
    private int m_lastChar = Integer.MAX_VALUE;
    private int m_lastOptionId;
    private CLOption m_option;
    private int m_state = 0;
    private char m_tokesep;

    public final String[] getUnparsedArgs() {
        return this.m_unparsedArgs;
    }

    public final Vector<CLOption> getArguments() {
        return this.m_options;
    }

    public final CLOption getArgumentById(int id) {
        return this.m_optionIndex.get(id);
    }

    public final CLOption getArgumentByName(String name) {
        return this.m_optionIndex.get(name);
    }

    private final CLOptionDescriptor getDescriptorFor(int id) {
        for (int i = 0; i < this.m_optionDescriptors.length; ++i) {
            if (this.m_optionDescriptors[i].getId() != id) continue;
            return this.m_optionDescriptors[i];
        }
        return null;
    }

    private final CLOptionDescriptor getDescriptorFor(String name) {
        for (int i = 0; i < this.m_optionDescriptors.length; ++i) {
            if (!this.m_optionDescriptors[i].getName().equals(name)) continue;
            return this.m_optionDescriptors[i];
        }
        return null;
    }

    public final String getErrorString() {
        return this.m_errorMessage;
    }

    private final int getStateFor(CLOptionDescriptor descriptor) {
        int flags = descriptor.getFlags();
        if ((flags & 0x10) == 16) {
            return 1;
        }
        if ((flags & 2) == 2) {
            return 2;
        }
        if ((flags & 4) == 4) {
            return 3;
        }
        return 0;
    }

    public CLArgsParser(String[] args, CLOptionDescriptor[] optionDescriptors, ParserControl control) {
        this.m_optionDescriptors = optionDescriptors;
        this.m_control = control;
        this.m_options = new Vector();
        this.m_args = args;
        try {
            this.parse();
            this.checkIncompatibilities(this.m_options);
            this.buildOptionIndex();
        }
        catch (ParseException pe) {
            this.m_errorMessage = pe.getMessage();
        }
    }

    private final void checkIncompatibilities(Vector<CLOption> arguments) throws ParseException {
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            CLOption option = arguments.elementAt(i);
            int id = option.getDescriptor().getId();
            CLOptionDescriptor descriptor = this.getDescriptorFor(id);
            if (null == descriptor) continue;
            int[] incompatible = descriptor.getIncompatible();
            this.checkIncompatible(arguments, incompatible, i);
        }
    }

    private final void checkIncompatible(Vector<CLOption> arguments, int[] incompatible, int original) throws ParseException {
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            if (original == i) continue;
            CLOption option = arguments.elementAt(i);
            int id = option.getDescriptor().getId();
            for (int j = 0; j < incompatible.length; ++j) {
                if (id != incompatible[j]) continue;
                CLOption originalOption = arguments.elementAt(original);
                int originalId = originalOption.getDescriptor().getId();
                String message = null;
                message = id == originalId ? "Duplicate options for " + this.describeDualOption(originalId) + " found." : "Incompatible options -" + this.describeDualOption(id) + " and " + this.describeDualOption(originalId) + " found.";
                throw new ParseException(message, 0);
            }
        }
    }

    private final String describeDualOption(int id) {
        String longOption;
        CLOptionDescriptor descriptor = this.getDescriptorFor(id);
        if (null == descriptor) {
            return "<parameter>";
        }
        StringBuilder sb = new StringBuilder();
        boolean hasCharOption = false;
        if (Character.isLetter((char)id)) {
            sb.append('-');
            sb.append((char)id);
            hasCharOption = true;
        }
        if (null != (longOption = descriptor.getName())) {
            if (hasCharOption) {
                sb.append('/');
            }
            sb.append("--");
            sb.append(longOption);
        }
        return sb.toString();
    }

    public CLArgsParser(String[] args, CLOptionDescriptor[] optionDescriptors) {
        this(args, optionDescriptors, null);
    }

    private final String[] subArray(String[] array, int index, int charIndex) {
        int remaining = array.length - index;
        String[] result = new String[remaining];
        if (remaining > 1) {
            System.arraycopy(array, index + 1, result, 1, remaining - 1);
        }
        result[0] = array[index].substring(charIndex - 1);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parse() throws ParseException {
        if (0 == this.m_args.length) {
            return;
        }
        this.m_stringLength = this.m_args[this.m_argIndex].length();
        while (true) {
            this.m_ch = this.peekAtChar();
            if (this.m_argIndex >= this.m_args.length) break;
            if (null != this.m_control && this.m_control.isFinished(this.m_lastOptionId)) {
                this.m_unparsedArgs = this.subArray(this.m_args, this.m_argIndex, this.m_stringIndex);
                return;
            }
            if (5 == this.m_state) {
                if ('\u0000' == this.m_ch) {
                    this.getChar();
                    this.m_state = 0;
                    continue;
                }
                this.parseShortOption();
                continue;
            }
            if (0 == this.m_state) {
                this.parseNormal();
                continue;
            }
            if (4 == this.m_state) {
                this.addOption(new CLOption(this.m_args[this.m_argIndex++]));
                continue;
            }
            this.parseArguments();
        }
        if (this.m_option == null) return;
        if (3 == this.m_state) {
            this.m_options.addElement(this.m_option);
            return;
        } else {
            if (2 == this.m_state) {
                CLOptionDescriptor descriptor = this.getDescriptorFor(this.m_option.getDescriptor().getId());
                String message = "Missing argument to option " + this.getOptionDescription(descriptor);
                throw new ParseException(message, 0);
            }
            if (1 != this.m_state) throw new ParseException("IllegalState " + this.m_state + ": " + this.m_option, 0);
            if (1 == this.m_option.getArgumentCount()) {
                this.m_option.addArgument("");
                this.m_options.addElement(this.m_option);
                return;
            } else {
                CLOptionDescriptor descriptor = this.getDescriptorFor(this.m_option.getDescriptor().getId());
                String message = "Missing argument to option " + this.getOptionDescription(descriptor);
                throw new ParseException(message, 0);
            }
        }
    }

    private final String getOptionDescription(CLOptionDescriptor descriptor) {
        if (this.m_isLong) {
            return "--" + descriptor.getName();
        }
        return "-" + (char)descriptor.getId();
    }

    private final char peekAtChar() {
        if (Integer.MAX_VALUE == this.m_lastChar) {
            this.m_lastChar = this.readChar();
        }
        return (char)this.m_lastChar;
    }

    private final char getChar() {
        if (Integer.MAX_VALUE != this.m_lastChar) {
            char result = (char)this.m_lastChar;
            this.m_lastChar = Integer.MAX_VALUE;
            return result;
        }
        return this.readChar();
    }

    private final char readChar() {
        if (this.m_stringIndex >= this.m_stringLength) {
            ++this.m_argIndex;
            this.m_stringIndex = 0;
            this.m_stringLength = this.m_argIndex < this.m_args.length ? this.m_args[this.m_argIndex].length() : 0;
            return '\u0000';
        }
        if (this.m_argIndex >= this.m_args.length) {
            return '\u0000';
        }
        return this.m_args[this.m_argIndex].charAt(this.m_stringIndex++);
    }

    private final Token nextToken(char[] separators) {
        this.m_ch = this.getChar();
        if (this.isSeparator(this.m_ch, separators)) {
            this.m_tokesep = this.m_ch;
            this.m_ch = this.getChar();
            return new Token(0, null);
        }
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(this.m_ch);
            this.m_ch = this.getChar();
        } while (!this.isSeparator(this.m_ch, separators));
        this.m_tokesep = this.m_ch;
        return new Token(1, sb.toString());
    }

    private final boolean isSeparator(char ch, char[] separators) {
        for (int i = 0; i < separators.length; ++i) {
            if (ch != separators[i]) continue;
            return true;
        }
        return false;
    }

    private final void addOption(CLOption option) {
        this.m_options.addElement(option);
        this.m_lastOptionId = option.getDescriptor().getId();
        this.m_option = null;
    }

    private final void parseOption(CLOptionDescriptor descriptor, String optionString) throws ParseException {
        if (null == descriptor) {
            throw new ParseException("Unknown option " + optionString, 0);
        }
        this.m_state = this.getStateFor(descriptor);
        this.m_option = new CLOption(descriptor);
        if (0 == this.m_state) {
            this.addOption(this.m_option);
        }
    }

    private final void parseShortOption() throws ParseException {
        this.m_ch = this.getChar();
        CLOptionDescriptor descriptor = this.getDescriptorFor(this.m_ch);
        this.m_isLong = false;
        this.parseOption(descriptor, "-" + this.m_ch);
        if (0 == this.m_state) {
            this.m_state = 5;
        }
    }

    private final void parseArguments() throws ParseException {
        if (2 == this.m_state) {
            if ('=' == this.m_ch || '\u0000' == this.m_ch) {
                this.getChar();
            }
            Token token = this.nextToken(NULL_SEPARATORS);
            this.m_option.addArgument(token.getValue());
            this.addOption(this.m_option);
            this.m_state = 0;
        } else if (3 == this.m_state) {
            if ('-' == this.m_ch || '\u0000' == this.m_ch) {
                this.getChar();
                this.addOption(this.m_option);
                this.m_state = 0;
                return;
            }
            if (this.m_isLong && '=' != this.m_tokesep) {
                this.addOption(this.m_option);
                this.m_state = 0;
                return;
            }
            if ('=' == this.m_ch) {
                this.getChar();
            }
            Token token = this.nextToken(NULL_SEPARATORS);
            this.m_option.addArgument(token.getValue());
            this.addOption(this.m_option);
            this.m_state = 0;
        } else if (1 == this.m_state) {
            if (0 == this.m_option.getArgumentCount()) {
                Token token;
                if (!this.m_isLong && '\u0000' == this.peekAtChar()) {
                    this.getChar();
                }
                if (0 == (token = this.nextToken(ARG_SEPARATORS)).getType()) {
                    CLOptionDescriptor descriptor = this.getDescriptorFor(this.m_option.getDescriptor().getId());
                    String message = "Unable to parse first argument for option " + this.getOptionDescription(descriptor);
                    throw new ParseException(message, 0);
                }
                this.m_option.addArgument(token.getValue());
                if ('\u0000' == this.m_ch && '-' == this.peekAtChar()) {
                    this.m_option.addArgument("");
                    this.m_options.addElement(this.m_option);
                    this.m_state = 0;
                }
            } else {
                StringBuilder sb = new StringBuilder();
                this.m_ch = this.getChar();
                while (!this.isSeparator(this.m_ch, NULL_SEPARATORS)) {
                    sb.append(this.m_ch);
                    this.m_ch = this.getChar();
                }
                String argument = sb.toString();
                this.m_option.addArgument(argument);
                this.addOption(this.m_option);
                this.m_option = null;
                this.m_state = 0;
            }
        }
    }

    private final void parseNormal() throws ParseException {
        if ('-' != this.m_ch) {
            String argument = this.nextToken(NULL_SEPARATORS).getValue();
            this.addOption(new CLOption(argument));
            this.m_state = 0;
        } else {
            this.getChar();
            if ('\u0000' == this.peekAtChar()) {
                throw new ParseException("Malformed option -", 0);
            }
            this.m_ch = this.peekAtChar();
            if ('-' != this.m_ch) {
                this.parseShortOption();
            } else {
                this.getChar();
                if ('\u0000' == this.peekAtChar()) {
                    this.getChar();
                    this.m_state = 4;
                } else {
                    String optionName = this.nextToken(ARG_SEPARATORS).getValue();
                    CLOptionDescriptor descriptor = this.getDescriptorFor(optionName);
                    this.m_isLong = true;
                    this.parseOption(descriptor, "--" + optionName);
                }
            }
        }
    }

    private final void buildOptionIndex() {
        int size = this.m_options.size();
        this.m_optionIndex = new Hashtable(size * 2);
        for (int i = 0; i < size; ++i) {
            CLOption option = this.m_options.get(i);
            CLOptionDescriptor optionDescriptor = this.getDescriptorFor(option.getDescriptor().getId());
            this.m_optionIndex.put(option.getDescriptor().getId(), option);
            if (null == optionDescriptor || null == optionDescriptor.getName()) continue;
            this.m_optionIndex.put(optionDescriptor.getName(), option);
        }
    }
}

