/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics;

import java.util.Hashtable;
import kg.apc.perfmon.metrics.InvalidPerfMonMetric;
import kg.apc.perfmon.metrics.MetricParamsSigar;
import kg.apc.perfmon.metrics.PerfMonMetricsService;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.hyperic.sigar.SigarProxy;

public abstract class AbstractPerfMonMetric {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected static final String PARAMS_DELIMITER = ":";
    protected final SigarProxy sigarProxy;
    private static final Hashtable unitDividingFactors = new Hashtable();

    public AbstractPerfMonMetric(SigarProxy aSigar) {
        this.sigarProxy = aSigar;
        unitDividingFactors.put("b", new Integer(1));
        unitDividingFactors.put("kb", new Integer(1024));
        unitDividingFactors.put("mb", new Integer(0x100000));
    }

    protected int getUnitDividingFactor(String unit) {
        if (!unitDividingFactors.containsKey(unit)) {
            return 1;
        }
        return (Integer)unitDividingFactors.get(unit);
    }

    public abstract void getValue(StringBuffer var1) throws Exception;

    public static AbstractPerfMonMetric createMetric(String metricType, String metricParamsStr, SigarProxy sigarProxy, boolean isNoExec) {
        AbstractPerfMonMetric metric;
        log.debug("Creating metric: " + metricType + " with params: " + metricParamsStr);
        if (metricType.indexOf(32) > 0) {
            metricType = metricType.substring(0, metricType.indexOf(32));
        }
        MetricParamsSigar metricParams = MetricParamsSigar.createFromString(metricParamsStr, sigarProxy);
        PerfMonMetricsService service = PerfMonMetricsService.getInstance();
        try {
            metric = service.getMetric(metricType, metricParams, sigarProxy, isNoExec);
        }
        catch (IllegalArgumentException ex) {
            log.debug(ex.toString());
            log.debug("Invalid parameters specified for metric " + metricType + ": " + metricParams);
            InvalidPerfMonMetric metric2 = new InvalidPerfMonMetric();
            throw new IllegalArgumentException("Invalid parameters specified for metric " + metricType + ": " + metricParams, ex);
        }
        catch (RuntimeException ex) {
            log.debug("Invalid metric specified: " + metricType, (Throwable)ex);
            InvalidPerfMonMetric metric3 = new InvalidPerfMonMetric();
            throw new RuntimeException("Invalid metric specified: " + metricType, ex);
        }
        log.debug("Have metric object: " + metric.toString());
        return metric;
    }
}

